/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.variant.SigningConfig;
import com.android.build.api.variant.impl.SigningConfigImpl;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.TaskCategory;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.HELP)
public class SigningReportTask
extends DefaultTask {
    private List<ApkCreationConfig> components;

    @TaskAction
    public void generate() {
        StyledTextOutput textOutput = ((StyledTextOutputFactory)this.getServices().get(StyledTextOutputFactory.class)).create(((Object)((Object)this)).getClass());
        HashMap cache2 = Maps.newHashMap();
        for (ApkCreationConfig component2 : this.components) {
            textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"Variant: ");
            textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)component2.getName());
            textOutput.println();
            SigningConfigImpl signingConfig2 = component2.getSigningConfigImpl();
            if (signingConfig2 == null) {
                textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"Config: ");
                textOutput.withStyle(StyledTextOutput.Style.Normal).text((Object)"none");
                textOutput.println();
            } else {
                SigningInfo signingInfo = SigningReportTask.getSigningInfo(signingConfig2, cache2);
                textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"Config: ");
                textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)signingConfig2.getName());
                textOutput.println();
                textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"Store: ");
                textOutput.withStyle(StyledTextOutput.Style.Description).text(signingConfig2.getStoreFile().getOrNull());
                textOutput.println();
                textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"Alias: ");
                textOutput.withStyle(StyledTextOutput.Style.Description).text(signingConfig2.getKeyAlias().getOrNull());
                textOutput.println();
                if (signingInfo.isValid()) {
                    if (signingInfo.error != null) {
                        textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"Error: ");
                        textOutput.withStyle(StyledTextOutput.Style.Failure).text((Object)signingInfo.error);
                    } else {
                        textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"MD5: ");
                        textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)signingInfo.md5);
                        textOutput.println();
                        textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"SHA1: ");
                        textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)signingInfo.sha1);
                        textOutput.println();
                        textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"SHA-256: ");
                        textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)signingInfo.sha256);
                        textOutput.println();
                        textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)"Valid until: ");
                        DateFormat df = DateFormat.getDateInstance(0);
                        textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)df.format(signingInfo.notAfter));
                    }
                    textOutput.println();
                }
            }
            textOutput.withStyle(StyledTextOutput.Style.Normal).text((Object)"----------");
            textOutput.println();
        }
    }

    public void setComponents(Collection<ApkCreationConfig> components2) {
        this.components = ImmutableList.copyOf(components2);
    }

    private static SigningInfo getSigningInfo(SigningConfigImpl signingConfig2, Map<SigningConfig, SigningInfo> cache2) {
        SigningInfo signingInfo = cache2.get(signingConfig2);
        if (signingInfo == null) {
            signingInfo = new SigningInfo();
            if (signingConfig2.isSigningReady()) {
                try {
                    CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)((String)signingConfig2.getStoreType().getOrNull()), (File)((File)signingConfig2.getStoreFile().get()), (String)((String)signingConfig2.getStorePassword().get()), (String)((String)signingConfig2.getKeyPassword().get()), (String)((String)signingConfig2.getKeyAlias().get()));
                    signingInfo.md5 = SigningReportTask.getFingerprint(certificateInfo.getCertificate(), "MD5");
                    signingInfo.sha1 = SigningReportTask.getFingerprint(certificateInfo.getCertificate(), "SHA1");
                    signingInfo.sha256 = SigningReportTask.getFingerprint(certificateInfo.getCertificate(), "SHA-256");
                    signingInfo.notAfter = certificateInfo.getCertificate().getNotAfter();
                }
                catch (KeytoolException e) {
                    signingInfo.error = e.getMessage();
                }
                catch (FileNotFoundException e) {
                    signingInfo.error = "Missing keystore";
                }
            }
            cache2.put(signingConfig2, signingInfo);
        }
        return signingInfo;
    }

    public static String getFingerprint(Certificate cert, String hashAlgorithm) {
        if (cert == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(hashAlgorithm);
            return SigningReportTask.toHexadecimalString(digest.digest(cert.getEncoded()));
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {
            return null;
        }
    }

    private static String toHexadecimalString(byte[] value) {
        StringBuilder sb = new StringBuilder();
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            int num = value[i] & 0xFF;
            if (num < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(num));
            if (i >= len - 1) continue;
            sb.append(':');
        }
        return sb.toString().toUpperCase(Locale.US);
    }

    private static final class SigningInfo {
        String md5;
        String sha1;
        String sha256;
        Date notAfter;
        String error;

        private SigningInfo() {
        }

        boolean isValid() {
            return this.md5 != null || this.error != null;
        }
    }
}

