/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.errors;

import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.errors.DeprecationReporterImpl;
import com.android.build.gradle.internal.errors.OptionInfo;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.Option;
import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.errors.IssueReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 )2\u00020\u0001:\u0001)B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\u000b\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0002\u0010\u000fJ*\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J*\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010!\u001a\u00020\u00112\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010$\u001a\u00020%H\u0016J \u0010&\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/build/gradle/internal/errors/DeprecationReporterImpl;", "Lcom/android/build/gradle/internal/errors/DeprecationReporter;", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "projectPath", "", "(Lcom/android/builder/errors/IssueReporter;Lcom/android/build/gradle/options/ProjectOptions;Ljava/lang/String;)V", "suppressedOptionWarnings", "", "getCallingSite", "traces", "", "Ljava/lang/StackTraceElement;", "([Ljava/lang/StackTraceElement;)Ljava/lang/String;", "reportDeprecatedApi", "", "newApiElement", "oldApiElement", "url", "deprecationTarget", "Lcom/android/build/gradle/internal/errors/DeprecationReporter$DeprecationTarget;", "reportDeprecatedConfiguration", "newDslElement", "oldConfiguration", "reportDeprecatedUsage", "oldDslElement", "reportDeprecatedValue", "dslElement", "oldValue", "newValue", "reportObsoleteUsage", "reportOptionIssuesIfAny", "option", "Lcom/android/build/gradle/options/Option;", "value", "", "reportRemovedApi", "reportRenamedConfiguration", "newConfiguration", "Companion", "gradle-core"})
public final class DeprecationReporterImpl
implements DeprecationReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IssueReporter issueReporter;
    @NotNull
    private final ProjectOptions projectOptions;
    @NotNull
    private final String projectPath;
    @NotNull
    private final Set<String> suppressedOptionWarnings;
    @NotNull
    private static final Set<String> obsoleteApis = new LinkedHashSet();
    @NotNull
    private static final Set<OptionInfo> options = new LinkedHashSet();

    public DeprecationReporterImpl(@NotNull IssueReporter issueReporter2, @NotNull ProjectOptions projectOptions, @NotNull String projectPath) {
        char[] cArray;
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        this.issueReporter = issueReporter2;
        this.projectOptions = projectOptions;
        this.projectPath = projectPath;
        Object object = this.projectOptions.get(StringOption.SUPPRESS_UNSUPPORTED_OPTION_WARNINGS);
        if (object == null || (object = StringsKt.splitToSequence$default((CharSequence)((CharSequence)object), (char[])(cArray = new char[]{','}), (boolean)false, (int)0, (int)6, null)) == null || (object = SequencesKt.toSet((Sequence)object)) == null) {
            object = SetsKt.emptySet();
        }
        this.suppressedOptionWarnings = object;
    }

    @Override
    public void reportDeprecatedUsage(@NotNull String newDslElement, @NotNull String oldDslElement, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkNotNullParameter((Object)newDslElement, (String)"newDslElement");
        Intrinsics.checkNotNullParameter((Object)oldDslElement, (String)"oldDslElement");
        Intrinsics.checkNotNullParameter((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        IssueReporter.reportWarning$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.DEPRECATED_DSL, (String)("DSL element '" + oldDslElement + "' is obsolete and has been replaced with '" + newDslElement + "'.\n" + deprecationTarget.getDeprecationTargetMessage()), (String)(oldDslElement + "::" + newDslElement + "::" + deprecationTarget.name()), null, (int)8, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reportDeprecatedApi(@Nullable String newApiElement, @NotNull String oldApiElement, @NotNull String url, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkNotNullParameter((Object)oldApiElement, (String)"oldApiElement");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        if (!Companion.checkAndSet(oldApiElement)) {
            boolean debugApi = this.projectOptions.get(BooleanOption.DEBUG_OBSOLETE_API);
            String firstLine = newApiElement != null ? "API '" + oldApiElement + "' is obsolete and has been replaced with '" + newApiElement + "'." : "API '" + oldApiElement + "' is obsolete.";
            String messageStart = firstLine + "\n" + deprecationTarget.getDeprecationTargetMessage() + "\nFor more information, see " + url + ".";
            Object messageEnd = "";
            if (debugApi) {
                void $this$filterTo$iv$iv;
                StackTraceElement[] traces = Thread.currentThread().getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)traces, (String)"traces");
                StackTraceElement[] $this$filter$iv = traces;
                boolean $i$f$filter = false;
                StackTraceElement[] stackTraceElementArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl = false;
                    String string = it.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.className");
                    if (!StringsKt.startsWith$default((String)string, (String)"org.jetbrains.kotlin.gradle.plugin.", (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List kotlin = (List)destination$iv$iv;
                messageEnd = (!((Collection)kotlin).isEmpty() ? "REASON: The Kotlin plugin is currently calling this deprecated API. Watch https://youtrack.jetbrains.com/issue/KT-25428 and, if possible, use a newer version of the Kotlin plugin that has fixed this issue." : this.getCallingSite(traces)) + "\nWARNING: Debugging obsolete API calls can take time during configuration. It's recommended to not keep it on at all times.";
            } else {
                messageEnd = "To determine what is calling " + oldApiElement + ", use -P" + BooleanOption.DEBUG_OBSOLETE_API.getPropertyName() + "=true on the command line to display more information.";
            }
            IssueReporter.reportWarning$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.DEPRECATED_DSL, (String)(messageStart + "\n" + (String)messageEnd), null, null, (int)12, null);
        }
    }

    @Override
    public void reportRemovedApi(@NotNull String oldApiElement, @NotNull String url, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkNotNullParameter((Object)oldApiElement, (String)"oldApiElement");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        if (!Companion.checkAndSet(oldApiElement)) {
            boolean debugApi = this.projectOptions.get(BooleanOption.DEBUG_OBSOLETE_API);
            String firstLine = "API '" + oldApiElement + "' is removed.";
            String messageStart = firstLine + "\n\nFor more information, see " + url + ".";
            Object messageEnd = "";
            if (debugApi) {
                StackTraceElement[] traces = Thread.currentThread().getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)traces, (String)"traces");
                String cfr_ignored_0 = this.getCallingSite(traces) + "\nWARNING: Debugging obsolete API calls can take time during configuration. It's recommended to not keep it on at all times.";
            } else {
                messageEnd = "To determine what is calling " + oldApiElement + ", use -P" + BooleanOption.DEBUG_OBSOLETE_API.getPropertyName() + "=true on the command line to display more information.";
            }
            IssueReporter.reportError$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.REMOVED_API, (String)(messageStart + "\n" + (String)messageEnd), null, null, (int)12, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getCallingSite(StackTraceElement[] traces) {
        String string;
        String gradleFile2 = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])traces), (Function1)getCallingSite.gradleFile.1.INSTANCE), (Function1)getCallingSite.gradleFile.2.INSTANCE));
        if (gradleFile2 != null) {
            string = "REASON: Called from: " + gradleFile2;
        } else {
            void $this$mapTo$iv$iv;
            StackTraceElement[] $this$map$iv = traces;
            boolean $i$f$map = false;
            StackTraceElement[] stackTraceElementArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var12_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getClassName() + "." + it.getMethodName() + "(" + it.getFileName() + ":" + it.getLineNumber() + ")\n");
            }
            List formattedTraces = (List)destination$iv$iv;
            string = "REASON: It is currently called from the following trace:\n" + CollectionsKt.joinToString$default((Iterable)formattedTraces, (CharSequence)"", (CharSequence)"", (CharSequence)"", (int)0, null, null, (int)56, null);
        }
        return string;
    }

    @Override
    public void reportObsoleteUsage(@NotNull String oldDslElement, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkNotNullParameter((Object)oldDslElement, (String)"oldDslElement");
        Intrinsics.checkNotNullParameter((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        IssueReporter.reportWarning$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.DEPRECATED_DSL, (String)("DSL element '" + oldDslElement + "' is obsolete and should be removed.\n" + deprecationTarget.getDeprecationTargetMessage()), (String)(oldDslElement + "::::" + deprecationTarget.name()), null, (int)8, null);
    }

    @Override
    public void reportRenamedConfiguration(@NotNull String newConfiguration, @NotNull String oldConfiguration, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkNotNullParameter((Object)newConfiguration, (String)"newConfiguration");
        Intrinsics.checkNotNullParameter((Object)oldConfiguration, (String)"oldConfiguration");
        Intrinsics.checkNotNullParameter((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        IssueReporter.reportWarning$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.USING_DEPRECATED_CONFIGURATION, (String)("Configuration '" + oldConfiguration + "' is obsolete and has been replaced with '" + newConfiguration + "'.\n" + deprecationTarget.getDeprecationTargetMessage()), (String)(oldConfiguration + "::" + newConfiguration + "::" + deprecationTarget.name()), null, (int)8, null);
    }

    @Override
    public void reportDeprecatedConfiguration(@NotNull String newDslElement, @NotNull String oldConfiguration, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkNotNullParameter((Object)newDslElement, (String)"newDslElement");
        Intrinsics.checkNotNullParameter((Object)oldConfiguration, (String)"oldConfiguration");
        Intrinsics.checkNotNullParameter((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        IssueReporter.reportWarning$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.USING_DEPRECATED_CONFIGURATION, (String)("Configuration '" + oldConfiguration + "' is obsolete and has been replaced with DSL element '" + newDslElement + "'.\n" + deprecationTarget.getDeprecationTargetMessage()), (String)(oldConfiguration + "::" + newDslElement + "::" + deprecationTarget.name()), null, (int)8, null);
    }

    @Override
    public void reportDeprecatedValue(@NotNull String dslElement, @NotNull String oldValue, @Nullable String newValue, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkNotNullParameter((Object)dslElement, (String)"dslElement");
        Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
        Intrinsics.checkNotNullParameter((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        IssueReporter.reportWarning$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.USING_DEPRECATED_DSL_VALUE, (String)("DSL element '" + dslElement + "' has a value '" + oldValue + "' which is obsolete " + (String)(newValue != null ? "and has been replaced with '" + newValue + "'.\n" : "and has not been replaced.\n") + deprecationTarget.getDeprecationTargetMessage()), null, null, (int)12, null);
    }

    @Override
    public void reportOptionIssuesIfAny(@NotNull Option<?> option, @NotNull Object value) {
        Option.Status status;
        Object defaultValueMessage;
        block17: {
            Object object;
            block16: {
                Intrinsics.checkNotNullParameter(option, (String)"option");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (Companion.checkAndSet(option, value)) {
                    return;
                }
                if (this.suppressedOptionWarnings.contains(option.getPropertyName())) {
                    return;
                }
                object = option.getDefaultValue();
                if (object == null) break block16;
                Object it = object;
                boolean bl = false;
                String string = "\nThe current default is '" + it + "'.";
                object = string;
                if (string != null) break block17;
            }
            object = defaultValueMessage = "";
        }
        if ((status = option.getStatus()) instanceof Option.Status.EXPERIMENTAL) {
            if (!Intrinsics.areEqual(option.getDefaultValue(), (Object)value)) {
                IssueReporter.reportWarning$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.UNSUPPORTED_PROJECT_OPTION_USE, (String)("The option setting '" + option.getPropertyName() + "=" + value + "' is experimental." + defaultValueMessage), (String)option.getPropertyName(), null, (int)8, null);
            }
        } else if (!Intrinsics.areEqual((Object)status, (Object)Option.Status.STABLE.INSTANCE)) {
            if (status instanceof Option.Status.Deprecated) {
                boolean useRecommendedValue;
                boolean bl = useRecommendedValue = option instanceof OptionalBooleanOption && ((OptionalBooleanOption)option).getRecommendedValue() != null && Intrinsics.areEqual((Object)((OptionalBooleanOption)option).getRecommendedValue(), (Object)value);
                if (!Intrinsics.areEqual(option.getDefaultValue(), (Object)value) && !useRecommendedValue) {
                    IssueReporter.reportWarning$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.UNSUPPORTED_PROJECT_OPTION_USE, (String)("The option setting '" + option.getPropertyName() + "=" + value + "' is deprecated." + defaultValueMessage + "\n" + ((Option.Status.Deprecated)status).getDeprecationTargetMessage()), (String)option.getPropertyName(), null, (int)8, null);
                }
            } else if (status instanceof Option.Status.Removed) {
                if (Intrinsics.areEqual(option.getDefaultValue(), (Object)value) || option == BooleanOption.ENABLE_DEPRECATED_NDK || Intrinsics.areEqual((Object)value, (Object)true) && option == OptionalBooleanOption.ENABLE_R8) {
                    IssueReporter.reportWarning$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.UNSUPPORTED_PROJECT_OPTION_USE, (String)("The option '" + option.getPropertyName() + "' is deprecated." + defaultValueMessage + "\n" + ((Option.Status.Removed)status).getRemovedVersionMessage()), (String)option.getPropertyName(), null, (int)8, null);
                } else {
                    IssueReporter.reportError$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.UNSUPPORTED_PROJECT_OPTION_USE, (String)("The option '" + option.getPropertyName() + "' is deprecated." + defaultValueMessage + "\n" + ((Option.Status.Removed)status).getRemovedVersionMessage()), (String)option.getPropertyName(), null, (int)8, null);
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/errors/DeprecationReporterImpl$Companion;", "", "()V", "obsoleteApis", "", "", "options", "Lcom/android/build/gradle/internal/errors/OptionInfo;", "checkAndSet", "", "option", "value", "api", "clean", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean checkAndSet(@NotNull String api) {
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            Set set = obsoleteApis;
            synchronized (set) {
                boolean bl;
                boolean bl2 = false;
                if (obsoleteApis.contains(api)) {
                    bl = true;
                } else {
                    obsoleteApis.add(api);
                    bl = false;
                }
                boolean bl3 = bl;
                return bl3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean checkAndSet(@NotNull Object option, @NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Set set = options;
            synchronized (set) {
                boolean bl;
                boolean bl2 = false;
                OptionInfo info2 = new OptionInfo(option, value);
                if (options.contains(info2)) {
                    bl = true;
                } else {
                    options.add(info2);
                    bl = false;
                }
                boolean bl3 = bl;
                return bl3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clean() {
            Set set = obsoleteApis;
            synchronized (set) {
                boolean $i$a$-synchronized-DeprecationReporterImpl$Companion$clean$32 = false;
                obsoleteApis.clear();
                Unit $i$a$-synchronized-DeprecationReporterImpl$Companion$clean$32 = Unit.INSTANCE;
            }
            set = options;
            synchronized (set) {
                boolean bl = false;
                options.clear();
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

