/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profgen;

import com.android.tools.profgen.Apk;
import com.android.tools.profgen.DexFile;
import com.android.tools.profgen.DexFileData;
import com.android.tools.profgen.DexFileParserKt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0000\u001a\u0017\u0010\u0011\u001a\u00020\u0012*\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0080\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"dexClassesPattern", "Lkotlin/text/Regex;", "Apk", "Lcom/android/tools/profgen/Apk;", "file", "Ljava/io/File;", "name", "", "bytes", "", "DexFile", "Lcom/android/tools/profgen/DexFile;", "src", "Ljava/io/InputStream;", "splitParameters", "", "parameters", "plus", "Lcom/android/tools/profgen/DexFileData;", "other", "profgen"})
public final class DexDataKt {
    @NotNull
    private static final Regex dexClassesPattern = new Regex(".*/?(classes[0-9]*\\.dex)$");

    @NotNull
    public static final Apk Apk(@NotNull File file, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return DexDataKt.Apk(FilesKt.readBytes((File)file), name);
    }

    public static /* synthetic */ Apk Apk$default(File file, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return DexDataKt.Apk(file, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Apk Apk(@NotNull byte[] bytes2, @NotNull String name) {
        Apk apk;
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Closeable closeable = new ZipInputStream(new ByteArrayInputStream(bytes2));
        Throwable throwable = null;
        try {
            ZipInputStream zis = (ZipInputStream)closeable;
            boolean bl = false;
            List dexes = new ArrayList();
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                String fileName = zipEntry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
                if (!StringsKt.endsWith$default((String)fileName, (String)".dex", (boolean)false, (int)2, null)) {
                    zipEntry = zis.getNextEntry();
                    continue;
                }
                MatchResult fileNameMatches = dexClassesPattern.matchEntire((CharSequence)fileName);
                if (fileNameMatches == null) {
                    zipEntry = zis.getNextEntry();
                    continue;
                }
                String dexFileName = (String)fileNameMatches.getDestructured().getMatch().getGroupValues().get(1);
                DexFile dex = DexFileParserKt.parseDexFile(ByteStreamsKt.readBytes((InputStream)zis), dexFileName);
                dexes.add(dex);
                zipEntry = zis.getNextEntry();
            }
            apk = new Apk(dexes, name);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return apk;
    }

    public static /* synthetic */ Apk Apk$default(byte[] byArray, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return DexDataKt.Apk(byArray, string);
    }

    @NotNull
    public static final DexFile DexFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        InputStream inputStream = new FileInputStream(file);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        return DexDataKt.DexFile(inputStream, string);
    }

    @NotNull
    public static final DexFile DexFile(@NotNull InputStream src, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return DexFileParserKt.parseDexFile(ByteStreamsKt.readBytes((InputStream)src), name);
    }

    @NotNull
    public static final DexFileData plus(@NotNull DexFileData $this$plus, @Nullable DexFileData other) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        if (other == null) {
            return $this$plus;
        }
        return new DexFileData(SetsKt.plus($this$plus.getTypeIndexes(), (Iterable)other.getTypeIndexes()), SetsKt.plus($this$plus.getClassIndexes(), (Iterable)other.getClassIndexes()), MapsKt.plus($this$plus.getMethods(), other.getMethods()));
    }

    @NotNull
    public static final List<String> splitParameters(@NotNull String parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        List result2 = new ArrayList();
        StringBuilder currentParam = new StringBuilder(parameters.length());
        boolean inClassName = false;
        int n = parameters.length();
        for (int i = 0; i < n; ++i) {
            char c = parameters.charAt(i);
            currentParam.append(c);
            boolean bl = inClassName ? c != ';' : (inClassName = c == 'L');
            if (inClassName || c == '[') continue;
            String string = currentParam.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentParam.toString()");
            result2.add(string);
            StringsKt.clear((StringBuilder)currentParam);
        }
        return result2;
    }
}

