/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.generators;

import com.android.build.gradle.internal.generators.ManifestClassData;
import com.android.build.gradle.internal.generators.ManifestClassGeneratorKt;
import com.android.builder.compiling.GeneratedCodeFileCreator;
import com.android.builder.packaging.JarFlinger;
import com.android.ide.common.symbols.SymbolUtils;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u001e\u0010\u001a\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u0016\u0010\u001e\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001cH\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u001f\u001a\u00020\rH\u0002R!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000b\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/generators/ManifestClassGenerator;", "Lcom/android/builder/compiling/GeneratedCodeFileCreator;", "manifestClassData", "Lcom/android/build/gradle/internal/generators/ManifestClassData;", "(Lcom/android/build/gradle/internal/generators/ManifestClassData;)V", "customPermissions", "Lcom/google/common/collect/ImmutableList;", "", "getCustomPermissions", "()Lcom/google/common/collect/ImmutableList;", "customPermissions$delegate", "Lkotlin/Lazy;", "folderPath", "Ljava/io/File;", "getFolderPath", "()Ljava/io/File;", "fullyQualifiedManifestClassName", "getFullyQualifiedManifestClassName", "()Ljava/lang/String;", "fullyQualifiedManifestClassName$delegate", "generatedFilePath", "getGeneratedFilePath", "generate", "", "generateManifestClass", "", "generateManifestJar", "permissions", "", "outputJar", "generateManifestPermissionClass", "manifest", "gradle-core"})
public final class ManifestClassGenerator
implements GeneratedCodeFileCreator {
    @NotNull
    private final ManifestClassData manifestClassData;
    @NotNull
    private final Lazy fullyQualifiedManifestClassName$delegate;
    @NotNull
    private final Lazy customPermissions$delegate;

    public ManifestClassGenerator(@NotNull ManifestClassData manifestClassData) {
        Intrinsics.checkNotNullParameter((Object)manifestClassData, (String)"manifestClassData");
        this.manifestClassData = manifestClassData;
        this.fullyQualifiedManifestClassName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ ManifestClassGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return ((CharSequence)ManifestClassGenerator.access$getManifestClassData$p(this.this$0).getNamespace()).length() == 0 ? "Manifest" : StringsKt.replace$default((String)ManifestClassGenerator.access$getManifestClassData$p(this.this$0).getNamespace(), (char)'.', (char)'/', (boolean)false, (int)4, null) + "/Manifest";
            }
        }));
        this.customPermissions$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ImmutableList<String>>(this){
            final /* synthetic */ ManifestClassGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ImmutableList<String> invoke() {
                return ManifestClassGenerator.access$getCustomPermissions(this.this$0, ManifestClassGenerator.access$getManifestClassData$p(this.this$0).getManifestFile());
            }
        }));
    }

    @NotNull
    public File getFolderPath() {
        File file = this.manifestClassData.getOutputFilePath().getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"manifestClassData.outputFilePath.parentFile");
        return file;
    }

    @NotNull
    public File getGeneratedFilePath() {
        return this.manifestClassData.getOutputFilePath();
    }

    @NotNull
    public final String getFullyQualifiedManifestClassName() {
        Lazy lazy = this.fullyQualifiedManifestClassName$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final ImmutableList<String> getCustomPermissions() {
        Lazy lazy = this.customPermissions$delegate;
        return (ImmutableList)lazy.getValue();
    }

    public void generate() {
        this.generateManifestJar((List)this.getCustomPermissions(), this.manifestClassData.getOutputFilePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateManifestJar(List<String> permissions, File outputJar) {
        Closeable closeable = (Closeable)new JarFlinger(outputJar.toPath());
        Throwable throwable = null;
        try {
            JarFlinger it = (JarFlinger)closeable;
            boolean bl = false;
            it.setCompressionLevel(0);
            it.addEntry(this.getFullyQualifiedManifestClassName() + "$permission.class", (InputStream)new ByteArrayInputStream(this.generateManifestPermissionClass(permissions)));
            it.addEntry(this.getFullyQualifiedManifestClassName() + ".class", (InputStream)new ByteArrayInputStream(this.generateManifestClass()));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final byte[] generateManifestPermissionClass(List<String> permissions) {
        MethodVisitor methodVisitor;
        ClassWriter classWriter;
        TreeMap permissionsMap = new TreeMap();
        Iterable $this$forEach$iv = permissions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            ((Map)permissionsMap).put(ManifestClassGeneratorKt.getPermissionName(it), it);
        }
        ClassWriter $this$generateManifestPermissionClass_u24lambda_u2d4 = classWriter = new ClassWriter(1);
        boolean bl = false;
        $this$generateManifestPermissionClass_u24lambda_u2d4.visit(52, 25, this.getFullyQualifiedManifestClassName() + "$permission", null, "java/lang/Object", null);
        $this$generateManifestPermissionClass_u24lambda_u2d4.visitInnerClass(this.getFullyQualifiedManifestClassName() + "$permission", this.getFullyQualifiedManifestClassName(), "permission", 25);
        Map $this$forEach$iv2 = permissionsMap;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry permission = element$iv = iterator2.next();
            boolean bl2 = false;
            $this$generateManifestPermissionClass_u24lambda_u2d4.visitField(25, (String)permission.getKey(), "Ljava/lang/String;", null, permission.getValue()).visitEnd();
        }
        MethodVisitor $this$generateManifestPermissionClass_u24lambda_u2d4_u24lambda_u2d3 = methodVisitor = $this$generateManifestPermissionClass_u24lambda_u2d4.visitMethod(1, "<init>", "()V", null, null);
        boolean bl3 = false;
        $this$generateManifestPermissionClass_u24lambda_u2d4_u24lambda_u2d3.visitCode();
        $this$generateManifestPermissionClass_u24lambda_u2d4_u24lambda_u2d3.visitVarInsn(25, 0);
        $this$generateManifestPermissionClass_u24lambda_u2d4_u24lambda_u2d3.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        $this$generateManifestPermissionClass_u24lambda_u2d4_u24lambda_u2d3.visitInsn(177);
        $this$generateManifestPermissionClass_u24lambda_u2d4_u24lambda_u2d3.visitMaxs(1, 1);
        $this$generateManifestPermissionClass_u24lambda_u2d4_u24lambda_u2d3.visitEnd();
        $this$generateManifestPermissionClass_u24lambda_u2d4.visitEnd();
        byte[] byArray = classWriter.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"ClassWriter(ClassWriter.\u2026)\n        }.toByteArray()");
        return byArray;
    }

    private final byte[] generateManifestClass() {
        MethodVisitor methodVisitor;
        ClassWriter classWriter;
        ClassWriter $this$generateManifestClass_u24lambda_u2d6 = classWriter = new ClassWriter(1);
        boolean bl = false;
        $this$generateManifestClass_u24lambda_u2d6.visit(52, 49, this.getFullyQualifiedManifestClassName(), null, "java/lang/Object", null);
        $this$generateManifestClass_u24lambda_u2d6.visitInnerClass(this.getFullyQualifiedManifestClassName() + "$permission", this.getFullyQualifiedManifestClassName(), "permission", 25);
        MethodVisitor $this$generateManifestClass_u24lambda_u2d6_u24lambda_u2d5 = methodVisitor = $this$generateManifestClass_u24lambda_u2d6.visitMethod(1, "<init>", "()V", null, null);
        boolean bl2 = false;
        $this$generateManifestClass_u24lambda_u2d6_u24lambda_u2d5.visitCode();
        $this$generateManifestClass_u24lambda_u2d6_u24lambda_u2d5.visitVarInsn(25, 0);
        $this$generateManifestClass_u24lambda_u2d6_u24lambda_u2d5.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        $this$generateManifestClass_u24lambda_u2d6_u24lambda_u2d5.visitInsn(177);
        $this$generateManifestClass_u24lambda_u2d6_u24lambda_u2d5.visitMaxs(1, 1);
        $this$generateManifestClass_u24lambda_u2d6_u24lambda_u2d5.visitEnd();
        $this$generateManifestClass_u24lambda_u2d6.visitEnd();
        byte[] byArray = classWriter.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"ClassWriter(ClassWriter.\u2026)\n        }.toByteArray()");
        return byArray;
    }

    private final ImmutableList<String> getCustomPermissions(File manifest) {
        ImmutableList immutableList = SymbolUtils.parseManifest((File)manifest).getCustomPermissions();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"parseManifest(manifest).customPermissions");
        return immutableList;
    }

    public static final /* synthetic */ ManifestClassData access$getManifestClassData$p(ManifestClassGenerator $this) {
        return $this.manifestClassData;
    }

    public static final /* synthetic */ ImmutableList access$getCustomPermissions(ManifestClassGenerator $this, File manifest) {
        return $this.getCustomPermissions(manifest);
    }
}

