/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.apksig.apk.ApkUtils;
import com.android.build.api.artifact.Artifact;
import com.android.build.api.variant.impl.BuiltArtifactImpl;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.tasks.BuildPrivacySandboxSdkApks;
import com.android.utils.FileUtils;
import com.android.zipflinger.ZipArchive;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="Task only extracts zips")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/tasks/BuildPrivacySandboxSdkApks;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "deviceConfig", "Lorg/gradle/api/file/RegularFileProperty;", "getDeviceConfig", "()Lorg/gradle/api/file/RegularFileProperty;", "ideModelFile", "getIdeModelFile", "sdkApks", "Lorg/gradle/api/file/DirectoryProperty;", "getSdkApks", "()Lorg/gradle/api/file/DirectoryProperty;", "sdkApksArchives", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getSdkApksArchives", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "doTaskAction", "", "Companion", "CreationAction", "gradle-core"})
public abstract class BuildPrivacySandboxSdkApks
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getSdkApksArchives();

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getDeviceConfig();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getSdkApks();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getIdeModelFile();

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doTaskAction() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        LogLevel logLevel;
        LogLevel logLevel2 = logLevel = this.getDeviceConfig().isPresent() ? LogLevel.INFO : LogLevel.LIFECYCLE;
        if (this.getSdkApksArchives().isEmpty()) {
            this.getLogger().log(logLevel, "There are no privacy sandbox SDK dependencies for " + this.getProjectPath().get() + " " + this.getVariantName() + " ");
            return;
        }
        Path outputDirectory = ((Directory)this.getSdkApks().get()).getAsFile().toPath();
        Path ideModel = ((RegularFile)this.getIdeModelFile().get()).getAsFile().toPath();
        FileUtils.cleanOutputDir((File)outputDirectory.toFile());
        Files.deleteIfExists(ideModel);
        List artifacts2 = new ArrayList();
        Set set = this.getSdkApksArchives().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"sdkApksArchives.files");
        Iterable iterable = set;
        Companion companion = Companion;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toPath());
        }
        Iterable iterable2 = (List)destination$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)outputDirectory, (String)"outputDirectory");
        companion.forEachInputFile(iterable2, outputDirectory, (Function2<? super Path, ? super Path, Unit>)((Function2)new Function2<Path, Path, Unit>((List<BuiltArtifactsImpl>)artifacts2, this, logLevel){
            final /* synthetic */ List<BuiltArtifactsImpl> $artifacts;
            final /* synthetic */ BuildPrivacySandboxSdkApks this$0;
            final /* synthetic */ LogLevel $logLevel;
            {
                this.$artifacts = $artifacts;
                this.this$0 = $receiver;
                this.$logLevel = $logLevel;
                super(2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull Path archive, @NotNull Path subDirectory) {
                Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
                Intrinsics.checkNotNullParameter((Object)subDirectory, (String)"subDirectory");
                Files.createDirectory(subDirectory, new FileAttribute[0]);
                Path outputFile = subDirectory.resolve("standalone.apk");
                Closeable closeable = (Closeable)new ZipArchive(archive);
                List<BuiltArtifactsImpl> list = this.$artifacts;
                BuildPrivacySandboxSdkApks buildPrivacySandboxSdkApks = this.this$0;
                LogLevel logLevel = this.$logLevel;
                Throwable throwable = null;
                try {
                    ZipArchive it = (ZipArchive)closeable;
                    boolean bl = false;
                    Closeable closeable2 = it.getInputStream("standalones/standalone.apk");
                    Throwable throwable2 = null;
                    try {
                        InputStream inputStream = (InputStream)closeable2;
                        boolean bl2 = false;
                        Files.copy(inputStream, outputFile, new CopyOption[0]);
                        Closeable closeable3 = (Closeable)new ZipArchive(outputFile);
                        Throwable throwable3 = null;
                        try {
                            ZipArchive apk = (ZipArchive)closeable3;
                            boolean bl3 = false;
                            Artifact artifact = (Artifact)InternalArtifactType.EXTRACTED_APKS_FROM_PRIVACY_SANDBOX_SDKs.INSTANCE;
                            String string = ApkUtils.getPackageNameFromBinaryAndroidManifest((ByteBuffer)apk.getContent("AndroidManifest.xml"));
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageNameFromBinary\u2026t(\"AndroidManifest.xml\"))");
                            list.add(new BuiltArtifactsImpl(0, artifact, string, "", CollectionsKt.listOf((Object)BuiltArtifactImpl.Companion.make$default(BuiltArtifactImpl.Companion, ((Object)outputFile).toString(), null, null, null, null, 30, null)), null, 33, null));
                            buildPrivacySandboxSdkApks.getLogger().log(logLevel, "Extracted sandbox SDK APK for " + buildPrivacySandboxSdkApks.getProjectPath().get() + " " + buildPrivacySandboxSdkApks.getVariantName() + ": " + outputFile);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)ideModel, (String)"ideModel");
        BuiltArtifactsImpl.Companion.saveAll(artifacts2, ideModel);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JV\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u000726\u0010\t\u001a2\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u00040\nH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/tasks/BuildPrivacySandboxSdkApks$Companion;", "", "()V", "forEachInputFile", "", "inputFiles", "", "Ljava/nio/file/Path;", "outputDirectory", "action", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "input", "outputSubDirectory", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public final void forEachInputFile(@NotNull Iterable<? extends Path> inputFiles, @NotNull Path outputDirectory, @NotNull Function2<? super Path, ? super Path, Unit> action) {
            Intrinsics.checkNotNullParameter(inputFiles, (String)"inputFiles");
            Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            Set usedOutputNames = new LinkedHashSet();
            for (Path path : inputFiles) {
                String key = StringsKt.substringBeforeLast$default((String)((Object)path.getFileName()).toString(), (char)'.', null, (int)2, null);
                int index = 0;
                Object candidateSubDirectoryName = key;
                while (!usedOutputNames.add(candidateSubDirectoryName)) {
                    candidateSubDirectoryName = key + "_" + ++index;
                }
                Path path2 = outputDirectory.resolve((String)candidateSubDirectoryName);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"outputDirectory.resolve(candidateSubDirectoryName)");
                action.invoke((Object)path, (Object)path2);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/tasks/BuildPrivacySandboxSdkApks$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/tasks/BuildPrivacySandboxSdkApks;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Companion", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<BuildPrivacySandboxSdkApks, ApkCreationConfig> {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig, false);
        }

        @Override
        @NotNull
        public String getName() {
            return Companion.getTaskName(this.creationConfig);
        }

        @Override
        @NotNull
        public Class<BuildPrivacySandboxSdkApks> getType() {
            return BuildPrivacySandboxSdkApks.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<BuildPrivacySandboxSdkApks> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).on(InternalArtifactType.EXTRACTED_APKS_FROM_PRIVACY_SANDBOX_SDKs.INSTANCE);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.2.INSTANCE).withName("ide_model.json").on(InternalArtifactType.EXTRACTED_APKS_FROM_PRIVACY_SANDBOX_SDKs_IDE_MODEL.INSTANCE);
        }

        @Override
        public void configure(@NotNull BuildPrivacySandboxSdkApks task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            Object[] objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(((ApkCreationConfig)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_SDK_APKS, null, 8, null)};
            HasConfigurableValuesKt.fromDisallowChanges(task.getSdkApksArchives(), objectArray);
            String deviceConfigPath = ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(StringOption.IDE_APK_SELECT_CONFIG);
            if (deviceConfigPath != null) {
                task.getDeviceConfig().set(new File(deviceConfigPath));
            }
            task.getDeviceConfig().disallowChanges();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/tasks/BuildPrivacySandboxSdkApks$CreationAction$Companion;", "", "()V", "getTaskName", "", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "gradle-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String getTaskName(@NotNull ComponentCreationConfig creationConfig) {
                Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
                return creationConfig.computeTaskName("buildPrivacySandboxSdkApksFor");
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

