/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.privaysandboxsdk.AsarUtilsKt;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@CacheableTransform
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/AsarTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/tasks/AsarTransform$Parameters;", "()V", "asar", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getAsar", "()Lorg/gradle/api/provider/Provider;", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "Companion", "Parameters", "gradle-core"})
public abstract class AsarTransform
implements TransformAction<Parameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<AndroidArtifacts.ArtifactType> supportedAsarTransformTypes;

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getAsar();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(@NotNull TransformOutputs outputs2) {
        Intrinsics.checkNotNullParameter((Object)outputs2, (String)"outputs");
        File asarFile = ((FileSystemLocation)this.getAsar().get()).getAsFile();
        Closeable closeable = new ZipFile(asarFile);
        Throwable throwable = null;
        try {
            Object object;
            AndroidArtifacts.ArtifactType targetType;
            ZipFile it = (ZipFile)closeable;
            boolean bl = false;
            AndroidArtifacts.ArtifactType artifactType = targetType = (AndroidArtifacts.ArtifactType)((Object)((Parameters)this.getParameters()).getTargetType().get());
            switch (artifactType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[artifactType.ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNullExpressionValue((Object)asarFile, (String)"asarFile");
                    Path outputFile = outputs2.file((Object)(FilesKt.getNameWithoutExtension((File)asarFile) + "_SdkMetadata.pb")).toPath();
                    Closeable closeable2 = it.getInputStream(it.getEntry("SdkMetadata.pb"));
                    Throwable throwable2 = null;
                    try {
                        Object protoBytes = (InputStream)closeable2;
                        boolean bl2 = false;
                        protoBytes = Files.copy((InputStream)protoBytes, outputFile, new CopyOption[0]);
                        object = protoBytes;
                        break;
                    }
                    catch (Throwable protoBytes) {
                        throwable2 = protoBytes;
                        throw protoBytes;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                }
                case 2: {
                    File sdkInterfaceDescriptor = outputs2.file((Object)"sdk-interface-descriptors.jar");
                    ZipEntry entry = it.getEntry("sdk-interface-descriptors.jar");
                    Closeable closeable3 = it.getInputStream(entry);
                    Throwable protoBytes = null;
                    try {
                        InputStream jar = (InputStream)closeable3;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)sdkInterfaceDescriptor, (String)"sdkInterfaceDescriptor");
                        byte[] byArray = jar.readAllBytes();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"jar.readAllBytes()");
                        FilesKt.writeBytes((File)sdkInterfaceDescriptor, (byte[])byArray);
                        jar = Unit.INSTANCE;
                    }
                    catch (Throwable jar) {
                        protoBytes = jar;
                        throw jar;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)protoBytes);
                    }
                    object = Unit.INSTANCE;
                    break;
                }
                case 3: {
                    Intrinsics.checkNotNullExpressionValue((Object)asarFile, (String)"asarFile");
                    Path manifest = outputs2.file((Object)(FilesKt.getNameWithoutExtension((File)asarFile) + "_AndroidManifest.xml")).toPath();
                    Closeable closeable4 = it.getInputStream(it.getEntry("AndroidManifest.xml"));
                    Throwable throwable3 = null;
                    try {
                        InputStream asarManifest = (InputStream)closeable4;
                        boolean bl4 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)asarManifest, (String)"asarManifest");
                        String newManifestString = AsarUtilsKt.tagAllElementsAsRequiredByPrivacySandboxSdk(asarManifest);
                        Path path = Files.writeString(manifest, (CharSequence)newManifestString, new OpenOption[0]);
                        object = path;
                        break;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable4, (Throwable)throwable3);
                    }
                }
                default: {
                    throw new IllegalStateException(("There is not yet support from transforming the asar format to " + targetType).toString());
                }
            }
            Object object2 = object;
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static {
        AndroidArtifacts.ArtifactType[] artifactTypeArray = new AndroidArtifacts.ArtifactType[]{AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_SDK_METADATA_PROTO, AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_SDK_INTERFACE_DESCRIPTOR, AndroidArtifacts.ArtifactType.MANIFEST};
        supportedAsarTransformTypes = CollectionsKt.listOf((Object[])artifactTypeArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/tasks/AsarTransform$Parameters;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "targetType", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ArtifactType;", "getTargetType", "()Lorg/gradle/api/provider/Property;", "gradle-core"})
    public static interface Parameters
    extends GenericTransformParameters {
        @Input
        @NotNull
        public Property<AndroidArtifacts.ArtifactType> getTargetType();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/tasks/AsarTransform$Companion;", "", "()V", "supportedAsarTransformTypes", "", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ArtifactType;", "getSupportedAsarTransformTypes", "()Ljava/util/List;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<AndroidArtifacts.ArtifactType> getSupportedAsarTransformTypes() {
            return supportedAsarTransformTypes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AndroidArtifacts.ArtifactType.values().length];
            nArray[AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_SDK_METADATA_PROTO.ordinal()] = 1;
            nArray[AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_SDK_INTERFACE_DESCRIPTOR.ordinal()] = 2;
            nArray[AndroidArtifacts.ArtifactType.MANIFEST.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

