/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.coverage.JacocoConfigurations;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.FileInfo;
import com.android.build.gradle.internal.tasks.JarsClasspathInputsWithIdentity;
import com.android.build.gradle.internal.tasks.JarsIdentityMapping;
import com.android.build.gradle.internal.tasks.NewIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.IncrementalChangesUtils;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.files.SerializableChange;
import com.android.builder.files.SerializableFileChanges;
import com.android.utils.FileUtils;
import com.android.utils.PathUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.jacoco.core.runtime.OfflineInstrumentationAccessGenerator;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.TEST)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u0000 &2\u00020\u0001:\u0005%&'()B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006R\u0014\u0010\u000e\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006*"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask;", "Lcom/android/build/gradle/internal/tasks/NewIncrementalTask;", "()V", "classesDir", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClassesDir", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "forceOutOfProcess", "Lorg/gradle/api/provider/Property;", "", "getForceOutOfProcess", "()Lorg/gradle/api/provider/Property;", "jacocoAntTaskConfiguration", "getJacocoAntTaskConfiguration", "jarsWithIdentity", "Lcom/android/build/gradle/internal/tasks/JarsClasspathInputsWithIdentity;", "getJarsWithIdentity", "()Lcom/android/build/gradle/internal/tasks/JarsClasspathInputsWithIdentity;", "outputForDirs", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputForDirs", "()Lorg/gradle/api/file/DirectoryProperty;", "outputForJars", "getOutputForJars", "workQueue", "Lorg/gradle/workers/WorkQueue;", "getWorkQueue", "()Lorg/gradle/workers/WorkQueue;", "doTaskAction", "", "inputChanges", "Lorg/gradle/work/InputChanges;", "processDirectories", "processJars", "removeFile", "fileToRemove", "Lcom/android/builder/files/SerializableChange;", "Action", "Companion", "CreationAction", "InstrumentDirAction", "InstrumentJarAction", "gradle-core"})
public abstract class JacocoTask
extends NewIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Pattern CLASS_PATTERN = Pattern.compile(".*\\.class$");
    private static final Pattern KOTLIN_MODULE_PATTERN = Pattern.compile("^META-INF/.*\\.kotlin_module$");

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getJacocoAntTaskConfiguration();

    @Nested
    @NotNull
    public abstract JarsClasspathInputsWithIdentity getJarsWithIdentity();

    @Classpath
    @Incremental
    @NotNull
    public abstract ConfigurableFileCollection getClassesDir();

    @Input
    @NotNull
    public abstract Property<Boolean> getForceOutOfProcess();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputForDirs();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputForJars();

    @Override
    public void doTaskAction(@NotNull InputChanges inputChanges) {
        Intrinsics.checkNotNullParameter((Object)inputChanges, (String)"inputChanges");
        this.processDirectories(inputChanges);
        this.processJars(inputChanges);
    }

    private final void processDirectories(InputChanges inputChanges) {
        Iterable iterable = inputChanges.getFileChanges((FileCollection)this.getClassesDir());
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"inputChanges.getFileChanges(classesDir)");
        SerializableFileChanges changes = IncrementalChangesUtils.toSerializable(iterable);
        Set filesToProcess = new HashSet(changes.getAddedFiles());
        for (SerializableChange removedFile : changes.getRemovedFiles()) {
            this.removeFile(removedFile);
        }
        for (Object modifiedFile : changes.getModifiedFiles()) {
            this.removeFile((SerializableChange)modifiedFile);
            filesToProcess.add(modifiedFile);
        }
        Map toProcess = new EnumMap(Action.class);
        for (SerializableChange change : filesToProcess) {
            Action action = Companion.calculateAction(change.getNormalizedPath());
            if (action == Action.IGNORE) continue;
            List byAction = toProcess.getOrDefault((Object)action, new ArrayList());
            byAction.add(change);
            toProcess.put(action, byAction);
        }
        WorkQueue workQueue2 = this.getWorkQueue();
        workQueue2.submit(InstrumentDirAction.class, new org.gradle.api.Action(toProcess, this){
            final /* synthetic */ Map<Action, List<SerializableChange>> $toProcess;
            final /* synthetic */ JacocoTask this$0;
            {
                this.$toProcess = $toProcess;
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull InstrumentDirAction.Parameters params) {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                params.getChangesToProcess().set(this.$toProcess);
                params.getOutput().set(this.this$0.getOutputForDirs().getAsFile());
            }
        });
    }

    private final void processJars(InputChanges inputChanges) {
        JarsIdentityMapping mappingState = this.getJarsWithIdentity().getMappingState(inputChanges);
        if (mappingState.getReprocessAll()) {
            try {
                FileUtils.deleteDirectoryContents((File)((Directory)this.getOutputForJars().get()).getAsFile());
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        for (Map.Entry<File, FileInfo> entry : mappingState.getJarsInfo().entrySet()) {
            File key = entry.getKey();
            FileInfo fileInfo = entry.getValue();
            if (!fileInfo.getHasChanged()) continue;
            File file = ((Directory)this.getOutputForJars().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputForJars.get().asFile");
            String string = Objects.requireNonNull(fileInfo.getIdentity());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"requireNonNull(fileInfo.identity)");
            File instrumentedJar = JacocoTask.Companion.getCorrespondingInstrumentedJar(file, string);
            try {
                FileUtils.deleteIfExists((File)instrumentedJar);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            WorkQueue workQueue2 = this.getWorkQueue();
            workQueue2.submit(InstrumentJarAction.class, new org.gradle.api.Action(key, instrumentedJar){
                final /* synthetic */ File $key;
                final /* synthetic */ File $instrumentedJar;
                {
                    this.$key = $key;
                    this.$instrumentedJar = $instrumentedJar;
                }

                public final void execute(@NotNull InstrumentJarAction.Parameters params) {
                    Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                    params.getRoot().set((Object)this.$key);
                    params.getOutput().set((Object)this.$instrumentedJar);
                }
            });
        }
    }

    private final void removeFile(SerializableChange fileToRemove) {
        Action action = Companion.calculateAction(fileToRemove.getNormalizedPath());
        if (action == Action.IGNORE) {
            return;
        }
        Path outputPath = ((Directory)this.getOutputForDirs().get()).getAsFile().toPath().resolve(fileToRemove.getNormalizedPath());
        try {
            PathUtils.deleteRecursivelyIfExists((Path)outputPath);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private final WorkQueue getWorkQueue() {
        WorkQueue workQueue2;
        Object object = this.getForceOutOfProcess().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"forceOutOfProcess.get()");
        if (((Boolean)object).booleanValue()) {
            WorkQueue workQueue3 = this.getWorkerExecutor().processIsolation(new org.gradle.api.Action(this){
                final /* synthetic */ JacocoTask this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void execute(@NotNull ProcessWorkerSpec spec) {
                    Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
                    Object[] objectArray = new Object[]{this.this$0.getJacocoAntTaskConfiguration()};
                    spec.getClasspath().from(objectArray);
                }
            });
            workQueue2 = workQueue3;
            Intrinsics.checkNotNullExpressionValue((Object)workQueue3, (String)"get() = if (forceOutOfPr\u2026              }\n        }");
        } else {
            WorkQueue workQueue4 = this.getWorkerExecutor().classLoaderIsolation(new org.gradle.api.Action(this){
                final /* synthetic */ JacocoTask this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void execute(@NotNull ClassLoaderWorkerSpec spec) {
                    Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
                    Object[] objectArray = new Object[]{this.this$0.getJacocoAntTaskConfiguration()};
                    spec.getClasspath().from(objectArray);
                }
            });
            workQueue2 = workQueue4;
            Intrinsics.checkNotNullExpressionValue((Object)workQueue4, (String)"get() = if (forceOutOfPr\u2026              }\n        }");
        }
        return workQueue2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask$Action;", "", "patterns", "", "Ljava/util/regex/Pattern;", "(Ljava/lang/String;I[Ljava/util/regex/Pattern;)V", "Lcom/google/common/collect/ImmutableList;", "getPatterns", "()Lcom/google/common/collect/ImmutableList;", "COPY", "IGNORE", "INSTRUMENT", "gradle-core"})
    public static final class Action
    extends Enum<Action> {
        @NotNull
        private final ImmutableList<Pattern> patterns;
        public static final /* enum */ Action COPY;
        public static final /* enum */ Action IGNORE;
        public static final /* enum */ Action INSTRUMENT;
        private static final /* synthetic */ Action[] $VALUES;

        private Action(Pattern ... patterns) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (Pattern pattern : patterns) {
                Preconditions.checkNotNull((Object)pattern);
                builder.add((Object)pattern);
            }
            ImmutableList immutableList = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"builder.build()");
            this.patterns = immutableList;
        }

        @NotNull
        public final ImmutableList<Pattern> getPatterns() {
            return this.patterns;
        }

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String value) {
            return Enum.valueOf(Action.class, value);
        }

        static {
            Pattern[] patternArray = new Pattern[1];
            Intrinsics.checkNotNullExpressionValue((Object)KOTLIN_MODULE_PATTERN, (String)"KOTLIN_MODULE_PATTERN");
            COPY = new Action(patternArray);
            IGNORE = new Action(new Pattern[0]);
            patternArray = new Pattern[1];
            Intrinsics.checkNotNullExpressionValue((Object)CLASS_PATTERN, (String)"CLASS_PATTERN");
            INSTRUMENT = new Action(patternArray);
            $VALUES = actionArray = new Action[]{Action.COPY, Action.IGNORE, Action.INSTRUMENT};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0006\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask$InstrumentDirAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/tasks/JacocoTask$InstrumentDirAction$Parameters;", "()V", "execute", "", "Companion", "Parameters", "gradle-core"})
    public static abstract class InstrumentDirAction
    implements WorkAction<Parameters> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final LoggerWrapper logger;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            WorkParameters workParameters = this.getParameters();
            Intrinsics.checkNotNull((Object)workParameters);
            Map inputs = (Map)((Parameters)workParameters).getChangesToProcess().get();
            WorkParameters workParameters2 = this.getParameters();
            Intrinsics.checkNotNull((Object)workParameters2);
            File outputDir = (File)((Parameters)workParameters2).getOutput().get();
            Instrumenter instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)new OfflineInstrumentationAccessGenerator());
            for (SerializableChange toInstrument : (List)inputs.getOrDefault((Object)Action.INSTRUMENT, ImmutableList.of())) {
                logger.info("Instrumenting file: " + toInstrument.getFile().getAbsolutePath(), new Object[0]);
                try {
                    Closeable closeable = Files.asByteSource((File)toInstrument.getFile()).openBufferedStream();
                    Throwable throwable = null;
                    try {
                        InputStream inputStream = (InputStream)closeable;
                        boolean bl = false;
                        byte[] instrumented = instrumenter.instrument(inputStream, toInstrument.toString());
                        File outputFile = new File(outputDir, toInstrument.getNormalizedPath());
                        Files.createParentDirs((File)outputFile);
                        Files.write((byte[])instrumented, (File)outputFile);
                        inputStream = Unit.INSTANCE;
                    }
                    catch (Throwable inputStream) {
                        throwable = inputStream;
                        throw inputStream;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to instrument file with Jacoco: " + toInstrument.getFile(), e);
                }
            }
            for (SerializableChange serializableChange : (List)inputs.getOrDefault((Object)Action.COPY, ImmutableList.of())) {
                File file = serializableChange.component1();
                String normalizedPath = serializableChange.component3();
                File outputFile = new File(outputDir, normalizedPath);
                try {
                    Files.createParentDirs((File)outputFile);
                    Files.copy((File)file, (File)outputFile);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to copy file: " + file, e);
                }
            }
        }

        static {
            LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(InstrumentDirAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"getLogger(\n             \u2026:class.java\n            )");
            logger = loggerWrapper;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask$InstrumentDirAction$Parameters;", "Lorg/gradle/workers/WorkParameters;", "()V", "changesToProcess", "Lorg/gradle/api/provider/MapProperty;", "Lcom/android/build/gradle/internal/tasks/JacocoTask$Action;", "", "Lcom/android/builder/files/SerializableChange;", "getChangesToProcess", "()Lorg/gradle/api/provider/MapProperty;", "output", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getOutput", "()Lorg/gradle/api/provider/Property;", "gradle-core"})
        public static abstract class Parameters
        implements WorkParameters {
            @NotNull
            public abstract MapProperty<Action, List<SerializableChange>> getChangesToProcess();

            @NotNull
            public abstract Property<File> getOutput();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask$InstrumentDirAction$Companion;", "", "()V", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "gradle-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0006\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask$InstrumentJarAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/tasks/JacocoTask$InstrumentJarAction$Parameters;", "()V", "execute", "", "Companion", "Parameters", "gradle-core"})
    public static abstract class InstrumentJarAction
    implements WorkAction<Parameters> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final LoggerWrapper logger;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            File inputJar;
            File file = inputJar = (File)((Parameters)this.getParameters()).getRoot().get();
            logger.info("Instrumenting jar: " + (file != null ? file.getAbsolutePath() : null), new Object[0]);
            File instrumentedJar = (File)((Parameters)this.getParameters()).getOutput().get();
            Instrumenter instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)new OfflineInstrumentationAccessGenerator());
            try {
                Closeable closeable = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(instrumentedJar)));
                Throwable throwable = null;
                try {
                    ZipOutputStream outputZip = (ZipOutputStream)closeable;
                    boolean bl = false;
                    Closeable closeable2 = new ZipFile(inputJar);
                    Throwable throwable2 = null;
                    try {
                        ZipFile zipFile = (ZipFile)closeable2;
                        boolean bl2 = false;
                        Enumeration<? extends ZipEntry> entries2 = zipFile.entries();
                        while (entries2.hasMoreElements()) {
                            ZipEntry entry = entries2.nextElement();
                            String entryName = entry.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)entryName, (String)"entryName");
                            Action entryAction = Companion.calculateAction(entryName);
                            if (entryAction == Action.IGNORE) continue;
                            InputStream classInputStream = zipFile.getInputStream(entry);
                            byte[] data = null;
                            data = entryAction == Action.INSTRUMENT ? instrumenter.instrument(classInputStream, entryName) : ByteStreams.toByteArray((InputStream)classInputStream);
                            ZipEntry nextEntry = new ZipEntry(entryName);
                            nextEntry.setTime(-1L);
                            outputZip.putNextEntry(nextEntry);
                            outputZip.write(data);
                            outputZip.closeEntry();
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to instrument file with Jacoco: " + inputJar, e);
            }
        }

        static {
            LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(InstrumentJarAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"getLogger(\n             \u2026:class.java\n            )");
            logger = loggerWrapper;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask$InstrumentJarAction$Parameters;", "Lorg/gradle/workers/WorkParameters;", "()V", "output", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getOutput", "()Lorg/gradle/api/provider/Property;", "root", "getRoot", "gradle-core"})
        public static abstract class Parameters
        implements WorkParameters {
            @NotNull
            public abstract Property<File> getRoot();

            @NotNull
            public abstract Property<File> getOutput();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask$InstrumentJarAction$Companion;", "", "()V", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "gradle-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/JacocoTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<JacocoTask, ComponentCreationConfig> {
        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return VariantTaskCreationAction.computeTaskName$default(this, "jacoco", null, 2, null);
        }

        @Override
        @NotNull
        public Class<JacocoTask> getType() {
            return JacocoTask.class;
        }

        @Override
        public void configure(@NotNull JacocoTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            Object[] objectArray = new Object[]{JacocoConfigurations.getJacocoAntTaskConfiguration(task.getProject(), Companion.getJacocoVersion(this.creationConfig))};
            task.getJacocoAntTaskConfiguration().from(objectArray);
            task.getForceOutOfProcess().set((Object)this.creationConfig.getServices().getProjectOptions().get(BooleanOption.FORCE_JACOCO_OUT_OF_PROCESS));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask$Companion;", "", "()V", "CLASS_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "KOTLIN_MODULE_PATTERN", "calculateAction", "Lcom/android/build/gradle/internal/tasks/JacocoTask$Action;", "inputRelativePath", "", "getCorrespondingInstrumentedJar", "Ljava/io/File;", "outputFolder", "identity", "getJacocoVersion", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getJacocoVersion(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            return creationConfig.getGlobal().getTestCoverage().getJacocoVersion();
        }

        @NotNull
        public final Action calculateAction(@NotNull String inputRelativePath) {
            Intrinsics.checkNotNullParameter((Object)inputRelativePath, (String)"inputRelativePath");
            if (StringsKt.startsWith$default((String)inputRelativePath, (String)"org/jacoco", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)inputRelativePath, (String)"org/junit/runner/notification/RunListener", (boolean)false, (int)2, null)) {
                return Action.COPY;
            }
            for (Pattern pattern : Action.COPY.getPatterns()) {
                if (!pattern.matcher(inputRelativePath).matches()) continue;
                return Action.COPY;
            }
            for (Pattern pattern : Action.INSTRUMENT.getPatterns()) {
                if (!pattern.matcher(inputRelativePath).matches()) continue;
                return Action.INSTRUMENT;
            }
            return Action.IGNORE;
        }

        private final File getCorrespondingInstrumentedJar(File outputFolder, String identity) {
            return new File(outputFolder, identity + ".jar");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

