/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.ScopedArtifact;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.artifact.impl.InternalScopedArtifacts;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.variant.ScopedArtifacts;
import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.PostprocessingFeatures;
import com.android.build.gradle.internal.component.ApplicationCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.component.TestComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.component.features.OptimizationCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.ProguardConfigurableTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.features.OptimizationTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.features.OptimizationTaskCreationActionImpl;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.core.ComponentType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.OPTIMIZATION)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u00002\u00020\u0001:\u0001AB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u00107\u001a\b\u0012\u0004\u0012\u000209082\u0006\u0010:\u001a\u00020;2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020=0<H\u0000\u00a2\u0006\u0002\b>J\u0012\u0010?\u001a\u0004\u0018\u0001092\u0006\u0010@\u001a\u000209H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0014\u0010\u0010\u001a\u00020\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\bR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\rR\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\rR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\rR \u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020#8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\bR\u0014\u0010)\u001a\u00020*8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\bR\u0014\u00101\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\bR\u0014\u00103\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\bR\u0014\u00105\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\b\u00a8\u0006B"}, d2={"Lcom/android/build/gradle/internal/tasks/ProguardConfigurableTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "(Lorg/gradle/api/file/ProjectLayout;)V", "classes", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasses", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "componentType", "Lorg/gradle/api/provider/Property;", "Lcom/android/builder/core/ComponentType;", "getComponentType", "()Lorg/gradle/api/provider/Property;", "configurationFiles", "getConfigurationFiles", "extractedDefaultProguardFile", "Lorg/gradle/api/file/DirectoryProperty;", "getExtractedDefaultProguardFile", "()Lorg/gradle/api/file/DirectoryProperty;", "generatedProguardFile", "getGeneratedProguardFile", "hasAllAccessTransformers", "", "getHasAllAccessTransformers", "ignoreAllLibraryKeepRules", "getIgnoreAllLibraryKeepRules", "ignoredLibraryKeepRules", "Lorg/gradle/api/provider/SetProperty;", "", "getIgnoredLibraryKeepRules", "()Lorg/gradle/api/provider/SetProperty;", "includeFeaturesInScopes", "getIncludeFeaturesInScopes", "<set-?>", "Lorg/gradle/api/artifacts/ArtifactCollection;", "libraryKeepRules", "getLibraryKeepRules", "()Lorg/gradle/api/artifacts/ArtifactCollection;", "libraryKeepRulesFileCollection", "getLibraryKeepRulesFileCollection", "mappingFile", "Lorg/gradle/api/file/RegularFileProperty;", "getMappingFile", "()Lorg/gradle/api/file/RegularFileProperty;", "getProjectLayout", "()Lorg/gradle/api/file/ProjectLayout;", "referencedClasses", "getReferencedClasses", "referencedResources", "getReferencedResources", "resources", "getResources", "testedMappingFile", "getTestedMappingFile", "reconcileDefaultProguardFile", "", "Ljava/io/File;", "proguardFiles", "Lorg/gradle/api/file/FileCollection;", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "reconcileDefaultProguardFile$gradle_core", "removeIfAbsent", "file", "CreationAction", "gradle-core"})
public abstract class ProguardConfigurableTask
extends NonIncrementalTask {
    @NotNull
    private final ProjectLayout projectLayout;
    private ArtifactCollection libraryKeepRules;

    public ProguardConfigurableTask(@NotNull ProjectLayout projectLayout) {
        Intrinsics.checkNotNullParameter((Object)projectLayout, (String)"projectLayout");
        this.projectLayout = projectLayout;
    }

    @Internal
    @NotNull
    public final ProjectLayout getProjectLayout() {
        return this.projectLayout;
    }

    @Input
    @NotNull
    public abstract Property<ComponentType> getComponentType();

    @Input
    @NotNull
    public abstract Property<Boolean> getIncludeFeaturesInScopes();

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getTestedMappingFile();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getClasses();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getResources();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getReferencedClasses();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getReferencedResources();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getExtractedDefaultProguardFile();

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getGeneratedProguardFile();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getConfigurationFiles();

    @Internal
    @NotNull
    public final ArtifactCollection getLibraryKeepRules() {
        ArtifactCollection artifactCollection = this.libraryKeepRules;
        if (artifactCollection != null) {
            return artifactCollection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"libraryKeepRules");
        return null;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getLibraryKeepRulesFileCollection();

    @Input
    @NotNull
    public abstract SetProperty<String> getIgnoredLibraryKeepRules();

    @Input
    @NotNull
    public abstract Property<Boolean> getIgnoreAllLibraryKeepRules();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getMappingFile();

    @Input
    @NotNull
    public abstract Property<Boolean> getHasAllAccessTransformers();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<File> reconcileDefaultProguardFile$gradle_core(@NotNull FileCollection proguardFiles2, @NotNull Provider<Directory> extractedDefaultProguardFile) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)proguardFiles2, (String)"proguardFiles");
        Intrinsics.checkNotNullParameter(extractedDefaultProguardFile, (String)"extractedDefaultProguardFile");
        if (!((ComponentType)this.getComponentType().get()).isBaseModule()) {
            void $this$mapNotNullTo$iv$iv2;
            Set set = proguardFiles2.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"proguardFiles.files");
            Iterable $this$mapNotNull$iv = set;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                File it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                File proguardFile = (File)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)proguardFile, (String)"proguardFile");
                if (this.removeIfAbsent(proguardFile) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        Set<String> set = ProguardFiles.KNOWN_FILE_NAMES;
        Intrinsics.checkNotNullExpressionValue(set, (String)"KNOWN_FILE_NAMES");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void name;
            String element$iv$iv$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(ProguardFiles.getDefaultProguardFile((String)name, this.projectLayout.getBuildDirectory()));
        }
        List defaultFiles = (List)destination$iv$iv2;
        Set set2 = proguardFiles2.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"proguardFiles.files");
        Iterable $this$mapNotNull$iv = set2;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            File file;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl = false;
            File proguardFile = (File)element$iv$iv;
            boolean bl4 = false;
            if (defaultFiles.contains(proguardFile)) {
                file = ((Directory)extractedDefaultProguardFile.get()).file(proguardFile.getName()).getAsFile();
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)proguardFile, (String)"proguardFile");
                file = this.removeIfAbsent(proguardFile);
            }
            if (file == null) continue;
            File it$iv$iv = file;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private final File removeIfAbsent(File file) {
        File file2;
        if (file.isFile()) {
            file2 = file;
        } else if (file.isDirectory()) {
            this.getLogger().warn("Directories as proguard configuration are not supported: " + file.getPath());
            file2 = null;
        } else {
            this.getLogger().warn("Supplied proguard configuration does not exist: " + file.getPath());
            file2 = null;
        }
        return file2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00052\u00020\u0006B!\b\u0001\u0012\u0006\u0010\u0007\u001a\u00028\u0001\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\b\u0010(\u001a\u00020#H\u0002J,\u0010)\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00010\r2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0015\u0010+\u001a\u00020#2\u0006\u0010'\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020#2\u0006\u0010-\u001a\u00020.H$J\u0016\u0010/\u001a\u00020#2\f\u00100\u001a\b\u0012\u0004\u0012\u00028\u000001H\u0016J\u0010\u00102\u001a\u00020#2\u0006\u00102\u001a\u00020.H$J\b\u00103\u001a\u00020#H$J\u0010\u00104\u001a\u00020#2\u0006\u00105\u001a\u000206H$R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\tX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\u001aX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/android/build/gradle/internal/tasks/ProguardConfigurableTask$CreationAction;", "TaskT", "Lcom/android/build/gradle/internal/tasks/ProguardConfigurableTask;", "CreationConfigT", "Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/features/OptimizationTaskCreationAction;", "creationConfig", "isTestApplication", "", "addCompileRClass", "(Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;ZZ)V", "classes", "Lorg/gradle/api/file/FileCollection;", "componentType", "Lcom/android/builder/core/ComponentType;", "getComponentType", "()Lcom/android/builder/core/ComponentType;", "defaultObfuscate", "getDefaultObfuscate", "()Z", "includeFeaturesInScopes", "inputScopes", "", "Lcom/android/build/api/transform/QualifiedContent$ScopeType;", "optimizationCreationConfig", "Lcom/android/build/gradle/internal/component/features/OptimizationCreationConfig;", "getOptimizationCreationConfig", "()Lcom/android/build/gradle/internal/component/features/OptimizationCreationConfig;", "referencedClasses", "referencedResources", "resources", "testedConfig", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "addFeatureProguardRules", "", "configurationFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "applyProguardConfigForNonTest", "task", "applyProguardDefaultsForTest", "applyProguardRules", "inputProguardMapping", "configure", "(Lcom/android/build/gradle/internal/tasks/ProguardConfigurableTask;)V", "dontWarn", "", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "keep", "keepAttributes", "setActions", "actions", "Lcom/android/build/gradle/internal/PostprocessingFeatures;", "gradle-core"})
    public static abstract class CreationAction<TaskT extends ProguardConfigurableTask, CreationConfigT extends ConsumableCreationConfig>
    extends VariantTaskCreationAction<TaskT, CreationConfigT>
    implements OptimizationTaskCreationAction {
        private final boolean isTestApplication;
        private final boolean addCompileRClass;
        private final /* synthetic */ OptimizationTaskCreationActionImpl $$delegate_0;
        private final boolean includeFeaturesInScopes;
        @NotNull
        private final ComponentType componentType;
        @Nullable
        private final VariantCreationConfig testedConfig;
        private final boolean defaultObfuscate;
        @NotNull
        private final FileCollection referencedClasses;
        @NotNull
        private final FileCollection referencedResources;
        @NotNull
        private final FileCollection classes;
        @NotNull
        private final FileCollection resources;
        @NotNull
        private final Set<QualifiedContent.ScopeType> inputScopes;

        @JvmOverloads
        public CreationAction(@NotNull CreationConfigT creationConfig, boolean isTestApplication, boolean addCompileRClass) {
            ConfigurableFileCollection it;
            ConfigurableFileCollection configurableFileCollection;
            Set set;
            Object[] objectArray;
            Intrinsics.checkNotNullParameter(creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
            this.isTestApplication = isTestApplication;
            this.addCompileRClass = addCompileRClass;
            this.$$delegate_0 = new OptimizationTaskCreationActionImpl((ConsumableCreationConfig)creationConfig);
            Object[] objectArray2 = objectArray = creationConfig instanceof ApplicationCreationConfig ? (Object[])creationConfig : null;
            this.includeFeaturesInScopes = objectArray != null ? objectArray.getConsumesFeatureJars() : false;
            this.componentType = creationConfig.getComponentType();
            TestComponentCreationConfig testComponentCreationConfig = creationConfig instanceof TestComponentCreationConfig ? (TestComponentCreationConfig)creationConfig : null;
            VariantCreationConfig variantCreationConfig = this.testedConfig = testComponentCreationConfig != null ? testComponentCreationConfig.getMainVariant() : null;
            if (this.componentType.isAar()) {
                objectArray = new QualifiedContent.ScopeType[]{(QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT, InternalScope.LOCAL_DEPS};
                set = SetsKt.mutableSetOf((Object[])objectArray);
            } else if (this.includeFeaturesInScopes) {
                objectArray = new QualifiedContent.ScopeType[]{(QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT, (QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS, (QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES, InternalScope.FEATURES};
                set = SetsKt.mutableSetOf((Object[])objectArray);
            } else {
                objectArray = new QualifiedContent.ScopeType[]{(QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT, (QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS, (QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES};
                set = SetsKt.mutableSetOf((Object[])objectArray);
            }
            this.inputScopes = set;
            CreationAction $this$_init__u24lambda_u2d0 = this;
            boolean bl = false;
            HashSet set2 = Sets.newHashSetWithExpectedSize((int)5);
            if ($this$_init__u24lambda_u2d0.componentType.isAar()) {
                set2.add(QualifiedContent.Scope.SUB_PROJECTS);
                set2.add(QualifiedContent.Scope.EXTERNAL_LIBRARIES);
            }
            if ($this$_init__u24lambda_u2d0.componentType.isTestComponent()) {
                set2.add(QualifiedContent.Scope.TESTED_CODE);
            }
            set2.add(QualifiedContent.Scope.PROVIDED_ONLY);
            ImmutableSet immutableSet = Sets.immutableEnumSet((Iterable)set2);
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"run {\n                va\u2026numSet(set)\n            }");
            Set referencedScopes = (Set)immutableSet;
            Preconditions.checkState((boolean)CollectionsKt.intersect((Iterable)referencedScopes, (Iterable)this.inputScopes).isEmpty(), (String)StringsKt.trimMargin$default((String)("|Referenced and non-referenced inputs must not overlap.\n                   |Referenced scope: " + referencedScopes + "\n                   |Non referenced scopes: " + this.inputScopes + "\n                   |Overlap: " + CollectionsKt.intersect((Iterable)referencedScopes, (Iterable)this.inputScopes) + "\n                "), null, (int)1, null), (Object[])new Object[0]);
            ConfigurableFileCollection configurableFileCollection2 = configurableFileCollection = creationConfig.getServices().fileCollection();
            CreationAction creationAction = this;
            boolean bl2 = false;
            Object[] objectArray3 = new Object[]{creationConfig.getArtifacts().forScope(ScopedArtifacts.Scope.PROJECT).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE)};
            it.from(objectArray3);
            if (this.inputScopes.contains((Object)InternalScope.LOCAL_DEPS)) {
                objectArray3 = new Object[]{creationConfig.getArtifacts().forScope(InternalScopedArtifacts.InternalScope.LOCAL_DEPS).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE)};
                it.from(objectArray3);
            }
            if (this.inputScopes.contains(QualifiedContent.Scope.EXTERNAL_LIBRARIES)) {
                objectArray3 = new Object[]{creationConfig.getArtifacts().forScope(InternalScopedArtifacts.InternalScope.EXTERNAL_LIBS).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE)};
                it.from(objectArray3);
            }
            if (this.inputScopes.contains(QualifiedContent.Scope.SUB_PROJECTS)) {
                objectArray3 = new Object[]{creationConfig.getArtifacts().forScope(InternalScopedArtifacts.InternalScope.SUB_PROJECTS).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE)};
                it.from(objectArray3);
            }
            if (this.inputScopes.contains((Object)InternalScope.FEATURES)) {
                objectArray3 = new Object[]{creationConfig.getArtifacts().forScope(InternalScopedArtifacts.InternalScope.FEATURES).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE)};
                it.from(objectArray3);
            }
            creationAction.classes = (FileCollection)configurableFileCollection;
            it = configurableFileCollection = creationConfig.getServices().fileCollection();
            creationAction = this;
            boolean bl3 = false;
            if (this.inputScopes.contains(QualifiedContent.Scope.PROJECT)) {
                objectArray3 = new Object[]{creationConfig.getArtifacts().forScope(ScopedArtifacts.Scope.PROJECT).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.JAVA_RES.INSTANCE)};
                it.from(objectArray3);
            }
            if (this.inputScopes.contains((Object)InternalScope.LOCAL_DEPS)) {
                objectArray3 = new Object[]{creationConfig.getArtifacts().forScope(InternalScopedArtifacts.InternalScope.LOCAL_DEPS).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.JAVA_RES.INSTANCE)};
                it.from(objectArray3);
            }
            if (this.inputScopes.contains(QualifiedContent.Scope.EXTERNAL_LIBRARIES)) {
                objectArray3 = new Object[]{creationConfig.getArtifacts().forScope(InternalScopedArtifacts.InternalScope.EXTERNAL_LIBS).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.JAVA_RES.INSTANCE)};
                it.from(objectArray3);
            }
            if (this.inputScopes.contains(QualifiedContent.Scope.SUB_PROJECTS)) {
                objectArray3 = new Object[]{creationConfig.getArtifacts().forScope(InternalScopedArtifacts.InternalScope.SUB_PROJECTS).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.JAVA_RES.INSTANCE)};
                it.from(objectArray3);
            }
            creationAction.resources = (FileCollection)configurableFileCollection;
            it = configurableFileCollection = creationConfig.getServices().fileCollection();
            creationAction = this;
            boolean bl4 = false;
            if (referencedScopes.contains(QualifiedContent.Scope.SUB_PROJECTS)) {
                objectArray3 = new Object[]{creationConfig.getArtifacts().forScope(InternalScopedArtifacts.InternalScope.SUB_PROJECTS).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE)};
                it.from(objectArray3);
            }
            if (referencedScopes.contains(QualifiedContent.Scope.TESTED_CODE)) {
                objectArray3 = new Object[]{creationConfig.getArtifacts().forScope(InternalScopedArtifacts.InternalScope.TESTED_CODE).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE)};
                it.from(objectArray3);
            }
            if (referencedScopes.contains(QualifiedContent.Scope.PROVIDED_ONLY)) {
                objectArray3 = new Object[]{creationConfig.getArtifacts().forScope(InternalScopedArtifacts.InternalScope.COMPILE_ONLY).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE)};
                it.from(objectArray3);
            }
            if (referencedScopes.contains(QualifiedContent.Scope.EXTERNAL_LIBRARIES)) {
                objectArray3 = new Object[]{creationConfig.getArtifacts().forScope(InternalScopedArtifacts.InternalScope.EXTERNAL_LIBS).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE)};
                it.from(objectArray3);
            }
            creationAction.referencedClasses = (FileCollection)configurableFileCollection;
            it = configurableFileCollection = creationConfig.getServices().fileCollection();
            creationAction = this;
            boolean bl5 = false;
            if (referencedScopes.contains(QualifiedContent.Scope.SUB_PROJECTS)) {
                objectArray3 = new Object[]{creationConfig.getArtifacts().forScope(InternalScopedArtifacts.InternalScope.SUB_PROJECTS).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.JAVA_RES.INSTANCE)};
                it.from(objectArray3);
            }
            if (referencedScopes.contains(QualifiedContent.Scope.TESTED_CODE)) {
                objectArray3 = new Object[]{creationConfig.getArtifacts().forScope(InternalScopedArtifacts.InternalScope.TESTED_CODE).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.JAVA_RES.INSTANCE)};
                it.from(objectArray3);
            }
            if (referencedScopes.contains(QualifiedContent.Scope.PROVIDED_ONLY)) {
                objectArray3 = new Object[]{creationConfig.getArtifacts().forScope(InternalScopedArtifacts.InternalScope.COMPILE_ONLY).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.JAVA_RES.INSTANCE)};
                it.from(objectArray3);
            }
            if (referencedScopes.contains(QualifiedContent.Scope.EXTERNAL_LIBRARIES)) {
                objectArray3 = new Object[]{creationConfig.getArtifacts().forScope(InternalScopedArtifacts.InternalScope.EXTERNAL_LIBS).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.JAVA_RES.INSTANCE)};
                it.from(objectArray3);
            }
            creationAction.referencedResources = (FileCollection)configurableFileCollection;
        }

        public /* synthetic */ CreationAction(ConsumableCreationConfig consumableCreationConfig, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(consumableCreationConfig, bl, bl2);
        }

        @Override
        @NotNull
        public OptimizationCreationConfig getOptimizationCreationConfig() {
            return this.$$delegate_0.getOptimizationCreationConfig();
        }

        @NotNull
        protected final ComponentType getComponentType() {
            return this.componentType;
        }

        protected boolean getDefaultObfuscate() {
            return this.defaultObfuscate;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<TaskT> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).on((Artifact.Single)SingleArtifact.OBFUSCATION_MAPPING_FILE.INSTANCE);
        }

        @Override
        public void configure(@NotNull TaskT task) {
            Object[] objectArray;
            Object[] objectArray2;
            Intrinsics.checkNotNullParameter(task, (String)"task");
            super.configure((Task)task);
            if (this.testedConfig instanceof ConsumableCreationConfig && this.testedConfig.getOptimizationCreationConfig().getMinifiedEnabled()) {
                objectArray2 = new Object[]{this.testedConfig.getArtifacts().get((SingleArtifact)SingleArtifact.OBFUSCATION_MAPPING_FILE.INSTANCE)};
                ((ProguardConfigurableTask)task).getTestedMappingFile().from(objectArray2);
            } else if (this.isTestApplication) {
                objectArray2 = new Object[]{VariantDependencies.getArtifactFileCollection$default(((ConsumableCreationConfig)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.APK_MAPPING, null, 8, null)};
                ((ProguardConfigurableTask)task).getTestedMappingFile().from(objectArray2);
            }
            ((ProguardConfigurableTask)task).getComponentType().set((Object)this.componentType);
            ((ProguardConfigurableTask)task).getIncludeFeaturesInScopes().set((Object)this.includeFeaturesInScopes);
            boolean hasAllAccessTransformers = ((ConsumableCreationConfig)this.creationConfig).getArtifacts().forScope(ScopedArtifacts.Scope.ALL).getScopedArtifactsContainer$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE).getArtifactsAltered().get();
            ((ProguardConfigurableTask)task).getHasAllAccessTransformers().set((Object)hasAllAccessTransformers);
            if (hasAllAccessTransformers) {
                ((ProguardConfigurableTask)task).getClasses().setFrom((Iterable)((ConsumableCreationConfig)this.creationConfig).getArtifacts().forScope(ScopedArtifacts.Scope.ALL).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE));
            } else {
                objectArray = new Object[]{this.classes};
                ((ProguardConfigurableTask)task).getClasses().from(objectArray);
                if (this.addCompileRClass) {
                    objectArray = new Object[]{((ConsumableCreationConfig)this.creationConfig).getArtifacts().get(InternalArtifactType.COMPILE_R_CLASS_JAR.INSTANCE)};
                    ((ProguardConfigurableTask)task).getClasses().from(objectArray);
                }
            }
            objectArray = new Object[]{this.resources};
            ((ProguardConfigurableTask)task).getResources().from(objectArray);
            objectArray = new Object[]{this.referencedClasses};
            ((ProguardConfigurableTask)task).getReferencedClasses().from(objectArray);
            objectArray = new Object[]{this.referencedResources};
            ((ProguardConfigurableTask)task).getReferencedResources().from(objectArray);
            ((ProguardConfigurableTask)task).getExtractedDefaultProguardFile().set(((ConsumableCreationConfig)this.creationConfig).getGlobal().getGlobalArtifacts().get(InternalArtifactType.DEFAULT_PROGUARD_FILES.INSTANCE));
            this.applyProguardRules((ProguardConfigurableTask)task, (ConsumableCreationConfig)this.creationConfig, (FileCollection)((ProguardConfigurableTask)task).getTestedMappingFile(), this.testedConfig);
        }

        private final void applyProguardRules(ProguardConfigurableTask task, ConsumableCreationConfig creationConfig, FileCollection inputProguardMapping, VariantCreationConfig testedConfig) {
            ConfigurableFileCollection configurationFiles;
            task.libraryKeepRules = VariantDependencies.getArtifactCollection$default(creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.FILTERED_PROGUARD_RULES, null, 8, null);
            Object[] objectArray = new Object[]{task.getLibraryKeepRules().getArtifactFiles()};
            task.getLibraryKeepRulesFileCollection().from(objectArray);
            task.getIgnoredLibraryKeepRules().set(this.getOptimizationCreationConfig().getIgnoredLibraryKeepRules());
            task.getIgnoreAllLibraryKeepRules().set((Object)this.getOptimizationCreationConfig().getIgnoreAllLibraryKeepRules());
            if (testedConfig != null) {
                this.applyProguardDefaultsForTest();
                Object[] objectArray2 = new Object[]{this.getOptimizationCreationConfig().getProguardFiles(), task.getLibraryKeepRulesFileCollection()};
                configurationFiles = task.getProject().files(objectArray2);
                objectArray2 = new Object[]{configurationFiles};
                task.getConfigurationFiles().from(objectArray2);
            } else if (creationConfig.getComponentType().isForTesting() && !creationConfig.getComponentType().isTestComponent()) {
                this.applyProguardDefaultsForTest();
                Object[] objectArray3 = new Object[]{this.getOptimizationCreationConfig().getProguardFiles(), task.getLibraryKeepRulesFileCollection()};
                configurationFiles = task.getProject().files(objectArray3);
                objectArray3 = new Object[]{configurationFiles};
                task.getConfigurationFiles().from(objectArray3);
            } else {
                this.applyProguardConfigForNonTest(task, creationConfig);
            }
            if (inputProguardMapping != null) {
                objectArray = new Object[]{inputProguardMapping};
                task.dependsOn(objectArray);
            }
        }

        private final void applyProguardDefaultsForTest() {
            this.setActions(new PostprocessingFeatures(false, this.getDefaultObfuscate(), false));
            this.keep("class * {*;}");
            this.keep("interface * {*;}");
            this.keep("enum * {*;}");
            this.keepAttributes();
        }

        private final void applyProguardConfigForNonTest(ProguardConfigurableTask task, ConsumableCreationConfig creationConfig) {
            Object[] it;
            Object[] postprocessingFeatures;
            if (postprocessingFeatures != null) {
                it = postprocessingFeatures = this.getOptimizationCreationConfig().getPostProcessingFeatures();
                boolean bl = false;
                this.setActions((PostprocessingFeatures)postprocessingFeatures);
            }
            Object object = task.getIncludeFeaturesInScopes().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"task.includeFeaturesInScopes.get()");
            Provider aaptProguardFile = (Boolean)object != false ? creationConfig.getArtifacts().get(InternalArtifactType.MERGED_AAPT_PROGUARD_FILE.INSTANCE) : creationConfig.getArtifacts().get(InternalArtifactType.AAPT_PROGUARD_FILE.INSTANCE);
            it = new Object[]{creationConfig.getArtifacts().get(InternalArtifactType.GENERATED_PROGUARD_FILE.INSTANCE)};
            HasConfigurableValuesKt.fromDisallowChanges(task.getGeneratedProguardFile(), it);
            Object[] objectArray = new Object[]{this.getOptimizationCreationConfig().getProguardFiles(), aaptProguardFile, task.getLibraryKeepRulesFileCollection()};
            ConfigurableFileCollection configurationFiles = task.getProject().files(objectArray);
            Object object2 = task.getIncludeFeaturesInScopes().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"task.includeFeaturesInScopes.get()");
            if (((Boolean)object2).booleanValue()) {
                Intrinsics.checkNotNullExpressionValue((Object)configurationFiles, (String)"configurationFiles");
                this.addFeatureProguardRules(creationConfig, configurationFiles);
            }
            objectArray = new Object[]{configurationFiles};
            task.getConfigurationFiles().from(objectArray);
            if (creationConfig.getComponentType().isAar()) {
                this.keep("class **.R");
                this.keep("class **.R$* {*;}");
            }
            if (creationConfig.isAndroidTestCoverageEnabled()) {
                this.keep("class com.vladium.** {*;}");
                this.keep("class org.jacoco.** {*;}");
                this.keep("interface org.jacoco.** {*;}");
                this.dontWarn("org.jacoco.**");
            }
        }

        private final void addFeatureProguardRules(ConsumableCreationConfig creationConfig, ConfigurableFileCollection configurationFiles) {
            Object[] objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.FILTERED_PROGUARD_RULES, null, 8, null)};
            configurationFiles.from(objectArray);
        }

        protected abstract void keep(@NotNull String var1);

        protected abstract void keepAttributes();

        protected abstract void dontWarn(@NotNull String var1);

        protected abstract void setActions(@NotNull PostprocessingFeatures var1);

        @JvmOverloads
        public CreationAction(@NotNull CreationConfigT creationConfig, boolean addCompileRClass) {
            Intrinsics.checkNotNullParameter(creationConfig, (String)"creationConfig");
            this((ConsumableCreationConfig)creationConfig, false, addCompileRClass, 2, null);
        }
    }
}

