/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.manifest;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.ManifestProvider;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.MergingReport;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0083\u0002\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001a\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u000e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\b\u0010%\u001a\u0004\u0018\u00010\t2\u0006\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020\u0013\u00a2\u0006\u0002\u0010)\u001a\u001a\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020\tH\u0002\u001aa\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u0002002\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u00101\u00a8\u00062"}, d2={"findOriginalManifestFilePosition", "Lcom/android/ide/common/blame/SourceFilePosition;", "manifestMergeBlameContents", "", "", "mergedFilePosition", "mergeManifests", "Lcom/android/manifmerger/MergingReport;", "mainManifest", "Ljava/io/File;", "manifestOverlays", "dependencies", "Lcom/android/manifmerger/ManifestProvider;", "navigationJsons", "", "featureName", "packageOverride", "namespace", "profileable", "", "versionCode", "", "versionName", "minSdkVersion", "targetSdkVersion", "maxSdkVersion", "testOnly", "outMergedManifestLocation", "outAaptSafeManifestLocation", "mergeType", "Lcom/android/manifmerger/ManifestMerger2$MergeType;", "placeHolders", "", "", "optionalFeatures", "Lcom/android/manifmerger/ManifestMerger2$Invoker$Feature;", "dependencyFeatureNames", "reportFile", "logger", "Lcom/android/utils/ILogger;", "checkIfPackageInMainManifest", "(Ljava/io/File;Ljava/util/List;Ljava/util/List;Ljava/util/Collection;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;ZLjava/lang/String;Ljava/lang/String;Lcom/android/manifmerger/ManifestMerger2$MergeType;Ljava/util/Map;Ljava/util/Collection;Ljava/util/Collection;Ljava/io/File;Lcom/android/utils/ILogger;Z)Lcom/android/manifmerger/MergingReport;", "save", "", "xmlDocument", "out", "setInjectableValues", "invoker", "Lcom/android/manifmerger/ManifestMerger2$Invoker;", "(Lcom/android/manifmerger/ManifestMerger2$Invoker;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;ZZ)V", "gradle-core"})
public final class ManifestHelperKt {
    @NotNull
    public static final MergingReport mergeManifests(@NotNull File mainManifest, @NotNull List<? extends File> manifestOverlays, @NotNull List<? extends ManifestProvider> dependencies2, @NotNull Collection<? extends File> navigationJsons, @Nullable String featureName2, @Nullable String packageOverride, @NotNull String namespace2, boolean profileable, @Nullable Integer versionCode2, @Nullable String versionName2, @Nullable String minSdkVersion2, @Nullable String targetSdkVersion2, @Nullable Integer maxSdkVersion, boolean testOnly, @Nullable String outMergedManifestLocation, @Nullable String outAaptSafeManifestLocation, @NotNull ManifestMerger2.MergeType mergeType, @NotNull Map<String, ? extends Object> placeHolders, @NotNull Collection<? extends ManifestMerger2.Invoker.Feature> optionalFeatures, @NotNull Collection<String> dependencyFeatureNames, @Nullable File reportFile2, @NotNull ILogger logger, boolean checkIfPackageInMainManifest) {
        Intrinsics.checkNotNullParameter((Object)mainManifest, (String)"mainManifest");
        Intrinsics.checkNotNullParameter(manifestOverlays, (String)"manifestOverlays");
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        Intrinsics.checkNotNullParameter(navigationJsons, (String)"navigationJsons");
        Intrinsics.checkNotNullParameter((Object)namespace2, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)mergeType, (String)"mergeType");
        Intrinsics.checkNotNullParameter(placeHolders, (String)"placeHolders");
        Intrinsics.checkNotNullParameter(optionalFeatures, (String)"optionalFeatures");
        Intrinsics.checkNotNullParameter(dependencyFeatureNames, (String)"dependencyFeatureNames");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        try {
            String annotatedDocument;
            boolean injectProfileable;
            Object[] $this$toTypedArray$iv = (Object[])manifestOverlays;
            boolean $i$f$toTypedArray = false;
            Object[] thisCollection$iv = $this$toTypedArray$iv;
            File[] fileArray = thisCollection$iv.toArray(new File[0]);
            ManifestMerger2.Invoker invoker = ManifestMerger2.newMerger((File)mainManifest, (ILogger)logger, (ManifestMerger2.MergeType)mergeType).setPlaceHolderValues(placeHolders).addFlavorAndBuildTypeManifests(Arrays.copyOf(fileArray, fileArray.length)).addManifestProviders((Iterable)dependencies2).addNavigationJsons((Iterable)navigationJsons);
            $this$toTypedArray$iv = optionalFeatures;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            fileArray = thisCollection$iv.toArray(new ManifestMerger2.Invoker.Feature[0]);
            ManifestMerger2.Invoker manifestMergerInvoker = invoker.withFeatures((ManifestMerger2.Invoker.Feature[])Arrays.copyOf(fileArray, fileArray.length)).setMergeReportFile(reportFile2).setFeatureName(featureName2).addDependencyFeatureNames((Iterable)dependencyFeatureNames).setNamespace(namespace2);
            if (checkIfPackageInMainManifest) {
                fileArray = new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.CHECK_IF_PACKAGE_IN_MAIN_MANIFEST};
                manifestMergerInvoker.withFeatures((ManifestMerger2.Invoker.Feature[])fileArray);
            }
            boolean isAppMerge = mergeType == ManifestMerger2.MergeType.APPLICATION;
            boolean bl = injectProfileable = isAppMerge && profileable;
            if (isAppMerge) {
                ManifestMerger2.Invoker.Feature[] $i$f$toTypedArray2 = new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS};
                manifestMergerInvoker.withFeatures($i$f$toTypedArray2);
            }
            if (outAaptSafeManifestLocation != null) {
                ManifestMerger2.Invoker.Feature[] $i$f$toTypedArray2 = new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.MAKE_AAPT_SAFE};
                manifestMergerInvoker.withFeatures($i$f$toTypedArray2);
            }
            Intrinsics.checkNotNullExpressionValue((Object)manifestMergerInvoker, (String)"manifestMergerInvoker");
            ManifestHelperKt.setInjectableValues(manifestMergerInvoker, packageOverride, versionCode2, versionName2, minSdkVersion2, targetSdkVersion2, maxSdkVersion, injectProfileable, testOnly);
            MergingReport mergingReport = manifestMergerInvoker.merge();
            thisCollection$iv = new Object[]{mergingReport.getResult()};
            logger.verbose("Merging result: %1$s", thisCollection$iv);
            if (mergingReport.getResult() == MergingReport.Result.ERROR) {
                mergingReport.log(logger);
                throw new RuntimeException(mergingReport.getReportString());
            }
            if (mergingReport.getResult() == MergingReport.Result.WARNING) {
                mergingReport.log(logger);
            }
            if ((annotatedDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.BLAME)) != null) {
                logger.verbose(annotatedDocument, new Object[0]);
            }
            logger.verbose("Merged manifest saved to " + outMergedManifestLocation, new Object[0]);
            if (outMergedManifestLocation != null) {
                ManifestHelperKt.save(mergingReport.getMergedDocument(MergingReport.MergedManifestKind.MERGED), new File(outMergedManifestLocation));
            }
            if (outAaptSafeManifestLocation != null) {
                ManifestHelperKt.save(mergingReport.getMergedDocument(mergingReport.isAaptSafeManifestUnchanged() ? MergingReport.MergedManifestKind.MERGED : MergingReport.MergedManifestKind.AAPT_SAFE), new File(outAaptSafeManifestLocation));
            }
            Intrinsics.checkNotNullExpressionValue((Object)mergingReport, (String)"mergingReport");
            return mergingReport;
        }
        catch (ManifestMerger2.MergeFailureException e) {
            throw new RuntimeException(e);
        }
    }

    public static /* synthetic */ MergingReport mergeManifests$default(File file, List list, List list2, Collection collection, String string, String string2, String string3, boolean bl, Integer n, String string4, String string5, String string6, Integer n2, boolean bl2, String string7, String string8, ManifestMerger2.MergeType mergeType, Map map, Collection collection2, Collection collection3, File file2, ILogger iLogger, boolean bl3, int n3, Object object) {
        if ((n3 & 0x400000) != 0) {
            bl3 = true;
        }
        return ManifestHelperKt.mergeManifests(file, list, list2, collection, string, string2, string3, bl, n, string4, string5, string6, n2, bl2, string7, string8, mergeType, map, collection2, collection3, file2, iLogger, bl3);
    }

    @NotNull
    public static final SourceFilePosition findOriginalManifestFilePosition(@NotNull List<String> manifestMergeBlameContents, @NotNull SourceFilePosition mergedFilePosition) {
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter(manifestMergeBlameContents, (String)"manifestMergeBlameContents");
                Intrinsics.checkNotNullParameter((Object)mergedFilePosition, (String)"mergedFilePosition");
                if (Intrinsics.areEqual((Object)mergedFilePosition.getFile(), (Object)SourceFile.UNKNOWN)) break block9;
                Object object = mergedFilePosition.getFile().getSourceFile();
                boolean bl = object != null && (object = ((File)object).getAbsolutePath()) != null ? !StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"merged_manifests", (boolean)false, (int)2, null) : false;
                if (!bl) break block10;
            }
            return mergedFilePosition;
        }
        try {
            String linePrefix = mergedFilePosition.getPosition().getStartLine() + 1 + "-->";
            Iterable $this$forEach$iv = manifestMergeBlameContents;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SourceFilePosition sourceFilePosition;
                int index;
                int closingIndex;
                String position;
                String line = (String)element$iv;
                boolean bl = false;
                String trimmed = ((Object)StringsKt.trim((CharSequence)line)).toString();
                if (!StringsKt.startsWith$default((String)trimmed, (String)linePrefix, (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)trimmed.substring(linePrefix.length()), (String)"this as java.lang.String).substring(startIndex)");
                if (StringsKt.startsWith$default((String)position, (String)"[", (boolean)false, (int)2, null) && (closingIndex = StringsKt.indexOf$default((CharSequence)position, (String)"] ", (int)0, (boolean)false, (int)6, null)) >= 0) {
                    String string = position.substring(closingIndex + 2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    position = string;
                }
                if ((index = StringsKt.indexOf$default((CharSequence)position, (String)".xml", (int)0, (boolean)false, (int)6, null)) == -1) continue;
                String string = position.substring(0, index + ".xml".length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String file = string;
                if (!Intrinsics.areEqual((Object)file, (Object)position)) {
                    String string2 = position.substring(index + ".xml".length() + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                    String sourcePosition = string2;
                    sourceFilePosition = new SourceFilePosition(new File(file), SourcePosition.fromString((String)sourcePosition));
                } else {
                    sourceFilePosition = new SourceFilePosition(new File(file), SourcePosition.UNKNOWN);
                }
                return sourceFilePosition;
            }
        }
        catch (Exception e) {
            return mergedFilePosition;
        }
        return mergedFilePosition;
    }

    private static final void setInjectableValues(ManifestMerger2.Invoker invoker, String packageOverride, Integer versionCode2, String versionName2, String minSdkVersion2, String targetSdkVersion2, Integer maxSdkVersion, boolean profileable, boolean testOnly) {
        if (packageOverride != null && ((CharSequence)packageOverride).length() > 0) {
            invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.Document.PACKAGE, packageOverride);
        }
        Integer n = versionCode2;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            if (it > 0) {
                invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.Manifest.VERSION_CODE, String.valueOf(it));
            }
        }
        if (versionName2 != null && ((CharSequence)versionName2).length() > 0) {
            invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.Manifest.VERSION_NAME, versionName2);
        }
        if (minSdkVersion2 != null && ((CharSequence)minSdkVersion2).length() > 0) {
            invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.UsesSdk.MIN_SDK_VERSION, minSdkVersion2);
        }
        if (targetSdkVersion2 != null && ((CharSequence)targetSdkVersion2).length() > 0) {
            invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.UsesSdk.TARGET_SDK_VERSION, targetSdkVersion2);
        }
        if (maxSdkVersion != null) {
            invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.UsesSdk.MAX_SDK_VERSION, maxSdkVersion.toString());
        }
        if (profileable) {
            invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.Profileable.SHELL, "true");
            invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.Profileable.ENABLED, "true");
        }
        if (testOnly) {
            invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.Application.TEST_ONLY, "true");
        }
    }

    private static final void save(String xmlDocument, File out) {
        try {
            Files.createParentDirs((File)out);
            CharSink charSink = Files.asCharSink((File)out, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]);
            String string = xmlDocument;
            Intrinsics.checkNotNull((Object)string);
            charSink.write((CharSequence)string);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

