/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing;

import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.internal.testing.CustomTestRunListener;
import com.android.build.gradle.internal.testing.StaticTestData;
import com.android.build.gradle.internal.testing.TestRunner;
import com.android.build.gradle.internal.testing.utp.PrivacySandboxSdkInstallBundle;
import com.android.builder.internal.InstallUtils;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.builder.testing.api.DeviceConfigProviderImpl;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.TestException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.workers.ExecutorServiceAdapter;
import com.android.ide.common.workers.WorkerExecutorException;
import com.android.sdklib.AndroidVersion;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class BaseTestRunner
implements TestRunner {
    protected final File splitSelectExec;
    protected final ProcessExecutor processExecutor;
    protected final ExecutorServiceAdapter executor;

    public BaseTestRunner(File splitSelectExec, ProcessExecutor processExecutor2, ExecutorServiceAdapter executor2) {
        this.splitSelectExec = splitSelectExec;
        this.processExecutor = (ProcessExecutor)Preconditions.checkNotNull((Object)processExecutor2);
        this.executor = executor2;
    }

    private static void generateXmlOutputForNoDevices(String projectName, String variantName, File resultsDir, ILogger logger, int totalDevices, Map<DeviceConnector, ImmutableList<File>> availableDevices) {
        CustomTestRunListener fakeRunListener = new CustomTestRunListener("TestRunner", projectName, variantName, logger);
        fakeRunListener.setReportDir(resultsDir);
        Map<String, String> emptyMetrics = Collections.emptyMap();
        TestIdentifier fakeTest = new TestIdentifier(variantName, totalDevices == 0 ? ": No devices connected." : ": No compatible devices connected.");
        fakeRunListener.testStarted(fakeTest);
        fakeRunListener.testFailed(fakeTest, String.format(Locale.US, "Found %d connected device(s), %d of which were compatible.", totalDevices, availableDevices.size()));
        fakeRunListener.testEnded(fakeTest, emptyMetrics);
        fakeRunListener.testRunEnded(0L, emptyMetrics);
    }

    private static void generateXmlOutputForUnauthorizedDevices(String projectName, String variantName, File resultsDir, ILogger logger, int unauthorizedDevices) {
        CustomTestRunListener fakeRunListener = new CustomTestRunListener("TestRunner", projectName, variantName, logger);
        fakeRunListener.setReportDir(resultsDir);
        Map<String, String> emptyMetrics = Collections.emptyMap();
        TestIdentifier fakeTest = new TestIdentifier(variantName, ": found unauthorized devices.");
        fakeRunListener.testStarted(fakeTest);
        fakeRunListener.testFailed(fakeTest, String.format(Locale.US, "Found %d unauthorized device(s).", unauthorizedDevices));
        fakeRunListener.testEnded(fakeTest, emptyMetrics);
        fakeRunListener.testRunEnded(0L, emptyMetrics);
    }

    @Override
    public boolean runTests(String projectName, String variantName, StaticTestData testData, Set<File> dependencyApks, Set<File> helperApks, List<? extends DeviceConnector> deviceList, int timeoutInMs, Collection<String> installOptions, File resultsDir, boolean additionalTestOutputEnabled, File additionalTestOutputDir, File coverageDir, ILogger logger) throws TestException {
        int totalDevices = deviceList.size();
        int unauthorizedDevices = 0;
        HashMap<DeviceConnector, ImmutableList<File>> apksForDevice = new HashMap<DeviceConnector, ImmutableList<File>>();
        HashMap dependencyApkMap = new HashMap();
        for (DeviceConnector deviceConnector : deviceList) {
            if (deviceConnector.getState() != IDevice.DeviceState.UNAUTHORIZED) {
                DeviceConfigProviderImpl deviceConfigProvider;
                if (!InstallUtils.checkDeviceApiLevel((DeviceConnector)deviceConnector, (AndroidVersion)VariantApiExtensionsKt.toSharedAndroidVersion(testData.getMinSdkVersion()), (ILogger)logger, (String)projectName, (String)variantName)) continue;
                try {
                    deviceConfigProvider = new DeviceConfigProviderImpl(deviceConnector);
                }
                catch (DeviceException e) {
                    throw new TestException((Throwable)e);
                }
                Object testedApks = ImmutableList.of();
                if (!testData.isLibrary() && (testedApks = (List)testData.getTestedApkFinder().invoke((Object)deviceConfigProvider)).isEmpty()) {
                    logger.info("Skipping device '%1$s' for '%2$s:%3$s': No matching output file", new Object[]{deviceConnector.getName(), projectName, variantName});
                    continue;
                }
                apksForDevice.put(deviceConnector, (ImmutableList<File>)ImmutableList.copyOf((Collection)testedApks));
                dependencyApks.forEach(arg_0 -> BaseTestRunner.lambda$runTests$0(dependencyApkMap, deviceConnector, testData, (DeviceConfigProvider)deviceConfigProvider, arg_0));
                continue;
            }
            ++unauthorizedDevices;
        }
        if (totalDevices == 0 || apksForDevice.isEmpty()) {
            BaseTestRunner.generateXmlOutputForNoDevices(projectName, variantName, resultsDir, logger, totalDevices, apksForDevice);
            return false;
        }
        if (unauthorizedDevices > 0) {
            BaseTestRunner.generateXmlOutputForUnauthorizedDevices(projectName, variantName, resultsDir, logger, unauthorizedDevices);
        }
        PrivacySandboxSdkInstallBundle privacySandboxSdkInstallBundle = new PrivacySandboxSdkInstallBundle(dependencyApks, dependencyApkMap);
        List<TestResult> list = this.scheduleTests(projectName, variantName, testData, apksForDevice, privacySandboxSdkInstallBundle, helperApks, timeoutInMs, installOptions, resultsDir, additionalTestOutputEnabled, additionalTestOutputDir, coverageDir, logger);
        try {
            this.executor.await();
        }
        catch (WorkerExecutorException e) {
            e.getCauses().forEach(cause -> logger.error(cause, null, new Object[0]));
            return false;
        }
        boolean success = unauthorizedDevices == 0;
        for (TestResult result2 : list) {
            if (result2.getTestResult() != TestResult.Result.FAILED) continue;
            success = false;
        }
        return success;
    }

    protected abstract List<TestResult> scheduleTests(String var1, String var2, StaticTestData var3, Map<DeviceConnector, ImmutableList<File>> var4, PrivacySandboxSdkInstallBundle var5, Set<File> var6, int var7, Collection<String> var8, File var9, boolean var10, File var11, File var12, ILogger var13);

    private static /* synthetic */ void lambda$runTests$0(Map dependencyApkMap, DeviceConnector device, StaticTestData testData, DeviceConfigProvider deviceConfigProvider, File apk) {
        dependencyApkMap.put(device, (List)testData.getPrivacySandboxInstallBundlesFinder().invoke((Object)deviceConfigProvider));
    }

    public static class TestResult {
        Result testResult;

        public void setTestResult(Result testResult) {
            this.testResult = testResult;
        }

        public Result getTestResult() {
            return this.testResult;
        }

        public static enum Result {
            SUCCEEDED,
            FAILED;

        }
    }
}

