/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.variant.BuildConfigField;
import com.android.build.api.variant.impl.VariantOutputImpl;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ApplicationCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.component.features.BuildConfigCreationConfig;
import com.android.build.gradle.internal.generators.BuildConfigByteCodeGenerator;
import com.android.build.gradle.internal.generators.BuildConfigData;
import com.android.build.gradle.internal.generators.BuildConfigGenerator;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.features.BuildConfigTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.features.BuildConfigTaskCreationActionImpl;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.GenerateBuildConfigKt;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.compiling.GeneratedCodeFileCreator;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.COMPILED_CLASSES, secondaryTaskCategories={TaskCategory.SOURCE_GENERATION})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010/\u001a\u000200H\u0014J\u0010\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0007R \u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR(\u0010\u001c\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e0\u001d8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0007R\u0014\u0010(\u001a\u00020#8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010%R\u001c\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010+0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0007R\u001c\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0007\u00a8\u00064"}, d2={"Lcom/android/build/gradle/tasks/GenerateBuildConfig;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "applicationId", "Lorg/gradle/api/provider/Property;", "", "getApplicationId", "()Lorg/gradle/api/provider/Property;", "buildTypeName", "getBuildTypeName", "bytecodeOutputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getBytecodeOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "debuggable", "", "getDebuggable", "flavorName", "getFlavorName", "flavorNamesWithDimensionNames", "Lorg/gradle/api/provider/ListProperty;", "getFlavorNamesWithDimensionNames", "()Lorg/gradle/api/provider/ListProperty;", "hasVersionInfo", "getHasVersionInfo", "<set-?>", "isLibrary", "()Z", "items", "Lorg/gradle/api/provider/MapProperty;", "Lcom/android/build/api/variant/BuildConfigField;", "Ljava/io/Serializable;", "getItems", "()Lorg/gradle/api/provider/MapProperty;", "mergedManifests", "Lorg/gradle/api/file/DirectoryProperty;", "getMergedManifests", "()Lorg/gradle/api/file/DirectoryProperty;", "namespace", "getNamespace", "sourceOutputDir", "getSourceOutputDir", "versionCode", "", "getVersionCode", "versionName", "getVersionName", "doTaskAction", "", "sanitizeFlavorDimension", "name", "CreationAction", "gradle-core"})
public abstract class GenerateBuildConfig
extends NonIncrementalTask {
    private boolean isLibrary;

    @OutputDirectory
    @Optional
    @NotNull
    public abstract DirectoryProperty getSourceOutputDir();

    @OutputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getBytecodeOutputFile();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getBuildTypeName();

    @Input
    public final boolean isLibrary() {
        return this.isLibrary;
    }

    @Input
    @NotNull
    public abstract Property<String> getNamespace();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getApplicationId();

    @Input
    @NotNull
    public abstract Property<Boolean> getDebuggable();

    @Input
    @NotNull
    public abstract Property<String> getFlavorName();

    @Input
    @NotNull
    public abstract ListProperty<String> getFlavorNamesWithDimensionNames();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getVersionName();

    @Input
    @Optional
    @NotNull
    public abstract Property<Integer> getVersionCode();

    @Internal
    @NotNull
    public abstract Property<Boolean> getHasVersionInfo();

    @Input
    @NotNull
    public abstract MapProperty<String, BuildConfigField<? extends Serializable>> getItems();

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getMergedManifests();

    @Override
    protected void doTaskAction() {
        GeneratedCodeFileCreator generatedCodeFileCreator;
        BuildConfigData.Builder builder;
        Map itemsToGenerate = (Map)this.getItems().get();
        BuildConfigData.Builder builder2 = new BuildConfigData.Builder(null, null, null, null, 15, null);
        Object object = this.getNamespace().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"namespace.get()");
        BuildConfigData.Builder $this$doTaskAction_u24lambda_u2d3 = builder = builder2.setNamespace((String)object);
        boolean bl = false;
        if (this.getSourceOutputDir().isPresent()) {
            Object object2 = this.getDebuggable().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"debuggable.get()");
            BuildConfigData.Builder.addBooleanField$default($this$doTaskAction_u24lambda_u2d3, "DEBUG", (Boolean)object2, null, 4, null);
        }
        if (this.isLibrary) {
            Object object3 = this.getNamespace().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"namespace.get()");
            BuildConfigData.Builder.addStringField$default($this$doTaskAction_u24lambda_u2d3, "LIBRARY_PACKAGE_NAME", (String)object3, null, 4, null);
        } else {
            Object object4 = this.getApplicationId().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"applicationId.get()");
            BuildConfigData.Builder.addStringField$default($this$doTaskAction_u24lambda_u2d3, "APPLICATION_ID", (String)object4, null, 4, null);
        }
        String string = (String)this.getBuildTypeName().getOrNull();
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            BuildConfigData.Builder.addStringField$default($this$doTaskAction_u24lambda_u2d3, "BUILD_TYPE", it, null, 4, null);
        }
        String it = (String)this.getFlavorName().get();
        boolean bl3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        if (((CharSequence)it).length() > 0) {
            BuildConfigData.Builder.addStringField$default($this$doTaskAction_u24lambda_u2d3, "FLAVOR", it, null, 4, null);
        }
        List flavors = (List)this.getFlavorNamesWithDimensionNames().get();
        int count = flavors.size();
        if (count > 1) {
            for (int i = 0; i < count; i += 2) {
                Object e = flavors.get(i + 1);
                Intrinsics.checkNotNullExpressionValue(e, (String)"flavors[i + 1]");
                String sanitizedDimensionName = this.sanitizeFlavorDimension((String)e);
                $this$doTaskAction_u24lambda_u2d3.addStringField("FLAVOR_" + sanitizedDimensionName, String.valueOf(flavors.get(i)), (String)(Intrinsics.areEqual((Object)sanitizedDimensionName, flavors.get(i + 1)) ? (String)null : "From flavor dimension " + flavors.get(i + 1)));
            }
        }
        Object object5 = this.getHasVersionInfo().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"hasVersionInfo.get()");
        if (((Boolean)object5).booleanValue()) {
            Integer n = (Integer)this.getVersionCode().getOrNull();
            if (n != null) {
                Integer it2 = n;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                BuildConfigData.Builder.addIntField$default($this$doTaskAction_u24lambda_u2d3, "VERSION_CODE", it2, null, 4, null);
                BuildConfigData.Builder.addStringField$default($this$doTaskAction_u24lambda_u2d3, "VERSION_NAME", String.valueOf(this.getVersionName().getOrElse((Object)"")), null, 4, null);
            }
        }
        BuildConfigData.Builder buildConfigData = builder;
        if (this.getBytecodeOutputFile().isPresent()) {
            FileUtils.deleteIfExists((File)((RegularFile)this.getBytecodeOutputFile().get()).getAsFile());
            Path path = ((RegularFile)this.getBytecodeOutputFile().get()).getAsFile().getParentFile().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"bytecodeOutputFile.get()\u2026sFile.parentFile.toPath()");
            BuildConfigData.Builder builder3 = buildConfigData.setOutputPath(path);
            Object object6 = this.getDebuggable().get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"debuggable.get()");
            BuildConfigData byteCodeBuildConfigData = BuildConfigData.Builder.addBooleanField$default(builder3, "DEBUG", (Boolean)object6, null, 4, null).build();
            generatedCodeFileCreator = new BuildConfigByteCodeGenerator(byteCodeBuildConfigData);
        } else {
            BuildConfigData.Builder builder4;
            File destinationDir = ((Directory)this.getSourceOutputDir().get()).getAsFile();
            FileUtils.cleanOutputDir((File)destinationDir);
            Path path = ((Directory)this.getSourceOutputDir().get()).getAsFile().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"sourceOutputDir.get().asFile.toPath()");
            BuildConfigData.Builder $this$doTaskAction_u24lambda_u2d5 = builder4 = buildConfigData.setOutputPath(path);
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue((Object)itemsToGenerate, (String)"itemsToGenerate");
            Map $this$forEach$iv = MapsKt.toSortedMap((Map)itemsToGenerate);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl6 = false;
                String name = (String)entry.getKey();
                BuildConfigField buildConfigField = (BuildConfigField)entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                Intrinsics.checkNotNullExpressionValue((Object)buildConfigField, (String)"buildConfigField");
                $this$doTaskAction_u24lambda_u2d5.addItem(name, (BuildConfigField<? extends Serializable>)buildConfigField);
            }
            BuildConfigData sourceCodeBuildConfigData = builder4.build();
            generatedCodeFileCreator = new BuildConfigGenerator(sourceCodeBuildConfigData);
        }
        GeneratedCodeFileCreator generator = generatedCodeFileCreator;
        generator.generate();
    }

    private final String sanitizeFlavorDimension(String name) {
        Preconditions.checkArgument((((CharSequence)name).length() > 0 ? 1 : 0) != 0);
        CharSequence charSequence = name;
        Regex regex = new Regex("[^a-zA-Z0-9_$]");
        String string = "_";
        return regex.replace(charSequence, string);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0016\u0010\u0016\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016R\u0012\u0010\u0007\u001a\u00020\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/tasks/GenerateBuildConfig$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/tasks/GenerateBuildConfig;", "Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;", "Lcom/android/build/gradle/internal/tasks/factory/features/BuildConfigTaskCreationAction;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;)V", "buildConfigCreationConfig", "Lcom/android/build/gradle/internal/component/features/BuildConfigCreationConfig;", "getBuildConfigCreationConfig", "()Lcom/android/build/gradle/internal/component/features/BuildConfigCreationConfig;", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<GenerateBuildConfig, ConsumableCreationConfig>
    implements BuildConfigTaskCreationAction {
        private final /* synthetic */ BuildConfigTaskCreationActionImpl $$delegate_0;
        @NotNull
        private final String name;
        @NotNull
        private final Class<GenerateBuildConfig> type;

        public CreationAction(@NotNull ConsumableCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
            this.$$delegate_0 = new BuildConfigTaskCreationActionImpl(creationConfig);
            this.name = this.computeTaskName("generate", "BuildConfig");
            this.type = GenerateBuildConfig.class;
        }

        @Override
        @NotNull
        public BuildConfigCreationConfig getBuildConfigCreationConfig() {
            return this.$$delegate_0.getBuildConfigCreationConfig();
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<GenerateBuildConfig> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<GenerateBuildConfig> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            boolean outputBytecode = ((ConsumableCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.ENABLE_BUILD_CONFIG_AS_BYTECODE);
            boolean generateItems = MapsKt.any(this.getBuildConfigCreationConfig().getDslBuildConfigFields());
            ((ConsumableCreationConfig)this.creationConfig).getTaskContainer().setGenerateBuildConfigTask(taskProvider);
            if (outputBytecode && !generateItems) {
                ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("BuildConfig.jar").on(InternalArtifactType.COMPILE_BUILD_CONFIG_JAR.INSTANCE);
            } else {
                ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.2.INSTANCE).atLocation(((ConsumableCreationConfig)this.creationConfig).getPaths().getBuildConfigSourceOutputDir()).on(InternalArtifactType.GENERATED_BUILD_CONFIG_JAVA.INSTANCE);
            }
        }

        @Override
        public void configure(@NotNull GenerateBuildConfig task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            TaskCreationServices services = ((ConsumableCreationConfig)this.creationConfig).getServices();
            HasConfigurableValuesKt.setDisallowChanges(task.getNamespace(), ((ConsumableCreationConfig)this.creationConfig).getNamespace());
            if (this.creationConfig instanceof ApkCreationConfig) {
                HasConfigurableValuesKt.setDisallowChanges(task.getApplicationId(), ((ConsumableCreationConfig)this.creationConfig).getApplicationId());
            }
            if (this.creationConfig instanceof ApplicationCreationConfig) {
                VariantOutputImpl mainSplit = ((ApplicationCreationConfig)this.creationConfig).getOutputs().getMainSplit();
                HasConfigurableValuesKt.setDisallowChanges(task.getVersionCode(), (Provider)mainSplit.getVersionCode());
                HasConfigurableValuesKt.setDisallowChanges(task.getVersionName(), (Provider)mainSplit.getVersionName());
                HasConfigurableValuesKt.setDisallowChanges(task.getHasVersionInfo(), true);
            } else {
                HasConfigurableValuesKt.setDisallowChanges(task.getHasVersionInfo(), false);
            }
            HasConfigurableValuesKt.setDisallowChanges(task.getDebuggable(), ((ConsumableCreationConfig)this.creationConfig).getDebuggable());
            HasConfigurableValuesKt.setDisallowChanges(task.getBuildTypeName(), ((ConsumableCreationConfig)this.creationConfig).getBuildType());
            HasConfigurableValuesKt.setDisallowChanges(task.getFlavorName(), services.provider((Function0)new Function0<String>(this){
                final /* synthetic */ CreationAction this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final String invoke() {
                    String string = ((ConsumableCreationConfig)CreationAction.access$getCreationConfig$p(this.this$0)).getFlavorName();
                    if (string == null) {
                        string = "";
                    }
                    return string;
                }
            }));
            HasConfigurableValuesKt.setDisallowChanges(task.getFlavorNamesWithDimensionNames(), services.provider((Function0)new Function0<List<? extends String>>(this){
                final /* synthetic */ CreationAction this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final List<String> invoke() {
                    return GenerateBuildConfigKt.access$getFlavorNamesWithDimensionNames(CreationAction.access$getCreationConfig$p(this.this$0));
                }
            }));
            task.getItems().set((Provider)this.getBuildConfigCreationConfig().getBuildConfigFields());
            if (((ConsumableCreationConfig)this.creationConfig).getComponentType().isTestComponent()) {
                ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.PACKAGED_MANIFESTS.INSTANCE, (Property)task.getMergedManifests());
            }
            task.isLibrary = ((ConsumableCreationConfig)this.creationConfig).getComponentType().isAar();
        }

        public static final /* synthetic */ ComponentCreationConfig access$getCreationConfig$p(CreationAction $this) {
            return $this.creationConfig;
        }
    }
}

