/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactTransformationRequest;
import com.android.build.api.artifact.impl.InAndOutDirectoryOperationRequestImpl;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.internal.workeractions.DecoratedWorkParameters;
import com.android.build.gradle.internal.workeractions.WorkActionAdapter;
import com.android.build.gradle.tasks.ProcessManifestForInstantAppTask;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.manifmerger.ManifestUtils;
import com.android.manifmerger.XmlDocument;
import com.android.utils.PositionXmlParser;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.MANIFEST)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0015R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR \u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\r0\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/tasks/ProcessManifestForInstantAppTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "workers", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "instantAppManifests", "Lorg/gradle/api/file/DirectoryProperty;", "getInstantAppManifests", "()Lorg/gradle/api/file/DirectoryProperty;", "mergedManifests", "getMergedManifests", "transformationRequest", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/api/artifact/ArtifactTransformationRequest;", "getTransformationRequest", "()Lorg/gradle/api/provider/Property;", "getWorkers", "()Lorg/gradle/workers/WorkerExecutor;", "doTaskAction", "", "CreationAction", "WorkItem", "WorkItemParameters", "gradle-core"})
public abstract class ProcessManifestForInstantAppTask
extends NonIncrementalTask {
    @NotNull
    private final WorkerExecutor workers;

    @Inject
    public ProcessManifestForInstantAppTask(@NotNull WorkerExecutor workers) {
        Intrinsics.checkNotNullParameter((Object)workers, (String)"workers");
        this.workers = workers;
    }

    @Internal
    @NotNull
    public final WorkerExecutor getWorkers() {
        return this.workers;
    }

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getInstantAppManifests();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getMergedManifests();

    @Internal
    @NotNull
    public abstract Property<ArtifactTransformationRequest<ProcessManifestForInstantAppTask>> getTransformationRequest();

    @Override
    @TaskAction
    protected void doTaskAction() {
        ArtifactTransformationRequest artifactTransformationRequest = (ArtifactTransformationRequest)this.getTransformationRequest().get();
        Task task = (Task)this;
        WorkQueue workQueue2 = this.workers.noIsolation();
        Intrinsics.checkNotNullExpressionValue((Object)workQueue2, (String)"workers.noIsolation()");
        artifactTransformationRequest.submit(task, workQueue2, WorkItem.class, (Function3)doTaskAction.1.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/tasks/ProcessManifestForInstantAppTask$WorkItemParameters;", "Lcom/android/build/gradle/internal/workeractions/DecoratedWorkParameters;", "inputXmlFile", "Lorg/gradle/api/file/RegularFileProperty;", "getInputXmlFile", "()Lorg/gradle/api/file/RegularFileProperty;", "outputXmlFile", "getOutputXmlFile", "gradle-core"})
    public static interface WorkItemParameters
    extends DecoratedWorkParameters {
        @NotNull
        public RegularFileProperty getInputXmlFile();

        @NotNull
        public RegularFileProperty getOutputXmlFile();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0002H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/tasks/ProcessManifestForInstantAppTask$WorkItem;", "Lcom/android/build/gradle/internal/workeractions/WorkActionAdapter;", "Lcom/android/build/gradle/tasks/ProcessManifestForInstantAppTask$WorkItemParameters;", "parameters", "(Lcom/android/build/gradle/tasks/ProcessManifestForInstantAppTask$WorkItemParameters;)V", "doExecute", "", "getParameters", "setTargetSandboxVersionAttribute", "", "document", "Lorg/w3c/dom/Document;", "gradle-core"})
    public static abstract class WorkItem
    implements WorkActionAdapter<WorkItemParameters> {
        @NotNull
        private final WorkItemParameters parameters;

        @Inject
        public WorkItem(@NotNull WorkItemParameters parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.parameters = parameters;
        }

        @NotNull
        public WorkItemParameters getParameters() {
            return this.parameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doExecute() {
            Document document;
            Closeable closeable = new BufferedInputStream(new FileInputStream(((RegularFile)this.parameters.getInputXmlFile().get()).getAsFile()));
            Throwable throwable = null;
            try {
                BufferedInputStream it = (BufferedInputStream)closeable;
                boolean bl = false;
                document = PositionXmlParser.parse((InputStream)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Document xmlDocument = document;
            Intrinsics.checkNotNullExpressionValue((Object)xmlDocument, (String)"xmlDocument");
            this.setTargetSandboxVersionAttribute(xmlDocument);
            File file = ((RegularFile)this.parameters.getOutputXmlFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parameters.outputXmlFile.get().asFile");
            String string = XmlDocument.prettyPrint((Document)xmlDocument);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"prettyPrint(xmlDocument)");
            FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
        }

        private final String setTargetSandboxVersionAttribute(Document document) {
            return ManifestUtils.INSTANCE.setManifestAndroidAttribute(document, "targetSandboxVersion", "2");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0016\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/tasks/ProcessManifestForInstantAppTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/tasks/ProcessManifestForInstantAppTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "transformationRequest", "Lcom/android/build/api/artifact/ArtifactTransformationRequest;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ProcessManifestForInstantAppTask, ApkCreationConfig> {
        private ArtifactTransformationRequest<ProcessManifestForInstantAppTask> transformationRequest;

        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("process", "ManifestForInstantApp");
        }

        @Override
        @NotNull
        public Class<ProcessManifestForInstantAppTask> getType() {
            return ProcessManifestForInstantAppTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ProcessManifestForInstantAppTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.transformationRequest = InAndOutDirectoryOperationRequestImpl.toTransformMany$default((InAndOutDirectoryOperationRequestImpl)((ApkCreationConfig)this.creationConfig).getArtifacts().use((TaskProvider)taskProvider).wiredWithDirectories((Function1)handleProvider.1.INSTANCE, (Function1)handleProvider.2.INSTANCE), InternalArtifactType.MERGED_MANIFESTS.INSTANCE, InternalArtifactType.INSTANT_APP_MANIFEST.INSTANCE, null, 4, null);
        }

        @Override
        public void configure(@NotNull ProcessManifestForInstantAppTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            Property<ArtifactTransformationRequest<ProcessManifestForInstantAppTask>> property = task.getTransformationRequest();
            ArtifactTransformationRequest<ProcessManifestForInstantAppTask> artifactTransformationRequest = this.transformationRequest;
            if (artifactTransformationRequest == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"transformationRequest");
                artifactTransformationRequest = null;
            }
            HasConfigurableValuesKt.setDisallowChanges(property, artifactTransformationRequest);
        }
    }
}

