/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.Version;
import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.dsl.Lint;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.TestComponentCreationConfig;
import com.android.build.gradle.internal.component.UnitTestCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.lint.AndroidLintTask;
import com.android.build.gradle.internal.lint.EnvironmentVariableInputs;
import com.android.build.gradle.internal.lint.LintFixBuildService;
import com.android.build.gradle.internal.lint.LintMode;
import com.android.build.gradle.internal.lint.LintTool;
import com.android.build.gradle.internal.lint.ProjectInputs;
import com.android.build.gradle.internal.lint.SystemPropertyInputs;
import com.android.build.gradle.internal.lint.VariantInputs;
import com.android.build.gradle.internal.lint.VariantWithTests;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.LintClassLoaderBuildService;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.LINT)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\b\b'\u0018\u0000 \u0088\u00012\u00020\u0001:\u000e\u0087\u0001\u0088\u0001\u0089\u0001\u008a\u0001\u008b\u0001\u008c\u0001\u008d\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JX\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020l2\u0006\u0010m\u001a\u00020n2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020p0o2\u0006\u0010q\u001a\u00020r2\u0006\u0010.\u001a\u00020/2\b\b\u0002\u0010!\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u0005J\u0010\u0010s\u001a\u00020f2\u0006\u0010m\u001a\u00020nH\u0002J\b\u0010t\u001a\u00020fH\u0014J\b\u0010u\u001a\u00020fH\u0002J\u0013\u0010v\u001a\b\u0012\u0004\u0012\u00020\t0wH\u0001\u00a2\u0006\u0002\bxJ\b\u0010y\u001a\u00020\tH\u0002J \u0010z\u001a\u00020f2\u0006\u0010{\u001a\u00020h2\u0006\u0010|\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/H\u0002J\b\u0010}\u001a\u00020fH\u0002J\b\u0010~\u001a\u00020fH\u0002J%\u0010\u007f\u001a\u00020f*\t\u0012\u0004\u0012\u00020\t0\u0080\u00012\u0007\u0010\u0081\u0001\u001a\u00020\t2\u0007\u0010\u0082\u0001\u001a\u00020\tH\u0002J&\u0010\u007f\u001a\u00020f*\t\u0012\u0004\u0012\u00020\t0\u0080\u00012\u0007\u0010\u0081\u0001\u001a\u00020\t2\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0002J\u0014\u0010\u0085\u0001\u001a\u00020\t*\t\u0012\u0004\u0012\u00020\t0\u0086\u0001H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007R\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R\u0014\u0010\u001b\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010R\u0014\u0010\u001d\u001a\u00020\u001e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0007R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0007R\u0014\u0010%\u001a\u00020&8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020&8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0007R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0007R\u0014\u00101\u001a\u0002028gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0007R\u0014\u00107\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0010R\u0014\u00109\u001a\u00020:8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0014\u0010=\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u0010R\u001a\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u0007R\u001a\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u0007R\u0014\u0010C\u001a\u0002028gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u00104R\u001a\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u0007R\u0014\u0010G\u001a\u00020H8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0014\u0010K\u001a\u00020&8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010(R\u001a\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010\u0007R\u0014\u0010O\u001a\u00020&8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010(R\u0014\u0010Q\u001a\u00020R8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bS\u0010TR\u001a\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u0010\u0007R\u0014\u0010W\u001a\u00020&8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bX\u0010(R\u001a\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bZ\u0010\u0007R\u0014\u0010[\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\\\u0010\u0010R\u0014\u0010]\u001a\u00020^8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b_\u0010`R\u001a\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bb\u0010\u0007R\u0014\u0010c\u001a\u00020&8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bd\u0010(\u00a8\u0006\u008e\u0001"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "android", "Lorg/gradle/api/provider/Property;", "", "getAndroid", "()Lorg/gradle/api/provider/Property;", "androidGradlePluginVersion", "", "getAndroidGradlePluginVersion", "androidSdkHome", "getAndroidSdkHome", "androidTestDependencyLintModels", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getAndroidTestDependencyLintModels", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "autoFix", "getAutoFix", "checkDependencies", "getCheckDependencies", "checkOnly", "Lorg/gradle/api/provider/ListProperty;", "getCheckOnly", "()Lorg/gradle/api/provider/ListProperty;", "dependencyPartialResults", "getDependencyPartialResults", "dynamicFeatureLintModels", "getDynamicFeatureLintModels", "environmentVariableInputs", "Lcom/android/build/gradle/internal/lint/EnvironmentVariableInputs;", "getEnvironmentVariableInputs", "()Lcom/android/build/gradle/internal/lint/EnvironmentVariableInputs;", "fatalOnly", "getFatalOnly", "htmlReportEnabled", "getHtmlReportEnabled", "htmlReportOutputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getHtmlReportOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "intermediateTextReport", "getIntermediateTextReport", "lintFixBuildService", "Lcom/android/build/gradle/internal/lint/LintFixBuildService;", "getLintFixBuildService", "lintMode", "Lcom/android/build/gradle/internal/lint/LintMode;", "getLintMode", "lintModelDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getLintModelDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "lintModelWriterTaskOutputPath", "getLintModelWriterTaskOutputPath", "lintRuleJars", "getLintRuleJars", "lintTool", "Lcom/android/build/gradle/internal/lint/LintTool;", "getLintTool", "()Lcom/android/build/gradle/internal/lint/LintTool;", "mainDependencyLintModels", "getMainDependencyLintModels", "missingBaselineIsEmptyBaseline", "getMissingBaselineIsEmptyBaseline", "offline", "getOffline", "partialResults", "getPartialResults", "printStackTrace", "getPrintStackTrace", "projectInputs", "Lcom/android/build/gradle/internal/lint/ProjectInputs;", "getProjectInputs", "()Lcom/android/build/gradle/internal/lint/ProjectInputs;", "returnValueOutputFile", "getReturnValueOutputFile", "sarifReportEnabled", "getSarifReportEnabled", "sarifReportOutputFile", "getSarifReportOutputFile", "systemPropertyInputs", "Lcom/android/build/gradle/internal/lint/SystemPropertyInputs;", "getSystemPropertyInputs", "()Lcom/android/build/gradle/internal/lint/SystemPropertyInputs;", "textReportEnabled", "getTextReportEnabled", "textReportOutputFile", "getTextReportOutputFile", "textReportToStdOut", "getTextReportToStdOut", "unitTestDependencyLintModels", "getUnitTestDependencyLintModels", "variantInputs", "Lcom/android/build/gradle/internal/lint/VariantInputs;", "getVariantInputs", "()Lcom/android/build/gradle/internal/lint/VariantInputs;", "xmlReportEnabled", "getXmlReportEnabled", "xmlReportOutputFile", "getXmlReportOutputFile", "configureForStandalone", "", "taskCreationServices", "Lcom/android/build/gradle/internal/services/TaskCreationServices;", "javaPluginExtension", "Lorg/gradle/api/plugins/JavaPluginExtension;", "customLintChecksConfig", "Lorg/gradle/api/file/FileCollection;", "lintOptions", "Lcom/android/build/api/dsl/Lint;", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "lintModelWriterTaskOutputDir", "Ljava/io/File;", "configureOutputSettings", "doTaskAction", "finalizeOutputTypes", "generateCommandLineArguments", "", "generateCommandLineArguments$gradle_core", "getUpdateBaselineWarning", "initializeGlobalInputs", "services", "isAndroid", "initializeOutputTypesConvention", "writeLintModelFile", "add", "", "arg", "value", "path", "Lorg/gradle/api/file/RegularFile;", "asLintPaths", "", "AndroidLintLauncherWorkAction", "Companion", "FixSingleVariantCreationAction", "LintVitalCreationAction", "SingleVariantCreationAction", "UpdateBaselineCreationAction", "VariantCreationAction", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nAndroidLintTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidLintTask.kt\ncom/android/build/gradle/internal/lint/AndroidLintTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 buildServices.kt\ncom/android/build/gradle/internal/services/BuildServicesKt\n*L\n1#1,984:1\n1#2:985\n766#3:986\n857#3,2:987\n1549#3:989\n1620#3,3:990\n67#4:993\n67#4:994\n*S KotlinDebug\n*F\n+ 1 AndroidLintTask.kt\ncom/android/build/gradle/internal/lint/AndroidLintTask\n*L\n409#1:986\n409#1:987,2\n409#1:989\n409#1:990,3\n875#1:993\n881#1:994\n*E\n"})
public abstract class AndroidLintTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String LINT_PRINT_STACKTRACE_ENVIRONMENT_VARIABLE = "LINT_PRINT_STACKTRACE";
    @NotNull
    private static final String ANDROID_LINT_JARS_ENVIRONMENT_VARIABLE = "ANDROID_LINT_JARS";

    @Nested
    @NotNull
    public abstract LintTool getLintTool();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getLintModelDirectory();

    @Input
    @NotNull
    public abstract Property<String> getLintModelWriterTaskOutputPath();

    @Input
    @NotNull
    public abstract Property<Boolean> getTextReportEnabled();

    @OutputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getTextReportOutputFile();

    @OutputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getIntermediateTextReport();

    @Input
    @NotNull
    public abstract Property<Boolean> getHtmlReportEnabled();

    @OutputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getHtmlReportOutputFile();

    @Input
    @NotNull
    public abstract Property<Boolean> getXmlReportEnabled();

    @OutputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getXmlReportOutputFile();

    @Input
    @NotNull
    public abstract Property<Boolean> getSarifReportEnabled();

    @OutputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getSarifReportOutputFile();

    @Input
    @NotNull
    public abstract Property<Boolean> getTextReportToStdOut();

    @Internal
    @NotNull
    public abstract Property<String> getAndroidSdkHome();

    @Input
    @NotNull
    public abstract Property<String> getAndroidGradlePluginVersion();

    @Input
    @NotNull
    public abstract Property<Boolean> getOffline();

    @Input
    @NotNull
    public abstract Property<Boolean> getAndroid();

    @Input
    @NotNull
    public abstract Property<Boolean> getFatalOnly();

    @Input
    @NotNull
    public abstract Property<Boolean> getAutoFix();

    @Internal
    @NotNull
    public abstract Property<LintFixBuildService> getLintFixBuildService();

    @Input
    @NotNull
    public abstract Property<Boolean> getCheckDependencies();

    @Input
    @NotNull
    public abstract ListProperty<String> getCheckOnly();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getLintRuleJars();

    @Nested
    @NotNull
    public abstract ProjectInputs getProjectInputs();

    @Nested
    @NotNull
    public abstract VariantInputs getVariantInputs();

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public abstract ConfigurableFileCollection getMainDependencyLintModels();

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public abstract ConfigurableFileCollection getAndroidTestDependencyLintModels();

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public abstract ConfigurableFileCollection getUnitTestDependencyLintModels();

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public abstract ConfigurableFileCollection getDynamicFeatureLintModels();

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Optional
    @NotNull
    public abstract DirectoryProperty getPartialResults();

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getDependencyPartialResults();

    @Input
    @NotNull
    public abstract Property<Boolean> getPrintStackTrace();

    @Nested
    @NotNull
    public abstract SystemPropertyInputs getSystemPropertyInputs();

    @Nested
    @NotNull
    public abstract EnvironmentVariableInputs getEnvironmentVariableInputs();

    @OutputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getReturnValueOutputFile();

    @Input
    @NotNull
    public abstract Property<LintMode> getLintMode();

    @Input
    @NotNull
    public abstract Property<Boolean> getMissingBaselineIsEmptyBaseline();

    @Override
    protected void doTaskAction() {
        ((LintClassLoaderBuildService)this.getLintTool().getLintClassLoaderBuildService().get()).setShouldDispose(true);
        if (Intrinsics.areEqual((Object)this.getSystemPropertyInputs().getLintAutofix().getOrNull(), (Object)"true")) {
            this.getLogger().warn("Running lint with -Dlint.autofix=true is not supported by the Android Gradle Plugin. Please try running the lintFix task instead.");
        }
        this.writeLintModelFile();
        RegularFile regularFile = (RegularFile)this.getProjectInputs().getLintOptions().getBaseline().getOrNull();
        File baselineFile = regularFile != null ? regularFile.getAsFile() : null;
        String originalBaselineFileText = null;
        List originalBaselineFileLines = null;
        if (this.getLintMode().get() == LintMode.UPDATE_BASELINE) {
            if (baselineFile == null) {
                this.getLogger().warn(this.getUpdateBaselineWarning());
                return;
            }
            if (baselineFile.isFile()) {
                originalBaselineFileText = FilesKt.readText$default((File)baselineFile, null, (int)1, null);
                originalBaselineFileLines = FilesKt.readLines$default((File)baselineFile, null, (int)1, null);
            }
            FileUtils.deleteIfExists((File)baselineFile);
        }
        this.getWorkerExecutor().noIsolation().submit(AndroidLintLauncherWorkAction.class, new Action(this){
            final /* synthetic */ AndroidLintTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(AndroidLintLauncherWorkAction.LauncherParameters parameters) {
                parameters.getArguments().set((Iterable)this.this$0.generateCommandLineArguments$gradle_core());
                parameters.getLintTool().set((Object)this.this$0.getLintTool());
                parameters.getAndroid().set((Provider)this.this$0.getAndroid());
                parameters.getFatalOnly().set((Provider)this.this$0.getFatalOnly());
                parameters.getLintFixBuildService().set((Provider)this.this$0.getLintFixBuildService());
                parameters.getReturnValueOutputFile().set((Provider)this.this$0.getReturnValueOutputFile());
                parameters.getLintMode().set((Provider)this.this$0.getLintMode());
                parameters.getHasBaseline().set((Object)(this.this$0.getProjectInputs().getLintOptions().getBaseline().getOrNull() != null ? 1 : 0));
            }
        });
        if (this.getLintMode().get() == LintMode.UPDATE_BASELINE && originalBaselineFileText != null && originalBaselineFileLines != null && baselineFile != null) {
            this.getWorkerExecutor().await();
            if (!AndroidLintTask.Companion.isBaselineChanged(originalBaselineFileLines, baselineFile)) {
                FilesKt.writeText$default((File)baselineFile, (String)originalBaselineFileText, null, (int)2, null);
            }
        }
    }

    private final void writeLintModelFile() {
        LintModelModule module2 = this.getProjectInputs().convertToLintModelModule$gradle_core();
        Directory directory2 = (Directory)this.getPartialResults().getOrNull();
        LintModelVariant variant2 = this.getVariantInputs().toLintModel(module2, directory2 != null ? directory2.getAsFile() : null, CollectionsKt.emptyList());
        File file = ((Directory)this.getLintModelDirectory().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"lintModelDirectory.get().asFile");
        LintModelSerialization.writeModule$default((LintModelSerialization)LintModelSerialization.INSTANCE, (LintModelModule)module2, (File)file, (List)CollectionsKt.listOf((Object)variant2), (boolean)true, null, null, (int)48, null);
    }

    private final String getUpdateBaselineWarning() {
        Object object = this.getAndroid().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"android.get()");
        String example = (Boolean)object != false ? "```\nandroid {\n    lint {\n        baseline = file(\"lint-baseline.xml\")\n    }\n}\n```" : "```\nlint {\n    baseline = file(\"lint-baseline.xml\")\n}\n```";
        return StringsKt.trimIndent((String)("\n            No baseline file is specified, so no baseline file will be created.\n\n            Please specify a baseline file in the build.gradle file like so:\n\n            " + example + "\n        "));
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final List<String> generateCommandLineArguments$gradle_core() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        File it;
        void $this$filterTo$iv$iv;
        Object[] objectArray;
        String it2;
        List arguments = new ArrayList();
        Object object = this.getAutoFix().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"autoFix.get()");
        if (((Boolean)object).booleanValue()) {
            ((Collection)arguments).add("--apply-suggestions");
            ((Collection)arguments).add("--abort-if-suggestions-applied");
        }
        Object object2 = this.getFatalOnly().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fatalOnly.get()");
        if (((Boolean)object2).booleanValue()) {
            ((Collection)arguments).add("--fatalOnly");
        }
        if (this.getLintMode().get() == LintMode.UPDATE_BASELINE) {
            ((Collection)arguments).add("--update-baseline");
        }
        ((Collection)arguments).add("--report-only");
        Collection collection = arguments;
        String[] stringArray = new String[]{"--jdk-home", this.getSystemPropertyInputs().getJavaHome().get()};
        CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])stringArray));
        String string = (String)this.getAndroidSdkHome().getOrNull();
        if (string != null) {
            it2 = string;
            boolean bl = false;
            this.add((List<String>)arguments, "--sdk-home", it2);
        }
        Object object3 = this.getTextReportEnabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"textReportEnabled.get()");
        if (((Boolean)object3).booleanValue()) {
            Object object4 = this.getTextReportOutputFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"textReportOutputFile.get()");
            this.add((List<String>)arguments, "--text", (RegularFile)object4);
        }
        RegularFile regularFile = (RegularFile)this.getIntermediateTextReport().getOrNull();
        if (regularFile != null) {
            it2 = regularFile;
            boolean bl = false;
            this.add((List<String>)arguments, "--text", (RegularFile)it2);
        }
        Object object5 = this.getHtmlReportEnabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"htmlReportEnabled.get()");
        if (((Boolean)object5).booleanValue()) {
            Object object6 = this.getHtmlReportOutputFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"htmlReportOutputFile.get()");
            this.add((List<String>)arguments, "--html", (RegularFile)object6);
        }
        Object object7 = this.getXmlReportEnabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"xmlReportEnabled.get()");
        if (((Boolean)object7).booleanValue()) {
            Object object8 = this.getXmlReportOutputFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"xmlReportOutputFile.get()");
            this.add((List<String>)arguments, "--xml", (RegularFile)object8);
        }
        Object object9 = this.getSarifReportEnabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"sarifReportEnabled.get()");
        if (((Boolean)object9).booleanValue()) {
            Object object10 = this.getSarifReportOutputFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object10, (String)"sarifReportOutputFile.get()");
            this.add((List<String>)arguments, "--sarif", (RegularFile)object10);
        }
        Object object11 = this.getTextReportToStdOut().get();
        Intrinsics.checkNotNullExpressionValue((Object)object11, (String)"textReportToStdOut.get()");
        if (((Boolean)object11).booleanValue()) {
            this.add((List<String>)arguments, "--text", "stdout");
        }
        LinkedHashSet<String> models = new LinkedHashSet<String>(1);
        ((Collection)models).add(((Directory)this.getLintModelDirectory().get()).getAsFile().getAbsolutePath());
        for (File model : this.getDynamicFeatureLintModels()) {
            models.add(model.getAbsolutePath());
        }
        for (File model : this.getMainDependencyLintModels().getFiles()) {
            models.add(model.getAbsolutePath());
        }
        for (File model : this.getAndroidTestDependencyLintModels().getFiles()) {
            models.add(model.getAbsolutePath());
        }
        for (File model : this.getUnitTestDependencyLintModels().getFiles()) {
            models.add(model.getAbsolutePath());
        }
        models.remove(this.getLintModelWriterTaskOutputPath().get());
        Object object12 = this.getCheckDependencies().get();
        Intrinsics.checkNotNullExpressionValue((Object)object12, (String)"checkDependencies.get()");
        if (!((Boolean)object12 != false || models.size() == 1 + this.getDynamicFeatureLintModels().getFiles().size())) {
            boolean $i$a$-check-AndroidLintTask$generateCommandLineArguments$42 = false;
            String $i$a$-check-AndroidLintTask$generateCommandLineArguments$42 = "Library dependency models should not be an input unless check dependencies is being used.";
            throw new IllegalStateException($i$a$-check-AndroidLintTask$generateCommandLineArguments$42.toString());
        }
        ((Collection)arguments).add("--lint-model");
        ((Collection)arguments).add(this.asLintPaths((Collection<String>)models));
        for (String check : (List)this.getCheckOnly().get()) {
            Collection bl = arguments;
            objectArray = new String[]{"--check", check};
            CollectionsKt.addAll((Collection)bl, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        }
        Set set = this.getLintRuleJars().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"lintRuleJars.files");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.isFile()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getAbsolutePath());
        }
        List rules2 = (List)destination$iv$iv;
        if (!((Collection)rules2).isEmpty()) {
            ((Collection)arguments).add("--lint-rule-jars");
            ((Collection)arguments).add(this.asLintPaths(rules2));
        }
        Object object13 = this.getPrintStackTrace().get();
        Intrinsics.checkNotNullExpressionValue((Object)object13, (String)"printStackTrace.get()");
        if (((Boolean)object13).booleanValue()) {
            ((Collection)arguments).add("--stacktrace");
        }
        CollectionsKt.addAll((Collection)arguments, (Iterable)this.getLintTool().initializeLintCacheDir());
        if (Intrinsics.areEqual((Object)this.getSystemPropertyInputs().getLintBaselinesContinue().getOrNull(), (Object)"true")) {
            ((Collection)arguments).add("--continue-after-baseline-created");
        }
        Object object14 = this.getMissingBaselineIsEmptyBaseline().get();
        Intrinsics.checkNotNullExpressionValue((Object)object14, (String)"missingBaselineIsEmptyBaseline.get()");
        if (((Boolean)object14).booleanValue()) {
            ((Collection)arguments).add("--missing-baseline-is-empty-baseline");
        }
        this.add((List<String>)arguments, "--client-id", "gradle");
        this.add((List<String>)arguments, "--client-name", "AGP");
        String string2 = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
        this.add((List<String>)arguments, "--client-version", string2);
        Object object15 = this.getOffline().get();
        Intrinsics.checkNotNullExpressionValue((Object)object15, (String)"offline.get()");
        if (((Boolean)object15).booleanValue()) {
            GradleVersion gradleVersion = GradleVersion.tryParse((String)((String)this.getLintTool().getVersion().get()));
            boolean bl = gradleVersion != null ? gradleVersion.isAtLeast(30, 3, 0, "beta", 1, false) : false;
            if (bl) {
                ((Collection)arguments).add("--offline");
            }
        }
        List<String> list = Collections.unmodifiableList(arguments);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(arguments)");
        return list;
    }

    private final String asLintPaths(Collection<String> $this$asLintPaths) {
        return CollectionsKt.joinToString$default((Iterable)$this$asLintPaths, (CharSequence)";", null, (CharSequence)";", (int)0, null, null, (int)58, null);
    }

    private final void add(List<String> $this$add, String arg, RegularFile path) {
        $this$add.add(arg);
        String string = path.getAsFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path.asFile.absolutePath");
        $this$add.add(string);
    }

    private final void add(List<String> $this$add, String arg, String value) {
        $this$add.add(arg);
        $this$add.add(value);
    }

    private final void initializeOutputTypesConvention() {
        this.getTextReportEnabled().convention((Object)false);
        this.getHtmlReportEnabled().convention((Object)false);
        this.getXmlReportEnabled().convention((Object)false);
        this.getSarifReportEnabled().convention((Object)false);
        this.getTextReportToStdOut().convention((Object)false);
    }

    private final void finalizeOutputTypes() {
        this.getTextReportEnabled().disallowChanges();
        this.getHtmlReportEnabled().disallowChanges();
        this.getXmlReportEnabled().disallowChanges();
        this.getSarifReportEnabled().disallowChanges();
        this.getTextReportToStdOut().disallowChanges();
    }

    private final void initializeGlobalInputs(TaskCreationServices services, boolean isAndroid, LintMode lintMode) {
        BuildServiceRegistry buildServiceRegistry = this.getProject().getGradle().getSharedServices();
        HasConfigurableValuesKt.setDisallowChanges(this.getAndroidGradlePluginVersion(), Version.ANDROID_GRADLE_PLUGIN_VERSION);
        HasConfigurableValuesKt.setDisallowChanges(this.getAndroid(), isAndroid);
        if (isAndroid) {
            Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"buildServiceRegistry");
            Provider<SdkComponentsBuildService> sdkComponentsBuildService2 = BuildServicesKt.getBuildService(buildServiceRegistry, SdkComponentsBuildService.class);
            this.getAndroidSdkHome().set(sdkComponentsBuildService2.flatMap((Transformer)initializeGlobalInputs.1.INSTANCE).map((Transformer)initializeGlobalInputs.2.INSTANCE));
        }
        this.getAndroidSdkHome().disallowChanges();
        HasConfigurableValuesKt.setDisallowChanges(this.getOffline(), this.getProject().getGradle().getStartParameter().isOffline());
        Provider provider2 = this.getProject().getProviders().environmentVariable(ANDROID_LINT_JARS_ENVIRONMENT_VARIABLE).orElse((Object)"").map((Transformer)initializeGlobalInputs.globalLintJarsFromEnvVariable.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"project.providers.enviro\u2026ter(String::isNotEmpty) }");
        Provider globalLintJarsFromEnvVariable2 = provider2;
        Object[] objectArray = new Object[]{globalLintJarsFromEnvVariable2};
        this.getLintRuleJars().from(objectArray);
        if (this.getProject().getGradle().getStartParameter().getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS) {
            HasConfigurableValuesKt.setDisallowChanges(this.getPrintStackTrace(), true);
        } else {
            Property<Boolean> property = this.getPrintStackTrace();
            Provider provider3 = this.getProject().getProviders().environmentVariable(LINT_PRINT_STACKTRACE_ENVIRONMENT_VARIABLE).map((Transformer)initializeGlobalInputs.3.INSTANCE).orElse(services.getProjectOptions().getProvider(BooleanOption.PRINT_LINT_STACK_TRACE));
            Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"project.providers.enviro\u2026CE)\n                    )");
            HasConfigurableValuesKt.setDisallowChanges(property, provider3);
        }
        SystemPropertyInputs systemPropertyInputs = this.getSystemPropertyInputs();
        ProviderFactory providerFactory = this.getProject().getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"project.providers");
        systemPropertyInputs.initialize(providerFactory, lintMode);
        EnvironmentVariableInputs environmentVariableInputs = this.getEnvironmentVariableInputs();
        ProviderFactory providerFactory2 = this.getProject().getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory2, (String)"project.providers");
        environmentVariableInputs.initialize(providerFactory2, lintMode);
    }

    public final void configureForStandalone(@NotNull TaskCreationServices taskCreationServices, @NotNull JavaPluginExtension javaPluginExtension, @NotNull FileCollection customLintChecksConfig, @NotNull Lint lintOptions2, @NotNull Provider<Directory> partialResults, @NotNull File lintModelWriterTaskOutputDir, @NotNull LintMode lintMode, boolean fatalOnly, boolean autoFix) {
        Intrinsics.checkNotNullParameter((Object)taskCreationServices, (String)"taskCreationServices");
        Intrinsics.checkNotNullParameter((Object)javaPluginExtension, (String)"javaPluginExtension");
        Intrinsics.checkNotNullParameter((Object)customLintChecksConfig, (String)"customLintChecksConfig");
        Intrinsics.checkNotNullParameter((Object)lintOptions2, (String)"lintOptions");
        Intrinsics.checkNotNullParameter(partialResults, (String)"partialResults");
        Intrinsics.checkNotNullParameter((Object)lintModelWriterTaskOutputDir, (String)"lintModelWriterTaskOutputDir");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        ProjectInfo projectInfo = taskCreationServices.getProjectInfo();
        this.initializeGlobalInputs(taskCreationServices, false, lintMode);
        this.setGroup("verification");
        this.setVariantName("");
        BuildServiceRegistry buildServiceRegistry$iv = taskCreationServices.getBuildServiceRegistry();
        boolean $i$f$getBuildService = false;
        HasConfigurableValuesKt.setDisallowChanges(this.getAnalyticsService(), BuildServicesKt.getBuildService(buildServiceRegistry$iv, AnalyticsService.class));
        HasConfigurableValuesKt.setDisallowChanges(this.getFatalOnly(), fatalOnly);
        HasConfigurableValuesKt.setDisallowChanges(this.getAutoFix(), autoFix);
        HasConfigurableValuesKt.setDisallowChanges(this.getLintMode(), lintMode);
        if (autoFix) {
            buildServiceRegistry$iv = taskCreationServices.getBuildServiceRegistry();
            $i$f$getBuildService = false;
            this.getLintFixBuildService().set(BuildServicesKt.getBuildService(buildServiceRegistry$iv, LintFixBuildService.class));
        }
        this.getLintFixBuildService().disallowChanges();
        HasConfigurableValuesKt.setDisallowChanges(this.getCheckDependencies(), false);
        HasConfigurableValuesKt.setDisallowChanges(this.getCheckOnly(), (Iterable)lintOptions2.getCheckOnly());
        this.getLintTool().initialize(taskCreationServices);
        ProjectInputs projectInputs = this.getProjectInputs();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        projectInputs.initializeForStandalone$gradle_core(project2, javaPluginExtension, lintOptions2, lintMode);
        this.getOutputs().upToDateWhen(new Spec(this){
            final /* synthetic */ AndroidLintTask this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isSatisfiedBy(Task it) {
                RegularFile regularFile = (RegularFile)this.this$0.getProjectInputs().getLintOptions().getBaseline().getOrNull();
                Object object = regularFile;
                if (regularFile == null) return true;
                File file = object.getAsFile();
                object = file;
                if (file == null) return true;
                boolean bl = ((File)object).exists();
                if (bl) return true;
                Object object2 = this.this$0.getMissingBaselineIsEmptyBaseline().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"this.missingBaselineIsEmptyBaseline.get()");
                if ((Boolean)object2 == false) return false;
                return true;
            }
        });
        this.getOutputs().upToDateWhen(new Spec(this){
            final /* synthetic */ AndroidLintTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final boolean isSatisfiedBy(Task it) {
                return this.this$0.getLintMode().get() != LintMode.UPDATE_BASELINE;
            }
        });
        VariantInputs variantInputs = this.getVariantInputs();
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        variantInputs.initializeForStandalone$gradle_core(project3, javaPluginExtension, taskCreationServices.getProjectOptions(), fatalOnly, false, lintMode);
        Object[] objectArray = new Object[]{customLintChecksConfig};
        HasConfigurableValuesKt.fromDisallowChanges(this.getLintRuleJars(), objectArray);
        Property property = (Property)this.getLintModelDirectory();
        Provider provider2 = projectInfo.getBuildDirectory().dir("intermediates/" + this.getName() + "/android-lint-model");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"projectInfo.buildDirecto\u2026ame}/android-lint-model\")");
        HasConfigurableValuesKt.setDisallowChanges(property, provider2);
        HasConfigurableValuesKt.setDisallowChanges((Property)this.getPartialResults(), partialResults);
        HasConfigurableValuesKt.setDisallowChanges(this.getLintModelWriterTaskOutputPath(), lintModelWriterTaskOutputDir.getAbsolutePath());
        this.initializeOutputTypesConvention();
        if (!fatalOnly) {
            if (autoFix) {
                HasConfigurableValuesKt.setDisallowChanges(this.getTextReportToStdOut(), true);
                this.getOutputs().upToDateWhen((Spec)configureForStandalone.3.INSTANCE);
            } else if (lintMode != LintMode.UPDATE_BASELINE) {
                this.configureOutputSettings(lintOptions2);
            }
        }
        this.finalizeOutputTypes();
        Property<Boolean> property2 = this.getMissingBaselineIsEmptyBaseline();
        Provider<Boolean> provider3 = taskCreationServices.getProjectOptions().getProvider(BooleanOption.MISSING_LINT_BASELINE_IS_EMPTY_BASELINE);
        Intrinsics.checkNotNullExpressionValue(provider3, (String)"taskCreationServices.pro\u2026SELINE_IS_EMPTY_BASELINE)");
        HasConfigurableValuesKt.setDisallowChanges(property2, provider3);
    }

    public static /* synthetic */ void configureForStandalone$default(AndroidLintTask androidLintTask, TaskCreationServices taskCreationServices, JavaPluginExtension javaPluginExtension, FileCollection fileCollection2, Lint lint2, Provider provider2, File file, LintMode lintMode, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureForStandalone");
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        if ((n & 0x100) != 0) {
            bl2 = false;
        }
        androidLintTask.configureForStandalone(taskCreationServices, javaPluginExtension, fileCollection2, lint2, (Provider<Directory>)provider2, file, lintMode, bl, bl2);
    }

    private final void configureOutputSettings(Lint lintOptions2) {
        HasConfigurableValuesKt.setDisallowChanges(this.getTextReportEnabled(), true);
        HasConfigurableValuesKt.setDisallowChanges(this.getHtmlReportEnabled(), lintOptions2.getHtmlReport());
        HasConfigurableValuesKt.setDisallowChanges(this.getXmlReportEnabled(), lintOptions2.getXmlReport());
        HasConfigurableValuesKt.setDisallowChanges(this.getSarifReportEnabled(), lintOptions2.getSarifReport());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$AndroidLintLauncherWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintTask$AndroidLintLauncherWorkAction$LauncherParameters;", "()V", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "execute", "", "LauncherParameters", "gradle-core"})
    public static abstract class AndroidLintLauncherWorkAction
    implements WorkAction<LauncherParameters> {
        @Inject
        @NotNull
        public abstract WorkerExecutor getWorkerExecutor();

        public void execute() {
            LintFixBuildService lintFixBuildService = (LintFixBuildService)((LauncherParameters)this.getParameters()).getLintFixBuildService().getOrNull();
            LintTool lintTool = (LintTool)((LauncherParameters)this.getParameters()).getLintTool().get();
            WorkerExecutor workerExecutor = this.getWorkerExecutor();
            List list = (List)((LauncherParameters)this.getParameters()).getArguments().get();
            Boolean bl = (Boolean)((LauncherParameters)this.getParameters()).getAndroid().get();
            Boolean bl2 = (Boolean)((LauncherParameters)this.getParameters()).getFatalOnly().get();
            boolean bl3 = lintFixBuildService != null;
            LintMode lintMode = (LintMode)((Object)((LauncherParameters)this.getParameters()).getLintMode().get());
            Boolean bl4 = (Boolean)((LauncherParameters)this.getParameters()).getHasBaseline().get();
            RegularFile regularFile = (RegularFile)((LauncherParameters)this.getParameters()).getReturnValueOutputFile().getOrNull();
            File file = regularFile != null ? regularFile.getAsFile() : null;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"get()");
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get()");
            boolean bl5 = bl;
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"get()");
            boolean bl6 = bl2;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)lintMode), (String)"get()");
            Intrinsics.checkNotNullExpressionValue((Object)bl4, (String)"get()");
            lintTool.submit(workerExecutor, "com.android.tools.lint.Main", list, bl5, bl6, bl3, lintMode, bl4, file);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0007R\u0012\u0010\u001a\u001a\u00020\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$AndroidLintLauncherWorkAction$LauncherParameters;", "Lorg/gradle/workers/WorkParameters;", "()V", "android", "Lorg/gradle/api/provider/Property;", "", "getAndroid", "()Lorg/gradle/api/provider/Property;", "arguments", "Lorg/gradle/api/provider/ListProperty;", "", "getArguments", "()Lorg/gradle/api/provider/ListProperty;", "fatalOnly", "getFatalOnly", "hasBaseline", "getHasBaseline", "lintFixBuildService", "Lcom/android/build/gradle/internal/lint/LintFixBuildService;", "getLintFixBuildService", "lintMode", "Lcom/android/build/gradle/internal/lint/LintMode;", "getLintMode", "lintTool", "Lcom/android/build/gradle/internal/lint/LintTool;", "getLintTool", "returnValueOutputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getReturnValueOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "gradle-core"})
        public static abstract class LauncherParameters
        implements WorkParameters {
            @Nested
            @NotNull
            public abstract Property<LintTool> getLintTool();

            @NotNull
            public abstract ListProperty<String> getArguments();

            @NotNull
            public abstract Property<Boolean> getAndroid();

            @NotNull
            public abstract Property<Boolean> getFatalOnly();

            @NotNull
            public abstract Property<LintFixBuildService> getLintFixBuildService();

            @NotNull
            public abstract RegularFileProperty getReturnValueOutputFile();

            @NotNull
            public abstract Property<LintMode> getLintMode();

            @NotNull
            public abstract Property<Boolean> getHasBaseline();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$Companion;", "", "()V", "ANDROID_LINT_JARS_ENVIRONMENT_VARIABLE", "", "LINT_PRINT_STACKTRACE_ENVIRONMENT_VARIABLE", "isBaselineChanged", "", "originalBaselineFileLines", "", "newBaselineFile", "Ljava/io/File;", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nAndroidLintTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidLintTask.kt\ncom/android/build/gradle/internal/lint/AndroidLintTask$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,984:1\n1864#2,3:985\n*S KotlinDebug\n*F\n+ 1 AndroidLintTask.kt\ncom/android/build/gradle/internal/lint/AndroidLintTask$Companion\n*L\n971#1:985,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isBaselineChanged(List<String> originalBaselineFileLines, File newBaselineFile) {
            if (!newBaselineFile.isFile()) {
                return true;
            }
            List newBaselineFileLines = FilesKt.readLines$default((File)newBaselineFile, null, (int)1, null);
            if (originalBaselineFileLines.size() != newBaselineFileLines.size()) {
                return true;
            }
            Iterable $this$forEachIndexed$iv = newBaselineFileLines;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                String originalLine;
                void newLine;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int i = n;
                boolean bl = false;
                if (StringsKt.startsWith$default((String)newLine, (String)"<issues", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)(originalLine = originalBaselineFileLines.get(i)))).toString(), (Object)((Object)StringsKt.trim((CharSequence)((CharSequence)newLine))).toString())) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$FixSingleVariantCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintTask$VariantCreationAction;", "variant", "Lcom/android/build/gradle/internal/lint/VariantWithTests;", "(Lcom/android/build/gradle/internal/lint/VariantWithTests;)V", "autoFix", "", "getAutoFix", "()Z", "checkDependencies", "getCheckDependencies", "description", "", "getDescription", "()Ljava/lang/String;", "fatalOnly", "getFatalOnly", "lintMode", "Lcom/android/build/gradle/internal/lint/LintMode;", "getLintMode", "()Lcom/android/build/gradle/internal/lint/LintMode;", "name", "getName", "configureOutputSettings", "", "task", "Lcom/android/build/gradle/internal/lint/AndroidLintTask;", "gradle-core"})
    public static final class FixSingleVariantCreationAction
    extends VariantCreationAction {
        @NotNull
        private final String name;

        public FixSingleVariantCreationAction(@NotNull VariantWithTests variant2) {
            Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
            super(variant2);
            this.name = this.creationConfig.computeTaskName("lintFix");
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean getFatalOnly() {
            return false;
        }

        @Override
        public boolean getAutoFix() {
            return true;
        }

        @Override
        @NotNull
        public LintMode getLintMode() {
            return LintMode.REPORTING;
        }

        @Override
        @NotNull
        public String getDescription() {
            return "Fix lint on the " + this.creationConfig.getName() + " variant";
        }

        @Override
        public boolean getCheckDependencies() {
            return this.creationConfig.getGlobal().getLintOptions().getCheckDependencies() && !this.getVariant().getMain().getComponentType().isDynamicFeature();
        }

        @Override
        public void configureOutputSettings(@NotNull AndroidLintTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            HasConfigurableValuesKt.setDisallowChanges(task.getTextReportToStdOut(), true);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001dH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$LintVitalCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintTask$VariantCreationAction;", "variant", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;)V", "autoFix", "", "getAutoFix", "()Z", "checkDependencies", "getCheckDependencies", "description", "", "getDescription", "()Ljava/lang/String;", "fatalOnly", "getFatalOnly", "lintMode", "Lcom/android/build/gradle/internal/lint/LintMode;", "getLintMode", "()Lcom/android/build/gradle/internal/lint/LintMode;", "name", "getName", "configureOutputSettings", "", "task", "Lcom/android/build/gradle/internal/lint/AndroidLintTask;", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class LintVitalCreationAction
    extends VariantCreationAction {
        @NotNull
        private final String name;

        public LintVitalCreationAction(@NotNull VariantCreationConfig variant2) {
            Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
            super(new VariantWithTests(variant2, null, null, null));
            this.name = this.creationConfig.computeTaskName("lintVitalReport");
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean getFatalOnly() {
            return true;
        }

        @Override
        public boolean getAutoFix() {
            return false;
        }

        @Override
        @NotNull
        public LintMode getLintMode() {
            return LintMode.REPORTING;
        }

        @Override
        @NotNull
        public String getDescription() {
            return "Run lint with only the fatal issues enabled on the " + this.creationConfig.getName() + " variant";
        }

        @Override
        public boolean getCheckDependencies() {
            return false;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AndroidLintTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            VariantCreationAction.Companion.registerLintIntermediateArtifacts(taskProvider, this.creationConfig.getArtifacts(), true, this.creationConfig.getName());
        }

        @Override
        public void configureOutputSettings(@NotNull AndroidLintTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001dH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$SingleVariantCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintTask$VariantCreationAction;", "variant", "Lcom/android/build/gradle/internal/lint/VariantWithTests;", "(Lcom/android/build/gradle/internal/lint/VariantWithTests;)V", "autoFix", "", "getAutoFix", "()Z", "checkDependencies", "getCheckDependencies", "description", "", "getDescription", "()Ljava/lang/String;", "fatalOnly", "getFatalOnly", "lintMode", "Lcom/android/build/gradle/internal/lint/LintMode;", "getLintMode", "()Lcom/android/build/gradle/internal/lint/LintMode;", "name", "getName", "configureOutputSettings", "", "task", "Lcom/android/build/gradle/internal/lint/AndroidLintTask;", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Companion", "gradle-core"})
    public static final class SingleVariantCreationAction
    extends VariantCreationAction {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;

        public SingleVariantCreationAction(@NotNull VariantWithTests variant2) {
            Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
            super(variant2);
            this.name = this.creationConfig.computeTaskName("lintReport");
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean getFatalOnly() {
            return false;
        }

        @Override
        public boolean getAutoFix() {
            return false;
        }

        @Override
        @NotNull
        public LintMode getLintMode() {
            return LintMode.REPORTING;
        }

        @Override
        @NotNull
        public String getDescription() {
            return "Run lint on the " + this.creationConfig.getName() + " variant";
        }

        @Override
        public boolean getCheckDependencies() {
            return this.creationConfig.getGlobal().getLintOptions().getCheckDependencies() && !this.getVariant().getMain().getComponentType().isDynamicFeature();
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AndroidLintTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            VariantCreationAction.Companion.registerLintIntermediateArtifacts$default(VariantCreationAction.Companion, taskProvider, this.creationConfig.getArtifacts(), false, this.creationConfig.getName(), 4, null);
            Companion.registerLintReportArtifacts(taskProvider, this.creationConfig.getArtifacts(), this.creationConfig.getName(), this.creationConfig.getServices().getProjectInfo().getReportsDir());
        }

        @Override
        public void configureOutputSettings(@NotNull AndroidLintTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            task.configureOutputSettings(this.creationConfig.getGlobal().getLintOptions());
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$SingleVariantCreationAction$Companion;", "", "()V", "registerLintReportArtifacts", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/android/build/gradle/internal/lint/AndroidLintTask;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "variantName", "", "reportsDirectory", "Ljava/io/File;", "gradle-core"})
        public static final class Companion {
            private Companion() {
            }

            public final void registerLintReportArtifacts(@NotNull TaskProvider<AndroidLintTask> taskProvider, @NotNull ArtifactsImpl artifacts2, @Nullable String variantName, @NotNull File reportsDirectory) {
                Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
                Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
                Intrinsics.checkNotNullParameter((Object)reportsDirectory, (String)"reportsDirectory");
                String string = variantName;
                String name = "lint-results" + (String)(string != null ? "-" + string : "");
                artifacts2.setInitialProvider(taskProvider, (Function1)registerLintReportArtifacts.1.INSTANCE).atLocation(reportsDirectory.getAbsolutePath()).withName(name + ".txt").on(InternalArtifactType.LINT_TEXT_REPORT.INSTANCE);
                artifacts2.setInitialProvider(taskProvider, (Function1)registerLintReportArtifacts.2.INSTANCE).atLocation(reportsDirectory.getAbsolutePath()).withName(name + ".html").on(InternalArtifactType.LINT_HTML_REPORT.INSTANCE);
                artifacts2.setInitialProvider(taskProvider, (Function1)registerLintReportArtifacts.3.INSTANCE).atLocation(reportsDirectory.getAbsolutePath()).withName(name + ".xml").on(InternalArtifactType.LINT_XML_REPORT.INSTANCE);
                artifacts2.setInitialProvider(taskProvider, (Function1)registerLintReportArtifacts.4.INSTANCE).atLocation(reportsDirectory.getAbsolutePath()).withName(name + ".sarif").on(InternalArtifactType.LINT_SARIF_REPORT.INSTANCE);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$UpdateBaselineCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintTask$VariantCreationAction;", "variant", "Lcom/android/build/gradle/internal/lint/VariantWithTests;", "(Lcom/android/build/gradle/internal/lint/VariantWithTests;)V", "autoFix", "", "getAutoFix", "()Z", "checkDependencies", "getCheckDependencies", "description", "", "getDescription", "()Ljava/lang/String;", "fatalOnly", "getFatalOnly", "lintMode", "Lcom/android/build/gradle/internal/lint/LintMode;", "getLintMode", "()Lcom/android/build/gradle/internal/lint/LintMode;", "name", "getName", "configureOutputSettings", "", "task", "Lcom/android/build/gradle/internal/lint/AndroidLintTask;", "gradle-core"})
    public static final class UpdateBaselineCreationAction
    extends VariantCreationAction {
        @NotNull
        private final String name;

        public UpdateBaselineCreationAction(@NotNull VariantWithTests variant2) {
            Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
            super(variant2);
            this.name = this.creationConfig.computeTaskName("updateLintBaseline");
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean getFatalOnly() {
            return false;
        }

        @Override
        public boolean getAutoFix() {
            return false;
        }

        @Override
        @NotNull
        public LintMode getLintMode() {
            return LintMode.UPDATE_BASELINE;
        }

        @Override
        @NotNull
        public String getDescription() {
            return "Update the lint baseline using the " + this.creationConfig.getName() + " variant";
        }

        @Override
        public boolean getCheckDependencies() {
            return this.creationConfig.getGlobal().getLintOptions().getCheckDependencies() && !this.getVariant().getMain().getComponentType().isDynamicFeature();
        }

        @Override
        public void configureOutputSettings(@NotNull AndroidLintTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 !2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001!B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H&R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\""}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$VariantCreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "variant", "Lcom/android/build/gradle/internal/lint/VariantWithTests;", "(Lcom/android/build/gradle/internal/lint/VariantWithTests;)V", "autoFix", "", "getAutoFix", "()Z", "checkDependencies", "getCheckDependencies", "description", "", "getDescription", "()Ljava/lang/String;", "fatalOnly", "getFatalOnly", "lintMode", "Lcom/android/build/gradle/internal/lint/LintMode;", "getLintMode", "()Lcom/android/build/gradle/internal/lint/LintMode;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "getVariant", "()Lcom/android/build/gradle/internal/lint/VariantWithTests;", "configure", "", "task", "configureOutputSettings", "Companion", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nAndroidLintTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidLintTask.kt\ncom/android/build/gradle/internal/lint/AndroidLintTask$VariantCreationAction\n+ 2 buildServices.kt\ncom/android/build/gradle/internal/services/BuildServicesKt\n*L\n1#1,984:1\n67#2:985\n*S KotlinDebug\n*F\n+ 1 AndroidLintTask.kt\ncom/android/build/gradle/internal/lint/AndroidLintTask$VariantCreationAction\n*L\n624#1:985\n*E\n"})
    public static abstract class VariantCreationAction
    extends VariantTaskCreationAction<AndroidLintTask, ComponentCreationConfig> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final VariantWithTests variant;

        public VariantCreationAction(@NotNull VariantWithTests variant2) {
            Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
            super((ComponentCreationConfig)variant2.getMain());
            this.variant = variant2;
        }

        @NotNull
        public final VariantWithTests getVariant() {
            return this.variant;
        }

        @Override
        @NotNull
        public final Class<AndroidLintTask> getType() {
            return AndroidLintTask.class;
        }

        public abstract boolean getFatalOnly();

        public abstract boolean getAutoFix();

        @NotNull
        public abstract String getDescription();

        public abstract boolean getCheckDependencies();

        @NotNull
        public abstract LintMode getLintMode();

        @Override
        public final void configure(@NotNull AndroidLintTask task) {
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.setGroup("verification");
            task.setDescription(this.getDescription());
            task.initializeGlobalInputs(this.variant.getMain().getServices(), true, this.getLintMode());
            DirectoryProperty directoryProperty = task.getLintModelDirectory();
            VariantPathHelper variantPathHelper = this.variant.getMain().getPaths();
            String string = task.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.name");
            directoryProperty.set(variantPathHelper.getIncrementalDir(string));
            Object[] objectArray2 = new Object[]{this.creationConfig.getGlobal().getLocalCustomLintChecks()};
            task.getLintRuleJars().from(objectArray2);
            objectArray2 = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.LINT, null, 8, null)};
            task.getLintRuleJars().from(objectArray2);
            objectArray2 = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.LINT, null, 8, null)};
            task.getLintRuleJars().from(objectArray2);
            task.getLintRuleJars().disallowChanges();
            HasConfigurableValuesKt.setDisallowChanges(task.getFatalOnly(), this.getFatalOnly());
            HasConfigurableValuesKt.setDisallowChanges(task.getAutoFix(), this.getAutoFix());
            HasConfigurableValuesKt.setDisallowChanges(task.getLintMode(), this.getLintMode());
            if (this.getAutoFix()) {
                BuildServiceRegistry buildServiceRegistry$iv = this.creationConfig.getServices().getBuildServiceRegistry();
                boolean $i$f$getBuildService = false;
                task.getLintFixBuildService().set(BuildServicesKt.getBuildService(buildServiceRegistry$iv, LintFixBuildService.class));
            }
            task.getLintFixBuildService().disallowChanges();
            HasConfigurableValuesKt.setDisallowChanges(task.getCheckDependencies(), this.getCheckDependencies());
            HasConfigurableValuesKt.setDisallowChanges(task.getCheckOnly(), this.creationConfig.getServices().provider((Function0)new Function0<Set<String>>(this){
                final /* synthetic */ VariantCreationAction this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Set<String> invoke() {
                    return VariantCreationAction.access$getCreationConfig$p(this.this$0).getGlobal().getLintOptions().getCheckOnly();
                }
            }));
            task.getProjectInputs().initialize$gradle_core(this.variant, this.getLintMode());
            task.getOutputs().upToDateWhen(new Spec(task){
                final /* synthetic */ AndroidLintTask $task;
                {
                    this.$task = $task;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isSatisfiedBy(Task it) {
                    RegularFile regularFile = (RegularFile)this.$task.getProjectInputs().getLintOptions().getBaseline().getOrNull();
                    Object object = regularFile;
                    if (regularFile == null) return true;
                    File file = object.getAsFile();
                    object = file;
                    if (file == null) return true;
                    boolean bl = ((File)object).exists();
                    if (bl) return true;
                    Object object2 = this.$task.getMissingBaselineIsEmptyBaseline().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"task.missingBaselineIsEmptyBaseline.get()");
                    if ((Boolean)object2 == false) return false;
                    return true;
                }
            });
            boolean hasDynamicFeatures = this.creationConfig.getGlobal().getHasDynamicFeatures();
            VariantInputs.initialize$default(task.getVariantInputs(), this.variant, this.getCheckDependencies(), true, this.getLintMode(), false, 16, null);
            Provider partialResults = this.getFatalOnly() ? this.creationConfig.getArtifacts().get(InternalArtifactType.LINT_VITAL_PARTIAL_RESULTS.INSTANCE) : this.creationConfig.getArtifacts().get(InternalArtifactType.LINT_PARTIAL_RESULTS.INSTANCE);
            HasConfigurableValuesKt.setDisallowChanges((Property)task.getPartialResults(), partialResults);
            if (hasDynamicFeatures) {
                objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, this.getFatalOnly() ? AndroidArtifacts.ArtifactType.LINT_VITAL_LINT_MODEL : AndroidArtifacts.ArtifactType.LINT_MODEL, null, 8, null)};
                task.getDynamicFeatureLintModels().from(objectArray);
                objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, this.getFatalOnly() ? AndroidArtifacts.ArtifactType.LINT_VITAL_PARTIAL_RESULTS : AndroidArtifacts.ArtifactType.LINT_PARTIAL_RESULTS, null, 8, null)};
                task.getDependencyPartialResults().from(objectArray);
            }
            task.getDynamicFeatureLintModels().disallowChanges();
            if (this.getCheckDependencies()) {
                Object[] objectArray3;
                TestComponentCreationConfig it;
                objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LINT_MODEL, null, 8, null)};
                task.getMainDependencyLintModels().from(objectArray);
                objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LINT_MODEL, null, 8, null)};
                task.getMainDependencyLintModels().from(objectArray);
                AndroidTestCreationConfig androidTestCreationConfig = this.variant.getAndroidTest();
                if (androidTestCreationConfig != null) {
                    it = androidTestCreationConfig;
                    boolean bl = false;
                    objectArray3 = new Object[]{VariantDependencies.getArtifactFileCollection$default(it.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LINT_MODEL, null, 8, null)};
                    task.getAndroidTestDependencyLintModels().from(objectArray3);
                    objectArray3 = new Object[]{VariantDependencies.getArtifactFileCollection$default(it.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LINT_MODEL, null, 8, null)};
                    task.getAndroidTestDependencyLintModels().from(objectArray3);
                }
                UnitTestCreationConfig unitTestCreationConfig = this.variant.getUnitTest();
                if (unitTestCreationConfig != null) {
                    it = unitTestCreationConfig;
                    boolean bl = false;
                    objectArray3 = new Object[]{VariantDependencies.getArtifactFileCollection$default(it.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LINT_MODEL, null, 8, null)};
                    task.getUnitTestDependencyLintModels().from(objectArray3);
                    objectArray3 = new Object[]{VariantDependencies.getArtifactFileCollection$default(it.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LINT_MODEL, null, 8, null)};
                    task.getUnitTestDependencyLintModels().from(objectArray3);
                }
                objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LINT_PARTIAL_RESULTS, null, 8, null)};
                task.getDependencyPartialResults().from(objectArray);
                objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LINT_PARTIAL_RESULTS, null, 8, null)};
                task.getDependencyPartialResults().from(objectArray);
            }
            task.getMainDependencyLintModels().disallowChanges();
            task.getAndroidTestDependencyLintModels().disallowChanges();
            task.getUnitTestDependencyLintModels().disallowChanges();
            task.getDependencyPartialResults().disallowChanges();
            task.getLintTool().initialize(this.creationConfig.getServices());
            HasConfigurableValuesKt.setDisallowChanges(task.getLintModelWriterTaskOutputPath(), ArtifactsImpl.getOutputPath$gradle_core$default(this.creationConfig.getArtifacts(), (Artifact)InternalArtifactType.LINT_MODEL.INSTANCE, new String[0], null, 4, null).getAbsolutePath());
            if (this.getAutoFix()) {
                task.getOutputs().upToDateWhen((Spec)configure.5.INSTANCE);
            }
            task.initializeOutputTypesConvention();
            this.configureOutputSettings(task);
            task.finalizeOutputTypes();
            Property<Boolean> property = task.getMissingBaselineIsEmptyBaseline();
            Provider<Boolean> provider2 = this.creationConfig.getServices().getProjectOptions().getProvider(BooleanOption.MISSING_LINT_BASELINE_IS_EMPTY_BASELINE);
            Intrinsics.checkNotNullExpressionValue(provider2, (String)"creationConfig.services\n\u2026SELINE_IS_EMPTY_BASELINE)");
            HasConfigurableValuesKt.setDisallowChanges(property, provider2);
        }

        public abstract void configureOutputSettings(@NotNull AndroidLintTask var1);

        @JvmStatic
        public static final void registerLintIntermediateArtifacts(@NotNull TaskProvider<AndroidLintTask> taskProvider, @NotNull ArtifactsImpl artifacts2, boolean fatalOnly, @Nullable String variantName) {
            Companion.registerLintIntermediateArtifacts(taskProvider, artifacts2, fatalOnly, variantName);
        }

        public static final /* synthetic */ ComponentCreationConfig access$getCreationConfig$p(VariantCreationAction $this) {
            return $this.creationConfig;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTask$VariantCreationAction$Companion;", "", "()V", "registerLintIntermediateArtifacts", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/android/build/gradle/internal/lint/AndroidLintTask;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "fatalOnly", "", "variantName", "", "gradle-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            public final void registerLintIntermediateArtifacts(@NotNull TaskProvider<AndroidLintTask> taskProvider, @NotNull ArtifactsImpl artifacts2, boolean fatalOnly, @Nullable String variantName) {
                Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
                Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
                String string = variantName;
                String reportName = "lint-results" + (String)(string != null ? "-" + string : "");
                artifacts2.setInitialProvider(taskProvider, (Function1)registerLintIntermediateArtifacts.1.INSTANCE).withName(reportName + ".txt").on(fatalOnly ? (InternalArtifactType)InternalArtifactType.LINT_VITAL_INTERMEDIATE_TEXT_REPORT.INSTANCE : (InternalArtifactType)InternalArtifactType.LINT_INTERMEDIATE_TEXT_REPORT.INSTANCE);
                String string2 = variantName;
                String returnValueName = "return-value" + (String)(string2 != null ? "-" + string2 : "");
                artifacts2.setInitialProvider(taskProvider, (Function1)registerLintIntermediateArtifacts.2.INSTANCE).withName(returnValueName + ".txt").on(fatalOnly ? (InternalArtifactType)InternalArtifactType.LINT_VITAL_RETURN_VALUE.INSTANCE : (InternalArtifactType)InternalArtifactType.LINT_RETURN_VALUE.INSTANCE);
            }

            public static /* synthetic */ void registerLintIntermediateArtifacts$default(Companion companion, TaskProvider taskProvider, ArtifactsImpl artifactsImpl, boolean bl, String string, int n, Object object) {
                if ((n & 4) != 0) {
                    bl = false;
                }
                if ((n & 8) != 0) {
                    string = null;
                }
                companion.registerLintIntermediateArtifacts((TaskProvider<AndroidLintTask>)taskProvider, artifactsImpl, bl, string);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

