/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.test.TestsAnalytics;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestFilter;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestResult;

public class AndroidAnalyticsTestListener
implements TestListener {
    private final ArtifactCollection dependencies;
    private final boolean coverageEnabled;
    private final AnalyticsService analyticsService;
    private TestFilter testFilter;
    private long totalTests;
    private boolean isIdeInvocation;

    public AndroidAnalyticsTestListener(ArtifactCollection dependencies2, boolean coverageEnabled, AnalyticsService analyticsService, TestFilter testFilter, boolean isIdeInvocation) {
        this.dependencies = dependencies2;
        this.coverageEnabled = coverageEnabled;
        this.analyticsService = analyticsService;
        this.testFilter = testFilter;
        this.isIdeInvocation = isIdeInvocation;
    }

    public void beforeSuite(TestDescriptor testDescriptor) {
    }

    public void afterSuite(TestDescriptor testDescriptor, TestResult testResult) {
        if (testDescriptor.getParent() == null) {
            if (!(this.totalTests != 0L || testResult.getResultType() == TestResult.ResultType.FAILURE || this.testFilter.getIncludePatterns().isEmpty() && this.testFilter.getExcludePatterns().isEmpty())) {
                TestsAnalytics.recordCrashedUnitTestRun(this.dependencies, this.coverageEnabled, this.analyticsService, this.isIdeInvocation);
            }
            if (this.totalTests != 0L) {
                TestsAnalytics.recordOkUnitTestRun(this.dependencies, this.coverageEnabled, (int)this.totalTests, this.analyticsService, this.isIdeInvocation);
            }
        }
    }

    public void beforeTest(TestDescriptor testDescriptor) {
    }

    public void afterTest(TestDescriptor testDescriptor, TestResult testResult) {
        this.totalTests += testResult.getTestCount();
    }
}

