/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.attribution;

import com.android.build.gradle.internal.cxx.attribution.AttributionKey;
import com.android.build.gradle.internal.cxx.attribution.BuildTaskAttribution;
import com.android.build.gradle.internal.cxx.attribution.BuildTaskAttributions;
import com.android.build.gradle.internal.cxx.attribution.OperationType;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.builder.profile.ChromeTraceJson;
import com.android.builder.profile.TraceEventJson;
import com.google.common.base.Throwables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002\u001a&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 \u001a\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020 2\b\b\u0002\u0010\"\u001a\u00020 \u001a\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020 2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0$\u001a\u001e\u0010%\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u001c\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0$2\u0006\u0010!\u001a\u00020 H\u0002\u001a\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001a0)2\u0006\u0010*\u001a\u00020\u001aH\u0002\u001a\"\u0010+\u001a\u00020\u0018*\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020\u00012\u0006\u0010/\u001a\u00020\u0006H\u0002\u001a2\u00100\u001a\u00020\u0018*\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\fH\u0002\u001a\"\u00104\u001a\u00020\u0018*\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u0001H\u0002\u001a\u0014\u00105\u001a\u00020\u0018*\u0002062\u0006\u00107\u001a\u00020\u0005H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0006*\u00020\u001cH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\"\u0015\u0010\u000b\u001a\u00020\u0005*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00068"}, d2={"MICROSECOND_IN_MILLISECOND", "", "illegalChars", "Lkotlin/text/Regex;", "describe", "", "Lcom/android/build/gradle/internal/cxx/attribution/AttributionKey;", "getDescribe", "(Lcom/android/build/gradle/internal/cxx/attribution/AttributionKey;)Ljava/lang/String;", "filename", "getFilename", "name", "Lcom/android/build/gradle/internal/cxx/attribution/BuildTaskAttribution;", "getName", "(Lcom/android/build/gradle/internal/cxx/attribution/BuildTaskAttribution;)Ljava/lang/String;", "type", "Lcom/android/build/gradle/internal/cxx/attribution/OperationType;", "getType", "(Lcom/android/build/gradle/internal/cxx/attribution/BuildTaskAttribution;)Lcom/android/build/gradle/internal/cxx/attribution/OperationType;", "createAttributionKey", "module", "variant", "abi", "generateChromeTrace", "", "allTasks", "Lcom/android/build/gradle/internal/cxx/attribution/BuildTaskAttributions;", "abiModel", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "buildStartTime", "", "extraChromeTraceDir", "Ljava/io/File;", "file", "outputFile", "allAttributions", "", "generateNinjaSourceFileAttribution", "linesToSkip", "readZipContent", "squashTasks", "", "tasks", "addProcessNameMetaEvent", "", "Lcom/android/builder/profile/TraceEventJson;", "pid", "key", "addTaskEvent", "tid", "buildStartTimeMs", "task", "addThreadNameMetaEvent", "collectTask", "Lcom/android/build/gradle/internal/cxx/attribution/BuildTaskAttributions$Builder;", "line", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nBuildAttributionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildAttributionUtils.kt\ncom/android/build/gradle/internal/cxx/attribution/BuildAttributionUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,270:1\n1045#2:271\n1864#2,2:272\n1864#2,2:274\n1855#2,2:276\n1866#2:278\n1866#2:279\n1045#2:297\n766#2:298\n857#2,2:299\n1963#2,14:301\n1549#2:315\n1620#2,3:316\n408#3,4:280\n643#3,5:284\n125#4:289\n152#4,3:290\n231#5:293\n1#6:294\n1295#7,2:295\n*S KotlinDebug\n*F\n+ 1 BuildAttributionUtils.kt\ncom/android/build/gradle/internal/cxx/attribution/BuildAttributionUtilsKt\n*L\n73#1:271\n74#1:272,2\n76#1:274,2\n78#1:276,2\n76#1:278\n74#1:279\n214#1:297\n216#1:298\n216#1:299,2\n217#1:301,14\n224#1:315\n224#1:316,3\n101#1:280,4\n102#1:284,5\n112#1:289\n112#1:290,3\n139#1:293\n139#1:294\n140#1:295,2\n*E\n"})
public final class BuildAttributionUtilsKt {
    private static final int MICROSECOND_IN_MILLISECOND = 1000;
    @NotNull
    private static final Regex illegalChars = new Regex("[:\\\\/\"'|?*<>]");

    public static final void generateChromeTrace(@NotNull File file, @NotNull File outputFile) {
        Map<AttributionKey, BuildTaskAttributions> map;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        try {
            map = BuildAttributionUtilsKt.readZipContent(file);
        }
        catch (Throwable e) {
            LoggingEnvironmentKt.warnln("Cannot parse native build attribution zip file. Exception: " + Throwables.getStackTraceAsString((Throwable)e), new Object[0]);
            return;
        }
        Map<AttributionKey, BuildTaskAttributions> allAttributions = map;
        BuildAttributionUtilsKt.generateChromeTrace(outputFile, allAttributions);
    }

    public static /* synthetic */ void generateChromeTrace$default(File file, File file2, int n, Object object) {
        if ((n & 2) != 0) {
            file2 = new File(file.getParentFile(), FilesKt.getNameWithoutExtension((File)file) + ".json.gz");
        }
        BuildAttributionUtilsKt.generateChromeTrace(file, file2);
    }

    public static final void generateChromeTrace(@NotNull BuildTaskAttributions allTasks, @NotNull CxxAbiModel abiModel, long buildStartTime, @NotNull File extraChromeTraceDir) {
        Intrinsics.checkNotNullParameter((Object)allTasks, (String)"allTasks");
        Intrinsics.checkNotNullParameter((Object)abiModel, (String)"abiModel");
        Intrinsics.checkNotNullParameter((Object)extraChromeTraceDir, (String)"extraChromeTraceDir");
        AttributionKey attributionKey = BuildAttributionUtilsKt.createAttributionKey(abiModel);
        extraChromeTraceDir.mkdirs();
        BuildAttributionUtilsKt.generateChromeTrace(FilesKt.resolve((File)extraChromeTraceDir, (String)("external_native_build-" + buildStartTime + "-" + BuildAttributionUtilsKt.getFilename(attributionKey) + ".json.gz")), MapsKt.mapOf((Pair)TuplesKt.to((Object)attributionKey, (Object)allTasks)));
    }

    /*
     * WARNING - void declaration
     */
    public static final void generateChromeTrace(@NotNull File outputFile, @NotNull Map<AttributionKey, BuildTaskAttributions> allAttributions) {
        void $this$forEachIndexed$iv;
        Iterable $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter(allAttributions, (String)"allAttributions");
        boolean bl = false;
        List allEvents = new ArrayList();
        Iterable iterable = allAttributions.entrySet();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry entry = (Map.Entry)a;
                boolean bl = false;
                BuildTaskAttributions tasks = (BuildTaskAttributions)entry.getValue();
                List<BuildTaskAttribution> list = tasks.getAttributionList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"tasks.attributionList");
                BuildTaskAttribution buildTaskAttribution = (BuildTaskAttribution)CollectionsKt.firstOrNull(list);
                entry = (Map.Entry)b;
                Comparable comparable = Integer.valueOf(buildTaskAttribution != null ? buildTaskAttribution.getStartTimeOffsetMs() : 0);
                bl = false;
                tasks = (BuildTaskAttributions)entry.getValue();
                List<BuildTaskAttribution> list2 = tasks.getAttributionList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"tasks.attributionList");
                BuildTaskAttribution buildTaskAttribution2 = (BuildTaskAttribution)CollectionsKt.firstOrNull(list2);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(buildTaskAttribution2 != null ? buildTaskAttribution2.getStartTimeOffsetMs() : 0));
            }
        });
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Map.Entry entry = (Map.Entry)item$iv;
            int pid = n;
            boolean bl2 = false;
            AttributionKey key = (AttributionKey)entry.getKey();
            BuildTaskAttributions tasksForAnAbi = (BuildTaskAttributions)entry.getValue();
            BuildAttributionUtilsKt.addProcessNameMetaEvent(allEvents, pid, key);
            Iterable $this$forEachIndexed$iv2 = BuildAttributionUtilsKt.squashTasks(tasksForAnAbi);
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void tasks;
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                BuildTaskAttributions buildTaskAttributions = (BuildTaskAttributions)item$iv2;
                int tid = n2;
                boolean bl3 = false;
                BuildAttributionUtilsKt.addThreadNameMetaEvent(allEvents, pid, tid);
                List<BuildTaskAttribution> list = tasks.getAttributionList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"tasks.attributionList");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BuildTaskAttribution task = (BuildTaskAttribution)element$iv;
                    boolean bl4 = false;
                    long l = tasksForAnAbi.getBuildStartTimeMs();
                    Intrinsics.checkNotNullExpressionValue((Object)task, (String)"task");
                    BuildAttributionUtilsKt.addTaskEvent(allEvents, pid, tid, l, task);
                }
            }
        }
        outputFile.getParentFile().mkdirs();
        new ChromeTraceJson(allEvents).storeToFile(outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Map<AttributionKey, BuildTaskAttributions> readZipContent(File file) {
        void $this$mapTo$iv$iv;
        Object it2;
        Map allAttributions = new LinkedHashMap();
        ZipFile zipFile = new ZipFile(file);
        Closeable closeable = new ZipInputStream(new FileInputStream(file));
        Throwable throwable = null;
        try {
            it2 = (ZipInputStream)closeable;
            boolean bl = false;
            while (true) {
                BuildTaskAttributions.Builder builder;
                BuildTaskAttributions.Builder builder2;
                Object object = ((ZipInputStream)it2).getNextEntry();
                ZipEntry zipEntry = object;
                if (zipEntry == null) break;
                Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"it.nextEntry ?: break");
                Object entry = object;
                if (((ZipEntry)entry).isDirectory()) continue;
                String string = ((ZipEntry)entry).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                char[] cArray = new char[]{'/'};
                object = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)3, (int)2, null);
                String module2 = (String)object.get(0);
                String variant2 = (String)object.get(1);
                String abi = (String)object.get(2);
                Map map = allAttributions;
                AttributionKey attributionKey = BuildAttributionUtilsKt.createAttributionKey(module2, variant2, abi);
                BuildTaskAttributions.Builder $this$readZipContent_u24lambda_u249_u24lambda_u248 = builder2 = BuildTaskAttributions.newBuilder();
                boolean bl2 = false;
                Closeable closeable2 = new InputStreamReader(zipFile.getInputStream((ZipEntry)entry), StandardCharsets.UTF_8);
                Throwable throwable2 = null;
                try {
                    InputStreamReader inputStreamReader = (InputStreamReader)closeable2;
                    boolean bl3 = false;
                    for (String line : TextStreamsKt.readLines((Reader)inputStreamReader)) {
                        if (StringsKt.startsWith$default((CharSequence)line, (char)'#', (boolean)false, (int)2, null)) {
                            String string2;
                            BuildTaskAttributions.Builder builder3;
                            block17: {
                                void $this$takeWhile$iv;
                                String string3;
                                char c;
                                int index$iv;
                                int n;
                                String $this$dropWhile$iv;
                                block16: {
                                    String string4 = line;
                                    builder3 = $this$readZipContent_u24lambda_u249_u24lambda_u248;
                                    boolean $i$f$dropWhile = false;
                                    n = $this$dropWhile$iv.length();
                                    for (index$iv = 0; index$iv < n; ++index$iv) {
                                        c = $this$dropWhile$iv.charAt(index$iv);
                                        boolean bl4 = false;
                                        if (!Character.isDigit(c)) continue;
                                        String string5 = $this$dropWhile$iv.substring(index$iv);
                                        string3 = string5;
                                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
                                        break block16;
                                    }
                                    string3 = "";
                                }
                                $this$dropWhile$iv = string3;
                                boolean $i$f$takeWhile = false;
                                n = $this$takeWhile$iv.length();
                                for (index$iv = 0; index$iv < n; ++index$iv) {
                                    c = $this$takeWhile$iv.charAt(index$iv);
                                    boolean bl5 = false;
                                    if (Character.isDigit(c)) continue;
                                    void var28_37 = $this$takeWhile$iv;
                                    int n2 = 0;
                                    String string6 = var28_37.substring(n2, index$iv);
                                    string2 = string6;
                                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                    break block17;
                                }
                                string2 = $this$takeWhile$iv;
                            }
                            builder3.setBuildStartTimeMs(Long.parseLong(string2));
                            continue;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)$this$readZipContent_u24lambda_u249_u24lambda_u248, (String)"readZipContent$lambda$9$lambda$8$lambda$7");
                        BuildAttributionUtilsKt.collectTask($this$readZipContent_u24lambda_u249_u24lambda_u248, line);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder().apply {\n   \u2026      }\n                }");
                map.put(attributionKey, builder);
            }
            it2 = Unit.INSTANCE;
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Map $this$map$iv = allAttributions;
        boolean $i$f$map = false;
        it2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AttributionKey key = (AttributionKey)entry.getKey();
            BuildTaskAttributions.Builder value = (BuildTaskAttributions.Builder)entry.getValue();
            collection.add(TuplesKt.to((Object)key, (Object)value.build()));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private static final void collectTask(BuildTaskAttributions.Builder $this$collectTask, String line) {
        char[] cArray = new char[]{'\t'};
        List list = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        String start = (String)list.get(0);
        String end = (String)list.get(1);
        String output2 = (String)list.get(3);
        $this$collectTask.addAttribution(BuildTaskAttribution.newBuilder().setStartTimeOffsetMs(Integer.parseInt(start)).setEndTimeOffsetMs(Integer.parseInt(end)).setOutputFile(output2).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final BuildTaskAttributions generateNinjaSourceFileAttribution(@NotNull CxxAbiModel abi, int linesToSkip, long buildStartTime) {
        void $this$useLines$iv;
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        BuildTaskAttributions.Builder allTasks = BuildTaskAttributions.newBuilder().setKey(BuildAttributionUtilsKt.createAttributionKey(abi)).setBuildFolder(CxxAbiModelKt.getNinjaLogFile(abi).getParent()).setNinjaLogStartLine(linesToSkip).setBuildStartTimeMs(buildStartTime);
        File file = CxxAbiModelKt.getNinjaLogFile(abi);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset$iv = charset;
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv;
        int n = 8192;
        Reader reader = closeable;
        reader = new InputStreamReader((InputStream)new FileInputStream((File)((Object)reader)), charset$iv);
        closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl = false;
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl2 = false;
            Sequence $this$forEach$iv = SequencesKt.drop((Sequence)lines, (int)linesToSkip);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String line = (String)element$iv;
                boolean bl3 = false;
                if (StringsKt.startsWith$default((String)line, (String)"# ", (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)allTasks, (String)"allTasks");
                BuildAttributionUtilsKt.collectTask(allTasks, line);
            }
            reader = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        BuildTaskAttributions buildTaskAttributions = allTasks.build();
        Intrinsics.checkNotNullExpressionValue((Object)buildTaskAttributions, (String)"allTasks.build()");
        return buildTaskAttributions;
    }

    private static final void addProcessNameMetaEvent(List<TraceEventJson> $this$addProcessNameMetaEvent, int pid, AttributionKey key) {
        $this$addProcessNameMetaEvent.add(new TraceEventJson(pid, 0, 0L, "M", null, "process_name", null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)BuildAttributionUtilsKt.getDescribe(key))), 80, null));
    }

    private static final void addThreadNameMetaEvent(List<TraceEventJson> $this$addThreadNameMetaEvent, int pid, int tid) {
        $this$addThreadNameMetaEvent.add(new TraceEventJson(pid, tid, 0L, "M", null, "thread_name", null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)("ninja->clang " + tid))), 80, null));
    }

    private static final void addTaskEvent(List<TraceEventJson> $this$addTaskEvent, int pid, int tid, long buildStartTimeMs, BuildTaskAttribution task) {
        $this$addTaskEvent.add(new TraceEventJson(pid, tid, (buildStartTimeMs + (long)task.getStartTimeOffsetMs()) * (long)1000, "B", BuildAttributionUtilsKt.getType(task).toString(), BuildAttributionUtilsKt.getName(task), BuildAttributionUtilsKt.getType(task).getColorName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"output", (Object)task.getOutputFile()))));
        $this$addTaskEvent.add(new TraceEventJson(pid, tid, (buildStartTimeMs + (long)task.getEndTimeOffsetMs()) * (long)1000, "E", null, null, null, null, 240, null));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<BuildTaskAttributions> squashTasks(BuildTaskAttributions tasks) {
        void $this$mapTo$iv$iv;
        List result2 = new ArrayList();
        List<BuildTaskAttribution> list = tasks.getAttributionList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"tasks.attributionList");
        Iterable $this$sortedBy$iv = list;
        boolean $i$f$sortedBy = false;
        for (BuildTaskAttribution task : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                BuildTaskAttribution it = (BuildTaskAttribution)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStartTimeOffsetMs());
                it = (BuildTaskAttribution)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStartTimeOffsetMs()));
            }
        })) {
            Object v2;
            Object[] $this$maxByOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = result2;
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                List it = (List)element$iv$iv;
                boolean bl = false;
                BuildTaskAttribution buildTaskAttribution = (BuildTaskAttribution)CollectionsKt.lastOrNull((List)it);
                if (!((buildTaskAttribution != null ? buildTaskAttribution.getEndTimeOffsetMs() : 0) <= task.getStartTimeOffsetMs())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v2 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v2 = maxElem$iv;
                } else {
                    List it = (List)maxElem$iv;
                    boolean bl = false;
                    BuildTaskAttribution buildTaskAttribution = (BuildTaskAttribution)CollectionsKt.lastOrNull((List)it);
                    int maxValue$iv = buildTaskAttribution != null ? buildTaskAttribution.getEndTimeOffsetMs() : 0;
                    do {
                        int v$iv;
                        Object e$iv = iterator$iv.next();
                        List it2 = (List)e$iv;
                        $i$a$-maxByOrNull-BuildAttributionUtilsKt$squashTasks$chosenTrack$2 = false;
                        BuildTaskAttribution buildTaskAttribution2 = (BuildTaskAttribution)CollectionsKt.lastOrNull((List)it2);
                        int n = v$iv = buildTaskAttribution2 != null ? buildTaskAttribution2.getEndTimeOffsetMs() : 0;
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v2 = maxElem$iv;
                }
            }
            List chosenTrack = v2;
            if (chosenTrack == null) {
                $this$maxByOrNull$iv = new BuildTaskAttribution[1];
                Intrinsics.checkNotNullExpressionValue((Object)task, (String)"task");
                $this$maxByOrNull$iv[0] = task;
                result2.add(CollectionsKt.mutableListOf((Object[])$this$maxByOrNull$iv));
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)task, (String)"task");
            chosenTrack.add(task);
        }
        Iterable $this$map$iv = result2;
        boolean $i$f$map = false;
        Iterable chosenTrack = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List maxValue$iv = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BuildTaskAttributions.newBuilder().addAllAttribution((Iterable)it).build());
        }
        return (List)destination$iv$iv;
    }

    private static final String getDescribe(AttributionKey $this$describe) {
        return $this$describe.getModule() + " / " + $this$describe.getVariant() + " / " + $this$describe.getAbi();
    }

    private static final String getFilename(AttributionKey $this$filename) {
        String string = $this$filename.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module");
        CharSequence charSequence = string;
        Regex regex = illegalChars;
        String string2 = "_";
        String string3 = regex.replace(charSequence, string2);
        String string4 = $this$filename.getVariant();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"variant");
        charSequence = string4;
        regex = illegalChars;
        string2 = "_";
        return string3 + "-" + regex.replace(charSequence, string2) + "-" + $this$filename.getAbi();
    }

    private static final AttributionKey createAttributionKey(String module2, String variant2, String abi) {
        AttributionKey attributionKey = AttributionKey.newBuilder().setModule(module2).setVariant(variant2).setAbi(abi).build();
        Intrinsics.checkNotNullExpressionValue((Object)attributionKey, (String)"newBuilder()\n        .se\u2026Abi(abi)\n        .build()");
        return attributionKey;
    }

    private static final AttributionKey createAttributionKey(CxxAbiModel $this$createAttributionKey) {
        AttributionKey attributionKey = AttributionKey.newBuilder().setModule($this$createAttributionKey.getVariant().getModule().getGradleModulePathName()).setVariant($this$createAttributionKey.getVariant().getVariantName()).setAbi($this$createAttributionKey.getAbi().getTag()).build();
        Intrinsics.checkNotNullExpressionValue((Object)attributionKey, (String)"newBuilder()\n        .se\u2026abi.tag)\n        .build()");
        return attributionKey;
    }

    @NotNull
    public static final OperationType getType(@NotNull BuildTaskAttribution $this$type) {
        Intrinsics.checkNotNullParameter((Object)$this$type, (String)"<this>");
        String string = $this$type.getOutputFile();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outputFile");
        return StringsKt.endsWith$default((String)string, (String)".o", (boolean)false, (int)2, null) ? OperationType.COMPILE : OperationType.LINK;
    }

    @NotNull
    public static final String getName(@NotNull BuildTaskAttribution $this$name) {
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"<this>");
        String string = new File($this$name.getOutputFile()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(outputFile).name");
        return string;
    }
}

