/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.Version;
import com.android.build.api.dsl.Lint;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.lint.AndroidLintInputs;
import com.android.build.gradle.internal.lint.LintMode;
import com.android.build.gradle.internal.lint.LintOptionsInput;
import com.android.build.gradle.internal.lint.ProjectInputs;
import com.android.build.gradle.internal.lint.VariantWithTests;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.lint.model.DefaultLintModelMavenName;
import com.android.tools.lint.model.DefaultLintModelModule;
import com.android.tools.lint.model.LintModelLintOptions;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelModuleType;
import com.android.utils.FileUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\r\u0010/\u001a\u000200H\u0000\u00a2\u0006\u0002\b1J\u001d\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0000\u00a2\u0006\u0002\b8J-\u00109\u001a\u0002032\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u00106\u001a\u000207H\u0000\u00a2\u0006\u0002\b@J\u0018\u0010A\u001a\u0002032\u0006\u0010B\u001a\u00020C2\u0006\u00106\u001a\u000207H\u0002J\u0010\u0010D\u001a\u0002032\u0006\u0010B\u001a\u00020CH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000bR\u0014\u0010\u0017\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\u001a8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000bR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000bR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000bR\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000bR\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000bR\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000bR\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u000bR\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u000b\u00a8\u0006E"}, d2={"Lcom/android/build/gradle/internal/lint/ProjectInputs;", "", "()V", "bootClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBootClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "buildDirectoryPath", "Lorg/gradle/api/provider/Property;", "", "getBuildDirectoryPath", "()Lorg/gradle/api/provider/Property;", "buildDirectoryPathInput", "getBuildDirectoryPathInput", "compileTarget", "getCompileTarget", "dynamicFeatures", "Lorg/gradle/api/provider/ListProperty;", "getDynamicFeatures", "()Lorg/gradle/api/provider/ListProperty;", "javaSourceLevel", "Lorg/gradle/api/JavaVersion;", "getJavaSourceLevel", "lintConfigFiles", "getLintConfigFiles", "lintOptions", "Lcom/android/build/gradle/internal/lint/LintOptionsInput;", "getLintOptions", "()Lcom/android/build/gradle/internal/lint/LintOptionsInput;", "mavenArtifactId", "getMavenArtifactId", "mavenGroupId", "getMavenGroupId", "neverShrinking", "", "getNeverShrinking", "projectDirectoryPath", "getProjectDirectoryPath", "projectDirectoryPathInput", "getProjectDirectoryPathInput", "projectGradlePath", "getProjectGradlePath", "projectType", "Lcom/android/tools/lint/model/LintModelModuleType;", "getProjectType", "resourcePrefix", "getResourcePrefix", "convertToLintModelModule", "Lcom/android/tools/lint/model/LintModelModule;", "convertToLintModelModule$gradle_core", "initialize", "", "variant", "Lcom/android/build/gradle/internal/lint/VariantWithTests;", "lintMode", "Lcom/android/build/gradle/internal/lint/LintMode;", "initialize$gradle_core", "initializeForStandalone", "project", "Lorg/gradle/api/Project;", "javaExtension", "Lorg/gradle/api/plugins/JavaPluginExtension;", "dslLintOptions", "Lcom/android/build/api/dsl/Lint;", "initializeForStandalone$gradle_core", "initializeFromProject", "projectInfo", "Lcom/android/build/gradle/internal/scope/ProjectInfo;", "initializeLintConfigFiles", "gradle-core"})
public abstract class ProjectInputs {
    @Internal
    @NotNull
    public abstract Property<String> getProjectDirectoryPath();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getProjectDirectoryPathInput();

    @Input
    @NotNull
    public abstract Property<String> getProjectGradlePath();

    @Input
    @NotNull
    public abstract Property<LintModelModuleType> getProjectType();

    @Input
    @NotNull
    public abstract Property<String> getMavenGroupId();

    @Input
    @NotNull
    public abstract Property<String> getMavenArtifactId();

    @Internal
    @NotNull
    public abstract Property<String> getBuildDirectoryPath();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getBuildDirectoryPathInput();

    @Nested
    @NotNull
    public abstract LintOptionsInput getLintOptions();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getResourcePrefix();

    @Input
    @NotNull
    public abstract ListProperty<String> getDynamicFeatures();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getBootClasspath();

    @Input
    @NotNull
    public abstract Property<JavaVersion> getJavaSourceLevel();

    @Input
    @NotNull
    public abstract Property<String> getCompileTarget();

    @Input
    @NotNull
    public abstract Property<Boolean> getNeverShrinking();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract ConfigurableFileCollection getLintConfigFiles();

    public final void initialize$gradle_core(@NotNull VariantWithTests variant2, @NotNull LintMode lintMode) {
        Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        VariantCreationConfig creationConfig = variant2.getMain();
        GlobalTaskCreationConfig globalConfig2 = creationConfig.getGlobal();
        this.initializeFromProject(creationConfig.getServices().getProjectInfo(), lintMode);
        HasConfigurableValuesKt.setDisallowChanges(this.getProjectType(), AndroidLintInputs.toLintModelModuleType(creationConfig.getComponentType()));
        this.getLintOptions().initialize(globalConfig2.getLintOptions(), lintMode);
        HasConfigurableValuesKt.setDisallowChanges(this.getResourcePrefix(), globalConfig2.getResourcePrefix());
        HasConfigurableValuesKt.setDisallowChanges(this.getDynamicFeatures(), (Iterable)globalConfig2.getDynamicFeatures());
        Object[] objectArray = new Object[]{globalConfig2.getBootClasspath()};
        HasConfigurableValuesKt.fromDisallowChanges(this.getBootClasspath(), objectArray);
        HasConfigurableValuesKt.setDisallowChanges(this.getJavaSourceLevel(), globalConfig2.getCompileOptions().getSourceCompatibility());
        HasConfigurableValuesKt.setDisallowChanges(this.getCompileTarget(), globalConfig2.getCompileSdkHashString());
        HasConfigurableValuesKt.setDisallowChanges(this.getNeverShrinking(), globalConfig2.getHasNoBuildTypeMinified());
    }

    public final void initializeForStandalone$gradle_core(@NotNull Project project2, @NotNull JavaPluginExtension javaExtension, @NotNull Lint dslLintOptions, @NotNull LintMode lintMode) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)javaExtension, (String)"javaExtension");
        Intrinsics.checkNotNullParameter((Object)dslLintOptions, (String)"dslLintOptions");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        this.initializeFromProject(new ProjectInfo(project2), lintMode);
        HasConfigurableValuesKt.setDisallowChanges(this.getProjectType(), LintModelModuleType.JAVA_LIBRARY);
        this.getLintOptions().initialize(dslLintOptions, lintMode);
        HasConfigurableValuesKt.setDisallowChanges(this.getResourcePrefix(), "");
        HasConfigurableValuesKt.setDisallowChanges(this.getDynamicFeatures(), (Iterable)SetsKt.emptySet());
        SourceSet mainSourceSet = (SourceSet)javaExtension.getSourceSets().getByName("main");
        TaskProvider javaCompileTask = project2.getTasks().named(mainSourceSet.getCompileJavaTaskName(), JavaCompile.class);
        ConfigurableFileCollection configurableFileCollection = this.getBootClasspath();
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)javaCompileTask.map(new Transformer(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final FileCollection transform(JavaCompile it) {
                FileCollection fileCollection2 = it.getOptions().getBootstrapClasspath();
                if (fileCollection2 == null) {
                    fileCollection2 = (FileCollection)this.$project.files(new Object[0]);
                }
                return fileCollection2;
            }
        }), (String)"project: Project,\n      \u2026path ?: project.files() }");
        HasConfigurableValuesKt.fromDisallowChanges(configurableFileCollection, objectArray);
        HasConfigurableValuesKt.setDisallowChanges(this.getJavaSourceLevel(), javaExtension.getSourceCompatibility());
        HasConfigurableValuesKt.setDisallowChanges(this.getCompileTarget(), "");
        HasConfigurableValuesKt.setDisallowChanges(this.getNeverShrinking(), true);
    }

    private final void initializeFromProject(ProjectInfo projectInfo, LintMode lintMode) {
        HasConfigurableValuesKt.setDisallowChanges(this.getProjectDirectoryPath(), projectInfo.getProjectDirectory().toString());
        HasConfigurableValuesKt.setDisallowChanges(this.getProjectGradlePath(), projectInfo.getPath());
        HasConfigurableValuesKt.setDisallowChanges(this.getMavenGroupId(), projectInfo.getGroup());
        HasConfigurableValuesKt.setDisallowChanges(this.getMavenArtifactId(), projectInfo.getName());
        Property<String> property = this.getBuildDirectoryPath();
        Provider provider2 = projectInfo.getBuildDirectory().map((Transformer)initializeFromProject.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"projectInfo.buildDirecto\u2026 it.asFile.absolutePath }");
        HasConfigurableValuesKt.setDisallowChanges(property, provider2);
        if (lintMode != LintMode.ANALYSIS) {
            this.getProjectDirectoryPathInput().set((Provider)this.getProjectDirectoryPath());
            this.getBuildDirectoryPathInput().set((Provider)this.getBuildDirectoryPath());
        }
        this.getProjectDirectoryPathInput().disallowChanges();
        this.getBuildDirectoryPathInput().disallowChanges();
        this.initializeLintConfigFiles(projectInfo);
    }

    @NotNull
    public final LintModelModule convertToLintModelModule$gradle_core() {
        File file = new File((String)this.getProjectDirectoryPath().get());
        Object object = this.getProjectGradlePath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"projectGradlePath.get()");
        String string = (String)object;
        Object object2 = this.getProjectType().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"projectType.get()");
        LintModelModuleType lintModelModuleType = (LintModelModuleType)object2;
        Object object3 = this.getMavenGroupId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"mavenGroupId.get()");
        String string2 = (String)object3;
        Object object4 = this.getMavenArtifactId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"mavenArtifactId.get()");
        LintModelMavenName lintModelMavenName = (LintModelMavenName)new DefaultLintModelMavenName(string2, (String)object4, null, 4, null);
        String string3 = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
        AgpVersion agpVersion = AgpVersion.Companion.tryParse(string3);
        File file2 = new File((String)this.getBuildDirectoryPath().get());
        LintModelLintOptions lintModelLintOptions = this.getLintOptions().toLintModel();
        List list = CollectionsKt.emptyList();
        String string4 = (String)this.getResourcePrefix().getOrNull();
        Object object5 = this.getDynamicFeatures().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"dynamicFeatures.get()");
        Collection collection = (Collection)object5;
        Set set = this.getBootClasspath().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"bootClasspath.files");
        List list2 = CollectionsKt.toList((Iterable)set);
        String string5 = ((JavaVersion)this.getJavaSourceLevel().get()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"javaSourceLevel.get().toString()");
        Object object6 = this.getCompileTarget().get();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"compileTarget.get()");
        String string6 = (String)object6;
        List list3 = CollectionsKt.emptyList();
        Object object7 = this.getNeverShrinking().get();
        Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"neverShrinking.get()");
        return (LintModelModule)new DefaultLintModelModule(null, file, string, lintModelModuleType, lintModelMavenName, agpVersion, file2, lintModelLintOptions, list, string4, collection, list2, string5, string6, list3, ((Boolean)object7).booleanValue());
    }

    private final void initializeLintConfigFiles(ProjectInfo projectInfo) {
        File currentDir = projectInfo.getProjectDirectory().getAsFile();
        File currentLintXml = new File(currentDir, "lint.xml");
        while (FileUtils.isFileInDirectory((File)currentLintXml, (File)projectInfo.getRootDir())) {
            Object[] objectArray = new Object[]{currentLintXml};
            this.getLintConfigFiles().from(objectArray);
            if (currentDir.getParentFile() == null) break;
            currentLintXml = new File(currentDir, "lint.xml");
        }
        this.getLintConfigFiles().disallowChanges();
    }
}

