/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;

public class SimpleMarkupWriter
extends Writer {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Writer output;
    private final LinkedList<String> elements = new LinkedList();
    private Context context = Context.Outside;
    private int squareBrackets;
    private final String indent;

    protected SimpleMarkupWriter(Writer writer, String indent) throws IOException {
        this.indent = indent;
        this.output = writer;
    }

    @Override
    public void write(char[] chars, int offset, int length) throws IOException {
        this.characters(chars, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
    }

    public SimpleMarkupWriter characters(char[] characters) throws IOException {
        this.characters(characters, 0, characters.length);
        return this;
    }

    public SimpleMarkupWriter characters(char[] characters, int start, int count) throws IOException {
        if (this.context == Context.CData) {
            this.writeCDATA(characters, start, count);
        } else {
            this.maybeStartText();
            this.writeXmlEncoded(characters, start, count);
        }
        return this;
    }

    public SimpleMarkupWriter characters(CharSequence characters) throws IOException {
        if (this.context == Context.CData) {
            this.writeCDATA(characters);
        } else {
            this.maybeStartText();
            this.writeXmlEncoded(characters);
        }
        return this;
    }

    private void maybeStartText() throws IOException {
        if (this.context == Context.Outside) {
            throw new IllegalStateException("Cannot write text, as there are no started elements.");
        }
        if (this.context == Context.StartTag) {
            this.writeRaw(">");
        }
        this.context = Context.Text;
    }

    private void maybeFinishStartTag() throws IOException {
        if (this.context == Context.StartTag) {
            this.writeRaw(">");
            this.context = Context.ElementContent;
        }
    }

    public SimpleMarkupWriter startElement(String name) throws IOException {
        if (!SimpleMarkupWriter.isValidXmlName(name)) {
            throw new IllegalArgumentException(String.format("Invalid element name: '%s'", name));
        }
        if (this.context == Context.CData) {
            throw new IllegalStateException("Cannot start element, as current CDATA node has not been closed.");
        }
        this.maybeFinishStartTag();
        if (this.indent != null) {
            this.writeRaw(LINE_SEPARATOR);
            for (int i = 0; i < this.elements.size(); ++i) {
                this.writeRaw(this.indent);
            }
        }
        this.context = Context.StartTag;
        this.elements.add(name);
        this.writeRaw("<");
        this.writeRaw(name);
        return this;
    }

    public SimpleMarkupWriter endElement() throws IOException {
        if (this.context == Context.Outside) {
            throw new IllegalStateException("Cannot end element, as there are no started elements.");
        }
        if (this.context == Context.CData) {
            throw new IllegalStateException("Cannot end element, as current CDATA node has not been closed.");
        }
        if (this.context == Context.StartTag) {
            this.writeRaw("/>");
            this.elements.removeLast();
        } else {
            if (this.context != Context.Text && this.indent != null) {
                this.writeRaw(LINE_SEPARATOR);
                for (int i = 1; i < this.elements.size(); ++i) {
                    this.writeRaw(this.indent);
                }
            }
            this.writeRaw("</");
            this.writeRaw(this.elements.removeLast());
            this.writeRaw(">");
        }
        if (this.elements.isEmpty()) {
            if (this.indent != null) {
                this.writeRaw(LINE_SEPARATOR);
            }
            this.output.flush();
            this.context = Context.Outside;
        } else {
            this.context = Context.ElementContent;
        }
        return this;
    }

    private void writeCDATA(char[] cdata, int offset, int count) throws IOException {
        int end = offset + count;
        for (int i = offset; i < end; ++i) {
            this.writeCDATA(cdata[i]);
        }
    }

    private void writeCDATA(CharSequence cdata) throws IOException {
        int len = cdata.length();
        for (int i = 0; i < len; ++i) {
            this.writeCDATA(cdata.charAt(i));
        }
    }

    private void writeCDATA(char ch) throws IOException {
        if (this.needsCDATAEscaping(ch)) {
            this.writeRaw("]]><![CDATA[>");
        } else if (!this.isLegalCharacter(ch)) {
            this.writeRaw('?');
        } else if (this.isRestrictedCharacter(ch)) {
            this.writeRaw("]]>");
            this.writeCharacterReference(ch);
            this.writeRaw("<![CDATA[");
        } else {
            this.writeRaw(ch);
        }
    }

    private void writeCharacterReference(char ch) throws IOException {
        this.writeRaw("&#x");
        this.writeRaw(Integer.toHexString(ch));
        this.writeRaw(";");
    }

    private boolean needsCDATAEscaping(char ch) {
        switch (ch) {
            case ']': {
                ++this.squareBrackets;
                return false;
            }
            case '>': {
                if (this.squareBrackets >= 2) {
                    this.squareBrackets = 0;
                    return true;
                }
                return false;
            }
        }
        this.squareBrackets = 0;
        return false;
    }

    public SimpleMarkupWriter startCDATA() throws IOException {
        if (this.context == Context.CData) {
            throw new IllegalStateException("Cannot start CDATA node, as current CDATA node has not been closed.");
        }
        this.maybeFinishStartTag();
        this.writeRaw("<![CDATA[");
        this.context = Context.CData;
        this.squareBrackets = 0;
        return this;
    }

    public SimpleMarkupWriter endCDATA() throws IOException {
        if (this.context != Context.CData) {
            throw new IllegalStateException("Cannot end CDATA node, as not currently in a CDATA node.");
        }
        this.writeRaw("]]>");
        this.context = Context.Text;
        return this;
    }

    public SimpleMarkupWriter attribute(String name, String value) throws IOException {
        if (!SimpleMarkupWriter.isValidXmlName(name)) {
            throw new IllegalArgumentException(String.format("Invalid attribute name: '%s'", name));
        }
        if (this.context != Context.StartTag) {
            throw new IllegalStateException("Cannot write attribute [" + name + ":" + value + "]. You should write start element first.");
        }
        this.writeRaw(" ");
        this.writeRaw(name);
        this.writeRaw("=\"");
        this.writeXmlAttributeEncoded(value);
        this.writeRaw("\"");
        return this;
    }

    private static boolean isValidXmlName(String name) {
        int length = name.length();
        if (length == 0) {
            return false;
        }
        char ch = name.charAt(0);
        if (!SimpleMarkupWriter.isValidNameStartChar(ch)) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            ch = name.charAt(i);
            if (SimpleMarkupWriter.isValidNameChar(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidNameChar(char ch) {
        if (SimpleMarkupWriter.isValidNameStartChar(ch)) {
            return true;
        }
        if (ch >= '0' && ch <= '9') {
            return true;
        }
        if (ch == '-' || ch == '.' || ch == '\u00b7') {
            return true;
        }
        if (ch >= '\u0300' && ch <= '\u036f') {
            return true;
        }
        return ch >= '\u203f' && ch <= '\u2040';
    }

    private static boolean isValidNameStartChar(char ch) {
        if (ch >= 'A' && ch <= 'Z') {
            return true;
        }
        if (ch >= 'a' && ch <= 'z') {
            return true;
        }
        if (ch == ':' || ch == '_') {
            return true;
        }
        if (ch >= '\u00c0' && ch <= '\u00d6') {
            return true;
        }
        if (ch >= '\u00d8' && ch <= '\u00f6') {
            return true;
        }
        if (ch >= '\u00f8' && ch <= '\u02ff') {
            return true;
        }
        if (ch >= '\u0370' && ch <= '\u037d') {
            return true;
        }
        if (ch >= '\u037f' && ch <= '\u1fff') {
            return true;
        }
        if (ch >= '\u200c' && ch <= '\u200d') {
            return true;
        }
        if (ch >= '\u2070' && ch <= '\u218f') {
            return true;
        }
        if (ch >= '\u2c00' && ch <= '\u2fef') {
            return true;
        }
        if (ch >= '\u3001' && ch <= '\ud7ff') {
            return true;
        }
        if (ch >= '\uf900' && ch <= '\ufdcf') {
            return true;
        }
        return ch >= '\ufdf0' && ch <= '\ufffd';
    }

    private void writeRaw(char c) throws IOException {
        this.output.write(c);
    }

    private boolean isLegalCharacter(char c) {
        if (c == '\u0000') {
            return false;
        }
        if (c <= '\ud7ff') {
            return true;
        }
        if (c < '\ue000') {
            return false;
        }
        return c <= '\ufffd';
    }

    private boolean isRestrictedCharacter(char c) {
        if (c == '\t' || c == '\n' || c == '\r' || c == '\u0085') {
            return false;
        }
        if (c <= '\u001f') {
            return true;
        }
        if (c < '\u007f') {
            return false;
        }
        return c <= '\u009f';
    }

    protected void writeRaw(String message2) throws IOException {
        this.output.write(message2);
    }

    private void writeXmlEncoded(char[] message2, int offset, int count) throws IOException {
        int end = offset + count;
        for (int i = offset; i < end; ++i) {
            this.writeXmlEncoded(message2[i]);
        }
    }

    private void writeXmlAttributeEncoded(CharSequence message2) throws IOException {
        assert (message2 != null);
        int len = message2.length();
        for (int i = 0; i < len; ++i) {
            this.writeXmlAttributeEncoded(message2.charAt(i));
        }
    }

    private void writeXmlAttributeEncoded(char ch) throws IOException {
        if (ch == '\t') {
            this.writeRaw("&#9;");
        } else if (ch == '\n') {
            this.writeRaw("&#10;");
        } else if (ch == '\r') {
            this.writeRaw("&#13;");
        } else {
            this.writeXmlEncoded(ch);
        }
    }

    private void writeXmlEncoded(CharSequence message2) throws IOException {
        assert (message2 != null);
        int len = message2.length();
        for (int i = 0; i < len; ++i) {
            this.writeXmlEncoded(message2.charAt(i));
        }
    }

    private void writeXmlEncoded(char ch) throws IOException {
        if (ch == '<') {
            this.writeRaw("&lt;");
        } else if (ch == '>') {
            this.writeRaw("&gt;");
        } else if (ch == '&') {
            this.writeRaw("&amp;");
        } else if (ch == '\"') {
            this.writeRaw("&quot;");
        } else if (!this.isLegalCharacter(ch)) {
            this.writeRaw('?');
        } else if (this.isRestrictedCharacter(ch)) {
            this.writeCharacterReference(ch);
        } else {
            this.writeRaw(ch);
        }
    }

    private static enum Context {
        Outside,
        Text,
        CData,
        StartTag,
        ElementContent;

    }
}

