/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TransformInputUtil {
    public static Collection<File> getAllFiles(Iterable<TransformInput> transformInputs) {
        return TransformInputUtil.getAllFiles(transformInputs, true, true);
    }

    public static Collection<File> getDirectories(Iterable<TransformInput> transformInputs) {
        return TransformInputUtil.getAllFiles(transformInputs, true, false);
    }

    static Collection<File> getAllFiles(Iterable<TransformInput> transformInputs, boolean includeDirectoryInput, boolean includeJarInput) {
        ImmutableList.Builder inputFiles = ImmutableList.builder();
        for (TransformInput input : transformInputs) {
            if (includeDirectoryInput) {
                for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                    if (!directoryInput.getFile().isDirectory()) continue;
                    inputFiles.add((Object)directoryInput.getFile());
                }
            }
            if (!includeJarInput) continue;
            for (JarInput jarInput : input.getJarInputs()) {
                if (!jarInput.getFile().isFile()) continue;
                inputFiles.add((Object)jarInput.getFile());
            }
        }
        return inputFiles.build();
    }

    public static Map<Status, Set<File>> getByStatus(DirectoryInput dir) {
        Map<Status, Set<File>> byStatus = dir.getChangedFiles().entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toSet())));
        for (Status status : Status.values()) {
            byStatus.putIfAbsent(status, (Set<File>)ImmutableSet.of());
        }
        return byStatus;
    }

    public static Iterable<TransformInput> getInputAndReferenced(TransformInvocation invocation) {
        return Iterables.concat((Iterable)invocation.getInputs(), (Iterable)invocation.getReferencedInputs());
    }

    public static Set<Path> findChangedPaths(Iterable<TransformInput> transformInputs) {
        HashSet changedPaths = Sets.newHashSet();
        for (TransformInput input : transformInputs) {
            for (DirectoryInput dirInput : input.getDirectoryInputs()) {
                Map<Status, Set<File>> byStatus = TransformInputUtil.getByStatus(dirInput);
                for (File modifiedFile : Iterables.concat((Iterable)byStatus.get(Status.CHANGED), (Iterable)byStatus.get(Status.REMOVED), (Iterable)byStatus.get(Status.ADDED))) {
                    if (!modifiedFile.toString().endsWith(".class")) continue;
                    changedPaths.add(modifiedFile.toPath());
                }
            }
            for (JarInput jarInput : input.getJarInputs()) {
                if (jarInput.getStatus() == Status.NOTCHANGED) continue;
                changedPaths.add(jarInput.getFile().toPath());
            }
        }
        return changedPaths;
    }
}

