/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core;

import com.android.build.gradle.internal.PostprocessingFeatures;
import com.android.build.gradle.internal.ProguardFileType;
import com.android.build.gradle.internal.ProguardFilesProvider;
import com.android.build.gradle.internal.core.PostProcessingOptions;
import com.android.build.gradle.internal.dsl.PostProcessingBlock;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0006H\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0001J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/core/PostProcessingBlockOptions;", "Lcom/android/build/gradle/internal/core/PostProcessingOptions;", "Lcom/android/build/gradle/internal/ProguardFilesProvider;", "postProcessingBlock", "Lcom/android/build/gradle/internal/dsl/PostProcessingBlock;", "isTestComponent", "", "(Lcom/android/build/gradle/internal/dsl/PostProcessingBlock;Z)V", "codeShrinkerEnabled", "getDefaultProguardFiles", "", "Ljava/io/File;", "getPostprocessingFeatures", "Lcom/android/build/gradle/internal/PostprocessingFeatures;", "getProguardFiles", "", "type", "Lcom/android/build/gradle/internal/ProguardFileType;", "hasPostProcessingConfiguration", "resourcesShrinkingEnabled", "gradle-core"})
public final class PostProcessingBlockOptions
implements PostProcessingOptions,
ProguardFilesProvider {
    @NotNull
    private final PostProcessingBlock postProcessingBlock;
    private final boolean isTestComponent;

    public PostProcessingBlockOptions(@NotNull PostProcessingBlock postProcessingBlock, boolean isTestComponent) {
        Intrinsics.checkNotNullParameter((Object)postProcessingBlock, (String)"postProcessingBlock");
        this.postProcessingBlock = postProcessingBlock;
        this.isTestComponent = isTestComponent;
    }

    @Override
    @NotNull
    public Collection<File> getProguardFiles(@NotNull ProguardFileType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Collection<File> collection = this.postProcessingBlock.getProguardFiles(type);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getProguardFiles(...)");
        return collection;
    }

    @Override
    @NotNull
    public List<File> getDefaultProguardFiles() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public PostprocessingFeatures getPostprocessingFeatures() {
        return new PostprocessingFeatures(this.postProcessingBlock.isRemoveUnusedCode(), this.postProcessingBlock.isObfuscate(), this.postProcessingBlock.isOptimizeCode());
    }

    @Override
    public boolean codeShrinkerEnabled() {
        return this.isTestComponent ? this.postProcessingBlock.isObfuscate() : this.postProcessingBlock.isRemoveUnusedCode() || this.postProcessingBlock.isObfuscate() || this.postProcessingBlock.isOptimizeCode();
    }

    @Override
    public boolean resourcesShrinkingEnabled() {
        return this.postProcessingBlock.isRemoveUnusedResources();
    }

    @Override
    public boolean hasPostProcessingConfiguration() {
        return true;
    }
}

