/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.api.attributes.AgpVersionAttr;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollections;
import com.android.build.gradle.internal.ide.dependencies.ArtifactUtils;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.ide.dependencies.VariantKey;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a0\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u001a2\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\u00110\u000f\"\u0004\b\u0000\u0010\u0011*\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u0002H\u00110\u0014H\u0002\u001a\u0018\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00150\u0017*\u00020\u0012H\u0002\u001a\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0015H\u0002\u001a\n\u0010\u001a\u001a\u00020\u0010*\u00020\u001b\u00a8\u0006\u001c\u00b2\u0006\u0016\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00150\u0017X\u008a\u0084\u0002"}, d2={"getAllArtifacts", "", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "componentImpl", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "consumedConfigType", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ConsumedConfigType;", "dependencyFailureHandler", "Lcom/android/build/gradle/internal/ide/DependencyFailureHandler;", "collections", "Lcom/android/build/gradle/internal/ide/dependencies/ArtifactCollections;", "projectPath", "", "variantName", "asMap", "", "Lcom/android/build/gradle/internal/ide/dependencies/VariantKey;", "T", "Lorg/gradle/api/artifacts/ArtifactCollection;", "action", "Lkotlin/Function1;", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "asMultiMap", "Lcom/google/common/collect/ImmutableMultimap;", "isAndroidProjectLibrary", "", "toKey", "Lorg/gradle/api/artifacts/result/ResolvedVariantResult;", "gradle-core", "projectJarsMap"})
@JvmName(name="ArtifactUtils")
@SourceDebugExtension(value={"SMAP\nArtifactUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactUtils.kt\ncom/android/build/gradle/internal/ide/dependencies/ArtifactUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,496:1\n766#2:497\n857#2,2:498\n1747#2,3:500\n1855#2,2:503\n1179#2,2:505\n1253#2,4:507\n*S KotlinDebug\n*F\n+ 1 ArtifactUtils.kt\ncom/android/build/gradle/internal/ide/dependencies/ArtifactUtils\n*L\n352#1:497\n352#1:498,2\n424#1:500,3\n433#1:503,2\n471#1:505,2\n471#1:507,4\n*E\n"})
public final class ArtifactUtils {
    @NotNull
    public static final Set<ResolvedArtifact> getAllArtifacts(@NotNull ComponentCreationConfig componentImpl, @NotNull AndroidArtifacts.ConsumedConfigType consumedConfigType, @Nullable DependencyFailureHandler dependencyFailureHandler) {
        Intrinsics.checkNotNullParameter((Object)componentImpl, (String)"componentImpl");
        Intrinsics.checkNotNullParameter((Object)((Object)consumedConfigType), (String)"consumedConfigType");
        ArtifactCollections collections = new ArtifactCollections(componentImpl, consumedConfigType);
        return ArtifactUtils.getAllArtifacts(collections, dependencyFailureHandler, componentImpl.getServices().getProjectInfo().getPath(), componentImpl.getName());
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<ResolvedArtifact> getAllArtifacts(ArtifactCollections collections, DependencyFailureHandler dependencyFailureHandler, String projectPath, String variantName) {
        void $this$filterTo$iv$iv;
        ArtifactCollection incomingArtifacts = collections.getAll();
        Map explodedAars2 = ArtifactUtils.asMap(collections.getExplodedAars(), getAllArtifacts.explodedAars.1.INSTANCE);
        Map lintJars2 = ArtifactUtils.asMap(collections.getLintJar(), getAllArtifacts.lintJars.1.INSTANCE);
        Map asarJars2 = ArtifactUtils.asMap(collections.getAsarJarsCollection(), getAllArtifacts.asarJars.1.INSTANCE);
        ArtifactCollection projectList = collections.getProjectJars();
        Lazy projectJarsMap$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<ImmutableMultimap<VariantKey, ResolvedArtifactResult>>(projectList){
            final /* synthetic */ ArtifactCollection $projectList;
            {
                this.$projectList = $projectList;
                super(0);
            }

            @NotNull
            public final ImmutableMultimap<VariantKey, ResolvedArtifactResult> invoke() {
                return ArtifactUtils.access$asMultiMap(this.$projectList);
            }
        }));
        if (dependencyFailureHandler != null) {
            Collection failures = incomingArtifacts.getFailures();
            String string = projectPath + "@" + variantName + "/" + collections.getConsumedConfigType().getName();
            Intrinsics.checkNotNullExpressionValue((Object)failures, (String)"failures");
            dependencyFailureHandler.addErrors(string, failures);
        }
        Iterable $this$filter$iv = explodedAars2.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VariantKey it = (VariantKey)element$iv$iv;
            boolean bl = false;
            if (!(it.getOwner() instanceof ProjectComponentIdentifier)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List aarWrappedAsProjects = (List)destination$iv$iv;
        Set resolvedArtifactResults = incomingArtifacts.getArtifacts();
        LinkedHashSet artifacts2 = Sets.newLinkedHashSetWithExpectedSize((int)resolvedArtifactResults.size());
        for (ResolvedArtifactResult resolvedComponentResult : resolvedArtifactResults) {
            String artifactType;
            ResolvedVariantResult resolvedVariantResult = resolvedComponentResult.getVariant();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedVariantResult, (String)"resolvedComponentResult.variant");
            VariantKey variantKey = ArtifactUtils.toKey(resolvedVariantResult);
            String string = artifactType = (String)resolvedComponentResult.getVariant().getAttributes().getAttribute(AndroidArtifacts.ARTIFACT_TYPE);
            if (Intrinsics.areEqual((Object)string, (Object)AndroidArtifacts.ArtifactType.AAR.getType())) {
                Intrinsics.checkNotNullExpressionValue((Object)resolvedComponentResult, (String)"resolvedComponentResult");
                ArtifactUtils.getAllArtifacts$addArtifact$default(artifacts2, explodedAars2, variantKey, asarJars2, aarWrappedAsProjects, ResolvedArtifact.DependencyType.ANDROID, resolvedComponentResult, (File)lintJars2.get(variantKey), null, 256, null);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_SDK_ARCHIVE.getType())) {
                Intrinsics.checkNotNullExpressionValue((Object)resolvedComponentResult, (String)"resolvedComponentResult");
                ArtifactUtils.getAllArtifacts$addArtifact$default(artifacts2, explodedAars2, variantKey, asarJars2, aarWrappedAsProjects, ResolvedArtifact.DependencyType.ANDROID_SANDBOX_SDK, resolvedComponentResult, null, null, 384, null);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)AndroidArtifacts.ArtifactType.JAR.getType())) {
                void $this$forEach$iv;
                Collection collection;
                boolean bl;
                block13: {
                    Intrinsics.checkNotNullExpressionValue((Object)resolvedComponentResult, (String)"resolvedComponentResult");
                    if (ArtifactUtils.isAndroidProjectLibrary(resolvedComponentResult)) {
                        ArtifactUtils.getAllArtifacts$addArtifact(artifacts2, explodedAars2, variantKey, asarJars2, aarWrappedAsProjects, ResolvedArtifact.DependencyType.ANDROID, resolvedComponentResult, (File)lintJars2.get(variantKey), null);
                        continue;
                    }
                    ImmutableCollection immutableCollection = ArtifactUtils.getAllArtifacts$lambda$0((Lazy<? extends ImmutableMultimap<VariantKey, ResolvedArtifactResult>>)projectJarsMap$delegate).get((Object)variantKey);
                    Intrinsics.checkNotNullExpressionValue((Object)immutableCollection, (String)"projectJarsMap[variantKey]");
                    Iterable $this$any$iv = (Iterable)immutableCollection;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ResolvedArtifactResult it = (ResolvedArtifactResult)element$iv;
                            boolean bl2 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            if (!ArtifactUtils.isAndroidProjectLibrary(it)) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                }
                if (bl) continue;
                ImmutableCollection projectJars = ArtifactUtils.getAllArtifacts$lambda$0((Lazy<? extends ImmutableMultimap<VariantKey, ResolvedArtifactResult>>)projectJarsMap$delegate).get((Object)variantKey);
                Collection collection2 = (Collection)projectJars;
                if (collection2.isEmpty()) {
                    boolean bl3 = false;
                    collection = CollectionsKt.listOf((Object)resolvedComponentResult);
                } else {
                    collection = collection2;
                }
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"projectJars.ifEmpty {\n  \u2026lt)\n                    }");
                Iterable $i$f$any = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ResolvedArtifactResult it = (ResolvedArtifactResult)element$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    ArtifactUtils.getAllArtifacts$addArtifact$default(artifacts2, explodedAars2, variantKey, asarJars2, aarWrappedAsProjects, ResolvedArtifact.DependencyType.JAVA, it, null, null, 384, null);
                }
                continue;
            }
            throw new IllegalStateException("Internal error: Artifact type " + artifactType + " not expected, only jar or aar are handled.");
        }
        Intrinsics.checkNotNullExpressionValue((Object)artifacts2, (String)"artifacts");
        return artifacts2;
    }

    private static final boolean isAndroidProjectLibrary(ResolvedArtifactResult $this$isAndroidProjectLibrary) {
        return $this$isAndroidProjectLibrary.getVariant().getAttributes().getAttribute(AgpVersionAttr.ATTRIBUTE) != null;
    }

    private static final ImmutableMultimap<VariantKey, ResolvedArtifactResult> asMultiMap(ArtifactCollection $this$asMultiMap) {
        ImmutableMultimap.Builder builder;
        ImmutableMultimap.Builder builder2 = builder = ImmutableMultimap.builder();
        boolean bl = false;
        for (ResolvedArtifactResult artifact : $this$asMultiMap.getArtifacts()) {
            ResolvedVariantResult resolvedVariantResult = artifact.getVariant();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedVariantResult, (String)"artifact.variant");
            builder2.put((Object)ArtifactUtils.toKey(resolvedVariantResult), (Object)artifact);
        }
        ImmutableMultimap immutableMultimap = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMultimap, (String)"builder<VariantKey, Reso\u2026      }\n        }.build()");
        return immutableMultimap;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> Map<VariantKey, T> asMap(ArtifactCollection $this$asMap, Function1<? super ResolvedArtifactResult, ? extends T> action) {
        void $this$associateTo$iv$iv;
        Set set = $this$asMap.getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"artifacts");
        Iterable $this$associate$iv = set;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            ResolvedArtifactResult it = (ResolvedArtifactResult)element$iv$iv;
            boolean bl = false;
            ResolvedVariantResult resolvedVariantResult = it.getVariant();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedVariantResult, (String)"it.variant");
            VariantKey variantKey = ArtifactUtils.toKey(resolvedVariantResult);
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Pair pair = TuplesKt.to((Object)variantKey, (Object)action.invoke((Object)it));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final VariantKey toKey(@NotNull ResolvedVariantResult $this$toKey) {
        Intrinsics.checkNotNullParameter((Object)$this$toKey, (String)"<this>");
        ComponentIdentifier componentIdentifier = $this$toKey.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)componentIdentifier, (String)"owner");
        List list = $this$toKey.getCapabilities();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"capabilities");
        ResolvedVariantResult resolvedVariantResult = $this$toKey.getExternalVariant().orElse(null);
        return new VariantKey(componentIdentifier, list, resolvedVariantResult != null ? ArtifactUtils.toKey(resolvedVariantResult) : null);
    }

    private static final ImmutableMultimap<VariantKey, ResolvedArtifactResult> getAllArtifacts$lambda$0(Lazy<? extends ImmutableMultimap<VariantKey, ResolvedArtifactResult>> $projectJarsMap$delegate) {
        Lazy<? extends ImmutableMultimap<VariantKey, ResolvedArtifactResult>> lazy = $projectJarsMap$delegate;
        return (ImmutableMultimap)lazy.getValue();
    }

    private static final void getAllArtifacts$addArtifact(LinkedHashSet<ResolvedArtifact> artifacts2, Map<VariantKey, ? extends File> explodedAars2, VariantKey variantKey, Map<VariantKey, ? extends File> asarJars2, List<VariantKey> aarWrappedAsProjects, ResolvedArtifact.DependencyType dependencyType, ResolvedArtifactResult mainArtifact, File publishedLintJar, File artifactFile) {
        File file = explodedAars2.get(variantKey);
        if (file == null) {
            file = asarJars2.get(variantKey);
        }
        artifacts2.add(new ResolvedArtifact(mainArtifact, artifactFile, file, publishedLintJar, dependencyType, aarWrappedAsProjects.contains(variantKey)));
    }

    static /* synthetic */ void getAllArtifacts$addArtifact$default(LinkedHashSet linkedHashSet, Map map, VariantKey variantKey, Map map2, List list, ResolvedArtifact.DependencyType dependencyType, ResolvedArtifactResult resolvedArtifactResult, File file, File file2, int n, Object object) {
        if ((n & 0x80) != 0) {
            file = null;
        }
        if ((n & 0x100) != 0) {
            file2 = resolvedArtifactResult.getFile();
        }
        ArtifactUtils.getAllArtifacts$addArtifact(linkedHashSet, map, variantKey, map2, list, dependencyType, resolvedArtifactResult, file, file2);
    }

    public static final /* synthetic */ Set access$getAllArtifacts(ArtifactCollections collections, DependencyFailureHandler dependencyFailureHandler, String projectPath, String variantName) {
        return ArtifactUtils.getAllArtifacts(collections, dependencyFailureHandler, projectPath, variantName);
    }

    public static final /* synthetic */ ImmutableMultimap access$asMultiMap(ArtifactCollection $receiver) {
        return ArtifactUtils.asMultiMap($receiver);
    }
}

