/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.ManagedVirtualDeviceLockManagerKt;
import com.android.builder.utils.ExceptionConsumer;
import com.android.builder.utils.ExceptionFunction;
import com.android.builder.utils.SynchronizedFile;
import com.android.prefs.AndroidLocationsProvider;
import java.io.Closeable;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0012\u001a\u00060\u0013R\u00020\u00002\b\b\u0002\u0010\u0014\u001a\u00020\u0005J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0005H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/ManagedVirtualDeviceLockManager;", "", "androidLocationsProvider", "Lcom/android/prefs/AndroidLocationsProvider;", "maxGMDs", "", "lockRetryWaitMs", "", "(Lcom/android/prefs/AndroidLocationsProvider;IJ)V", "logger", "Lorg/gradle/api/logging/Logger;", "trackingFile", "Lcom/android/builder/utils/SynchronizedFile;", "createDefaultLockFile", "", "file", "Ljava/io/File;", "getCurrentLockCount", "lock", "Lcom/android/build/gradle/internal/ManagedVirtualDeviceLockManager$DeviceLock;", "lockCount", "releaseLocks", "locksToRelease", "tryToAcquireLocks", "locksRequested", "writeLockCount", "newLockCount", "DeviceLock", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nManagedVirtualDeviceLockManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManagedVirtualDeviceLockManager.kt\ncom/android/build/gradle/internal/ManagedVirtualDeviceLockManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1855#2,2:176\n*S KotlinDebug\n*F\n+ 1 ManagedVirtualDeviceLockManager.kt\ncom/android/build/gradle/internal/ManagedVirtualDeviceLockManager\n*L\n151#1:176,2\n*E\n"})
public final class ManagedVirtualDeviceLockManager {
    private final int maxGMDs;
    private final long lockRetryWaitMs;
    @NotNull
    private final SynchronizedFile trackingFile;
    @NotNull
    private final Logger logger;

    public ManagedVirtualDeviceLockManager(@NotNull AndroidLocationsProvider androidLocationsProvider, int maxGMDs, long lockRetryWaitMs) {
        Intrinsics.checkNotNullParameter((Object)androidLocationsProvider, (String)"androidLocationsProvider");
        this.maxGMDs = maxGMDs;
        this.lockRetryWaitMs = lockRetryWaitMs;
        File file = androidLocationsProvider.getGradleAvdLocation().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"androidLocationsProvider\u2026radleAvdLocation.toFile()");
        File lockFile = FilesKt.resolve((File)file, (String)"active_gradle_devices");
        if (!lockFile.getParentFile().exists()) {
            lockFile.getParentFile().mkdirs();
        }
        SynchronizedFile synchronizedFile = SynchronizedFile.getInstanceWithMultiProcessLocking((File)lockFile);
        Intrinsics.checkNotNullExpressionValue((Object)synchronizedFile, (String)"getInstanceWithMultiProcessLocking(lockFile)");
        this.trackingFile = synchronizedFile;
        Logger logger = Logging.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this.javaClass)");
        this.logger = logger;
    }

    public /* synthetic */ ManagedVirtualDeviceLockManager(AndroidLocationsProvider androidLocationsProvider, int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            l = ManagedVirtualDeviceLockManagerKt.access$getDEFAULT_RETRY_WAIT_MS$p();
        }
        this(androidLocationsProvider, n, l);
    }

    @NotNull
    public final DeviceLock lock(int lockCount) {
        int locksAcquired = 0;
        while (locksAcquired == 0) {
            locksAcquired = this.tryToAcquireLocks(lockCount);
            Thread.sleep(this.lockRetryWaitMs);
        }
        return new DeviceLock(locksAcquired);
    }

    public static /* synthetic */ DeviceLock lock$default(ManagedVirtualDeviceLockManager managedVirtualDeviceLockManager, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return managedVirtualDeviceLockManager.lock(n);
    }

    private final void releaseLocks(int locksToRelease) {
        this.trackingFile.write(new ExceptionFunction(this, locksToRelease){
            final /* synthetic */ ManagedVirtualDeviceLockManager this$0;
            final /* synthetic */ int $locksToRelease;
            {
                this.this$0 = $receiver;
                this.$locksToRelease = $locksToRelease;
            }

            public final void accept(File file) {
                int n;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                int currentLockCount = ManagedVirtualDeviceLockManager.access$getCurrentLockCount(this.this$0, file);
                if (currentLockCount < this.$locksToRelease) {
                    ManagedVirtualDeviceLockManager.access$getLogger$p(this.this$0).error(StringsKt.trimIndent((String)("\n                        Attempting to free more locks than have been claimed.\n                        Locks to release: " + this.$locksToRelease + " Locks available: " + currentLockCount + "\n                    ")));
                    n = 0;
                } else {
                    n = currentLockCount - this.$locksToRelease;
                }
                int newlockCount = n;
                ManagedVirtualDeviceLockManager.access$writeLockCount(this.this$0, file, newlockCount);
            }
        });
    }

    private final int tryToAcquireLocks(int locksRequested) {
        this.trackingFile.createIfAbsent(new ExceptionConsumer(this){
            final /* synthetic */ ManagedVirtualDeviceLockManager this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(File file) {
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                ManagedVirtualDeviceLockManager.access$createDefaultLockFile(this.this$0, file);
            }
        });
        Object object = this.trackingFile.write(new ExceptionFunction(this, locksRequested){
            final /* synthetic */ ManagedVirtualDeviceLockManager this$0;
            final /* synthetic */ int $locksRequested;
            {
                this.this$0 = $receiver;
                this.$locksRequested = $locksRequested;
            }

            public final Integer accept(File file) {
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                int currentLockCount = ManagedVirtualDeviceLockManager.access$getCurrentLockCount(this.this$0, file);
                int locksToClaim = Math.min(this.$locksRequested, ManagedVirtualDeviceLockManager.access$getMaxGMDs$p(this.this$0) - currentLockCount);
                if (locksToClaim != 0) {
                    ManagedVirtualDeviceLockManager.access$writeLockCount(this.this$0, file, currentLockCount + locksToClaim);
                }
                return locksToClaim;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"private fun tryToAcquire\u2026ksToClaim\n        }\n    }");
        return ((Number)object).intValue();
    }

    private final void createDefaultLockFile(File file) {
        this.logger.info("Creating default GMD lock tracking file at " + file.getAbsolutePath());
        FilesKt.writeText$default((File)file, (String)"MDLockCount 0", null, (int)2, null);
    }

    private final int getCurrentLockCount(File file) {
        for (String line : FilesKt.readLines$default((File)file, null, (int)1, null)) {
            if (!StringsKt.startsWith$default((String)line, (String)"MDLockCount", (boolean)false, (int)2, null)) continue;
            String string = line.substring(11);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            return Integer.parseInt(((Object)StringsKt.trim((CharSequence)string)).toString());
        }
        this.logger.error(" Failed to find MDLockCount in gmd lock file. File Contents:\n " + FilesKt.readLines$default((File)file, null, (int)1, null));
        this.writeLockCount(file, 0);
        throw new IllegalStateException("Failed to find the number of active Gradle Managed Devices.".toString());
    }

    private final void writeLockCount(File file, int newLockCount) {
        List lines = FilesKt.readLines$default((File)file, null, (int)1, null);
        FilesKt.writeText$default((File)file, (String)"", null, (int)2, null);
        FilesKt.appendText$default((File)file, (String)("MDLockCount " + newLockCount), null, (int)2, null);
        Iterable $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)line, (String)"MDLockCount", (boolean)false, (int)2, null)) continue;
            FilesKt.appendText$default((File)file, (String)("\n" + line), null, (int)2, null);
        }
    }

    public static final /* synthetic */ int access$getCurrentLockCount(ManagedVirtualDeviceLockManager $this, File file) {
        return $this.getCurrentLockCount(file);
    }

    public static final /* synthetic */ Logger access$getLogger$p(ManagedVirtualDeviceLockManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$writeLockCount(ManagedVirtualDeviceLockManager $this, File file, int newLockCount) {
        $this.writeLockCount(file, newLockCount);
    }

    public static final /* synthetic */ void access$createDefaultLockFile(ManagedVirtualDeviceLockManager $this, File file) {
        $this.createDefaultLockFile(file);
    }

    public static final /* synthetic */ int access$getMaxGMDs$p(ManagedVirtualDeviceLockManager $this) {
        return $this.maxGMDs;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/ManagedVirtualDeviceLockManager$DeviceLock;", "Ljava/io/Closeable;", "lockCount", "", "(Lcom/android/build/gradle/internal/ManagedVirtualDeviceLockManager;I)V", "<set-?>", "", "closed", "getClosed", "()Z", "getLockCount", "()I", "close", "", "gradle-core"})
    public final class DeviceLock
    implements Closeable {
        private final int lockCount;
        private boolean closed;

        public DeviceLock(int lockCount) {
            this.lockCount = lockCount;
        }

        public final int getLockCount() {
            return this.lockCount;
        }

        public final boolean getClosed() {
            return this.closed;
        }

        @Override
        public void close() {
            if (!this.closed) {
                ManagedVirtualDeviceLockManager.this.releaseLocks(this.lockCount);
                this.closed = true;
            }
        }
    }
}

