/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.GradleLocalPropertiesFactory;
import com.android.build.gradle.internal.SdkLocation;
import com.android.build.gradle.internal.SdkLocationSourceSet;
import com.android.build.gradle.internal.SdkType;
import com.android.builder.errors.IssueReporter;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0007J\u0018\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0016\u0010\u0006\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/SdkLocator;", "", "()V", "ANDROID_DIR_PROPERTY", "", "getANDROID_DIR_PROPERTY$annotations", "ANDROID_HOME_SYSTEM_PROPERTY", "getANDROID_HOME_SYSTEM_PROPERTY$annotations", "cachedSdkLocation", "Lcom/android/build/gradle/internal/SdkLocation;", "cachedSdkLocationKey", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "sdkTestDirectory", "Ljava/io/File;", "getSdkTestDirectory$annotations", "getSdkTestDirectory", "()Ljava/io/File;", "setSdkTestDirectory", "(Ljava/io/File;)V", "getSdkDirectory", "projectRootDir", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "getSdkLocation", "sourceSet", "resetCache", "", "updateCache", "sdkLocation", "SdkLocationSource", "gradle-core"})
public final class SdkLocator {
    @NotNull
    public static final SdkLocator INSTANCE = new SdkLocator();
    @Nullable
    private static File sdkTestDirectory;
    @NotNull
    public static final String ANDROID_DIR_PROPERTY = "android.dir";
    @NotNull
    public static final String ANDROID_HOME_SYSTEM_PROPERTY = "android.home";
    @Nullable
    private static SdkLocationSourceSet cachedSdkLocationKey;
    @Nullable
    private static SdkLocation cachedSdkLocation;

    private SdkLocator() {
    }

    @Nullable
    public static final File getSdkTestDirectory() {
        return sdkTestDirectory;
    }

    public static final void setSdkTestDirectory(@Nullable File file) {
        sdkTestDirectory = file;
    }

    @JvmStatic
    @VisibleForTesting
    public static /* synthetic */ void getSdkTestDirectory$annotations() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getANDROID_DIR_PROPERTY$annotations() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getANDROID_HOME_SYSTEM_PROPERTY$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final File getSdkDirectory(@NotNull File projectRootDir, @NotNull IssueReporter issueReporter2) {
        File file;
        Intrinsics.checkNotNullParameter((Object)projectRootDir, (String)"projectRootDir");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        SdkLocation sdkLocation = SdkLocator.getSdkLocation(new SdkLocationSourceSet(projectRootDir, null, null, null, 14, null), issueReporter2);
        if (sdkLocation.getType() == SdkType.MISSING) {
            file = new File(projectRootDir, "missingSdkDirectory");
        } else {
            file = sdkLocation.getDirectory();
            if (file == null) {
                throw new IllegalStateException(("Directory must not be null when type = " + sdkLocation.getType()).toString());
            }
        }
        return file;
    }

    @JvmStatic
    @NotNull
    public static final synchronized SdkLocation getSdkLocation(@NotNull SdkLocationSourceSet sourceSet, @NotNull IssueReporter issueReporter2) {
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        SdkLocationSourceSet sdkLocationSourceSet = cachedSdkLocationKey;
        if (sdkLocationSourceSet != null) {
            SdkLocationSourceSet it = sdkLocationSourceSet;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)sourceSet)) {
                SdkLocation sdkLocation = cachedSdkLocation;
                Intrinsics.checkNotNull((Object)sdkLocation);
                return sdkLocation;
            }
        }
        for (SdkLocationSource source : SdkLocationSource.values()) {
            SdkLocation sdkLocation = source.getSdkLocation(sourceSet);
            if (sdkLocation == null) continue;
            SdkLocation it = sdkLocation;
            boolean bl = false;
            INSTANCE.updateCache(it, sourceSet);
            return it;
        }
        SdkLocation it = new SdkLocation(null, SdkType.MISSING);
        boolean bl = false;
        INSTANCE.updateCache(it, sourceSet);
        String filePath = new File(sourceSet.getProjectRoot(), "local.properties").getAbsolutePath();
        String message2 = "SDK location not found. Define a valid SDK location with an ANDROID_HOME environment variable or by setting the sdk.dir path in your project's local properties file at '" + filePath + "'.";
        IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.SDK_NOT_SET, (String)message2, (String)filePath, null, (int)8, null);
        return it;
    }

    private final synchronized void updateCache(SdkLocation sdkLocation, SdkLocationSourceSet sourceSet) {
        cachedSdkLocationKey = sourceSet;
        cachedSdkLocation = sdkLocation;
    }

    @JvmStatic
    public static final synchronized void resetCache() {
        GradleLocalPropertiesFactory.INSTANCE.resetCache$gradle_core();
        cachedSdkLocationKey = null;
        cachedSdkLocation = null;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH&J\u001a\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource;", "", "sdkType", "Lcom/android/build/gradle/internal/SdkType;", "(Ljava/lang/String;ILcom/android/build/gradle/internal/SdkType;)V", "getSdkType", "()Lcom/android/build/gradle/internal/SdkType;", "getSdkLocation", "Lcom/android/build/gradle/internal/SdkLocation;", "sourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "getSdkPathProperty", "Ljava/io/File;", "validateSdkPath", "path", "", "rootDir", "TEST_SDK_DIRECTORY", "LOCAL_SDK_DIR", "LOCAL_ANDROID_DIR", "INJECTED_SDK_HOME", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nSdkLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkLocator.kt\ncom/android/build/gradle/internal/SdkLocator$SdkLocationSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,307:1\n1#2:308\n*E\n"})
    public static final abstract class SdkLocationSource
    extends Enum<SdkLocationSource> {
        @NotNull
        private final SdkType sdkType;
        public static final /* enum */ SdkLocationSource TEST_SDK_DIRECTORY = new TEST_SDK_DIRECTORY("TEST_SDK_DIRECTORY", 0);
        public static final /* enum */ SdkLocationSource LOCAL_SDK_DIR = new LOCAL_SDK_DIR("LOCAL_SDK_DIR", 1);
        public static final /* enum */ SdkLocationSource LOCAL_ANDROID_DIR = new LOCAL_ANDROID_DIR("LOCAL_ANDROID_DIR", 2);
        public static final /* enum */ SdkLocationSource INJECTED_SDK_HOME = new INJECTED_SDK_HOME("INJECTED_SDK_HOME", 3);
        private static final /* synthetic */ SdkLocationSource[] $VALUES;

        private SdkLocationSource(SdkType sdkType) {
            this.sdkType = sdkType;
        }

        @NotNull
        public final SdkType getSdkType() {
            return this.sdkType;
        }

        @Nullable
        public final SdkLocation getSdkLocation(@NotNull SdkLocationSourceSet sourceSet) {
            SdkLocation sdkLocation;
            Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
            File file = this.getSdkPathProperty(sourceSet);
            if (file != null) {
                File it = file;
                boolean bl = false;
                sdkLocation = new SdkLocation(it, this.sdkType);
            } else {
                sdkLocation = null;
            }
            return sdkLocation;
        }

        @Nullable
        public abstract File getSdkPathProperty(@NotNull SdkLocationSourceSet var1);

        @Nullable
        protected final File validateSdkPath(@NotNull String path, @NotNull File rootDir) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
            File sdk = new File(path);
            if (!sdk.isAbsolute()) {
                File file = new File(rootDir, path).getCanonicalFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"File(rootDir, path).canonicalFile");
                sdk = file;
            }
            return sdk.isDirectory() ? sdk : null;
        }

        public static SdkLocationSource[] values() {
            return (SdkLocationSource[])$VALUES.clone();
        }

        public static SdkLocationSource valueOf(String value) {
            return Enum.valueOf(SdkLocationSource.class, value);
        }

        public /* synthetic */ SdkLocationSource(String $enum$name, int $enum$ordinal, SdkType sdkType, DefaultConstructorMarker $constructor_marker) {
            this(sdkType);
        }

        static {
            $VALUES = sdkLocationSourceArray = new SdkLocationSource[]{SdkLocationSource.TEST_SDK_DIRECTORY, SdkLocationSource.LOCAL_SDK_DIR, SdkLocationSource.LOCAL_ANDROID_DIR, SdkLocationSource.INJECTED_SDK_HOME};
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource$INJECTED_SDK_HOME;", "Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource;", "getSdkPathProperty", "Ljava/io/File;", "sourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "gradle-core"})
        @SourceDebugExtension(value={"SMAP\nSdkLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkLocator.kt\ncom/android/build/gradle/internal/SdkLocator$SdkLocationSource$INJECTED_SDK_HOME\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,307:1\n1477#2:308\n1502#2,3:309\n1505#2,3:319\n1045#2:322\n361#3,7:312\n*S KotlinDebug\n*F\n+ 1 SdkLocator.kt\ncom/android/build/gradle/internal/SdkLocator$SdkLocationSource$INJECTED_SDK_HOME\n*L\n139#1:308\n139#1:309,3\n139#1:319,3\n153#1:322\n139#1:312,7\n*E\n"})
        static final class INJECTED_SDK_HOME
        extends SdkLocationSource {
            /*
             * WARNING - void declaration
             */
            INJECTED_SDK_HOME() {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @Nullable
            public File getSdkPathProperty(@NotNull SdkLocationSourceSet sourceSet) {
                void $this$groupByTo$iv$iv;
                File it;
                String path;
                Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
                Map map = new LinkedHashMap();
                String string = sourceSet.getEnvironmentProperties$gradle_core().getProperty("ANDROID_SDK_ROOT");
                if (string != null) {
                    path = string;
                    boolean bl = false;
                    File file = this.validateSdkPath(path, sourceSet.getProjectRoot());
                    if (file != null) {
                        it = file;
                        boolean bl2 = false;
                        map.put("ANDROID_SDK_ROOT", it);
                    }
                }
                string = sourceSet.getEnvironmentProperties$gradle_core().getProperty("ANDROID_HOME");
                if (string != null) {
                    path = string;
                    boolean bl = false;
                    File file = this.validateSdkPath(path, sourceSet.getProjectRoot());
                    if (file != null) {
                        it = file;
                        boolean bl3 = false;
                        map.put("ANDROID_HOME", it);
                    }
                }
                String string2 = sourceSet.getSystemProperties$gradle_core().getProperty(SdkLocator.ANDROID_HOME_SYSTEM_PROPERTY);
                if (string2 != null) {
                    path = string2;
                    boolean bl = false;
                    File file = this.validateSdkPath(path, sourceSet.getProjectRoot());
                    if (file != null) {
                        it = file;
                        boolean bl4 = false;
                        map.put(SdkLocator.ANDROID_HOME_SYSTEM_PROPERTY, it);
                    }
                }
                if (map.isEmpty()) {
                    return null;
                }
                if (map.size() == 1) {
                    return (File)CollectionsKt.single((Iterable)map.values());
                }
                Iterable $this$groupBy$iv = map.entrySet();
                boolean $i$f$groupBy = false;
                Iterable bl = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    Map.Entry it2 = (Map.Entry)element$iv$iv;
                    boolean bl5 = false;
                    File key$iv$iv = (File)it2.getValue();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl6 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                Map reverseMap = destination$iv$iv;
                if (reverseMap.size() == 1) {
                    return (File)CollectionsKt.single((Iterable)reverseMap.keySet());
                }
                Object message2 = ((Object)StringsKt.trimStart((CharSequence)"\nSeveral environment variables and/or system properties contain different paths to the SDK.\nPlease correct and use only one way to inject the SDK location.\n")).toString();
                Iterable $this$sortedBy$iv = map.entrySet();
                boolean $i$f$sortedBy = false;
                for (Map.Entry entry : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                    }
                })) {
                    message2 = (String)message2 + "\n" + entry.getKey() + ": " + entry.getValue();
                }
                message2 = StringsKt.trimIndent((String)((String)message2 + "\n\nIt is recommended to use ANDROID_HOME as other methods are deprecated\n"));
                throw new RuntimeException((String)message2);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource$LOCAL_ANDROID_DIR;", "Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource;", "getSdkPathProperty", "Ljava/io/File;", "sourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "gradle-core"})
        static final class LOCAL_ANDROID_DIR
        extends SdkLocationSource {
            /*
             * WARNING - void declaration
             */
            LOCAL_ANDROID_DIR() {
                void var1_1;
            }

            @Override
            @Nullable
            public File getSdkPathProperty(@NotNull SdkLocationSourceSet sourceSet) {
                File file;
                Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
                String string = sourceSet.getLocalProperties$gradle_core().getProperty(SdkLocator.ANDROID_DIR_PROPERTY);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    file = this.validateSdkPath(it, sourceSet.getProjectRoot());
                } else {
                    file = null;
                }
                return file;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource$LOCAL_SDK_DIR;", "Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource;", "getSdkPathProperty", "Ljava/io/File;", "sourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "gradle-core"})
        static final class LOCAL_SDK_DIR
        extends SdkLocationSource {
            /*
             * WARNING - void declaration
             */
            LOCAL_SDK_DIR() {
                void var1_1;
            }

            @Override
            @Nullable
            public File getSdkPathProperty(@NotNull SdkLocationSourceSet sourceSet) {
                File file;
                Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
                String string = sourceSet.getLocalProperties$gradle_core().getProperty("sdk.dir");
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    file = this.validateSdkPath(it, sourceSet.getProjectRoot());
                } else {
                    file = null;
                }
                return file;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource$TEST_SDK_DIRECTORY;", "Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource;", "getSdkPathProperty", "Ljava/io/File;", "sourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "gradle-core"})
        static final class TEST_SDK_DIRECTORY
        extends SdkLocationSource {
            /*
             * WARNING - void declaration
             */
            TEST_SDK_DIRECTORY() {
                void var1_1;
            }

            @Override
            @Nullable
            public File getSdkPathProperty(@NotNull SdkLocationSourceSet sourceSet) {
                File file;
                Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
                Object object = SdkLocator.getSdkTestDirectory();
                if (object != null && (object = ((File)object).getAbsolutePath()) != null) {
                    Object it = object;
                    boolean bl = false;
                    file = this.validateSdkPath((String)it, sourceSet.getProjectRoot());
                } else {
                    file = null;
                }
                return file;
            }
        }
    }
}

