/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.VersionedCodeShrinker;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.annotations.VisibleForTesting;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"configDirRegex", "Lkotlin/text/Regex;", "configDirMatchesVersion", "", "dirName", "", "versionedShrinker", "Lcom/android/build/gradle/internal/dependency/VersionedCodeShrinker;", "gradle-core"})
public final class FilterShrinkerRulesTransformKt {
    @NotNull
    private static final Regex configDirRegex = new Regex("r8(?:-from-([^:@]+?))?(?:-upto-([^:@]+?))?");

    @VisibleForTesting
    public static final boolean configDirMatchesVersion(@NotNull String dirName2, @NotNull VersionedCodeShrinker versionedShrinker) {
        Intrinsics.checkNotNullParameter((Object)dirName2, (String)"dirName");
        Intrinsics.checkNotNullParameter((Object)versionedShrinker, (String)"versionedShrinker");
        String string = dirName2;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        MatchResult matchResult = configDirRegex.matchEntire((CharSequence)string2);
        if (matchResult != null) {
            GradleVersion gradleVersion;
            GradleVersion gradleVersion2;
            MatchResult matchResult2 = matchResult;
            boolean bl = false;
            MatchResult.Destructured destructured = matchResult2.getDestructured();
            String from = (String)destructured.getMatch().getGroupValues().get(1);
            String upto = (String)destructured.getMatch().getGroupValues().get(2);
            if (((CharSequence)from).length() == 0 && ((CharSequence)upto).length() == 0) {
                return true;
            }
            GradleVersion gradleVersion3 = gradleVersion2 = GradleVersion.tryParse((String)versionedShrinker.getVersion());
            if (gradleVersion3 == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion3, (String)"GradleVersion.tryParse(v\u2026.version) ?: return false");
            GradleVersion shrinkerCoord = gradleVersion2;
            if (((CharSequence)from).length() > 0) {
                GradleVersion gradleVersion4 = gradleVersion = GradleVersion.tryParse((String)from);
                if (gradleVersion4 == null) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)gradleVersion4, (String)"GradleVersion.tryParse(from) ?: return false");
                GradleVersion minCoord = gradleVersion;
                if (minCoord.compareTo(shrinkerCoord) > 0) {
                    return false;
                }
            }
            if (((CharSequence)upto).length() > 0) {
                GradleVersion gradleVersion5 = gradleVersion = GradleVersion.tryParse((String)upto);
                if (gradleVersion5 == null) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)gradleVersion5, (String)"GradleVersion.tryParse(upto) ?: return false");
                GradleVersion maxCoord = gradleVersion;
                if (maxCoord.compareTo(shrinkerCoord) <= 0) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

