/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.TaskProfilingRecord;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.time.Duration;
import java.time.Instant;

public class Blocks {
    public static <E extends Exception> void recordSpan(String taskPath, GradleBuildProfileSpan.ExecutionType type, AnalyticsService analyticsService, ThrowingBlock<E> block2) throws E {
        Instant before = TaskProfilingRecord.Companion.getClock().instant();
        block2.invoke();
        Instant after = TaskProfilingRecord.Companion.getClock().instant();
        if (analyticsService != null) {
            analyticsService.registerSpan(taskPath, GradleBuildProfileSpan.newBuilder().setType(type).setThreadId(Thread.currentThread().getId()).setStartTimeInMs(before.toEpochMilli()).setDurationInMs(Duration.between(before, after).toMillis()));
        }
    }

    @FunctionalInterface
    public static interface ThrowingBlock<E extends Exception> {
        public void invoke() throws E;
    }
}

