/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.variant.impl.BuiltArtifactImpl;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.ExtractPrivacySandboxCompatApks;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.APK_PACKAGING)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u0016\u0010\u0019\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR\u0014\u0010\u0013\u001a\u00020\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractPrivacySandboxCompatApks;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "apksFromBundleIdeModel", "Lorg/gradle/api/file/RegularFileProperty;", "getApksFromBundleIdeModel", "()Lorg/gradle/api/file/RegularFileProperty;", "applicationId", "Lorg/gradle/api/provider/Property;", "", "getApplicationId", "()Lorg/gradle/api/provider/Property;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "privacySandboxEnabled", "", "getPrivacySandboxEnabled", "privacySandboxSplitCompatApks", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getPrivacySandboxSplitCompatApks", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "doTaskAction", "", "writeMetadata", "elementList", "", "Lcom/android/build/api/variant/impl/BuiltArtifactImpl;", "CreationAction", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nExtractPrivacySandboxCompatApks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractPrivacySandboxCompatApks.kt\ncom/android/build/gradle/internal/tasks/ExtractPrivacySandboxCompatApks\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,147:1\n1855#2:148\n1856#2:151\n32#3,2:149\n*S KotlinDebug\n*F\n+ 1 ExtractPrivacySandboxCompatApks.kt\ncom/android/build/gradle/internal/tasks/ExtractPrivacySandboxCompatApks\n*L\n82#1:148\n82#1:151\n88#1:149,2\n*E\n"})
public abstract class ExtractPrivacySandboxCompatApks
extends NonIncrementalTask {
    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getPrivacySandboxSplitCompatApks();

    @Input
    @NotNull
    public abstract Property<Boolean> getPrivacySandboxEnabled();

    @Input
    @NotNull
    public abstract Property<String> getApplicationId();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getApksFromBundleIdeModel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doTaskAction() {
        if (!((Boolean)this.getPrivacySandboxEnabled().get()).booleanValue()) {
            throw new IllegalStateException("Unable to execute task as Privacy Sandbox support is not enabled. \nTo enable support, add\n    " + BooleanOption.PRIVACY_SANDBOX_SDK_SUPPORT.getPropertyName() + "=true\nto your project's gradle.properties file.");
        }
        List elements = new ArrayList();
        Set set = this.getPrivacySandboxSplitCompatApks().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"privacySandboxSplitCompatApks.files");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File zippedApks = (File)element$iv;
            boolean bl = false;
            Closeable closeable = new ZipFile(zippedApks);
            Throwable throwable = null;
            try {
                Iterator<? extends ZipEntry> $this$forEach$iv2;
                ZipFile apks = (ZipFile)closeable;
                boolean bl2 = false;
                if (apks.getEntry("toc.pb") != null) {
                    throw new IllegalStateException("Apks " + zippedApks.getAbsolutePath() + " must not contain a toc.pb file.");
                }
                Intrinsics.checkNotNullExpressionValue(apks.entries().asIterator(), (String)"apks.entries().asIterator()");
                boolean $i$f$forEach2 = false;
                Iterator<? extends ZipEntry> iterator2 = $this$forEach$iv2;
                while (iterator2.hasNext()) {
                    ZipEntry element$iv2;
                    ZipEntry it = element$iv2 = iterator2.next();
                    boolean bl3 = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)".apk", (boolean)false, (int)2, null)) continue;
                    InputStream inputStream = apks.getInputStream(it);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"apks.getInputStream(it)");
                    byte[] apkBytes = ByteStreamsKt.readBytes((InputStream)inputStream);
                    File outputApkFile = new File(((Directory)this.getOutputDir().get()).getAsFile(), it.getName());
                    FileUtils.createFile((File)outputApkFile, (String)"");
                    FilesKt.writeBytes((File)outputApkFile, (byte[])apkBytes);
                    String string2 = outputApkFile.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"outputApkFile.absolutePath");
                    elements.add(BuiltArtifactImpl.Companion.make$default(BuiltArtifactImpl.Companion, string2, null, null, null, null, 30, null));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        this.writeMetadata(elements);
    }

    private final void writeMetadata(List<BuiltArtifactImpl> elementList) {
        Artifact artifact = (Artifact)InternalArtifactType.EXTRACTED_SDK_APKS.INSTANCE;
        Object object = this.getApplicationId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"applicationId.get()");
        BuiltArtifactsImpl builtArtifactsImpl = new BuiltArtifactsImpl(0, artifact, (String)object, "", elementList, null, 33, null);
        File file = ((RegularFile)this.getOutputDir().file("output-metadata.json").get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputDir.file(BuiltArti\u2026A_FILE_NAME).get().asFile");
        builtArtifactsImpl.saveToFile(file);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractPrivacySandboxCompatApks$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ExtractPrivacySandboxCompatApks;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationAction", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ExtractPrivacySandboxCompatApks, ApkCreationConfig> {
        public CreationAction(@NotNull ApkCreationConfig creationAction) {
            Intrinsics.checkNotNullParameter((Object)creationAction, (String)"creationAction");
            super((ComponentCreationConfig)creationAction);
        }

        @Override
        @NotNull
        public String getName() {
            return VariantTaskCreationAction.computeTaskName$default(this, "extractApksFromSdkSplitsFor", null, 2, null);
        }

        @Override
        @NotNull
        public Class<ExtractPrivacySandboxCompatApks> getType() {
            return ExtractPrivacySandboxCompatApks.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ExtractPrivacySandboxCompatApks> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).on(InternalArtifactType.EXTRACTED_SDK_APKS.INSTANCE);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.2.INSTANCE).withName("output-metadata.json").on(InternalArtifactType.APK_FROM_SDKS_IDE_MODEL.INSTANCE);
        }

        @Override
        public void configure(@NotNull ExtractPrivacySandboxCompatApks task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            Object[] objectArray = new Object[]{((ApkCreationConfig)this.creationConfig).getArtifacts().get(InternalArtifactType.SDK_SPLITS_APKS.INSTANCE).map((Transformer)configure.1.INSTANCE)};
            task.getPrivacySandboxSplitCompatApks().from(objectArray);
            HasConfigurableValuesKt.setDisallowChanges(task.getApplicationId(), ((ApkCreationConfig)this.creationConfig).getApplicationId());
            HasConfigurableValuesKt.setDisallowChanges(task.getPrivacySandboxEnabled(), ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.PRIVACY_SANDBOX_SDK_SUPPORT));
        }
    }
}

