/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.attribution;

import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.buildanalyzer.common.CheckJetifierProjectResult;
import com.android.buildanalyzer.common.CheckJetifierResult;
import com.android.builder.utils.ExceptionFunction;
import com.android.builder.utils.SynchronizedFile;
import com.android.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\b\u0010\u000b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/attribution/CheckJetifierBuildService;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/attribution/CheckJetifierBuildService$Parameters;", "Ljava/lang/AutoCloseable;", "()V", "projectResults", "", "Lcom/android/buildanalyzer/common/CheckJetifierProjectResult;", "addResult", "", "result", "close", "writeResult", "Lcom/android/buildanalyzer/common/CheckJetifierResult;", "resultFile", "Ljava/io/File;", "Parameters", "RegistrationAction", "gradle-core"})
public abstract class CheckJetifierBuildService
implements BuildService<Parameters>,
AutoCloseable {
    @NotNull
    private final List<CheckJetifierProjectResult> projectResults = new ArrayList();

    public final synchronized void addResult(@NotNull CheckJetifierProjectResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (((Parameters)this.getParameters()).getResultFile().isPresent()) {
            this.projectResults.add(result2);
        }
    }

    @Override
    public void close() {
        block1: {
            RegularFile regularFile = (RegularFile)((Parameters)this.getParameters()).getResultFile().getOrNull();
            if (regularFile == null) break block1;
            RegularFile it = regularFile;
            boolean bl = false;
            if (!((Collection)this.projectResults).isEmpty()) {
                CheckJetifierResult aggregatedResult = CheckJetifierResult.Companion.aggregateProjectResults(this.projectResults);
                File file = it.getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it.asFile");
                this.writeResult(aggregatedResult, file);
            }
        }
    }

    private final void writeResult(CheckJetifierResult result2, File resultFile) {
        SynchronizedFile.getInstanceWithSingleProcessLocking((File)resultFile).write(new ExceptionFunction(result2, resultFile){
            final /* synthetic */ CheckJetifierResult $result;
            final /* synthetic */ File $resultFile;
            {
                this.$result = $result;
                this.$resultFile = $resultFile;
            }

            public final void accept(File it) {
                if (it.exists()) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    CheckJetifierResult existingResult = CheckJetifierResult.Companion.load(it);
                    CheckJetifierResult combinedResult = CheckJetifierResult.Companion.aggregateResults(existingResult, this.$result);
                    CheckJetifierResult.Companion.save(combinedResult, it);
                } else {
                    FileUtils.mkdirs((File)this.$resultFile.getParentFile());
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    CheckJetifierResult.Companion.save(this.$result, it);
                }
            }
        });
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/attribution/CheckJetifierBuildService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "resultFile", "Lorg/gradle/api/file/RegularFileProperty;", "getResultFile", "()Lorg/gradle/api/file/RegularFileProperty;", "gradle-core"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public RegularFileProperty getResultFile();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/attribution/CheckJetifierBuildService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/attribution/CheckJetifierBuildService;", "Lcom/android/build/gradle/internal/attribution/CheckJetifierBuildService$Parameters;", "project", "Lorg/gradle/api/Project;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/options/ProjectOptions;)V", "configure", "", "parameters", "execute", "Lorg/gradle/api/provider/Provider;", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nCheckJetifierBuildService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckJetifierBuildService.kt\ncom/android/build/gradle/internal/attribution/CheckJetifierBuildService$RegistrationAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<CheckJetifierBuildService, Parameters> {
        @NotNull
        private final ProjectOptions projectOptions;

        public RegistrationAction(@NotNull Project project, @NotNull ProjectOptions projectOptions) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
            super(project, CheckJetifierBuildService.class, null, null, 12, null);
            this.projectOptions = projectOptions;
        }

        @Override
        @NotNull
        public Provider<CheckJetifierBuildService> execute() {
            String resultFilePath = this.projectOptions.get(StringOption.IDE_CHECK_JETIFIER_RESULT_FILE);
            if (resultFilePath != null) {
                File resultFile = new File(resultFilePath);
                if (!resultFile.isAbsolute()) {
                    boolean bl = false;
                    String string = StringOption.IDE_CHECK_JETIFIER_RESULT_FILE.getPropertyName() + " must be an absolute path. Current value is: " + resultFilePath;
                    throw new IllegalStateException(string.toString());
                }
                FileUtils.deleteIfExists((File)resultFile);
            }
            return super.execute();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void configure(@NotNull Parameters parameters) {
            File file;
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            RegularFileProperty regularFileProperty = parameters.getResultFile();
            String string = this.projectOptions.get(StringOption.IDE_CHECK_JETIFIER_RESULT_FILE);
            if (string != null) {
                void it;
                String string2 = string;
                RegularFileProperty regularFileProperty2 = regularFileProperty;
                boolean bl = false;
                file = new File((String)it);
                regularFileProperty = regularFileProperty2;
            } else {
                file = null;
            }
            regularFileProperty.fileValue(file);
        }
    }
}

