/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.cxx.configure.NinjaMetadataGenerator;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughRecordingLoggingEnvironment;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.ninja.AdaptNinjaToCxxBuildKt;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessCommand;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessKt;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessResult;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessType;
import com.android.build.gradle.internal.cxx.settings.Macro;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.tasks.Internal;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\bH\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/NinjaMetadataGenerator;", "Lcom/android/build/gradle/tasks/ExternalNativeJsonGenerator;", "abi", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "variantBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "(Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;)V", "configureScript", "Ljava/io/File;", "getConfigureScript", "()Ljava/io/File;", "variant", "Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "getVariant", "()Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "getVariantBuilder", "()Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "checkPrefabConfig", "", "executeProcess", "ops", "Lorg/gradle/process/ExecOperations;", "getProcessBuilder", "Lcom/android/build/gradle/internal/cxx/process/ExecuteProcessCommand;", "reportErrors", "file", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nNinjaMetadataGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NinjaMetadataGenerator.kt\ncom/android/build/gradle/internal/cxx/configure/NinjaMetadataGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1747#2,3:164\n*S KotlinDebug\n*F\n+ 1 NinjaMetadataGenerator.kt\ncom/android/build/gradle/internal/cxx/configure/NinjaMetadataGenerator\n*L\n67#1:164,3\n*E\n"})
public final class NinjaMetadataGenerator
extends ExternalNativeJsonGenerator {
    @Nullable
    private final GradleBuildVariant.Builder variantBuilder;
    @NotNull
    private final File configureScript;
    @NotNull
    private final CxxVariantModel variant;

    public NinjaMetadataGenerator(@NotNull CxxAbiModel abi, @Nullable GradleBuildVariant.Builder variantBuilder) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        super(abi, variantBuilder);
        this.variantBuilder = variantBuilder;
        File file = abi.getVariant().getModule().getConfigureScript();
        Intrinsics.checkNotNull((Object)file);
        this.configureScript = file;
        this.variant = abi.getVariant();
        GradleBuildVariant.Builder builder = this.getVariantBuilder();
        if (builder != null) {
            builder.setNativeBuildSystemType(GradleNativeAndroidModule.NativeBuildSystemType.NINJA);
        }
    }

    @Override
    @Internal
    @Nullable
    public GradleBuildVariant.Builder getVariantBuilder() {
        return this.variantBuilder;
    }

    @NotNull
    public final File getConfigureScript() {
        return this.configureScript;
    }

    @NotNull
    public final CxxVariantModel getVariant() {
        return this.variant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeProcess(@NotNull ExecOperations ops2, @NotNull CxxAbiModel abi) {
        Unit unit;
        boolean bl;
        Object $this$any$iv;
        block13: {
            Intrinsics.checkNotNullParameter((Object)ops2, (String)"ops");
            Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
            $this$any$iv = abi.getConfigurationArguments();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                unit = $this$any$iv.iterator();
                while (unit.hasNext()) {
                    Object element$iv = unit.next();
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)CxxAbiModelKt.getName(abi), (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (!bl) {
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NINJA_CONFIGURE_INVALID_ARGUMENTS, "android." + this.variant + ".externalNativeBuild.ninja.arguments must be specified and at least one argument must reference " + Macro.NDK_ABI.getRef() + " [" + CxxAbiModelKt.getName(abi) + "] args:[" + CollectionsKt.joinToString$default((Iterable)abi.getConfigurationArguments(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "]", new Object[0]);
            return;
        }
        CxxAbiModelKt.getNinjaBuildFile(abi).delete();
        CxxAbiModelKt.getNinjaBuildLocationFile(abi).delete();
        CxxAbiModelKt.getAdditionalProjectFilesIndexFile(abi).delete();
        CxxAbiModelKt.getSymbolFolderIndexFile(abi).delete();
        CxxAbiModelKt.getBuildFileIndexFile(abi).delete();
        CxxAbiModelKt.getCompileCommandsJsonFile(abi).delete();
        CxxAbiModelKt.getCompileCommandsJsonBinFile(abi).delete();
        $this$any$iv = new PassThroughRecordingLoggingEnvironment();
        Throwable throwable = null;
        try {
            PassThroughRecordingLoggingEnvironment logger = (PassThroughRecordingLoggingEnvironment)$this$any$iv;
            boolean bl3 = false;
            ExecuteProcessResult result2 = ExecuteProcessKt.executeProcess$default(abi, ExecuteProcessType.CONFIGURE_PROCESS, this.getProcessBuilder(abi), ops2, null, (Function1)new Function1<File, Unit>((Object)this){

                public final void invoke(@NotNull File p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    NinjaMetadataGenerator.access$reportErrors((NinjaMetadataGenerator)this.receiver, p0);
                }
            }, (Function1)new Function1<File, Unit>((Object)this){

                public final void invoke(@NotNull File p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    NinjaMetadataGenerator.access$reportErrors((NinjaMetadataGenerator)this.receiver, p0);
                }
            }, 8, null);
            if (!CxxAbiModelKt.getNinjaBuildFile(abi).isFile() && !CxxAbiModelKt.getNinjaBuildLocationFile(abi).isFile()) {
                if (logger.getErrors().isEmpty()) {
                    FilesKt.forEachLine$default((File)result2.getStdout(), null, (Function1)executeProcess.2.1.INSTANCE, (int)1, null);
                    FilesKt.forEachLine$default((File)result2.getStderr(), null, (Function1)executeProcess.2.2.INSTANCE, (int)1, null);
                }
                File file = abi.getVariant().getModule().getConfigureScript();
                Intrinsics.checkNotNull((Object)file);
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.BUILD_NINJA_NOT_GENERATED, "Expected Ninja configure script '" + file.getName() + " " + CollectionsKt.joinToString$default((Iterable)abi.getConfigurationArguments(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "' to generate '" + CxxAbiModelKt.getNinjaBuildFile(abi) + "' or '" + CxxAbiModelKt.getNinjaBuildLocationFile(abi), new Object[0]);
                return;
            }
            unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)$this$any$iv, (Throwable)throwable);
        }
        File file = CxxAbiModelKt.getNinjaBuildFile(abi);
        String string = CxxAbiModelKt.getName(abi);
        File file2 = CxxAbiModelKt.getNinjaBuildFile(abi).getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"abi.ninjaBuildFile.parentFile");
        NativeBuildConfigValueMini config2 = AdaptNinjaToCxxBuildKt.adaptNinjaToCxxBuild$default(file, string, file2, (Function1)new Function1<List<? extends String>, List<? extends String>>((Object)abi){

            @NotNull
            public final List<String> invoke(@NotNull List<String> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return CxxAbiModelKt.createNinjaCommand((CxxAbiModel)this.receiver, p0);
            }
        }, CxxAbiModelKt.getCompileCommandsJsonBinFile(abi), null, 0, 96, null);
        AndroidBuildGradleJsons.writeNativeBuildMiniConfigValueToJsonFile(CxxAbiModelKt.getJsonFile(abi), config2);
        if (!CxxAbiModelKt.getAdditionalProjectFilesIndexFile(abi).isFile()) {
            CxxAbiModelKt.getAdditionalProjectFilesIndexFile(abi).getParentFile().mkdirs();
            FilesKt.writeText$default((File)CxxAbiModelKt.getAdditionalProjectFilesIndexFile(abi), (String)"", null, (int)2, null);
        }
    }

    @Override
    @NotNull
    public ExecuteProcessCommand getProcessBuilder(@NotNull CxxAbiModel abi) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        return ExecuteProcessCommand.copy$default(ExecuteProcessKt.createExecuteProcessCommand(this.configureScript), null, null, null, null, null, null, null, null, null, false, false, false, true, 4095, null).addArgs(abi.getConfigurationArguments());
    }

    @Override
    protected void checkPrefabConfig() {
    }

    private final void reportErrors(File file) {
        FilesKt.forEachLine$default((File)file, null, (Function1)reportErrors.1.INSTANCE, (int)1, null);
    }

    public static final /* synthetic */ void access$reportErrors(NinjaMetadataGenerator $this, File file) {
        $this.reportErrors(file);
    }
}

