/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ScopedArtifact;
import com.android.build.api.dsl.Device;
import com.android.build.api.dsl.EmulatorControl;
import com.android.build.api.instrumentation.StaticTestData;
import com.android.build.api.variant.ScopedArtifacts;
import com.android.build.gradle.internal.AvdComponentsBuildService;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.ManagedDeviceUtilsKt;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.InstrumentedTestCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.component.features.AndroidResourcesCreationConfig;
import com.android.build.gradle.internal.component.features.BuildConfigCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.EmulatorSnapshots;
import com.android.build.gradle.internal.dsl.ManagedVirtualDevice;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.AndroidTestTask;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.ManagedDeviceInstrumentationTestTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.TestsAnalytics;
import com.android.build.gradle.internal.test.report.CompositeTestResults;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestReport;
import com.android.build.gradle.internal.testing.TestData;
import com.android.build.gradle.internal.testing.utp.EmulatorControlConfig;
import com.android.build.gradle.internal.testing.utp.EmulatorControlConfigKt;
import com.android.build.gradle.internal.testing.utp.ManagedDeviceTestRunner;
import com.android.build.gradle.internal.testing.utp.RetentionConfig;
import com.android.build.gradle.internal.testing.utp.RetentionConfigKt;
import com.android.build.gradle.internal.testing.utp.UtpDependencies;
import com.android.build.gradle.internal.testing.utp.UtpDependencyUtilsKt;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.model.TestOptions;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.TEST)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b'\u0018\u00002\u00020\u00012\u00020\u0002:\u000278B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H'J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012H'J\b\u0010-\u001a\u00020+H'J\b\u0010.\u001a\u00020\u0017H\u0016J\b\u0010/\u001a\u00020\u0005H'J\b\u00100\u001a\u00020+H'J\b\u00101\u001a\u00020+H'J\u0010\u00102\u001a\u00020)2\u0006\u00103\u001a\u00020\u0017H\u0007J\u0010\u00104\u001a\u00020)2\u0006\u00105\u001a\u00020\u0017H\u0016J\b\u00106\u001a\u00020\u0017H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R \u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0007R\u000e\u0010 \u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0015R\u0014\u0010$\u001a\u00020%8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u00069"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "Lcom/android/build/gradle/internal/tasks/AndroidTestTask;", "()V", "buddyApks", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBuddyApks", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "buildConfigClasses", "getBuildConfigClasses", "classes", "getClasses", "<set-?>", "Lorg/gradle/api/artifacts/ArtifactCollection;", "dependencies", "getDependencies", "()Lorg/gradle/api/artifacts/ArtifactCollection;", "device", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;", "getDevice", "()Lorg/gradle/api/provider/Property;", "enableEmulatorDisplay", "", "getEnableEmulatorDisplay", "installOptions", "Lorg/gradle/api/provider/ListProperty;", "", "getInstallOptions", "()Lorg/gradle/api/provider/ListProperty;", "rClasses", "getRClasses", "shouldIgnore", "testData", "Lcom/android/build/gradle/internal/testing/TestData;", "getTestData", "testRunnerFactory", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$TestRunnerFactory;", "getTestRunnerFactory", "()Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$TestRunnerFactory;", "doTaskAction", "", "getAdditionalTestOutputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getAdditionalTestOutputEnabled", "getCoverageDirectory", "getIgnoreFailures", "getPrivacySandboxSdkApksFiles", "getReportsDir", "getResultsDir", "setDisplayEmulatorOption", "value", "setIgnoreFailures", "ignore", "testsFound", "CreationAction", "TestRunnerFactory", "gradle-core"})
public abstract class ManagedDeviceInstrumentationTestTask
extends NonIncrementalTask
implements AndroidTestTask {
    private boolean shouldIgnore;
    private ArtifactCollection dependencies;

    @Nested
    @NotNull
    public abstract TestRunnerFactory getTestRunnerFactory();

    @Nested
    @NotNull
    public abstract Property<TestData> getTestData();

    @Optional
    @Input
    @NotNull
    public abstract ListProperty<String> getInstallOptions();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getBuddyApks();

    @Internal
    @VisibleForTesting
    @NotNull
    public final ArtifactCollection getDependencies() {
        ArtifactCollection artifactCollection = this.dependencies;
        if (artifactCollection != null) {
            return artifactCollection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dependencies");
        return null;
    }

    @Nested
    @NotNull
    public abstract Property<ManagedVirtualDevice> getDevice();

    @Classpath
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getClasses();

    @Classpath
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getBuildConfigClasses();

    @Classpath
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getRClasses();

    public boolean getIgnoreFailures() {
        return this.shouldIgnore;
    }

    public void setIgnoreFailures(boolean ignore) {
        this.shouldIgnore = ignore;
    }

    @Override
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getResultsDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getReportsDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getCoverageDirectory();

    @Input
    @NotNull
    public abstract Property<Boolean> getAdditionalTestOutputEnabled();

    @Optional
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getAdditionalTestOutputDir();

    @Input
    @NotNull
    public abstract Property<Boolean> getEnableEmulatorDisplay();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getPrivacySandboxSdkApksFiles();

    @Option(option="enable-display", description="Adding this option will display the emulator while testing, insteadof running the tests on a headless emulator.")
    public final void setDisplayEmulatorOption(boolean value) {
        this.getEnableEmulatorDisplay().set((Object)value);
    }

    @Override
    public void doTaskAction() {
        boolean bl;
        File additionalTestOutputDir;
        File file;
        ManagedVirtualDevice device = (ManagedVirtualDevice)this.getDevice().get();
        DeviceProviderInstrumentTestTask.checkForNonApks(this.getBuddyApks().getFiles(), doTaskAction.1.INSTANCE);
        File resultsOutDir = ((Directory)this.getResultsDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)resultsOutDir);
        File codeCoverageOutDir = ((Directory)this.getCoverageDirectory().get()).getAsFile();
        FileUtils.cleanOutputDir((File)codeCoverageOutDir);
        Object object = this.getAdditionalTestOutputEnabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getAdditionalTestOutputEnabled().get()");
        if (((Boolean)object).booleanValue()) {
            File file2;
            File it = file2 = ((Directory)this.getAdditionalTestOutputDir().get()).getAsFile();
            boolean bl2 = false;
            FileUtils.cleanOutputDir((File)it);
            file = file2;
        } else {
            file = additionalTestOutputDir = null;
        }
        if (!this.testsFound()) {
            this.getLogger().info("No tests found, nothing to do.");
            bl = true;
        } else {
            boolean runner22;
            try {
                ManagedDeviceTestRunner runner22 = this.getTestRunnerFactory().createTestRunner(this.getWorkerExecutor(), (Integer)this.getTestRunnerFactory().getTestShardsSize().getOrNull());
                Intrinsics.checkNotNullExpressionValue((Object)device, (String)"device");
                Device device2 = (Device)device;
                String string = this.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
                Intrinsics.checkNotNullExpressionValue((Object)resultsOutDir, (String)"resultsOutDir");
                Intrinsics.checkNotNullExpressionValue((Object)codeCoverageOutDir, (String)"codeCoverageOutDir");
                Object object2 = this.getProjectPath().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"projectPath.get()");
                String string2 = (String)object2;
                Object object3 = ((TestData)this.getTestData().get()).getFlavorName().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"testData.get().flavorName.get()");
                String string3 = (String)object3;
                StaticTestData staticTestData = ((TestData)this.getTestData().get()).getAsStaticData();
                Object object4 = this.getInstallOptions().getOrElse((Object)CollectionsKt.emptyList());
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"installOptions.getOrElse(listOf())");
                List list = (List)object4;
                Set set = this.getBuddyApks().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"buddyApks.files");
                Logger logger = this.getLogger();
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
                ConfigurableFileCollection configurableFileCollection = this.getPrivacySandboxSdkApksFiles();
                Set bl2 = configurableFileCollection != null ? configurableFileCollection.getFiles() : null;
                runner22 = runner22.runTests(device2, string, resultsOutDir, codeCoverageOutDir, additionalTestOutputDir, string2, string3, staticTestData, list, set, logger, bl2 == null ? SetsKt.emptySet() : bl2);
            }
            catch (Exception e) {
                ArtifactCollection artifactCollection = this.getDependencies();
                Object object5 = this.getTestRunnerFactory().getExecutionEnum().get();
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"testRunnerFactory.executionEnum.get()");
                TestOptions.Execution execution = (TestOptions.Execution)object5;
                Object object6 = this.getAnalyticsService().get();
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"analyticsService.get()");
                TestsAnalytics.recordCrashedInstrumentedTestRun(artifactCollection, execution, false, (AnalyticsService)object6);
                throw e;
            }
            bl = runner22;
        }
        boolean success2 = bl;
        File reportOutDir = ((Directory)this.getReportsDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)reportOutDir);
        TestReport report = new TestReport(ReportType.SINGLE_FLAVOR, resultsOutDir, reportOutDir);
        CompositeTestResults results = report.generateReport();
        ArtifactCollection artifactCollection = this.getDependencies();
        Object object7 = this.getTestRunnerFactory().getExecutionEnum().get();
        Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"testRunnerFactory.executionEnum.get()");
        TestOptions.Execution execution = (TestOptions.Execution)object7;
        int n = results.getTestCount();
        Object object8 = this.getAnalyticsService().get();
        Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"analyticsService.get()");
        TestsAnalytics.recordOkInstrumentedTestRun(artifactCollection, execution, false, n, (AnalyticsService)object8);
        if (!success2) {
            String reportUrl = new ConsoleRenderer().asClickableFileUrl(new File(reportOutDir, "index.html"));
            String message2 = "There were failing tests. See the report at: " + reportUrl;
            if (this.getIgnoreFailures()) {
                this.getLogger().warn(message2);
                return;
            }
            throw new GradleException(message2);
        }
    }

    private final boolean testsFound() {
        Object object = ((TestData)this.getTestData().get()).hasTests((FileCollection)this.getClasses(), (FileCollection)this.getRClasses(), (FileCollection)this.getBuildConfigClasses()).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"testData\n            .ge\u2026asses)\n            .get()");
        return (Boolean)object;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001BG\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u0016\u0010\u001b\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0016R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask;", "Lcom/android/build/gradle/internal/component/InstrumentedTestCreationConfig;", "creationConfig", "device", "Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;", "testData", "Lcom/android/build/gradle/internal/test/AbstractTestDataImpl;", "testResultOutputDir", "Ljava/io/File;", "testReportOutputDir", "additionalTestOutputDir", "coverageOutputDir", "nameSuffix", "", "(Lcom/android/build/gradle/internal/component/InstrumentedTestCreationConfig;Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;Lcom/android/build/gradle/internal/test/AbstractTestDataImpl;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/lang/String;)V", "name", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nManagedDeviceInstrumentationTestTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManagedDeviceInstrumentationTestTask.kt\ncom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$CreationAction\n+ 2 buildServices.kt\ncom/android/build/gradle/internal/services/BuildServicesKt\n*L\n1#1,544:1\n78#2:545\n*S KotlinDebug\n*F\n+ 1 ManagedDeviceInstrumentationTestTask.kt\ncom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$CreationAction\n*L\n415#1:545\n*E\n"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ManagedDeviceInstrumentationTestTask, InstrumentedTestCreationConfig> {
        @NotNull
        private final ManagedVirtualDevice device;
        @NotNull
        private final AbstractTestDataImpl testData;
        @NotNull
        private final File testResultOutputDir;
        @NotNull
        private final File testReportOutputDir;
        @NotNull
        private final File additionalTestOutputDir;
        @NotNull
        private final File coverageOutputDir;
        @NotNull
        private final String name;
        @NotNull
        private final Class<ManagedDeviceInstrumentationTestTask> type;

        public CreationAction(@NotNull InstrumentedTestCreationConfig creationConfig, @NotNull ManagedVirtualDevice device, @NotNull AbstractTestDataImpl testData, @NotNull File testResultOutputDir, @NotNull File testReportOutputDir, @NotNull File additionalTestOutputDir, @NotNull File coverageOutputDir, @NotNull String nameSuffix) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            Intrinsics.checkNotNullParameter((Object)testData, (String)"testData");
            Intrinsics.checkNotNullParameter((Object)testResultOutputDir, (String)"testResultOutputDir");
            Intrinsics.checkNotNullParameter((Object)testReportOutputDir, (String)"testReportOutputDir");
            Intrinsics.checkNotNullParameter((Object)additionalTestOutputDir, (String)"additionalTestOutputDir");
            Intrinsics.checkNotNullParameter((Object)coverageOutputDir, (String)"coverageOutputDir");
            Intrinsics.checkNotNullParameter((Object)nameSuffix, (String)"nameSuffix");
            super((ComponentCreationConfig)creationConfig);
            this.device = device;
            this.testData = testData;
            this.testResultOutputDir = testResultOutputDir;
            this.testReportOutputDir = testReportOutputDir;
            this.additionalTestOutputDir = additionalTestOutputDir;
            this.coverageOutputDir = coverageOutputDir;
            this.name = this.computeTaskName(this.device.getName(), nameSuffix);
            this.type = ManagedDeviceInstrumentationTestTask.class;
        }

        public /* synthetic */ CreationAction(InstrumentedTestCreationConfig instrumentedTestCreationConfig, ManagedVirtualDevice managedVirtualDevice, AbstractTestDataImpl abstractTestDataImpl, File file, File file2, File file3, File file4, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x80) != 0) {
                string = "";
            }
            this(instrumentedTestCreationConfig, managedVirtualDevice, abstractTestDataImpl, file, file2, file3, file4, string);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<ManagedDeviceInstrumentationTestTask> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ManagedDeviceInstrumentationTestTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((InstrumentedTestCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, handleProvider.1.INSTANCE).atLocation(this.coverageOutputDir.getAbsolutePath()).on(InternalArtifactType.MANAGED_DEVICE_CODE_COVERAGE.INSTANCE);
            boolean isAdditionalAndroidTestOutputEnabled = ((InstrumentedTestCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.ENABLE_ADDITIONAL_ANDROID_TEST_OUTPUT);
            if (isAdditionalAndroidTestOutputEnabled) {
                ((InstrumentedTestCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, handleProvider.2.INSTANCE).atLocation(this.additionalTestOutputDir.getAbsolutePath()).on(InternalArtifactType.MANAGED_DEVICE_ANDROID_TEST_ADDITIONAL_OUTPUT.INSTANCE);
            }
        }

        @Override
        public void configure(@NotNull ManagedDeviceInstrumentationTestTask task) {
            Object[] objectArray;
            Object it;
            VariantCreationConfig variantCreationConfig;
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.getEnableEmulatorDisplay().convention((Object)false);
            task.getTestRunnerFactory().getEnableEmulatorDisplay().set((Provider)task.getEnableEmulatorDisplay());
            GlobalTaskCreationConfig globalConfig2 = ((InstrumentedTestCreationConfig)this.creationConfig).getGlobal();
            ProjectOptions projectOptions = ((InstrumentedTestCreationConfig)this.creationConfig).getServices().getProjectOptions();
            ComponentCreationConfig componentCreationConfig = this.creationConfig;
            AndroidTestCreationConfig androidTestCreationConfig = componentCreationConfig instanceof AndroidTestCreationConfig ? (AndroidTestCreationConfig)componentCreationConfig : null;
            VariantCreationConfig testedConfig = androidTestCreationConfig != null ? androidTestCreationConfig.getMainVariant() : null;
            Object object = testedConfig;
            if (object == null || (object = object.getName()) == null) {
                object = ((InstrumentedTestCreationConfig)this.creationConfig).getName();
            }
            Object variantName = object;
            task.setDescription("Installs and runs the test for " + (String)variantName + "  on the managed device " + this.device.getName());
            HasConfigurableValuesKt.setDisallowChanges(task.getDevice(), this.device);
            if (this.device.getApiLevel() <= 26 && !projectOptions.get(BooleanOption.GRADLE_MANAGED_DEVICE_ALLOW_OLD_API_LEVEL_DEVICES)) {
                throw new GradleException(StringsKt.trimIndent((String)("\n                    API level 26 and lower is currently not supported for Gradle Managed devices.\n                    Your current configuration requires API level " + this.device.getApiLevel() + ".\n                    While it's not recommended, you can use API levels 26 and lower by adding\n                    android.experimental.testOptions.managedDevices.allowOldApiLevelDevices=true\n                    to your gradle.properties file.\n                    ")));
            }
            BuildServiceRegistry buildServiceRegistry$iv = ((InstrumentedTestCreationConfig)this.creationConfig).getServices().getBuildServiceRegistry();
            boolean $i$f$getBuildService = false;
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getAvdComponents(), BuildServicesKt.getBuildService(buildServiceRegistry$iv, AvdComponentsBuildService.class));
            task.setGroup("verification");
            HasConfigurableValuesKt.setDisallowChanges(task.getTestData(), this.testData);
            task.getInstallOptions().set((Iterable)globalConfig2.getInstallationOptions().getInstallOptions());
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getCompileSdkVersion(), globalConfig2.getCompileSdkHashString());
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getBuildToolsRevision(), globalConfig2.getBuildToolsRevision());
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getSdkBuildService(), BuildServicesKt.getBuildService(((InstrumentedTestCreationConfig)this.creationConfig).getServices().getBuildServiceRegistry(), SdkComponentsBuildService.class));
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getTestShardsSize(), projectOptions.get(IntegerOption.MANAGED_DEVICE_SHARD_POOL_SIZE));
            TestOptions.Execution executionEnum = globalConfig2.getTestOptionExecutionEnum();
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getExecutionEnum(), executionEnum);
            if (!projectOptions.get(BooleanOption.ANDROID_TEST_USES_UNIFIED_TEST_PLATFORM)) {
                LoggerWrapper.getLogger(CreationAction.class).warning("Implicitly enabling Unified Test Platform because related features are specified in gradle test options. Please add -Pandroid.experimental.androidTest.useUnifiedTestPlatform=true to your gradle command to suppress this warning.", new Object[0]);
            }
            Project project = task.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"task.project");
            UtpDependencyUtilsKt.maybeCreateUtpConfigurations(project);
            UtpDependencies utpDependencies = task.getTestRunnerFactory().getUtpDependencies();
            ConfigurationContainer configurationContainer = task.getProject().getConfigurations();
            Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"task.project.configurations");
            UtpDependencyUtilsKt.resolveDependencies(utpDependencies, configurationContainer);
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getGetTargetIsSplitApk(), (variantCreationConfig = testedConfig) != null && (variantCreationConfig = variantCreationConfig.getComponentType()) != null ? variantCreationConfig.isDynamicFeature() : false);
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getCustomManagedDevice(), globalConfig2.getServices().getProjectOptions().get(BooleanOption.GRADLE_MANAGED_DEVICE_CUSTOM_DEVICE));
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getEmulatorGpuFlag(), ManagedDeviceUtilsKt.computeManagedDeviceEmulatorMode(((InstrumentedTestCreationConfig)this.creationConfig).getServices().getProjectOptions()));
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getShowEmulatorKernelLoggingFlag(), ((InstrumentedTestCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.GRADLE_MANAGED_DEVICE_EMULATOR_SHOW_KERNEL_LOGGING));
            boolean infoLoggingEnabled = Logging.getLogger(ManagedDeviceInstrumentationTestTask.class).isInfoEnabled();
            task.getTestRunnerFactory().getUtpLoggingLevel().set((Object)(infoLoggingEnabled ? Level.INFO : Level.OFF));
            Property<EmulatorControlConfig> property = task.getTestRunnerFactory().getEmulatorControlConfig();
            EmulatorControl emulatorControl = globalConfig2.getAndroidTestOptions().getEmulatorControl();
            Intrinsics.checkNotNull((Object)emulatorControl, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.dsl.EmulatorControl");
            HasConfigurableValuesKt.setDisallowChanges(property, EmulatorControlConfigKt.createEmulatorControlConfig(projectOptions, (com.android.build.gradle.internal.dsl.EmulatorControl)emulatorControl));
            Property<RetentionConfig> property2 = task.getTestRunnerFactory().getRetentionConfig();
            com.android.build.api.dsl.EmulatorSnapshots emulatorSnapshots = globalConfig2.getAndroidTestOptions().getEmulatorSnapshots();
            Intrinsics.checkNotNull((Object)emulatorSnapshots, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.dsl.EmulatorSnapshots");
            HasConfigurableValuesKt.setDisallowChanges(property2, RetentionConfigKt.createRetentionConfig(projectOptions, (EmulatorSnapshots)emulatorSnapshots));
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getInstallApkTimeout(), projectOptions.get(IntegerOption.INSTALL_APK_TIMEOUT));
            task.dependencies = VariantDependencies.getArtifactCollection$default(((InstrumentedTestCreationConfig)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES_JAR, null, 8, null);
            task.getAdditionalTestOutputEnabled().set((Object)projectOptions.get(BooleanOption.ENABLE_ADDITIONAL_ANDROID_TEST_OUTPUT));
            task.getResultsDir().set(this.testResultOutputDir);
            task.getReportsDir().set(this.testReportOutputDir);
            Configuration configuration = (Configuration)task.getProject().getConfigurations().findByName("androidTestUtil");
            if (configuration != null) {
                it = configuration;
                boolean bl = false;
                objectArray = new Object[]{it};
                task.getBuddyApks().from(objectArray);
            }
            Object[] objectArray2 = new Object[]{((InstrumentedTestCreationConfig)this.creationConfig).getArtifacts().forScope(ScopedArtifacts.Scope.PROJECT).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE)};
            task.getClasses().from(objectArray2);
            task.getClasses().disallowChanges();
            BuildConfigCreationConfig buildConfigCreationConfig2 = ((InstrumentedTestCreationConfig)this.creationConfig).getBuildConfigCreationConfig();
            if (buildConfigCreationConfig2 != null) {
                it = buildConfigCreationConfig2;
                boolean bl = false;
                objectArray = new Object[]{it.getCompiledBuildConfig()};
                task.getBuildConfigClasses().from(objectArray);
            }
            task.getBuildConfigClasses().disallowChanges();
            AndroidResourcesCreationConfig androidResourcesCreationConfig2 = ((InstrumentedTestCreationConfig)this.creationConfig).getAndroidResourcesCreationConfig();
            if (androidResourcesCreationConfig2 != null) {
                it = androidResourcesCreationConfig2;
                boolean bl = false;
                objectArray = new Object[]{it.getCompiledRClasses(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH)};
                task.getRClasses().from(objectArray);
            }
            task.getRClasses().disallowChanges();
            if (((InstrumentedTestCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.PRIVACY_SANDBOX_SDK_SUPPORT) && testedConfig != null) {
                task.getPrivacySandboxSdkApksFiles().setFrom((Iterable)VariantDependencies.getArtifactFileCollection$default(testedConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_SDK_APKS, null, 8, null));
            }
            task.getPrivacySandboxSdkApksFiles().disallowChanges();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0002\u00106R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0007R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0007R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0007R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0007R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0007R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0007R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0007R\u0014\u0010*\u001a\u00020+8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0007\u00a8\u00067"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$TestRunnerFactory;", "", "()V", "avdComponents", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "getAvdComponents", "()Lorg/gradle/api/provider/Property;", "buildToolsRevision", "Lcom/android/repository/Revision;", "getBuildToolsRevision", "compileSdkVersion", "", "getCompileSdkVersion", "customManagedDevice", "", "getCustomManagedDevice", "emulatorControlConfig", "Lcom/android/build/gradle/internal/testing/utp/EmulatorControlConfig;", "getEmulatorControlConfig", "emulatorGpuFlag", "getEmulatorGpuFlag", "enableEmulatorDisplay", "getEnableEmulatorDisplay", "executionEnum", "Lcom/android/builder/model/TestOptions$Execution;", "getExecutionEnum", "getTargetIsSplitApk", "getGetTargetIsSplitApk", "installApkTimeout", "", "getInstallApkTimeout", "retentionConfig", "Lcom/android/build/gradle/internal/testing/utp/RetentionConfig;", "getRetentionConfig", "sdkBuildService", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkBuildService", "showEmulatorKernelLoggingFlag", "getShowEmulatorKernelLoggingFlag", "testShardsSize", "getTestShardsSize", "utpDependencies", "Lcom/android/build/gradle/internal/testing/utp/UtpDependencies;", "getUtpDependencies", "()Lcom/android/build/gradle/internal/testing/utp/UtpDependencies;", "utpLoggingLevel", "Ljava/util/logging/Level;", "getUtpLoggingLevel", "createTestRunner", "Lcom/android/build/gradle/internal/testing/utp/ManagedDeviceTestRunner;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "numShards", "(Lorg/gradle/workers/WorkerExecutor;Ljava/lang/Integer;)Lcom/android/build/gradle/internal/testing/utp/ManagedDeviceTestRunner;", "gradle-core"})
    public static abstract class TestRunnerFactory {
        @Input
        @NotNull
        public abstract Property<Boolean> getCustomManagedDevice();

        @Input
        @NotNull
        public abstract Property<TestOptions.Execution> getExecutionEnum();

        @Input
        @NotNull
        public abstract Property<EmulatorControlConfig> getEmulatorControlConfig();

        @Input
        @NotNull
        public abstract Property<RetentionConfig> getRetentionConfig();

        @Input
        @NotNull
        public abstract Property<String> getCompileSdkVersion();

        @Input
        @NotNull
        public abstract Property<Revision> getBuildToolsRevision();

        @Input
        @Optional
        @NotNull
        public abstract Property<Integer> getTestShardsSize();

        @Internal
        @NotNull
        public abstract Property<SdkComponentsBuildService> getSdkBuildService();

        @Internal
        @NotNull
        public abstract Property<AvdComponentsBuildService> getAvdComponents();

        @Nested
        @NotNull
        public abstract UtpDependencies getUtpDependencies();

        @Internal
        @NotNull
        public abstract Property<Level> getUtpLoggingLevel();

        @Input
        @NotNull
        public abstract Property<String> getEmulatorGpuFlag();

        @Input
        @NotNull
        public abstract Property<Boolean> getShowEmulatorKernelLoggingFlag();

        @Input
        @Optional
        @NotNull
        public abstract Property<Integer> getInstallApkTimeout();

        @Input
        @NotNull
        public abstract Property<Boolean> getEnableEmulatorDisplay();

        @Input
        @Optional
        @NotNull
        public abstract Property<Boolean> getGetTargetIsSplitApk();

        @NotNull
        public final ManagedDeviceTestRunner createTestRunner(@NotNull WorkerExecutor workerExecutor, @Nullable Integer numShards) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
            TestOptions.Execution execution = (TestOptions.Execution)this.getExecutionEnum().get();
            switch (execution == null ? -1 : WhenMappings.$EnumSwitchMapping$0[execution.ordinal()]) {
                case 1: 
                case 2: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            boolean useOrchestrator = bl;
            UtpDependencies utpDependencies = this.getUtpDependencies();
            SdkComponentsBuildService.VersionedSdkLoader versionedSdkLoader2 = ((SdkComponentsBuildService)this.getSdkBuildService().get()).sdkLoader((Provider<String>)((Provider)this.getCompileSdkVersion()), (Provider<Revision>)((Provider)this.getBuildToolsRevision()));
            Object object = this.getEmulatorControlConfig().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"emulatorControlConfig.get()");
            EmulatorControlConfig emulatorControlConfig = (EmulatorControlConfig)object;
            Object object2 = this.getRetentionConfig().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"retentionConfig.get()");
            RetentionConfig retentionConfig = (RetentionConfig)object2;
            Object object3 = this.getEmulatorGpuFlag().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"emulatorGpuFlag.get()");
            String string = (String)object3;
            Object object4 = this.getShowEmulatorKernelLoggingFlag().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"showEmulatorKernelLoggingFlag.get()");
            boolean bl2 = (Boolean)object4;
            Object object5 = this.getAvdComponents().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"avdComponents.get()");
            AvdComponentsBuildService avdComponentsBuildService = (AvdComponentsBuildService)object5;
            Integer n = (Integer)this.getInstallApkTimeout().getOrNull();
            Object object6 = this.getEnableEmulatorDisplay().get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"enableEmulatorDisplay.get()");
            boolean bl3 = (Boolean)object6;
            Object object7 = this.getUtpLoggingLevel().get();
            Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"utpLoggingLevel.get()");
            Level level = (Level)object7;
            Object object8 = this.getGetTargetIsSplitApk().getOrElse((Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"getTargetIsSplitApk.getOrElse(false)");
            return new ManagedDeviceTestRunner(workerExecutor, utpDependencies, versionedSdkLoader2, emulatorControlConfig, retentionConfig, useOrchestrator, numShards, string, bl2, avdComponentsBuildService, n, bl3, level, (Boolean)object8, null, null, 49152, null);
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TestOptions.Execution.values().length];
                try {
                    nArray[TestOptions.Execution.ANDROIDX_TEST_ORCHESTRATOR.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TestOptions.Execution.ANDROID_TEST_ORCHESTRATOR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

