/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.Image;
import com.android.build.gradle.internal.test.report.ImageTexts;
import com.android.build.gradle.internal.test.report.ScreenshotTestImages;
import com.android.build.gradle.internal.test.report.SimpleHtmlWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.reporting.ReportRenderer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0002J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/test/report/ImagePanelRenderer;", "Lorg/gradle/reporting/ReportRenderer;", "Lcom/android/build/gradle/internal/test/report/ScreenshotTestImages;", "Lcom/android/build/gradle/internal/test/report/SimpleHtmlWriter;", "isRecordGolden", "", "(Z)V", "ALT_TEXT_PREFIX", "", "getALT_TEXT_PREFIX", "()Ljava/lang/String;", "COLUMN_NAME_ACTUAL", "getCOLUMN_NAME_ACTUAL", "COLUMN_NAME_DIFF", "getCOLUMN_NAME_DIFF", "COLUMN_NAME_GOLDEN", "getCOLUMN_NAME_GOLDEN", "addColumn", "", "htmlWriter", "columnName", "getTexts", "Lcom/android/build/gradle/internal/test/report/ImageTexts;", "ssImages", "render", "renderImage", "imagePath", "text", "gradle-core"})
public final class ImagePanelRenderer
extends ReportRenderer<ScreenshotTestImages, SimpleHtmlWriter> {
    private final boolean isRecordGolden;
    @NotNull
    private final String ALT_TEXT_PREFIX;
    @NotNull
    private final String COLUMN_NAME_GOLDEN;
    @NotNull
    private final String COLUMN_NAME_ACTUAL;
    @NotNull
    private final String COLUMN_NAME_DIFF;

    public ImagePanelRenderer(boolean isRecordGolden) {
        this.isRecordGolden = isRecordGolden;
        this.ALT_TEXT_PREFIX = "Error displaying image at ";
        this.COLUMN_NAME_GOLDEN = "Golden Image";
        this.COLUMN_NAME_ACTUAL = "Actual Image";
        this.COLUMN_NAME_DIFF = "Diff Image";
    }

    @NotNull
    public final String getALT_TEXT_PREFIX() {
        return this.ALT_TEXT_PREFIX;
    }

    @NotNull
    public final String getCOLUMN_NAME_GOLDEN() {
        return this.COLUMN_NAME_GOLDEN;
    }

    @NotNull
    public final String getCOLUMN_NAME_ACTUAL() {
        return this.COLUMN_NAME_ACTUAL;
    }

    @NotNull
    public final String getCOLUMN_NAME_DIFF() {
        return this.COLUMN_NAME_DIFF;
    }

    public void render(@NotNull ScreenshotTestImages ssImages, @NotNull SimpleHtmlWriter htmlWriter) {
        Intrinsics.checkNotNullParameter((Object)ssImages, (String)"ssImages");
        Intrinsics.checkNotNullParameter((Object)htmlWriter, (String)"htmlWriter");
        htmlWriter.startElement("span").startElement("table").startElement("thead").startElement("tr");
        this.addColumn(htmlWriter, this.COLUMN_NAME_GOLDEN);
        if (!this.isRecordGolden) {
            this.addColumn(htmlWriter, this.COLUMN_NAME_ACTUAL);
            this.addColumn(htmlWriter, this.COLUMN_NAME_DIFF);
        }
        htmlWriter.endElement().endElement();
        htmlWriter.startElement("tbody").attribute("class", "grid").startElement("tr");
        ImageTexts texts = this.getTexts(ssImages);
        this.renderImage(htmlWriter, ssImages.getGolden().getPath(), texts.getGoldenText());
        if (!this.isRecordGolden) {
            Image image = ssImages.getActual();
            Intrinsics.checkNotNull((Object)image);
            this.renderImage(htmlWriter, image.getPath(), texts.getActualText());
            Image image2 = ssImages.getDiff();
            Intrinsics.checkNotNull((Object)image2);
            this.renderImage(htmlWriter, image2.getPath(), texts.getDiffText());
        }
        htmlWriter.endElement().endElement().endElement().endElement();
    }

    private final void addColumn(SimpleHtmlWriter htmlWriter, String columnName) {
        htmlWriter.startElement("th").characters(columnName).endElement();
    }

    private final void renderImage(SimpleHtmlWriter htmlWriter, String imagePath, String text) {
        if (((CharSequence)imagePath).length() > 0) {
            htmlWriter.startElement("td").startElement("img").attribute("src", imagePath).attribute("alt", text).endElement().endElement();
        } else {
            htmlWriter.startElement("td").characters(text).endElement();
        }
    }

    private final ImageTexts getTexts(ScreenshotTestImages ssImages) {
        Object goldenText = this.ALT_TEXT_PREFIX + ssImages.getGolden().getPath();
        Image image = ssImages.getActual();
        Object actualText = this.ALT_TEXT_PREFIX + (image != null ? image.getPath() : null);
        Image image2 = ssImages.getDiff();
        Object diffText = this.ALT_TEXT_PREFIX + (image2 != null ? image2.getPath() : null);
        if (((CharSequence)ssImages.getGolden().getPath()).length() == 0) {
            goldenText = ssImages.getGolden().getMessage();
        }
        if (ssImages.getActual() != null && ((CharSequence)ssImages.getActual().getPath()).length() == 0) {
            actualText = ssImages.getActual().getMessage();
        }
        if (ssImages.getDiff() != null && ((CharSequence)ssImages.getDiff().getPath()).length() == 0) {
            diffText = ssImages.getDiff().getMessage();
        }
        return new ImageTexts((String)goldenText, (String)actualText, (String)diffText);
    }
}

