/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.screenshot;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00e6\u0080\u0001\u0018\u0000 \u000b2\u00020\u0001:\u0004\u000b\f\r\u000eJ\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH&R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000f\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer;", "", "name", "", "getName", "()Ljava/lang/String;", "diff", "Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$DiffResult;", "a", "Ljava/awt/image/BufferedImage;", "b", "Companion", "DiffResult", "MSSIMMatcher", "PixelPerfect", "gradle-core"})
public interface ImageDiffer {
    public static final /* synthetic */ Companion Companion;
    @Deprecated
    public static final int MAGENTA = -65281;
    @Deprecated
    public static final int TRANSPARENT = 0xFFFFFF;
    @Deprecated
    public static final int WHITE = 0xFFFFFF;

    @NotNull
    public DiffResult diff(@NotNull BufferedImage var1, @NotNull BufferedImage var2);

    @NotNull
    default public String getName() {
        String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        if (string == null) {
            boolean bl = false;
            String string2 = "Could not determine ImageDiffer.name reflectively. Please override ImageDiffer.name.";
            throw new IllegalArgumentException(string2.toString());
        }
        return string;
    }

    static {
        Companion = com.android.build.gradle.internal.testing.screenshot.ImageDiffer$Companion.$$INSTANCE;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\u00020\nX\u0086T\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0019\u0010\f\u001a\u00020\nX\u0086T\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$Companion;", "", "()V", "CONSTANT_C1", "", "CONSTANT_C2", "CONSTANT_K1", "CONSTANT_K2", "CONSTANT_L", "MAGENTA", "Lkotlin/UInt;", "I", "TRANSPARENT", "WHITE", "", "WINDOW_SIZE", "generatePixelDiffImage", "Lkotlin/Pair;", "Ljava/awt/image/BufferedImage;", "a", "b", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nImageDiffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageDiffer.kt\ncom/android/build/gradle/internal/testing/screenshot/ImageDiffer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,386:1\n1#2:387\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        public static final int MAGENTA = -65281;
        public static final int TRANSPARENT = 0xFFFFFF;
        public static final int WHITE = 0xFFFFFF;
        private static final double CONSTANT_L = 254.0;
        private static final double CONSTANT_K1 = 1.0E-5;
        private static final double CONSTANT_K2 = 3.0E-5;
        private static final double CONSTANT_C1;
        private static final double CONSTANT_C2;
        private static final int WINDOW_SIZE = 10;

        private Companion() {
        }

        private final Pair<BufferedImage, Integer> generatePixelDiffImage(BufferedImage a, BufferedImage b) {
            if (!(a.getWidth() == b.getWidth() && a.getHeight() == b.getHeight())) {
                boolean $i$a$-check-ImageDiffer$Companion$generatePixelDiffImage$22 = false;
                String $i$a$-check-ImageDiffer$Companion$generatePixelDiffImage$22 = "Images are different sizes";
                throw new IllegalStateException($i$a$-check-ImageDiffer$Companion$generatePixelDiffImage$22.toString());
            }
            int width = a.getWidth();
            int height = b.getHeight();
            BufferedImage highlights = new BufferedImage(width, height, 2);
            int count = 0;
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int bPixel;
                    int aPixel = a.getRGB(x, y);
                    if (aPixel == (bPixel = b.getRGB(x, y)) || aPixel >>> 24 == 0 && bPixel >>> 24 == 0) {
                        highlights.setRGB(x, y, 0xFFFFFF);
                        continue;
                    }
                    ++count;
                    highlights.setRGB(x, y, -65281);
                }
            }
            return new Pair((Object)highlights, (Object)count);
        }

        static {
            $$INSTANCE = new Companion();
            CONSTANT_C1 = Math.pow(0.00254, 2.0);
            CONSTANT_C2 = Math.pow(0.00762, 2.0);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static String getName(@NotNull ImageDiffer $this) {
            return $this.getName();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\n\u000bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0001\u0002\f\r\u00a8\u0006\u000e\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$DiffResult;", "", "description", "", "getDescription", "()Ljava/lang/String;", "highlights", "Ljava/awt/image/BufferedImage;", "getHighlights", "()Ljava/awt/image/BufferedImage;", "Different", "Similar", "Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$DiffResult$Different;", "Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$DiffResult$Similar;", "gradle-core"})
    public static interface DiffResult {
        @NotNull
        public String getDescription();

        @Nullable
        public BufferedImage getHighlights();

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$DiffResult$Different;", "Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$DiffResult;", "description", "", "highlights", "Ljava/awt/image/BufferedImage;", "(Ljava/lang/String;Ljava/awt/image/BufferedImage;)V", "getDescription", "()Ljava/lang/String;", "getHighlights", "()Ljava/awt/image/BufferedImage;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "gradle-core"})
        public static final class Different
        implements DiffResult {
            @NotNull
            private final String description;
            @NotNull
            private final BufferedImage highlights;

            public Different(@NotNull String description, @NotNull BufferedImage highlights) {
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                Intrinsics.checkNotNullParameter((Object)highlights, (String)"highlights");
                this.description = description;
                this.highlights = highlights;
            }

            @Override
            @NotNull
            public String getDescription() {
                return this.description;
            }

            @Override
            @NotNull
            public BufferedImage getHighlights() {
                return this.highlights;
            }

            @NotNull
            public final String component1() {
                return this.description;
            }

            @NotNull
            public final BufferedImage component2() {
                return this.highlights;
            }

            @NotNull
            public final Different copy(@NotNull String description, @NotNull BufferedImage highlights) {
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                Intrinsics.checkNotNullParameter((Object)highlights, (String)"highlights");
                return new Different(description, highlights);
            }

            public static /* synthetic */ Different copy$default(Different different, String string, BufferedImage bufferedImage, int n, Object object) {
                if ((n & 1) != 0) {
                    string = different.description;
                }
                if ((n & 2) != 0) {
                    bufferedImage = different.highlights;
                }
                return different.copy(string, bufferedImage);
            }

            @NotNull
            public String toString() {
                return "Different(description=" + this.description + ", highlights=" + this.highlights + ")";
            }

            public int hashCode() {
                int result2 = this.description.hashCode();
                result2 = result2 * 31 + this.highlights.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Different)) {
                    return false;
                }
                Different different = (Different)other;
                if (!Intrinsics.areEqual((Object)this.description, (Object)different.description)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.highlights, (Object)different.highlights);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$DiffResult$Similar;", "Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$DiffResult;", "description", "", "highlights", "Ljava/awt/image/BufferedImage;", "(Ljava/lang/String;Ljava/awt/image/BufferedImage;)V", "getDescription", "()Ljava/lang/String;", "getHighlights", "()Ljava/awt/image/BufferedImage;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "gradle-core"})
        public static final class Similar
        implements DiffResult {
            @NotNull
            private final String description;
            @Nullable
            private final BufferedImage highlights;

            public Similar(@NotNull String description, @Nullable BufferedImage highlights) {
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                this.description = description;
                this.highlights = highlights;
            }

            public /* synthetic */ Similar(String string, BufferedImage bufferedImage, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    bufferedImage = null;
                }
                this(string, bufferedImage);
            }

            @Override
            @NotNull
            public String getDescription() {
                return this.description;
            }

            @Override
            @Nullable
            public BufferedImage getHighlights() {
                return this.highlights;
            }

            @NotNull
            public final String component1() {
                return this.description;
            }

            @Nullable
            public final BufferedImage component2() {
                return this.highlights;
            }

            @NotNull
            public final Similar copy(@NotNull String description, @Nullable BufferedImage highlights) {
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                return new Similar(description, highlights);
            }

            public static /* synthetic */ Similar copy$default(Similar similar, String string, BufferedImage bufferedImage, int n, Object object) {
                if ((n & 1) != 0) {
                    string = similar.description;
                }
                if ((n & 2) != 0) {
                    bufferedImage = similar.highlights;
                }
                return similar.copy(string, bufferedImage);
            }

            @NotNull
            public String toString() {
                return "Similar(description=" + this.description + ", highlights=" + this.highlights + ")";
            }

            public int hashCode() {
                int result2 = this.description.hashCode();
                result2 = result2 * 31 + (this.highlights == null ? 0 : this.highlights.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Similar)) {
                    return false;
                }
                Similar similar = (Similar)other;
                if (!Intrinsics.areEqual((Object)this.description, (Object)similar.description)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.highlights, (Object)similar.highlights);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ-\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0015J8\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\rH\u0002J8\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\rH\u0002JH\u0010)\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\rH\u0002J\u000e\u0010,\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ(\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0002J0\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\rH\u0002J\u000e\u00103\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\f\u00104\u001a\u00020\u0011*\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$MSSIMMatcher;", "Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer;", "imageDiffThreshold", "", "(F)V", "SSIM", "", "muX", "muY", "sigX", "sigY", "sigXY", "blue", "", "color", "calculateSSIM", "ideal", "", "given", "width", "height", "calculateSSIM$gradle_core", "offset", "stride", "computeWindowSize", "coordinateStart", "dimension", "diff", "Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$DiffResult;", "a", "Ljava/awt/image/BufferedImage;", "b", "getIntensity", "pixel", "getMeans", "", "pixels0", "pixels1", "start", "windowWidth", "windowHeight", "getVariances", "mean0", "mean1", "green", "indexFromXAndY", "x", "y", "isWindowWhite", "", "colors", "red", "toIntArray", "gradle-core"})
    public static final class MSSIMMatcher
    implements ImageDiffer {
        private float imageDiffThreshold;

        public MSSIMMatcher(float imageDiffThreshold) {
            this.imageDiffThreshold = imageDiffThreshold;
        }

        public /* synthetic */ MSSIMMatcher(float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                f = 0.0f;
            }
            this(f);
        }

        @Override
        @NotNull
        public DiffResult diff(@NotNull BufferedImage a, @NotNull BufferedImage b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int[] aIntArray = this.toIntArray(a);
            int[] bIntArray = this.toIntArray(b);
            double SSIMTotal = this.calculateSSIM$gradle_core(aIntArray, bIntArray, a.getWidth(), a.getHeight());
            float SSIMThreshold = 1.0f - this.imageDiffThreshold;
            String string = "%.3f";
            Object[] objectArray = new Object[]{Float.valueOf(SSIMThreshold)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            string = "%.3f";
            objectArray = new Object[]{SSIMTotal};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            String stats = "[MSSIM] Required SSIM: " + string2 + ", Actual SSIM: " + string3;
            Pair pixelDiff = Companion.generatePixelDiffImage(a, b);
            BufferedImage highlights = (BufferedImage)pixelDiff.getFirst();
            int numPixelsDifferent = ((Number)pixelDiff.getSecond()).intValue();
            return SSIMTotal >= (double)SSIMThreshold ? (DiffResult)(numPixelsDifferent == 0 ? new DiffResult.Similar(stats, null, 2, null) : new DiffResult.Similar(stats, highlights)) : (DiffResult)new DiffResult.Different(stats, highlights);
        }

        public final double calculateSSIM$gradle_core(@NotNull int[] ideal, @NotNull int[] given, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)ideal, (String)"ideal");
            Intrinsics.checkNotNullParameter((Object)given, (String)"given");
            return this.calculateSSIM(ideal, given, 0, width, width, height);
        }

        private final double calculateSSIM(int[] ideal, int[] given, int offset, int stride, int width, int height) {
            double SSIMTotal = 0.0;
            int windows = 0;
            for (int currentWindowY = 0; currentWindowY < height; currentWindowY += 10) {
                int windowHeight = this.computeWindowSize(currentWindowY, height);
                int currentWindowX = 0;
                while (currentWindowX < width) {
                    int windowWidth = this.computeWindowSize(currentWindowX, width);
                    int start = this.indexFromXAndY(currentWindowX, currentWindowY, stride, offset);
                    if (this.isWindowWhite(ideal, start, stride, windowWidth, windowHeight) && this.isWindowWhite(given, start, stride, windowWidth, windowHeight)) {
                        currentWindowX += 10;
                        continue;
                    }
                    ++windows;
                    double[] means = this.getMeans(ideal, given, start, stride, windowWidth, windowHeight);
                    double meanX = means[0];
                    double meanY = means[1];
                    double[] variances = this.getVariances(ideal, given, meanX, meanY, start, stride, windowWidth, windowHeight);
                    double varX = variances[0];
                    double varY = variances[1];
                    double stdBoth = variances[2];
                    double SSIM = this.SSIM(meanX, meanY, varX, varY, stdBoth);
                    SSIMTotal += SSIM;
                    currentWindowX += 10;
                }
            }
            if (windows == 0) {
                return 1.0;
            }
            return SSIMTotal / (double)windows;
        }

        private final int computeWindowSize(int coordinateStart, int dimension) {
            return coordinateStart + 10 <= dimension ? 10 : dimension - coordinateStart;
        }

        private final boolean isWindowWhite(int[] colors, int start, int stride, int windowWidth, int windowHeight) {
            for (int y = 0; y < windowHeight; ++y) {
                for (int x = 0; x < windowWidth; ++x) {
                    if (colors[this.indexFromXAndY(x, y, stride, start)] == 0xFFFFFF) continue;
                    return false;
                }
            }
            return true;
        }

        private final int indexFromXAndY(int x, int y, int stride, int offset) {
            return x + y * stride + offset;
        }

        private final double SSIM(double muX, double muY, double sigX, double sigY, double sigXY) {
            double SSIM = ((double)2 * muX * muY + com.android.build.gradle.internal.testing.screenshot.ImageDiffer$Companion.CONSTANT_C1) * ((double)2 * sigXY + com.android.build.gradle.internal.testing.screenshot.ImageDiffer$Companion.CONSTANT_C2);
            double denom = (muX * muX + muY * muY + com.android.build.gradle.internal.testing.screenshot.ImageDiffer$Companion.CONSTANT_C1) * (sigX + sigY + com.android.build.gradle.internal.testing.screenshot.ImageDiffer$Companion.CONSTANT_C2);
            return SSIM /= denom;
        }

        private final double[] getMeans(int[] pixels0, int[] pixels1, int start, int stride, int windowWidth, int windowHeight) {
            double avg0 = 0.0;
            double avg1 = 0.0;
            for (int y = 0; y < windowHeight; ++y) {
                for (int x = 0; x < windowWidth; ++x) {
                    int index = this.indexFromXAndY(x, y, stride, start);
                    avg0 += this.getIntensity(pixels0[index]);
                    avg1 += this.getIntensity(pixels1[index]);
                }
            }
            double[] dArray = new double[]{avg0 /= (double)windowWidth * (double)windowHeight, avg1 /= (double)windowWidth * (double)windowHeight};
            return dArray;
        }

        private final double[] getVariances(int[] pixels0, int[] pixels1, double mean0, double mean1, int start, int stride, int windowWidth, int windowHeight) {
            if (windowHeight == 1 && windowWidth == 1) {
                double[] dArray = new double[]{0.0, 0.0, 0.0};
                return dArray;
            }
            double var0 = 0.0;
            double var1 = 0.0;
            double varBoth = 0.0;
            for (int y = 0; y < windowHeight; ++y) {
                for (int x = 0; x < windowWidth; ++x) {
                    int index = this.indexFromXAndY(x, y, stride, start);
                    double v0 = this.getIntensity(pixels0[index]) - mean0;
                    double v1 = this.getIntensity(pixels1[index]) - mean1;
                    var0 += v0 * v0;
                    var1 += v1 * v1;
                    varBoth += v0 * v1;
                }
            }
            double denominatorWithBesselsCorrection = (double)(windowWidth * windowHeight) - 1.0;
            double[] dArray = new double[]{var0 /= denominatorWithBesselsCorrection, var1 /= denominatorWithBesselsCorrection, varBoth /= denominatorWithBesselsCorrection};
            return dArray;
        }

        private final double getIntensity(int pixel) {
            double gamma = 1.0;
            double l = 0.0;
            l += (double)0.21f * Math.pow((double)this.red(pixel) / 255.0, gamma);
            l += (double)0.72f * Math.pow((double)this.green(pixel) / 255.0, gamma);
            return l += (double)0.07f * Math.pow((double)this.blue(pixel) / 255.0, gamma);
        }

        public final int red(int color) {
            return color >> 16 & 0xFF;
        }

        public final int green(int color) {
            return color >> 8 & 0xFF;
        }

        public final int blue(int color) {
            return color & 0xFF;
        }

        private final int[] toIntArray(BufferedImage $this$toIntArray) {
            int[] bitmapArray = new int[$this$toIntArray.getWidth() * $this$toIntArray.getHeight()];
            int n = $this$toIntArray.getWidth();
            for (int x = 0; x < n; ++x) {
                int n2 = $this$toIntArray.getHeight();
                for (int y = 0; y < n2; ++y) {
                    bitmapArray[y * $this$toIntArray.getWidth() + x] = $this$toIntArray.getRGB(x, y);
                }
            }
            return bitmapArray;
        }

        public MSSIMMatcher() {
            this(0.0f, 1, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$PixelPerfect;", "Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer;", "imageDiffThreshold", "", "(F)V", "diff", "Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$DiffResult;", "a", "Ljava/awt/image/BufferedImage;", "b", "gradle-core"})
    public static final class PixelPerfect
    implements ImageDiffer {
        private float imageDiffThreshold;

        public PixelPerfect(float imageDiffThreshold) {
            this.imageDiffThreshold = imageDiffThreshold;
        }

        public /* synthetic */ PixelPerfect(float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                f = 0.0f;
            }
            this(f);
        }

        @Override
        @NotNull
        public DiffResult diff(@NotNull BufferedImage a, @NotNull BufferedImage b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Pair pixelDiff = Companion.generatePixelDiffImage(a, b);
            BufferedImage highlights = (BufferedImage)pixelDiff.getFirst();
            int numPixelsDifferent = ((Number)pixelDiff.getSecond()).intValue();
            float percentDiff = (float)numPixelsDifferent / (float)(a.getWidth() * a.getHeight());
            String description = "Pixel percentage difference: " + percentDiff + ". " + numPixelsDifferent + " of " + a.getWidth() * a.getHeight() + " pixels are different";
            return numPixelsDifferent == 0 ? (DiffResult)new DiffResult.Similar(description, null, 2, null) : (Float.compare(percentDiff, this.imageDiffThreshold) <= 0 ? (DiffResult)new DiffResult.Similar(description, highlights) : (DiffResult)new DiffResult.Different(description, highlights));
        }

        public PixelPerfect() {
            this(0.0f, 1, null);
        }
    }
}

