/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.process;

import com.android.utils.cxx.process.LineOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0012\u001a\u00020\rH\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/cxx/process/ChunkBytesToLineOutputStream;", "Ljava/io/OutputStream;", "logPrefix", "", "printer", "Lcom/android/utils/cxx/process/LineOutputStream;", "initialBufferSize", "", "(Ljava/lang/String;Lcom/android/utils/cxx/process/LineOutputStream;I)V", "buffer", "", "nextByteIndex", "close", "", "write", "b", "off", "len", "writeBufferToInfo", "writeByteToBuffer", "gradle-core"})
public final class ChunkBytesToLineOutputStream
extends OutputStream {
    @NotNull
    private final String logPrefix;
    @NotNull
    private final LineOutputStream printer;
    @NotNull
    private byte[] buffer;
    private int nextByteIndex;

    public ChunkBytesToLineOutputStream(@NotNull String logPrefix, @NotNull LineOutputStream printer, int initialBufferSize) {
        Intrinsics.checkNotNullParameter((Object)logPrefix, (String)"logPrefix");
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        this.logPrefix = logPrefix;
        this.printer = printer;
        this.buffer = new byte[initialBufferSize];
    }

    public /* synthetic */ ChunkBytesToLineOutputStream(String string, LineOutputStream lineOutputStream, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 256;
        }
        this(string, lineOutputStream, n);
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        block3: for (int i = 0; i < len; ++i) {
            byte value = b[off + i];
            switch (value) {
                case 10: 
                case 13: {
                    this.writeBufferToInfo();
                    continue block3;
                }
                default: {
                    this.writeByteToBuffer(value);
                }
            }
        }
    }

    @Override
    public void write(int b) {
        throw new RuntimeException("Intentionally not implemented. Use write(byte[], int, int) for performance");
    }

    @Override
    public void close() {
        this.writeBufferToInfo();
        this.printer.close();
    }

    private final void writeByteToBuffer(int b) {
        if (this.nextByteIndex == this.buffer.length) {
            byte[] byArray = Arrays.copyOf(this.buffer, this.buffer.length * 2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
            this.buffer = byArray;
        }
        this.buffer[this.nextByteIndex] = (byte)b;
        int n = this.nextByteIndex;
        this.nextByteIndex = n + 1;
    }

    private final void writeBufferToInfo() {
        if (this.nextByteIndex == 0) {
            return;
        }
        byte[] byArray = this.buffer;
        int n = 0;
        int n2 = this.nextByteIndex;
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"UTF-8\")");
        Charset charset2 = charset;
        String line = new String(byArray, n, n2, charset2);
        this.printer.consume(this.logPrefix + line);
        this.nextByteIndex = 0;
    }
}

