/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.Version;
import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.dsl.Lint;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.component.HostTestCreationConfig;
import com.android.build.gradle.internal.component.NestedComponentCreationConfig;
import com.android.build.gradle.internal.component.TestFixturesCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.lint.AndroidLintAnalysisTask;
import com.android.build.gradle.internal.lint.EnvironmentVariableInputs;
import com.android.build.gradle.internal.lint.KotlinMultiplatformExtensionWrapper;
import com.android.build.gradle.internal.lint.LintMode;
import com.android.build.gradle.internal.lint.LintTool;
import com.android.build.gradle.internal.lint.ProjectInputs;
import com.android.build.gradle.internal.lint.SystemPropertyInputs;
import com.android.build.gradle.internal.lint.VariantInputs;
import com.android.build.gradle.internal.lint.VariantWithTests;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.InternalMultipleArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.LintClassLoaderBuildService;
import com.android.build.gradle.internal.services.LintParallelBuildServiceKt;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.DesugarLibUtils;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.tools.lint.model.LintModelArtifactType;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.LINT)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0006\b'\u0018\u0000 V2\u00020\u0001:\u0005VWXYZB\u0005\u00a2\u0006\u0002\u0010\u0002JN\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\b\u0010E\u001a\u0004\u0018\u00010F2\b\b\u0002\u0010\u0019\u001a\u00020\u00052\b\u0010G\u001a\u0004\u0018\u00010\tJ\b\u0010H\u001a\u00020:H\u0014J\u0013\u0010I\u001a\b\u0012\u0004\u0012\u00020\t0JH\u0001\u00a2\u0006\u0002\bKJ\u0018\u0010L\u001a\u00020:2\u0006\u0010M\u001a\u00020<2\u0006\u0010N\u001a\u00020\u0005H\u0002J\b\u0010O\u001a\u00020:H\u0002J\"\u0010P\u001a\u00020:*\b\u0012\u0004\u0012\u00020\t0Q2\u0006\u0010R\u001a\u00020\t2\u0006\u0010S\u001a\u00020\tH\u0002J\u0012\u0010T\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\t0UH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0007R\u0014\u0010\u001b\u001a\u00020\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0014R\u0014\u0010!\u001a\u00020\"8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0007R\u0014\u0010'\u001a\u00020\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001eR\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0007R\u0014\u0010+\u001a\u00020,8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u0002008gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0007R\u0014\u00105\u001a\u0002068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108\u00a8\u0006["}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "android", "Lorg/gradle/api/provider/Property;", "", "getAndroid", "()Lorg/gradle/api/provider/Property;", "androidGradlePluginVersion", "", "getAndroidGradlePluginVersion", "androidSdkHome", "getAndroidSdkHome", "checkOnly", "Lorg/gradle/api/provider/ListProperty;", "getCheckOnly", "()Lorg/gradle/api/provider/ListProperty;", "desugaredMethodsFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getDesugaredMethodsFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "environmentVariableInputs", "Lcom/android/build/gradle/internal/lint/EnvironmentVariableInputs;", "getEnvironmentVariableInputs", "()Lcom/android/build/gradle/internal/lint/EnvironmentVariableInputs;", "fatalOnly", "getFatalOnly", "lintModelDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getLintModelDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "lintRuleJars", "getLintRuleJars", "lintTool", "Lcom/android/build/gradle/internal/lint/LintTool;", "getLintTool", "()Lcom/android/build/gradle/internal/lint/LintTool;", "offline", "getOffline", "partialResultsDirectory", "getPartialResultsDirectory", "printStackTrace", "getPrintStackTrace", "projectInputs", "Lcom/android/build/gradle/internal/lint/ProjectInputs;", "getProjectInputs", "()Lcom/android/build/gradle/internal/lint/ProjectInputs;", "systemPropertyInputs", "Lcom/android/build/gradle/internal/lint/SystemPropertyInputs;", "getSystemPropertyInputs", "()Lcom/android/build/gradle/internal/lint/SystemPropertyInputs;", "useK2Uast", "getUseK2Uast", "variantInputs", "Lcom/android/build/gradle/internal/lint/VariantInputs;", "getVariantInputs", "()Lcom/android/build/gradle/internal/lint/VariantInputs;", "configureForStandalone", "", "taskCreationServices", "Lcom/android/build/gradle/internal/services/TaskCreationServices;", "javaPluginExtension", "Lorg/gradle/api/plugins/JavaPluginExtension;", "kotlinExtensionWrapper", "Lcom/android/build/gradle/internal/lint/KotlinMultiplatformExtensionWrapper;", "customLintChecksConfig", "Lorg/gradle/api/file/FileCollection;", "lintOptions", "Lcom/android/build/api/dsl/Lint;", "lintModelArtifactType", "Lcom/android/tools/lint/model/LintModelArtifactType;", "jvmTargetName", "doTaskAction", "generateCommandLineArguments", "", "generateCommandLineArguments$gradle_core", "initializeGlobalInputs", "services", "isAndroid", "writeLintModelFile", "add", "", "arg", "value", "asLintPaths", "", "Companion", "LintVitalCreationAction", "PerComponentCreationAction", "SingleVariantCreationAction", "VariantCreationAction", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nAndroidLintAnalysisTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidLintAnalysisTask.kt\ncom/android/build/gradle/internal/lint/AndroidLintAnalysisTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 buildServices.kt\ncom/android/build/gradle/internal/services/BuildServicesKt\n*L\n1#1,576:1\n1#2:577\n766#3:578\n857#3,2:579\n1549#3:581\n1620#3,3:582\n78#4:585\n*S KotlinDebug\n*F\n+ 1 AndroidLintAnalysisTask.kt\ncom/android/build/gradle/internal/lint/AndroidLintAnalysisTask\n*L\n188#1:578\n188#1:579,2\n188#1:581\n188#1:582,3\n515#1:585\n*E\n"})
public abstract class AndroidLintAnalysisTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String LINT_PRINT_STACKTRACE_ENVIRONMENT_VARIABLE = "LINT_PRINT_STACKTRACE";
    @NotNull
    private static final String ANDROID_LINT_JARS_ENVIRONMENT_VARIABLE = "ANDROID_LINT_JARS";
    @NotNull
    public static final String PARTIAL_RESULTS_DIR_NAME = "out";

    @Nested
    @NotNull
    public abstract LintTool getLintTool();

    @Internal
    @NotNull
    public abstract DirectoryProperty getLintModelDirectory();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getPartialResultsDirectory();

    @Internal
    @NotNull
    public abstract Property<String> getAndroidSdkHome();

    @Input
    @NotNull
    public abstract Property<String> getAndroidGradlePluginVersion();

    @Input
    @NotNull
    public abstract Property<Boolean> getOffline();

    @Input
    @NotNull
    public abstract Property<Boolean> getAndroid();

    @Input
    @NotNull
    public abstract Property<Boolean> getFatalOnly();

    @Input
    @NotNull
    public abstract ListProperty<String> getCheckOnly();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getLintRuleJars();

    @Nested
    @NotNull
    public abstract ProjectInputs getProjectInputs();

    @Nested
    @NotNull
    public abstract VariantInputs getVariantInputs();

    @Input
    @NotNull
    public abstract Property<Boolean> getPrintStackTrace();

    @Nested
    @NotNull
    public abstract SystemPropertyInputs getSystemPropertyInputs();

    @Nested
    @NotNull
    public abstract EnvironmentVariableInputs getEnvironmentVariableInputs();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getDesugaredMethodsFiles();

    @Input
    @NotNull
    public abstract Property<Boolean> getUseK2Uast();

    @Override
    protected void doTaskAction() {
        ((LintClassLoaderBuildService)this.getLintTool().getLintClassLoaderBuildService().get()).setShouldDispose(true);
        this.writeLintModelFile();
        LintTool lintTool = this.getLintTool();
        WorkerExecutor workerExecutor = this.getWorkerExecutor();
        List<String> list = this.generateCommandLineArguments$gradle_core();
        Boolean bl = (Boolean)this.getAndroid().get();
        Boolean bl2 = (Boolean)this.getFatalOnly().get();
        LintMode lintMode = LintMode.ANALYSIS;
        boolean bl3 = this.getProjectInputs().getLintOptions().getBaseline().getOrNull() != null;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get()");
        boolean bl4 = bl;
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"get()");
        LintTool.submit$default(lintTool, workerExecutor, "com.android.tools.lint.Main", list, bl4, bl2, false, lintMode, bl3, null, 256, null);
    }

    private final void writeLintModelFile() {
        File file;
        LintModelModule module = this.getProjectInputs().convertToLintModelModule$gradle_core();
        VariantInputs variantInputs = this.getVariantInputs();
        File file2 = ((Directory)this.getPartialResultsDirectory().get()).getAsFile();
        Set set = this.getDesugaredMethodsFiles().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"desugaredMethodsFiles.files");
        LintModelVariant variant = variantInputs.toLintModel(module, file2, set);
        File it = file = ((Directory)this.getLintModelDirectory().get()).getAsFile();
        boolean bl = false;
        FileUtils.cleanOutputDir((File)it);
        File destination = file;
        Intrinsics.checkNotNullExpressionValue((Object)destination, (String)"destination");
        LintModelSerialization.writeModule$default((LintModelSerialization)LintModelSerialization.INSTANCE, (LintModelModule)module, (File)destination, (List)CollectionsKt.listOf((Object)variant), (boolean)true, null, null, (int)48, null);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final List<String> generateCommandLineArguments$gradle_core() {
        void $this$mapTo$iv$iv;
        File it;
        Iterable $this$filterTo$iv$iv;
        Object it2;
        List arguments = new ArrayList();
        ((Collection)arguments).add("--analyze-only");
        Object object = this.getFatalOnly().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fatalOnly.get()");
        if (((Boolean)object).booleanValue()) {
            ((Collection)arguments).add("--fatalOnly");
        }
        Collection collection = arguments;
        Object[] objectArray = new String[]{"--jdk-home", this.getSystemPropertyInputs().getJavaHome().get()};
        CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        String string = (String)this.getAndroidSdkHome().getOrNull();
        if (string != null) {
            it2 = string;
            boolean bl = false;
            this.add(arguments, "--sdk-home", (String)it2);
        }
        ((Collection)arguments).add("--lint-model");
        ((Collection)arguments).add(this.asLintPaths(CollectionsKt.listOf((Object)((Directory)this.getLintModelDirectory().get()).getAsFile().getAbsolutePath())));
        for (String check : (List)this.getCheckOnly().get()) {
            it2 = arguments;
            Object[] bl = new String[]{"--check", check};
            CollectionsKt.addAll((Collection)it2, (Iterable)CollectionsKt.listOf((Object[])bl));
        }
        Set set = this.getLintRuleJars().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"lintRuleJars.files");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable bl = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl2 = false;
            if (!it.isFile()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl3 = false;
            collection2.add(it.getAbsolutePath());
        }
        List rules2 = (List)destination$iv$iv;
        if (!((Collection)rules2).isEmpty()) {
            ((Collection)arguments).add("--lint-rule-jars");
            ((Collection)arguments).add(this.asLintPaths(rules2));
        }
        Object object2 = this.getPrintStackTrace().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"printStackTrace.get()");
        if (((Boolean)object2).booleanValue()) {
            ((Collection)arguments).add("--stacktrace");
        }
        CollectionsKt.addAll((Collection)arguments, (Iterable)this.getLintTool().initializeLintCacheDir());
        Object object3 = this.getUseK2Uast().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"useK2Uast.get()");
        if (((Boolean)object3).booleanValue()) {
            ((Collection)arguments).add("--XuseK2Uast");
        }
        this.add(arguments, "--client-id", "gradle");
        this.add(arguments, "--client-name", "AGP");
        String string2 = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
        this.add(arguments, "--client-version", string2);
        Object object4 = this.getOffline().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"offline.get()");
        if (((Boolean)object4).booleanValue()) {
            ((Collection)arguments).add("--offline");
        }
        List<String> list = Collections.unmodifiableList(arguments);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(arguments)");
        return list;
    }

    private final String asLintPaths(Collection<String> $this$asLintPaths) {
        return CollectionsKt.joinToString$default((Iterable)$this$asLintPaths, (CharSequence)";", null, (CharSequence)";", (int)0, null, null, (int)58, null);
    }

    private final void add(List<String> $this$add, String arg, String value) {
        $this$add.add(arg);
        $this$add.add(value);
    }

    private final void initializeGlobalInputs(TaskCreationServices services, boolean isAndroid) {
        BuildServiceRegistry buildServiceRegistry = services.getBuildServiceRegistry();
        HasConfigurableValuesKt.setDisallowChanges(this.getAndroidGradlePluginVersion(), Version.ANDROID_GRADLE_PLUGIN_VERSION);
        Provider<SdkComponentsBuildService> sdkComponentsBuildService2 = BuildServicesKt.getBuildService(buildServiceRegistry, SdkComponentsBuildService.class);
        HasConfigurableValuesKt.setDisallowChanges(this.getAndroid(), isAndroid);
        if (isAndroid) {
            this.getAndroidSdkHome().set(sdkComponentsBuildService2.flatMap((Transformer)initializeGlobalInputs.1.INSTANCE).map((Transformer)initializeGlobalInputs.2.INSTANCE));
        }
        this.getAndroidSdkHome().disallowChanges();
        HasConfigurableValuesKt.setDisallowChanges(this.getOffline(), this.getProject().getGradle().getStartParameter().isOffline());
        Provider provider2 = this.getProject().getProviders().environmentVariable(ANDROID_LINT_JARS_ENVIRONMENT_VARIABLE).orElse((Object)"").map((Transformer)initializeGlobalInputs.globalLintJarsFromEnvVariable.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"project.providers.enviro\u2026ter(String::isNotEmpty) }");
        Provider globalLintJarsFromEnvVariable2 = provider2;
        Object[] objectArray = new Object[]{globalLintJarsFromEnvVariable2};
        this.getLintRuleJars().from(objectArray);
        if (this.getProject().getGradle().getStartParameter().getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS) {
            HasConfigurableValuesKt.setDisallowChanges(this.getPrintStackTrace(), true);
        } else {
            Property<Boolean> property = this.getPrintStackTrace();
            Provider provider3 = this.getProject().getProviders().environmentVariable(LINT_PRINT_STACKTRACE_ENVIRONMENT_VARIABLE).map((Transformer)initializeGlobalInputs.3.INSTANCE).orElse(services.getProjectOptions().getProvider(BooleanOption.PRINT_LINT_STACK_TRACE));
            Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"project.providers\n      \u2026CE)\n                    )");
            HasConfigurableValuesKt.setDisallowChanges(property, provider3);
        }
        SystemPropertyInputs systemPropertyInputs = this.getSystemPropertyInputs();
        ProviderFactory providerFactory = this.getProject().getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"project.providers");
        systemPropertyInputs.initialize(providerFactory, LintMode.ANALYSIS);
        EnvironmentVariableInputs environmentVariableInputs = this.getEnvironmentVariableInputs();
        ProviderFactory providerFactory2 = this.getProject().getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory2, (String)"project.providers");
        environmentVariableInputs.initialize(providerFactory2, LintMode.ANALYSIS);
        this.usesService(LintParallelBuildServiceKt.getLintParallelBuildService(services.getBuildServiceRegistry(), services.getProjectOptions()));
    }

    public final void configureForStandalone(@NotNull TaskCreationServices taskCreationServices, @NotNull JavaPluginExtension javaPluginExtension, @Nullable KotlinMultiplatformExtensionWrapper kotlinExtensionWrapper, @NotNull FileCollection customLintChecksConfig, @NotNull Lint lintOptions2, @Nullable LintModelArtifactType lintModelArtifactType, boolean fatalOnly, @Nullable String jvmTargetName) {
        Intrinsics.checkNotNullParameter((Object)taskCreationServices, (String)"taskCreationServices");
        Intrinsics.checkNotNullParameter((Object)javaPluginExtension, (String)"javaPluginExtension");
        Intrinsics.checkNotNullParameter((Object)customLintChecksConfig, (String)"customLintChecksConfig");
        Intrinsics.checkNotNullParameter((Object)lintOptions2, (String)"lintOptions");
        this.initializeGlobalInputs(taskCreationServices, false);
        this.setVariantName("");
        BuildServiceRegistry buildServiceRegistry$iv = taskCreationServices.getBuildServiceRegistry();
        boolean $i$f$getBuildService = false;
        HasConfigurableValuesKt.setDisallowChanges(this.getAnalyticsService(), BuildServicesKt.getBuildService(buildServiceRegistry$iv, AnalyticsService.class));
        HasConfigurableValuesKt.setDisallowChanges(this.getFatalOnly(), fatalOnly);
        HasConfigurableValuesKt.setDisallowChanges(this.getCheckOnly(), (Iterable)lintOptions2.getCheckOnly());
        LintTool lintTool = this.getLintTool();
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
        lintTool.initialize(taskCreationServices, string);
        ProjectInputs projectInputs = this.getProjectInputs();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        projectInputs.initializeForStandalone$gradle_core(project, javaPluginExtension, lintOptions2, LintMode.ANALYSIS);
        VariantInputs variantInputs = this.getVariantInputs();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        variantInputs.initializeForStandalone$gradle_core(project2, javaPluginExtension, kotlinExtensionWrapper, taskCreationServices.getProjectOptions(), fatalOnly, false, LintMode.ANALYSIS, lintModelArtifactType, jvmTargetName);
        Object[] objectArray = new Object[]{customLintChecksConfig};
        HasConfigurableValuesKt.fromDisallowChanges(this.getLintRuleJars(), objectArray);
        Property property = (Property)this.getLintModelDirectory();
        Provider provider2 = this.getProject().getLayout().getBuildDirectory().dir("intermediates/" + this.getName() + "/android-lint-model");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"project.layout.buildDire\u2026ame}/android-lint-model\")");
        HasConfigurableValuesKt.setDisallowChanges(property, provider2);
        Property<Boolean> property2 = this.getUseK2Uast();
        Provider<Boolean> provider3 = taskCreationServices.getProjectOptions().getProvider(BooleanOption.LINT_USE_K2_UAST);
        Intrinsics.checkNotNullExpressionValue(provider3, (String)"taskCreationServices.pro\u2026nOption.LINT_USE_K2_UAST)");
        HasConfigurableValuesKt.setDisallowChanges(property2, provider3);
    }

    public static /* synthetic */ void configureForStandalone$default(AndroidLintAnalysisTask androidLintAnalysisTask, TaskCreationServices taskCreationServices, JavaPluginExtension javaPluginExtension, KotlinMultiplatformExtensionWrapper kotlinMultiplatformExtensionWrapper, FileCollection fileCollection2, Lint lint, LintModelArtifactType lintModelArtifactType, boolean bl, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureForStandalone");
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        androidLintAnalysisTask.configureForStandalone(taskCreationServices, javaPluginExtension, kotlinMultiplatformExtensionWrapper, fileCollection2, lint, lintModelArtifactType, bl, string);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J*\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask$Companion;", "", "()V", "ANDROID_LINT_JARS_ENVIRONMENT_VARIABLE", "", "LINT_PRINT_STACKTRACE_ENVIRONMENT_VARIABLE", "PARTIAL_RESULTS_DIR_NAME", "registerOutputArtifacts", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask;", "internalArtifactType", "Lcom/android/build/gradle/internal/scope/InternalArtifactType;", "Lorg/gradle/api/file/Directory;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "Lcom/android/build/gradle/internal/scope/InternalMultipleArtifactType;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerOutputArtifacts(@NotNull TaskProvider<AndroidLintAnalysisTask> taskProvider, @NotNull InternalArtifactType<Directory> internalArtifactType, @NotNull ArtifactsImpl artifacts2) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            Intrinsics.checkNotNullParameter(internalArtifactType, (String)"internalArtifactType");
            Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
            artifacts2.setInitialProvider(taskProvider, (Function1)registerOutputArtifacts.1.INSTANCE).withName(AndroidLintAnalysisTask.PARTIAL_RESULTS_DIR_NAME).on((Artifact.Single)internalArtifactType);
        }

        public final void registerOutputArtifacts(@NotNull TaskProvider<AndroidLintAnalysisTask> taskProvider, @NotNull InternalMultipleArtifactType<Directory> internalArtifactType, @NotNull ArtifactsImpl artifacts2) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            Intrinsics.checkNotNullParameter(internalArtifactType, (String)"internalArtifactType");
            Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
            artifacts2.use((TaskProvider)taskProvider).wiredWith((Function1)registerOutputArtifacts.2.INSTANCE).toAppendTo((Artifact.Multiple)internalArtifactType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask$LintVitalCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask$VariantCreationAction;", "variant", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;)V", "description", "", "getDescription", "()Ljava/lang/String;", "fatalOnly", "", "getFatalOnly", "()Z", "name", "getName", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask;", "gradle-core"})
    public static final class LintVitalCreationAction
    extends VariantCreationAction {
        @NotNull
        private final String name;
        private final boolean fatalOnly;
        @NotNull
        private final String description;

        public LintVitalCreationAction(@NotNull VariantCreationConfig variant) {
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            super(new VariantWithTests(variant, null, null, null));
            this.name = this.creationConfig.computeTaskName("lintVitalAnalyze");
            this.fatalOnly = true;
            this.description = "Run lint analysis with only the fatal issues enabled on the " + this.creationConfig.getName() + " variant";
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean getFatalOnly() {
            return this.fatalOnly;
        }

        @Override
        @NotNull
        public String getDescription() {
            return this.description;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AndroidLintAnalysisTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            Companion.registerOutputArtifacts(taskProvider, InternalArtifactType.LINT_VITAL_PARTIAL_RESULTS.INSTANCE, this.creationConfig.getArtifacts());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0016\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask$PerComponentCreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "fatalOnly", "", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;Z)V", "description", "", "name", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class PerComponentCreationAction
    extends VariantTaskCreationAction<AndroidLintAnalysisTask, ComponentCreationConfig> {
        private final boolean fatalOnly;
        @NotNull
        private final String name;
        @NotNull
        private final String description;

        public PerComponentCreationAction(@NotNull ComponentCreationConfig creationConfig, boolean fatalOnly) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig);
            this.fatalOnly = fatalOnly;
            this.name = this.fatalOnly ? creationConfig.computeTaskName("lintVitalAnalyze") : creationConfig.computeTaskName("lintAnalyze");
            this.description = "Run lint analysis " + (String)(this.fatalOnly ? "with only the fatal issues enabled " : "on the " + creationConfig.getName() + " component");
        }

        @Override
        @NotNull
        public Class<AndroidLintAnalysisTask> getType() {
            return AndroidLintAnalysisTask.class;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AndroidLintAnalysisTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            ComponentCreationConfig componentCreationConfig = this.creationConfig;
            InternalArtifactType artifactType = componentCreationConfig instanceof HostTestCreationConfig ? (InternalArtifactType)InternalArtifactType.UNIT_TEST_LINT_PARTIAL_RESULTS.INSTANCE : (componentCreationConfig instanceof AndroidTestCreationConfig ? (InternalArtifactType)InternalArtifactType.ANDROID_TEST_LINT_PARTIAL_RESULTS.INSTANCE : (componentCreationConfig instanceof TestFixturesCreationConfig ? (InternalArtifactType)InternalArtifactType.TEST_FIXTURES_LINT_PARTIAL_RESULTS.INSTANCE : (this.fatalOnly ? (InternalArtifactType)InternalArtifactType.LINT_VITAL_PARTIAL_RESULTS.INSTANCE : (InternalArtifactType)InternalArtifactType.LINT_PARTIAL_RESULTS.INSTANCE)));
            ComponentCreationConfig mainVariant = this.creationConfig instanceof NestedComponentCreationConfig ? (ComponentCreationConfig)((NestedComponentCreationConfig)this.creationConfig).getMainVariant() : this.creationConfig;
            Companion.registerOutputArtifacts(taskProvider, artifactType, mainVariant.getArtifacts());
        }

        @Override
        public void configure(@NotNull AndroidLintAnalysisTask task) {
            VariantCreationConfig variantCreationConfig;
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.setDescription(this.description);
            task.initializeGlobalInputs(this.creationConfig.getServices(), true);
            DirectoryProperty directoryProperty = task.getLintModelDirectory();
            VariantPathHelper variantPathHelper = this.creationConfig.getPaths();
            String string = task.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.name");
            directoryProperty.set(variantPathHelper.getIncrementalDir(string));
            if (this.creationConfig instanceof NestedComponentCreationConfig) {
                variantCreationConfig = ((NestedComponentCreationConfig)this.creationConfig).getMainVariant();
            } else {
                ComponentCreationConfig componentCreationConfig = this.creationConfig;
                Intrinsics.checkNotNull((Object)componentCreationConfig, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.component.VariantCreationConfig");
                variantCreationConfig = (VariantCreationConfig)componentCreationConfig;
            }
            VariantCreationConfig mainVariant = variantCreationConfig;
            Object[] objectArray = new Object[]{mainVariant.getGlobal().getLocalCustomLintChecks()};
            task.getLintRuleJars().from(objectArray);
            objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(mainVariant.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.LINT, null, 8, null)};
            task.getLintRuleJars().from(objectArray);
            objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(mainVariant.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.LINT, null, 8, null)};
            task.getLintRuleJars().from(objectArray);
            task.getLintRuleJars().disallowChanges();
            HasConfigurableValuesKt.setDisallowChanges(task.getFatalOnly(), this.fatalOnly);
            task.getCheckOnly().set(mainVariant.getServices().provider((Function0)new Function0<Set<String>>(this){
                final /* synthetic */ PerComponentCreationAction this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Set<String> invoke() {
                    return PerComponentCreationAction.access$getCreationConfig$p(this.this$0).getGlobal().getLintOptions().getCheckOnly();
                }
            }));
            task.getProjectInputs().initialize$gradle_core(mainVariant, LintMode.ANALYSIS);
            objectArray = this.creationConfig;
            HostTestCreationConfig hostTestCreationConfig = objectArray instanceof HostTestCreationConfig ? (HostTestCreationConfig)objectArray : null;
            objectArray = this.creationConfig;
            AndroidTestCreationConfig androidTestCreationConfig = objectArray instanceof AndroidTestCreationConfig ? (AndroidTestCreationConfig)objectArray : null;
            objectArray = this.creationConfig;
            task.getVariantInputs().initialize(mainVariant, hostTestCreationConfig, androidTestCreationConfig, objectArray instanceof TestFixturesCreationConfig ? (TestFixturesCreationConfig)objectArray : null, this.creationConfig.getServices(), mainVariant.getName(), false, false, LintMode.ANALYSIS, false, this.fatalOnly, this.creationConfig instanceof VariantCreationConfig, true);
            task.getLintTool().initialize(mainVariant.getServices(), this.getName());
            objectArray = new Object[1];
            ConsumableCreationConfig consumableCreationConfig = mainVariant instanceof ConsumableCreationConfig ? (ConsumableCreationConfig)mainVariant : null;
            objectArray[0] = DesugarLibUtils.getDesugaredMethods(mainVariant.getServices(), consumableCreationConfig != null ? consumableCreationConfig.isCoreLibraryDesugaringEnabledLintCheck() : false, mainVariant.getMinSdk(), mainVariant.getGlobal());
            task.getDesugaredMethodsFiles().from(objectArray);
            task.getDesugaredMethodsFiles().disallowChanges();
            HasConfigurableValuesKt.setDisallowChanges(task.getUseK2Uast(), mainVariant.getUseK2Uast());
        }

        public static final /* synthetic */ ComponentCreationConfig access$getCreationConfig$p(PerComponentCreationAction $this) {
            return $this.creationConfig;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask$SingleVariantCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask$VariantCreationAction;", "variant", "Lcom/android/build/gradle/internal/lint/VariantWithTests;", "(Lcom/android/build/gradle/internal/lint/VariantWithTests;)V", "description", "", "getDescription", "()Ljava/lang/String;", "fatalOnly", "", "getFatalOnly", "()Z", "name", "getName", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask;", "gradle-core"})
    public static final class SingleVariantCreationAction
    extends VariantCreationAction {
        @NotNull
        private final String name;
        private final boolean fatalOnly;
        @NotNull
        private final String description;

        public SingleVariantCreationAction(@NotNull VariantWithTests variant) {
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            super(variant);
            this.name = this.creationConfig.computeTaskName("lintAnalyze");
            this.description = "Run lint analysis on the " + this.creationConfig.getName() + " variant";
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean getFatalOnly() {
            return this.fatalOnly;
        }

        @Override
        @NotNull
        public String getDescription() {
            return this.description;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AndroidLintAnalysisTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            Companion.registerOutputArtifacts(taskProvider, InternalArtifactType.LINT_PARTIAL_RESULTS.INSTANCE, this.creationConfig.getArtifacts());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask$VariantCreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintAnalysisTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "variant", "Lcom/android/build/gradle/internal/lint/VariantWithTests;", "(Lcom/android/build/gradle/internal/lint/VariantWithTests;)V", "description", "", "getDescription", "()Ljava/lang/String;", "fatalOnly", "", "getFatalOnly", "()Z", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "getVariant", "()Lcom/android/build/gradle/internal/lint/VariantWithTests;", "configure", "", "task", "gradle-core"})
    public static abstract class VariantCreationAction
    extends VariantTaskCreationAction<AndroidLintAnalysisTask, ComponentCreationConfig> {
        @NotNull
        private final VariantWithTests variant;

        public VariantCreationAction(@NotNull VariantWithTests variant) {
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            super((ComponentCreationConfig)variant.getMain());
            this.variant = variant;
        }

        @NotNull
        public final VariantWithTests getVariant() {
            return this.variant;
        }

        @Override
        @NotNull
        public final Class<AndroidLintAnalysisTask> getType() {
            return AndroidLintAnalysisTask.class;
        }

        public abstract boolean getFatalOnly();

        @NotNull
        public abstract String getDescription();

        @Override
        public final void configure(@NotNull AndroidLintAnalysisTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.setDescription(this.getDescription());
            task.initializeGlobalInputs(this.variant.getMain().getServices(), true);
            DirectoryProperty directoryProperty = task.getLintModelDirectory();
            VariantPathHelper variantPathHelper = this.variant.getMain().getPaths();
            String string = task.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.name");
            directoryProperty.set(variantPathHelper.getIncrementalDir(string));
            Object[] objectArray = new Object[]{this.creationConfig.getGlobal().getLocalCustomLintChecks()};
            task.getLintRuleJars().from(objectArray);
            objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.LINT, null, 8, null)};
            task.getLintRuleJars().from(objectArray);
            objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.LINT, null, 8, null)};
            task.getLintRuleJars().from(objectArray);
            task.getLintRuleJars().disallowChanges();
            HasConfigurableValuesKt.setDisallowChanges(task.getFatalOnly(), this.getFatalOnly());
            task.getCheckOnly().set(this.creationConfig.getServices().provider((Function0)new Function0<Set<String>>(this){
                final /* synthetic */ VariantCreationAction this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Set<String> invoke() {
                    return VariantCreationAction.access$getCreationConfig$p(this.this$0).getGlobal().getLintOptions().getCheckOnly();
                }
            }));
            task.getProjectInputs().initialize$gradle_core(this.variant, LintMode.ANALYSIS);
            VariantInputs.initialize$default(task.getVariantInputs(), this.variant, false, false, LintMode.ANALYSIS, false, this.getFatalOnly(), 16, null);
            task.getLintTool().initialize(this.creationConfig.getServices(), this.getName());
            objectArray = new Object[1];
            ComponentCreationConfig componentCreationConfig = this.creationConfig;
            ConsumableCreationConfig consumableCreationConfig = componentCreationConfig instanceof ConsumableCreationConfig ? (ConsumableCreationConfig)componentCreationConfig : null;
            objectArray[0] = DesugarLibUtils.getDesugaredMethods(this.creationConfig.getServices(), consumableCreationConfig != null ? consumableCreationConfig.isCoreLibraryDesugaringEnabledLintCheck() : false, this.creationConfig.getMinSdk(), this.creationConfig.getGlobal());
            task.getDesugaredMethodsFiles().from(objectArray);
            task.getDesugaredMethodsFiles().disallowChanges();
            HasConfigurableValuesKt.setDisallowChanges(task.getUseK2Uast(), this.variant.getMain().getUseK2Uast());
        }

        public static final /* synthetic */ ComponentCreationConfig access$getCreationConfig$p(VariantCreationAction $this) {
            return $this.creationConfig;
        }
    }
}

