/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.api.artifact.ScopedArtifact;
import com.android.build.api.variant.ScopedArtifacts;
import com.android.build.gradle.internal.component.HostTestCreationConfig;
import com.android.build.gradle.internal.component.KmpComponentCreationConfig;
import com.android.build.gradle.internal.component.features.AndroidResourcesCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollectionsInputs;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollectionsInputsImpl;
import com.android.build.gradle.internal.lint.ArtifactInput;
import com.android.build.gradle.internal.lint.DependencyCaches;
import com.android.build.gradle.internal.lint.KotlinCompilationWrapper;
import com.android.build.gradle.internal.lint.LintMode;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.ComponentType;
import com.android.builder.core.ComponentTypeImpl;
import com.android.tools.lint.model.DefaultLintModelJavaArtifact;
import com.android.tools.lint.model.LintModelArtifactType;
import com.android.tools.lint.model.LintModelDependencies;
import com.android.tools.lint.model.LintModelJavaArtifact;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinCommonOptions;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tJ>\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tJ>\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tJ\u001d\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001f\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/lint/JavaArtifactInput;", "Lcom/android/build/gradle/internal/lint/ArtifactInput;", "()V", "initialize", "creationConfig", "Lcom/android/build/gradle/internal/component/HostTestCreationConfig;", "lintMode", "Lcom/android/build/gradle/internal/lint/LintMode;", "useModuleDependencyLintModels", "", "addBaseModuleLintModel", "warnIfProjectTreatedAsExternalDependency", "includeClassesOutputDirectories", "fatalOnly", "isPerComponentLintAnalysis", "initializeForStandalone", "project", "Lorg/gradle/api/Project;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "sourceSet", "Lorg/gradle/api/tasks/SourceSet;", "initializeForStandaloneWithKotlinMultiplatform", "kotlinCompilationWrapper", "Lcom/android/build/gradle/internal/lint/KotlinCompilationWrapper;", "toLintModel", "Lcom/android/tools/lint/model/LintModelJavaArtifact;", "dependencyCaches", "Lcom/android/build/gradle/internal/lint/DependencyCaches;", "type", "Lcom/android/tools/lint/model/LintModelArtifactType;", "toLintModel$gradle_core", "gradle-core"})
public abstract class JavaArtifactInput
extends ArtifactInput {
    @NotNull
    public final JavaArtifactInput initialize(@NotNull HostTestCreationConfig creationConfig, @NotNull LintMode lintMode, boolean useModuleDependencyLintModels, boolean addBaseModuleLintModel, boolean warnIfProjectTreatedAsExternalDependency, boolean includeClassesOutputDirectories, boolean fatalOnly, boolean isPerComponentLintAnalysis) {
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        if (includeClassesOutputDirectories) {
            Object object;
            if (creationConfig instanceof KmpComponentCreationConfig) {
                Object[] objectArray = new Object[]{creationConfig.getArtifacts().forScope(ScopedArtifacts.Scope.PROJECT).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE)};
                this.getClassesOutputDirectories().from(objectArray);
            } else {
                Object[] objectArray = new Object[]{creationConfig.getArtifacts().get(InternalArtifactType.JAVAC.INSTANCE)};
                this.getClassesOutputDirectories().from(objectArray);
            }
            if ((object = creationConfig.getOldVariantApiLegacySupport()) != null && (object = object.getVariantData()) != null) {
                Object it = object;
                boolean bl = false;
                Object[] objectArray = new Object[]{((BaseVariantData)it).getAllPreJavacGeneratedBytecode()};
                this.getClassesOutputDirectories().from(objectArray);
                objectArray = new Object[]{((BaseVariantData)it).getAllPostJavacGeneratedBytecode()};
                this.getClassesOutputDirectories().from(objectArray);
            }
            AndroidResourcesCreationConfig androidResourcesCreationConfig2 = creationConfig.getAndroidResourcesCreationConfig();
            if (androidResourcesCreationConfig2 != null) {
                AndroidResourcesCreationConfig it = androidResourcesCreationConfig2;
                boolean bl = false;
                Object[] objectArray = new Object[]{it.getCompiledRClasses(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH)};
                this.getClassesOutputDirectories().from(objectArray);
            }
        }
        this.getClassesOutputDirectories().disallowChanges();
        HasConfigurableValuesKt.setDisallowChanges(this.getWarnIfProjectTreatedAsExternalDependency(), warnIfProjectTreatedAsExternalDependency);
        this.initializeProjectDependencyLintArtifacts(useModuleDependencyLintModels, creationConfig.getVariantDependencies(), lintMode, false, fatalOnly, isPerComponentLintAnalysis);
        if (!useModuleDependencyLintModels) {
            if (addBaseModuleLintModel) {
                this.initializeBaseModuleLintModel(creationConfig.getVariantDependencies());
            }
            this.setProjectRuntimeExplodedAars(creationConfig.getVariantDependencies().getArtifactCollectionForToolingModel(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LOCAL_EXPLODED_AAR_FOR_LINT));
            this.setProjectCompileExplodedAars(creationConfig.getVariantDependencies().getArtifactCollectionForToolingModel(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LOCAL_EXPLODED_AAR_FOR_LINT));
        }
        HasConfigurableValuesKt.setDisallowChanges(this.getArtifactCollectionsInputs(), new ArtifactCollectionsInputsImpl(creationConfig.getVariantDependencies(), creationConfig.getServices().getProjectInfo().getPath(), creationConfig.getName(), ArtifactCollectionsInputs.RuntimeType.FULL));
        return this;
    }

    @NotNull
    public final JavaArtifactInput initializeForStandalone(@NotNull Project project, @NotNull ProjectOptions projectOptions, @NotNull SourceSet sourceSet2, @NotNull LintMode lintMode, boolean useModuleDependencyLintModels, boolean includeClassesOutputDirectories, boolean fatalOnly) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
        Intrinsics.checkNotNullParameter((Object)sourceSet2, (String)"sourceSet");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        if (includeClassesOutputDirectories) {
            Object[] objectArray = new Object[]{sourceSet2.getOutput().getClassesDirs()};
            this.getClassesOutputDirectories().from(objectArray);
        }
        this.getClassesOutputDirectories().disallowChanges();
        HasConfigurableValuesKt.setDisallowChanges(this.getWarnIfProjectTreatedAsExternalDependency(), false);
        String string = sourceSet2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceSet.name");
        ComponentType componentType = (ComponentType)ComponentTypeImpl.JAVA_LIBRARY;
        Configuration configuration = project.getConfigurations().getByName(sourceSet2.getCompileClasspathConfigurationName());
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026asspathConfigurationName)");
        Configuration configuration2 = project.getConfigurations().getByName(sourceSet2.getRuntimeClasspathConfigurationName());
        Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"project.configurations.g\u2026asspathConfigurationName)");
        VariantDependencies variantDependencies2 = new VariantDependencies(string, componentType, configuration, configuration2, CollectionsKt.emptyList(), CollectionsKt.emptyList(), MapsKt.emptyMap(), project.getConfigurations().getByName(sourceSet2.getCompileOnlyConfigurationName()), project.getConfigurations().getByName(sourceSet2.getAnnotationProcessorConfigurationName()), null, null, null, project, projectOptions, false, false);
        Property<ArtifactCollectionsInputs> property = this.getArtifactCollectionsInputs();
        String string2 = project.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.path");
        String string3 = sourceSet2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sourceSet.name");
        HasConfigurableValuesKt.setDisallowChanges(property, new ArtifactCollectionsInputsImpl(variantDependencies2, string2, string3, ArtifactCollectionsInputs.RuntimeType.FULL));
        this.initializeProjectDependencyLintArtifacts(useModuleDependencyLintModels, variantDependencies2, lintMode, false, fatalOnly, projectOptions.get(BooleanOption.LINT_ANALYSIS_PER_COMPONENT));
        return this;
    }

    @NotNull
    public final JavaArtifactInput initializeForStandaloneWithKotlinMultiplatform(@NotNull Project project, @NotNull ProjectOptions projectOptions, @NotNull KotlinCompilationWrapper kotlinCompilationWrapper, @NotNull LintMode lintMode, boolean useModuleDependencyLintModels, boolean includeClassesOutputDirectories, boolean fatalOnly) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
        Intrinsics.checkNotNullParameter((Object)kotlinCompilationWrapper, (String)"kotlinCompilationWrapper");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        KotlinCompilation<KotlinCommonOptions> compilation = kotlinCompilationWrapper.getKotlinCompilation();
        if (includeClassesOutputDirectories) {
            Object[] objectArray = new Object[]{compilation.getOutput().getClassesDirs()};
            this.getClassesOutputDirectories().from(objectArray);
        }
        this.getClassesOutputDirectories().disallowChanges();
        HasConfigurableValuesKt.setDisallowChanges(this.getWarnIfProjectTreatedAsExternalDependency(), false);
        String string = compilation.getName();
        ComponentType componentType = (ComponentType)ComponentTypeImpl.JAVA_LIBRARY;
        Configuration configuration = project.getConfigurations().getByName(compilation.getCompileDependencyConfigurationName());
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026endencyConfigurationName)");
        ConfigurationContainer configurationContainer = project.getConfigurations();
        String string2 = compilation.getRuntimeDependencyConfigurationName();
        if (string2 == null) {
            string2 = compilation.getCompileDependencyConfigurationName();
        }
        Configuration configuration2 = configurationContainer.getByName(string2);
        Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"project.configurations.g\u2026endencyConfigurationName)");
        VariantDependencies variantDependencies2 = new VariantDependencies(string, componentType, configuration, configuration2, CollectionsKt.emptyList(), CollectionsKt.emptyList(), MapsKt.emptyMap(), project.getConfigurations().getByName(compilation.getCompileOnlyConfigurationName()), null, null, null, null, project, projectOptions, false, false);
        Property<ArtifactCollectionsInputs> property = this.getArtifactCollectionsInputs();
        String string3 = project.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"project.path");
        HasConfigurableValuesKt.setDisallowChanges(property, new ArtifactCollectionsInputsImpl(variantDependencies2, string3, compilation.getName(), ArtifactCollectionsInputs.RuntimeType.FULL));
        this.initializeProjectDependencyLintArtifacts(useModuleDependencyLintModels, variantDependencies2, lintMode, false, fatalOnly, projectOptions.get(BooleanOption.LINT_ANALYSIS_PER_COMPONENT));
        return this;
    }

    @NotNull
    public final LintModelJavaArtifact toLintModel$gradle_core(@NotNull DependencyCaches dependencyCaches, @NotNull LintModelArtifactType type) {
        Intrinsics.checkNotNullParameter((Object)dependencyCaches, (String)"dependencyCaches");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        LintModelDependencies lintModelDependencies = this.computeDependencies$gradle_core(dependencyCaches);
        Set set = this.getClassesOutputDirectories().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"classesOutputDirectories.files");
        return (LintModelJavaArtifact)new DefaultLintModelJavaArtifact(lintModelDependencies, CollectionsKt.toList((Iterable)set), type);
    }
}

