/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.InstrumentedTestCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.testing.screenshot.ImageDetails;
import com.android.build.gradle.internal.testing.screenshot.PreviewResult;
import com.android.build.gradle.internal.testing.screenshot.Response;
import com.android.build.gradle.internal.testing.screenshot.ResponseProcessor;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.utils.FileUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.VerificationTask;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.TEST)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001e\u0010\n\u001a\u00020\u000b8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/PreviewScreenshotUpdateTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "Lorg/gradle/api/tasks/VerificationTask;", "()V", "goldenImageDir", "Lorg/gradle/api/file/DirectoryProperty;", "getGoldenImageDir", "()Lorg/gradle/api/file/DirectoryProperty;", "renderTaskOutputDir", "getRenderTaskOutputDir", "variantName", "", "getVariantName", "()Ljava/lang/String;", "setVariantName", "(Ljava/lang/String;)V", "doTaskAction", "", "saveGoldenImage", "previewResult", "Lcom/android/build/gradle/internal/testing/screenshot/PreviewResult;", "CreationAction", "gradle-core"})
public abstract class PreviewScreenshotUpdateTask
extends NonIncrementalTask
implements VerificationTask {
    @Internal
    public String variantName;

    @Override
    @NotNull
    public String getVariantName() {
        String string = this.variantName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"variantName");
        return null;
    }

    @Override
    public void setVariantName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.variantName = string;
    }

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getGoldenImageDir();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract DirectoryProperty getRenderTaskOutputDir();

    @Override
    protected void doTaskAction() {
        Path path = ((Directory)this.getRenderTaskOutputDir().get()).getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"renderTaskOutputDir.get().asFile.toPath()");
        Response response = new ResponseProcessor(path).process();
        List resultsToSave = new ArrayList();
        for (PreviewResult previewResult : response.getPreviewResults()) {
            this.saveGoldenImage(previewResult);
        }
    }

    private final void saveGoldenImage(PreviewResult previewResult) {
        if (previewResult.getResponseCode() != 0) {
            throw new GradleException(previewResult.getMessage());
        }
        String string = previewResult.getPreviewName().substring(StringsKt.lastIndexOf$default((CharSequence)previewResult.getPreviewName(), (String)".", (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String screenshotName = string;
        String screenshotNamePng = screenshotName + ".png";
        Path goldenPath = ((File)this.getGoldenImageDir().getAsFile().get()).toPath().resolve(screenshotNamePng);
        ImageDetails goldenImageDetails = new ImageDetails(goldenPath, null);
        Path actualPath = ((File)this.getRenderTaskOutputDir().getAsFile().get()).toPath().resolve(screenshotName + "_actual.png");
        FileUtils.copyFile((File)actualPath.toFile(), (File)goldenPath.toFile());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/PreviewScreenshotUpdateTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/PreviewScreenshotUpdateTask;", "Lcom/android/build/gradle/internal/component/InstrumentedTestCreationConfig;", "androidTestCreationConfig", "Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;", "goldenImageDir", "Ljava/io/File;", "(Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;Ljava/io/File;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<PreviewScreenshotUpdateTask, InstrumentedTestCreationConfig> {
        @NotNull
        private final AndroidTestCreationConfig androidTestCreationConfig;
        @NotNull
        private final File goldenImageDir;
        @NotNull
        private final String name;
        @NotNull
        private final Class<PreviewScreenshotUpdateTask> type;

        public CreationAction(@NotNull AndroidTestCreationConfig androidTestCreationConfig, @NotNull File goldenImageDir) {
            Intrinsics.checkNotNullParameter((Object)androidTestCreationConfig, (String)"androidTestCreationConfig");
            Intrinsics.checkNotNullParameter((Object)goldenImageDir, (String)"goldenImageDir");
            super((ComponentCreationConfig)androidTestCreationConfig);
            this.androidTestCreationConfig = androidTestCreationConfig;
            this.goldenImageDir = goldenImageDir;
            this.name = VariantTaskCreationAction.computeTaskName$default(this, "previewScreenshotUpdate", null, 2, null);
            this.type = PreviewScreenshotUpdateTask.class;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<PreviewScreenshotUpdateTask> getType() {
            return this.type;
        }

        @Override
        public void configure(@NotNull PreviewScreenshotUpdateTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            ComponentCreationConfig componentCreationConfig = this.creationConfig;
            AndroidTestCreationConfig androidTestCreationConfig = componentCreationConfig instanceof AndroidTestCreationConfig ? (AndroidTestCreationConfig)componentCreationConfig : null;
            VariantCreationConfig testedConfig = androidTestCreationConfig != null ? androidTestCreationConfig.getMainVariant() : null;
            Object object = testedConfig;
            if (object == null || (object = object.getName()) == null) {
                object = ((InstrumentedTestCreationConfig)this.creationConfig).getName();
            }
            task.setVariantName((String)object);
            VariantCreationConfig testedVariant = this.androidTestCreationConfig.getMainVariant();
            task.setDescription("Update screenshots for the " + testedVariant.getName() + " build.");
            task.setGroup("verification");
            task.getGoldenImageDir().set(this.goldenImageDir);
            task.getGoldenImageDir().disallowChanges();
            ((InstrumentedTestCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.SCREENSHOTS_RENDERED.INSTANCE, (Property)task.getRenderTaskOutputDir());
        }
    }
}

