/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.screenshot;

import com.android.build.gradle.internal.testing.screenshot.ImageDiffer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u000eB\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/testing/screenshot/Verify;", "", "imageDiffer", "Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer;", "diffFilePath", "Ljava/nio/file/Path;", "(Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer;Ljava/nio/file/Path;)V", "analyze", "Lcom/android/build/gradle/internal/testing/screenshot/Verify$AnalysisResult;", "goldenPath", "actual", "Ljava/awt/image/BufferedImage;", "assertMatchGolden", "image", "AnalysisResult", "gradle-core"})
public final class Verify {
    @NotNull
    private final ImageDiffer imageDiffer;
    @NotNull
    private final Path diffFilePath;

    public Verify(@NotNull ImageDiffer imageDiffer, @NotNull Path diffFilePath) {
        Intrinsics.checkNotNullParameter((Object)imageDiffer, (String)"imageDiffer");
        Intrinsics.checkNotNullParameter((Object)diffFilePath, (String)"diffFilePath");
        this.imageDiffer = imageDiffer;
        this.diffFilePath = diffFilePath;
    }

    public /* synthetic */ Verify(ImageDiffer imageDiffer, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            imageDiffer = new ImageDiffer.PixelPerfect(0.0f, 1, null);
        }
        this(imageDiffer, path);
    }

    @NotNull
    public final AnalysisResult assertMatchGolden(@NotNull Path goldenPath, @NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)goldenPath, (String)"goldenPath");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.analyze(goldenPath, image);
    }

    private final AnalysisResult analyze(Path goldenPath, BufferedImage actual) {
        BufferedImage golden = null;
        if (goldenPath.toFile().exists()) {
            golden = ImageIO.read(goldenPath.toFile());
        }
        if (golden == null) {
            return new AnalysisResult.MissingGolden(actual, "MISSING GOLDEN");
        }
        if (actual.getWidth() != golden.getWidth() || actual.getHeight() != golden.getHeight()) {
            return new AnalysisResult.SizeMismatch(actual, "Size Mismatch. Reference image size: " + golden.getWidth() + "X" + golden.getHeight() + ". Rendered image size: " + actual.getWidth() + "X" + actual.getHeight(), golden);
        }
        ImageDiffer.DiffResult diff = this.imageDiffer.diff(actual, golden);
        if (diff.getHighlights() != null) {
            File diffFile = this.diffFilePath.toFile();
            ImageIO.write((RenderedImage)diff.getHighlights(), "png", diffFile);
        }
        if (diff instanceof ImageDiffer.DiffResult.Different) {
            return new AnalysisResult.Failed(actual, "FAILED", golden, (ImageDiffer.DiffResult.Different)diff);
        }
        Intrinsics.checkNotNull((Object)diff, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.testing.screenshot.ImageDiffer.DiffResult.Similar");
        return new AnalysisResult.Passed(actual, "PASSED", golden, (ImageDiffer.DiffResult.Similar)diff);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004\n\u000b\f\rR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0001\u0004\u000e\u000f\u0010\u0011\u00a8\u0006\u0012\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/testing/screenshot/Verify$AnalysisResult;", "", "actual", "Ljava/awt/image/BufferedImage;", "getActual", "()Ljava/awt/image/BufferedImage;", "message", "", "getMessage", "()Ljava/lang/String;", "Failed", "MissingGolden", "Passed", "SizeMismatch", "Lcom/android/build/gradle/internal/testing/screenshot/Verify$AnalysisResult$Failed;", "Lcom/android/build/gradle/internal/testing/screenshot/Verify$AnalysisResult$MissingGolden;", "Lcom/android/build/gradle/internal/testing/screenshot/Verify$AnalysisResult$Passed;", "Lcom/android/build/gradle/internal/testing/screenshot/Verify$AnalysisResult$SizeMismatch;", "gradle-core"})
    public static interface AnalysisResult {
        @NotNull
        public BufferedImage getActual();

        @NotNull
        public String getMessage();

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/internal/testing/screenshot/Verify$AnalysisResult$Failed;", "Lcom/android/build/gradle/internal/testing/screenshot/Verify$AnalysisResult;", "actual", "Ljava/awt/image/BufferedImage;", "message", "", "expected", "imageDiff", "Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$DiffResult$Different;", "(Ljava/awt/image/BufferedImage;Ljava/lang/String;Ljava/awt/image/BufferedImage;Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$DiffResult$Different;)V", "getActual", "()Ljava/awt/image/BufferedImage;", "getExpected", "getImageDiff", "()Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$DiffResult$Different;", "getMessage", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "gradle-core"})
        public static final class Failed
        implements AnalysisResult {
            @NotNull
            private final BufferedImage actual;
            @NotNull
            private final String message;
            @NotNull
            private final BufferedImage expected;
            @NotNull
            private final ImageDiffer.DiffResult.Different imageDiff;

            public Failed(@NotNull BufferedImage actual, @NotNull String message2, @NotNull BufferedImage expected, @NotNull ImageDiffer.DiffResult.Different imageDiff) {
                Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
                Intrinsics.checkNotNullParameter((Object)imageDiff, (String)"imageDiff");
                this.actual = actual;
                this.message = message2;
                this.expected = expected;
                this.imageDiff = imageDiff;
            }

            @Override
            @NotNull
            public BufferedImage getActual() {
                return this.actual;
            }

            @Override
            @NotNull
            public String getMessage() {
                return this.message;
            }

            @NotNull
            public final BufferedImage getExpected() {
                return this.expected;
            }

            @NotNull
            public final ImageDiffer.DiffResult.Different getImageDiff() {
                return this.imageDiff;
            }

            @NotNull
            public final BufferedImage component1() {
                return this.actual;
            }

            @NotNull
            public final String component2() {
                return this.message;
            }

            @NotNull
            public final BufferedImage component3() {
                return this.expected;
            }

            @NotNull
            public final ImageDiffer.DiffResult.Different component4() {
                return this.imageDiff;
            }

            @NotNull
            public final Failed copy(@NotNull BufferedImage actual, @NotNull String message2, @NotNull BufferedImage expected, @NotNull ImageDiffer.DiffResult.Different imageDiff) {
                Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
                Intrinsics.checkNotNullParameter((Object)imageDiff, (String)"imageDiff");
                return new Failed(actual, message2, expected, imageDiff);
            }

            public static /* synthetic */ Failed copy$default(Failed failed, BufferedImage bufferedImage, String string, BufferedImage bufferedImage2, ImageDiffer.DiffResult.Different different, int n, Object object) {
                if ((n & 1) != 0) {
                    bufferedImage = failed.actual;
                }
                if ((n & 2) != 0) {
                    string = failed.message;
                }
                if ((n & 4) != 0) {
                    bufferedImage2 = failed.expected;
                }
                if ((n & 8) != 0) {
                    different = failed.imageDiff;
                }
                return failed.copy(bufferedImage, string, bufferedImage2, different);
            }

            @NotNull
            public String toString() {
                return "Failed(actual=" + this.actual + ", message=" + this.message + ", expected=" + this.expected + ", imageDiff=" + this.imageDiff + ")";
            }

            public int hashCode() {
                int result2 = this.actual.hashCode();
                result2 = result2 * 31 + this.message.hashCode();
                result2 = result2 * 31 + this.expected.hashCode();
                result2 = result2 * 31 + this.imageDiff.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failed)) {
                    return false;
                }
                Failed failed = (Failed)other;
                if (!Intrinsics.areEqual((Object)this.actual, (Object)failed.actual)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.message, (Object)failed.message)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.expected, (Object)failed.expected)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.imageDiff, (Object)failed.imageDiff);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/testing/screenshot/Verify$AnalysisResult$MissingGolden;", "Lcom/android/build/gradle/internal/testing/screenshot/Verify$AnalysisResult;", "actual", "Ljava/awt/image/BufferedImage;", "message", "", "(Ljava/awt/image/BufferedImage;Ljava/lang/String;)V", "getActual", "()Ljava/awt/image/BufferedImage;", "getMessage", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "gradle-core"})
        public static final class MissingGolden
        implements AnalysisResult {
            @NotNull
            private final BufferedImage actual;
            @NotNull
            private final String message;

            public MissingGolden(@NotNull BufferedImage actual, @NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                this.actual = actual;
                this.message = message2;
            }

            @Override
            @NotNull
            public BufferedImage getActual() {
                return this.actual;
            }

            @Override
            @NotNull
            public String getMessage() {
                return this.message;
            }

            @NotNull
            public final BufferedImage component1() {
                return this.actual;
            }

            @NotNull
            public final String component2() {
                return this.message;
            }

            @NotNull
            public final MissingGolden copy(@NotNull BufferedImage actual, @NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                return new MissingGolden(actual, message2);
            }

            public static /* synthetic */ MissingGolden copy$default(MissingGolden missingGolden, BufferedImage bufferedImage, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    bufferedImage = missingGolden.actual;
                }
                if ((n & 2) != 0) {
                    string = missingGolden.message;
                }
                return missingGolden.copy(bufferedImage, string);
            }

            @NotNull
            public String toString() {
                return "MissingGolden(actual=" + this.actual + ", message=" + this.message + ")";
            }

            public int hashCode() {
                int result2 = this.actual.hashCode();
                result2 = result2 * 31 + this.message.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MissingGolden)) {
                    return false;
                }
                MissingGolden missingGolden = (MissingGolden)other;
                if (!Intrinsics.areEqual((Object)this.actual, (Object)missingGolden.actual)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.message, (Object)missingGolden.message);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/internal/testing/screenshot/Verify$AnalysisResult$Passed;", "Lcom/android/build/gradle/internal/testing/screenshot/Verify$AnalysisResult;", "actual", "Ljava/awt/image/BufferedImage;", "message", "", "expected", "imageDiff", "Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$DiffResult$Similar;", "(Ljava/awt/image/BufferedImage;Ljava/lang/String;Ljava/awt/image/BufferedImage;Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$DiffResult$Similar;)V", "getActual", "()Ljava/awt/image/BufferedImage;", "getExpected", "getImageDiff", "()Lcom/android/build/gradle/internal/testing/screenshot/ImageDiffer$DiffResult$Similar;", "getMessage", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "gradle-core"})
        public static final class Passed
        implements AnalysisResult {
            @NotNull
            private final BufferedImage actual;
            @NotNull
            private final String message;
            @NotNull
            private final BufferedImage expected;
            @NotNull
            private final ImageDiffer.DiffResult.Similar imageDiff;

            public Passed(@NotNull BufferedImage actual, @NotNull String message2, @NotNull BufferedImage expected, @NotNull ImageDiffer.DiffResult.Similar imageDiff) {
                Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
                Intrinsics.checkNotNullParameter((Object)imageDiff, (String)"imageDiff");
                this.actual = actual;
                this.message = message2;
                this.expected = expected;
                this.imageDiff = imageDiff;
            }

            @Override
            @NotNull
            public BufferedImage getActual() {
                return this.actual;
            }

            @Override
            @NotNull
            public String getMessage() {
                return this.message;
            }

            @NotNull
            public final BufferedImage getExpected() {
                return this.expected;
            }

            @NotNull
            public final ImageDiffer.DiffResult.Similar getImageDiff() {
                return this.imageDiff;
            }

            @NotNull
            public final BufferedImage component1() {
                return this.actual;
            }

            @NotNull
            public final String component2() {
                return this.message;
            }

            @NotNull
            public final BufferedImage component3() {
                return this.expected;
            }

            @NotNull
            public final ImageDiffer.DiffResult.Similar component4() {
                return this.imageDiff;
            }

            @NotNull
            public final Passed copy(@NotNull BufferedImage actual, @NotNull String message2, @NotNull BufferedImage expected, @NotNull ImageDiffer.DiffResult.Similar imageDiff) {
                Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
                Intrinsics.checkNotNullParameter((Object)imageDiff, (String)"imageDiff");
                return new Passed(actual, message2, expected, imageDiff);
            }

            public static /* synthetic */ Passed copy$default(Passed passed, BufferedImage bufferedImage, String string, BufferedImage bufferedImage2, ImageDiffer.DiffResult.Similar similar, int n, Object object) {
                if ((n & 1) != 0) {
                    bufferedImage = passed.actual;
                }
                if ((n & 2) != 0) {
                    string = passed.message;
                }
                if ((n & 4) != 0) {
                    bufferedImage2 = passed.expected;
                }
                if ((n & 8) != 0) {
                    similar = passed.imageDiff;
                }
                return passed.copy(bufferedImage, string, bufferedImage2, similar);
            }

            @NotNull
            public String toString() {
                return "Passed(actual=" + this.actual + ", message=" + this.message + ", expected=" + this.expected + ", imageDiff=" + this.imageDiff + ")";
            }

            public int hashCode() {
                int result2 = this.actual.hashCode();
                result2 = result2 * 31 + this.message.hashCode();
                result2 = result2 * 31 + this.expected.hashCode();
                result2 = result2 * 31 + this.imageDiff.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Passed)) {
                    return false;
                }
                Passed passed = (Passed)other;
                if (!Intrinsics.areEqual((Object)this.actual, (Object)passed.actual)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.message, (Object)passed.message)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.expected, (Object)passed.expected)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.imageDiff, (Object)passed.imageDiff);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/testing/screenshot/Verify$AnalysisResult$SizeMismatch;", "Lcom/android/build/gradle/internal/testing/screenshot/Verify$AnalysisResult;", "actual", "Ljava/awt/image/BufferedImage;", "message", "", "expected", "(Ljava/awt/image/BufferedImage;Ljava/lang/String;Ljava/awt/image/BufferedImage;)V", "getActual", "()Ljava/awt/image/BufferedImage;", "getExpected", "getMessage", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "gradle-core"})
        public static final class SizeMismatch
        implements AnalysisResult {
            @NotNull
            private final BufferedImage actual;
            @NotNull
            private final String message;
            @NotNull
            private final BufferedImage expected;

            public SizeMismatch(@NotNull BufferedImage actual, @NotNull String message2, @NotNull BufferedImage expected) {
                Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
                this.actual = actual;
                this.message = message2;
                this.expected = expected;
            }

            @Override
            @NotNull
            public BufferedImage getActual() {
                return this.actual;
            }

            @Override
            @NotNull
            public String getMessage() {
                return this.message;
            }

            @NotNull
            public final BufferedImage getExpected() {
                return this.expected;
            }

            @NotNull
            public final BufferedImage component1() {
                return this.actual;
            }

            @NotNull
            public final String component2() {
                return this.message;
            }

            @NotNull
            public final BufferedImage component3() {
                return this.expected;
            }

            @NotNull
            public final SizeMismatch copy(@NotNull BufferedImage actual, @NotNull String message2, @NotNull BufferedImage expected) {
                Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
                return new SizeMismatch(actual, message2, expected);
            }

            public static /* synthetic */ SizeMismatch copy$default(SizeMismatch sizeMismatch, BufferedImage bufferedImage, String string, BufferedImage bufferedImage2, int n, Object object) {
                if ((n & 1) != 0) {
                    bufferedImage = sizeMismatch.actual;
                }
                if ((n & 2) != 0) {
                    string = sizeMismatch.message;
                }
                if ((n & 4) != 0) {
                    bufferedImage2 = sizeMismatch.expected;
                }
                return sizeMismatch.copy(bufferedImage, string, bufferedImage2);
            }

            @NotNull
            public String toString() {
                return "SizeMismatch(actual=" + this.actual + ", message=" + this.message + ", expected=" + this.expected + ")";
            }

            public int hashCode() {
                int result2 = this.actual.hashCode();
                result2 = result2 * 31 + this.message.hashCode();
                result2 = result2 * 31 + this.expected.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SizeMismatch)) {
                    return false;
                }
                SizeMismatch sizeMismatch = (SizeMismatch)other;
                if (!Intrinsics.areEqual((Object)this.actual, (Object)sizeMismatch.actual)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.message, (Object)sizeMismatch.message)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.expected, (Object)sizeMismatch.expected);
            }
        }
    }
}

