/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.dsl.Installation;
import com.android.build.api.variant.impl.BuiltArtifactImpl;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.internal.BuildToolsExecutableInput;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkComponentsKt;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.BundleInstallUtils;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.test.BuiltArtifactsSplitOutputMatcher;
import com.android.build.gradle.internal.testing.ConnectedDeviceProvider;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.internal.InstallUtils;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.builder.testing.api.DeviceConfigProviderImpl;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.DEPLOYMENT)
public abstract class InstallVariantTask
extends NonIncrementalTask {
    private int timeOutInMs = 0;
    private Collection<String> installOptions;
    private String variantName;
    private Set<String> supportedAbis;
    private AndroidVersion minSdkVersion;

    @Inject
    public InstallVariantTask() {
        this.getOutputs().upToDateWhen(task -> {
            this.getLogger().debug("Install task is always run.");
            return false;
        });
    }

    @Override
    protected void doTaskAction() throws DeviceException, ExecutionException {
        LoggerWrapper iLogger = new LoggerWrapper(this.getLogger());
        ConnectedDeviceProvider deviceProvider = new ConnectedDeviceProvider(this.getBuildTools().adbExecutable(), this.getTimeOutInMs(), (ILogger)iLogger, System.getenv("ANDROID_SERIAL"));
        deviceProvider.use(() -> {
            InstallVariantTask.install((String)this.getProjectPath().get(), this.variantName, deviceProvider, this.minSdkVersion, (Directory)this.getApkDirectory().get(), this.getPrivacySandboxSdksApksFiles().getFiles(), this.getPrivacySandboxSupportedSdkAdditionalSplitApks(), this.getPrivacySandboxCompatApks(), this.supportedAbis, this.getInstallOptions(), this.getTimeOutInMs(), this.getLogger(), this.getDexMetadataDirectory());
            return null;
        });
    }

    static void install(String projectPath, String variantName, DeviceProvider deviceProvider, AndroidVersion minSdkVersion2, Directory apkDirectory, Set<File> privacySandboxSdksApksFiles, DirectoryProperty additionalSupportedSdkApkSplits, DirectoryProperty privacySandboxSdkSplitApksForLegacy, Set<String> supportedAbis2, Collection<String> installOptions, int timeOutInMs, Logger logger, DirectoryProperty dexMetadataDirectory) throws DeviceException, IOException {
        LoggerWrapper iLogger = new LoggerWrapper(logger);
        int successfulInstallCount = 0;
        List devices = deviceProvider.getDevices();
        BuiltArtifactsImpl builtArtifacts = new BuiltArtifactsLoaderImpl().load(apkDirectory);
        for (DeviceConnector device : devices) {
            if (!InstallUtils.checkDeviceApiLevel((DeviceConnector)device, (AndroidVersion)minSdkVersion2, (ILogger)iLogger, (String)projectPath, (String)variantName)) continue;
            Collection extraArgs = (Collection)MoreObjects.firstNonNull(installOptions, (Object)ImmutableList.of());
            DeviceConfigProviderImpl deviceConfigProvider = new DeviceConfigProviderImpl(device);
            LinkedList apkFiles = Lists.newLinkedList();
            if (builtArtifacts != null) {
                apkFiles.addAll(BuiltArtifactsSplitOutputMatcher.INSTANCE.computeBestOutput((DeviceConfigProvider)deviceConfigProvider, builtArtifacts, supportedAbis2));
            }
            if (device.getSupportsPrivacySandbox()) {
                BuiltArtifactsImpl privacySandboxSupportedApkSplitsBuiltArtifacts;
                privacySandboxSdksApksFiles.forEach(file -> {
                    List sdkApkFiles = BundleInstallUtils.extractApkFilesBypassingBundleTool(file.toPath()).stream().map(Path::toFile).collect(Collectors.toUnmodifiableList());
                    try {
                        device.installPackages(sdkApkFiles, extraArgs, timeOutInMs, iLogger);
                    }
                    catch (DeviceException e) {
                        logger.error(String.format("Failed to install privacy sandbox SDK APKs from %s", file.toPath()), (Throwable)e);
                    }
                });
                if (additionalSupportedSdkApkSplits.isPresent() && (privacySandboxSupportedApkSplitsBuiltArtifacts = new BuiltArtifactsLoaderImpl().load((Provider<Directory>)additionalSupportedSdkApkSplits)) != null) {
                    for (BuiltArtifactImpl split : privacySandboxSupportedApkSplitsBuiltArtifacts.getElements()) {
                        apkFiles.add(new File(split.getOutputFile()));
                    }
                }
            }
            BuiltArtifactsImpl privacySandboxLegacySplitbuiltArtifacts = null;
            if (privacySandboxSdkSplitApksForLegacy.getOrNull() != null) {
                privacySandboxLegacySplitbuiltArtifacts = new BuiltArtifactsLoaderImpl().load((Provider<Directory>)privacySandboxSdkSplitApksForLegacy);
            }
            if (!device.getSupportsPrivacySandbox() && privacySandboxLegacySplitbuiltArtifacts != null) {
                for (BuiltArtifactImpl sdkBuiltArtifact : privacySandboxLegacySplitbuiltArtifacts.getElements()) {
                    apkFiles.add(new File(sdkBuiltArtifact.getOutputFile()));
                }
            }
            InstallVariantTask.addDexMetadataFiles(dexMetadataDirectory, apkDirectory, device, apkFiles, logger);
            if (apkFiles.isEmpty()) {
                logger.lifecycle("Skipping device '{}' for '{}:{}': Could not find build of variant which supports density {} and an ABI in {}", new Object[]{device.getName(), projectPath, variantName, device.getDensity(), Joiner.on((String)", ").join((Iterable)device.getAbis())});
                continue;
            }
            logger.lifecycle("Installing APK '{}' on '{}' for {}:{}", new Object[]{FileUtils.getNamesAsCommaSeparatedList((Iterable)apkFiles), device.getName(), projectPath, variantName});
            if (apkFiles.size() > 1) {
                device.installPackages((List)apkFiles, extraArgs, timeOutInMs, (ILogger)iLogger);
            } else {
                device.installPackage((File)apkFiles.get(0), extraArgs, timeOutInMs, (ILogger)iLogger);
            }
            ++successfulInstallCount;
        }
        if (successfulInstallCount == 0) {
            throw new GradleException("Failed to install on any devices.");
        }
        logger.quiet("Installed on {} {}.", new Object[]{successfulInstallCount, successfulInstallCount == 1 ? "device" : "devices"});
    }

    private static void addDexMetadataFiles(DirectoryProperty dexMetadataDirectory, Directory apkDirectory, DeviceConnector device, List<File> apkFiles, Logger logger) throws IOException {
        Directory dmDir = (Directory)dexMetadataDirectory.getOrNull();
        if (dmDir != null && dmDir.file("dex-metadata-map.properties").getAsFile().exists()) {
            File dexMetadataProperties = dmDir.file("dex-metadata-map.properties").getAsFile();
            FileInputStream inputStream = new FileInputStream(dexMetadataProperties);
            Properties properties = new Properties();
            properties.load(inputStream);
            String dmPath = device.getApiLevel() > 31 ? properties.getProperty(String.valueOf(Integer.MAX_VALUE)) : properties.getProperty(String.valueOf(device.getApiLevel()));
            if (dmPath == null) {
                logger.log(LogLevel.INFO, "Baseline Profile not found for API level " + device.getApiLevel());
                return;
            }
            if (!apkFiles.isEmpty()) {
                String fileIndex = new File(dmPath).getParentFile().getName();
                int numApks = apkFiles.size();
                for (int i = 0; i < numApks; ++i) {
                    String apkFileName = apkFiles.get(i).getName();
                    if (!apkFileName.endsWith(".apk")) continue;
                    String apkName = Files.getNameWithoutExtension((String)apkFileName);
                    File renamedBaselineProfile = FileUtils.join((File)apkDirectory.getAsFile(), (String[])new String[]{"baselineProfiles", fileIndex, apkName + ".dm"});
                    if (!renamedBaselineProfile.exists()) {
                        logger.log(LogLevel.INFO, "Baseline Profile at " + renamedBaselineProfile.getAbsolutePath() + " was not found.");
                        return;
                    }
                    apkFiles.add(renamedBaselineProfile);
                }
            }
        }
    }

    @Input
    public int getTimeOutInMs() {
        return this.timeOutInMs;
    }

    public void setTimeOutInMs(int timeOutInMs) {
        this.timeOutInMs = timeOutInMs;
    }

    @Input
    @Optional
    public Collection<String> getInstallOptions() {
        return this.installOptions;
    }

    public void setInstallOptions(Collection<String> installOptions) {
        this.installOptions = installOptions;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract DirectoryProperty getApkDirectory();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public abstract ConfigurableFileCollection getPrivacySandboxSdksApksFiles();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public abstract DirectoryProperty getPrivacySandboxSupportedSdkAdditionalSplitApks();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public abstract DirectoryProperty getPrivacySandboxCompatApks();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public abstract DirectoryProperty getDexMetadataDirectory();

    @Nested
    public abstract BuildToolsExecutableInput getBuildTools();

    public static class CreationAction
    extends VariantTaskCreationAction<InstallVariantTask, ApkCreationConfig> {
        public CreationAction(ApkCreationConfig creationConfig) {
            super(creationConfig);
        }

        @Override
        public String getName() {
            return this.computeTaskName("install");
        }

        @Override
        public Class<InstallVariantTask> getType() {
            return InstallVariantTask.class;
        }

        @Override
        public void configure(InstallVariantTask task) {
            super.configure(task);
            task.variantName = ((ApkCreationConfig)this.creationConfig).getBaseName();
            task.supportedAbis = ((ApkCreationConfig)this.creationConfig).getNativeBuildCreationConfig() == null ? Collections.emptySet() : ((ApkCreationConfig)this.creationConfig).getNativeBuildCreationConfig().getSupportedAbis();
            task.minSdkVersion = VariantApiExtensionsKt.toSharedAndroidVersion(((ApkCreationConfig)this.creationConfig).getMinSdk());
            task.setDescription("Installs the " + ((ApkCreationConfig)this.creationConfig).getDescription() + ".");
            task.setGroup("Install");
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(SingleArtifact.APK.INSTANCE, task.getApkDirectory());
            if (((ApkCreationConfig)this.creationConfig).getPrivacySandboxCreationConfig() != null) {
                task.getPrivacySandboxSdksApksFiles().setFrom((Iterable)((ApkCreationConfig)this.creationConfig).getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_SDK_APKS));
                task.getPrivacySandboxSupportedSdkAdditionalSplitApks().set(((ApkCreationConfig)this.creationConfig).getArtifacts().get(InternalArtifactType.USES_SDK_LIBRARY_SPLIT_FOR_LOCAL_DEPLOYMENT.INSTANCE));
                task.getPrivacySandboxCompatApks().set(((ApkCreationConfig)this.creationConfig).getArtifacts().get(InternalArtifactType.EXTRACTED_SDK_APKS.INSTANCE));
            }
            task.getPrivacySandboxSdksApksFiles().disallowChanges();
            task.getPrivacySandboxSupportedSdkAdditionalSplitApks().disallowChanges();
            task.getPrivacySandboxCompatApks().disallowChanges();
            Installation installationOptions = ((ApkCreationConfig)this.creationConfig).getGlobal().getInstallationOptions();
            task.setTimeOutInMs(installationOptions.getTimeOutInMs());
            task.setInstallOptions(installationOptions.getInstallOptions());
            SdkComponentsKt.initialize(task.getBuildTools(), this.creationConfig);
            task.getDexMetadataDirectory().set(((ApkCreationConfig)this.creationConfig).getArtifacts().get(InternalArtifactType.DEX_METADATA_DIRECTORY.INSTANCE));
            task.getDexMetadataDirectory().disallowChanges();
        }

        @Override
        public void handleProvider(TaskProvider<InstallVariantTask> taskProvider) {
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getTaskContainer().setInstallTask(taskProvider);
        }
    }
}

