/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.api.DefaultAndroidSourceDirectorySet;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.buildanalyzer.common.TaskCategory;
import java.io.IOException;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.tasks.diagnostics.ProjectBasedReportTask;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.HELP)
public class SourceSetsTask
extends ProjectBasedReportTask {
    private final TextReportRenderer mRenderer = new TextReportRenderer();
    private Iterable<AndroidSourceSet> sourceSetContainer;

    protected ReportRenderer getRenderer() {
        return this.mRenderer;
    }

    protected void generate(Project project) throws IOException {
        for (AndroidSourceSet sourceSet2 : this.sourceSetContainer) {
            DefaultAndroidSourceSet androidSourceSet;
            this.mRenderer.getBuilder().subheading(sourceSet2.getName());
            this.renderKeyValue("Compile configuration: ", sourceSet2.getCompileConfigurationName());
            this.renderKeyValue("build.gradle name: ", "android.sourceSets." + sourceSet2.getName());
            this.renderDirectorySet("Java sources", sourceSet2.getJava(), project);
            this.renderDirectorySet("Kotlin sources", (AndroidSourceDirectorySet)sourceSet2.getKotlin(), project);
            if (!sourceSet2.getName().startsWith("test")) {
                this.renderKeyValue("Manifest file: ", project.getRootProject().relativePath((Object)sourceSet2.getManifest().getSrcFile()));
                this.renderDirectorySet("Android resources", sourceSet2.getRes(), project);
                this.renderDirectorySet("Assets", sourceSet2.getAssets(), project);
                this.renderDirectorySet("AIDL sources", sourceSet2.getAidl(), project);
                this.renderDirectorySet("RenderScript sources", sourceSet2.getRenderscript(), project);
                this.renderDirectorySet("Baseline profile sources", (AndroidSourceDirectorySet)sourceSet2.getBaselineProfiles(), project);
                this.renderDirectorySet("JNI sources", sourceSet2.getJni(), project);
                this.renderDirectorySet("JNI libraries", sourceSet2.getJniLibs(), project);
            }
            if (sourceSet2 instanceof DefaultAndroidSourceSet && !(androidSourceSet = (DefaultAndroidSourceSet)sourceSet2).getExtras$gradle_core().isEmpty()) {
                androidSourceSet.getExtras$gradle_core().forEach(androidSourceDirectorySet -> this.renderDirectorySet("Custom sources", (DefaultAndroidSourceDirectorySet)androidSourceDirectorySet, project));
            }
            this.renderDirectorySet("Java-style resources", sourceSet2.getResources(), project);
            this.mRenderer.getTextOutput().println();
        }
        this.mRenderer.complete();
    }

    private void renderDirectorySet(String name, DefaultAndroidSourceDirectorySet sourceDirectorySet, Project project) {
        String relativePaths = sourceDirectorySet.getSrcDirs().stream().map(file -> project.getRootProject().relativePath(file)).collect(Collectors.joining(", "));
        this.renderKeyValue(name + ": ", String.format("[%s]", relativePaths));
    }

    private void renderDirectorySet(String name, AndroidSourceDirectorySet sourceDirectorySet, Project project) {
        String relativePaths = sourceDirectorySet.getSrcDirs().stream().map(file -> project.getRootProject().relativePath(file)).collect(Collectors.joining(", "));
        this.renderKeyValue(name + ": ", String.format("[%s]", relativePaths));
    }

    private void renderKeyValue(String o, String o1) {
        this.mRenderer.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)o);
        this.mRenderer.getTextOutput().withStyle(StyledTextOutput.Style.Info).text((Object)o1);
        this.mRenderer.getTextOutput().println();
    }

    public static class CreationAction
    extends TaskCreationAction<SourceSetsTask> {
        private final Iterable<AndroidSourceSet> sourceSetContainer;

        public CreationAction(Iterable<AndroidSourceSet> sourceSetContainer) {
            this.sourceSetContainer = sourceSetContainer;
        }

        @Override
        public String getName() {
            return "sourceSets";
        }

        @Override
        public Class<SourceSetsTask> getType() {
            return SourceSetsTask.class;
        }

        @Override
        public void configure(SourceSetsTask sourceSetsTask) {
            sourceSetsTask.sourceSetContainer = this.sourceSetContainer;
            sourceSetsTask.setDescription("Prints out all the source sets defined in this project.");
            sourceSetsTask.setGroup("Android");
            sourceSetsTask.notCompatibleWithConfigurationCache("SourceSetsTask not compatible with config caching");
        }
    }
}

