/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing;

import java.util.Timer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!BE\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012 \b\u0002\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0019\u001a\u00020\u000bJ\u0006\u0010\u001a\u001a\u00020\u000bJ\u0006\u0010\u001b\u001a\u00020\u000bJ\u0006\u0010\u001c\u001a\u00020\u000bJ\u0006\u0010\u001d\u001a\u00020\u000bJ\u000e\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R)\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Lcom/android/build/gradle/internal/testing/TestResultProgressTracker;", "", "deviceName", "", "logStatusDelayMS", "", "logger", "Lorg/gradle/api/logging/Logger;", "timerFactory", "Lkotlin/Function2;", "Lkotlin/Function0;", "", "Ljava/util/Timer;", "(Ljava/lang/String;JLorg/gradle/api/logging/Logger;Lkotlin/jvm/functions/Function2;)V", "getLogStatusDelayMS", "()J", "logTimer", "getLogger", "()Lorg/gradle/api/logging/Logger;", "status", "Lcom/android/build/gradle/internal/testing/TestResultProgressTracker$TestSuiteStatus;", "getStatus", "()Lcom/android/build/gradle/internal/testing/TestResultProgressTracker$TestSuiteStatus;", "getTimerFactory", "()Lkotlin/jvm/functions/Function2;", "logStatus", "onTestFailed", "onTestPassed", "onTestSkipped", "onTestSuiteFinished", "onTestSuiteStarted", "scheduledTestCaseCount", "", "TestSuiteStatus", "gradle-core"})
public final class TestResultProgressTracker {
    private final long logStatusDelayMS;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Function2<Long, Function0<Unit>, Timer> timerFactory;
    @Nullable
    private Timer logTimer;
    @NotNull
    private final TestSuiteStatus status;

    @JvmOverloads
    public TestResultProgressTracker(@NotNull String deviceName, long logStatusDelayMS, @NotNull Logger logger, @NotNull Function2<? super Long, ? super Function0<Unit>, ? extends Timer> timerFactory) {
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(timerFactory, (String)"timerFactory");
        this.logStatusDelayMS = logStatusDelayMS;
        this.logger = logger;
        this.timerFactory = timerFactory;
        this.status = new TestSuiteStatus(deviceName);
    }

    public /* synthetic */ TestResultProgressTracker(String string, long l, Logger logger, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 10000L;
        }
        if ((n & 4) != 0) {
            Logger logger2 = Logging.getLogger(TestResultProgressTracker.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(TestResultProgressTracker::class.java)");
            logger = logger2;
        }
        if ((n & 8) != 0) {
            function2 = 1.INSTANCE;
        }
        this(string, l, logger, (Function2<? super Long, ? super Function0<Unit>, ? extends Timer>)function2);
    }

    public final long getLogStatusDelayMS() {
        return this.logStatusDelayMS;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Function2<Long, Function0<Unit>, Timer> getTimerFactory() {
        return this.timerFactory;
    }

    @NotNull
    public final TestSuiteStatus getStatus() {
        return this.status;
    }

    public final void logStatus() {
        if (this.status.hasChanged()) {
            this.logger.lifecycle(this.status.getStatus());
        }
    }

    public final void onTestSuiteStarted(int scheduledTestCaseCount) {
        this.status.scheduleTests(scheduledTestCaseCount);
        this.logTimer = (Timer)this.timerFactory.invoke((Object)this.logStatusDelayMS, (Object)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((TestResultProgressTracker)this.receiver).logStatus();
            }
        });
    }

    public final void onTestFailed() {
        this.status.addFailedTest();
    }

    public final void onTestPassed() {
        this.status.addCompletedTest();
    }

    public final void onTestSkipped() {
        this.status.addSkippedTest();
    }

    public final void onTestSuiteFinished() {
        Timer timer2 = this.logTimer;
        if (timer2 != null) {
            timer2.cancel();
        }
        this.logger.lifecycle("Finished " + this.status.getFinishedTests() + " tests on " + this.status.getDeviceName());
    }

    @JvmOverloads
    public TestResultProgressTracker(@NotNull String deviceName, long logStatusDelayMS, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this(deviceName, logStatusDelayMS, logger, null, 8, null);
    }

    @JvmOverloads
    public TestResultProgressTracker(@NotNull String deviceName, long logStatusDelayMS) {
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        this(deviceName, logStatusDelayMS, null, null, 12, null);
    }

    @JvmOverloads
    public TestResultProgressTracker(@NotNull String deviceName) {
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        this(deviceName, 0L, null, null, 14, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u0012J\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/testing/TestResultProgressTracker$TestSuiteStatus;", "", "deviceName", "", "(Ljava/lang/String;)V", "getDeviceName", "()Ljava/lang/String;", "finishedTests", "", "getFinishedTests", "()I", "statusChanged", "", "testsCompletedCount", "testsFailedCount", "testsScheduledCount", "testsSkippedCount", "addCompletedTest", "", "addFailedTest", "addSkippedTest", "getStatus", "hasChanged", "scheduleTests", "amount", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nTestResultProgressTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestResultProgressTracker.kt\ncom/android/build/gradle/internal/testing/TestResultProgressTracker$TestSuiteStatus\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
    public static final class TestSuiteStatus {
        @NotNull
        private final String deviceName;
        private int testsFailedCount;
        private int testsSkippedCount;
        private int testsScheduledCount;
        private int testsCompletedCount;
        private boolean statusChanged;

        public TestSuiteStatus(@NotNull String deviceName) {
            Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
            this.deviceName = deviceName;
        }

        @NotNull
        public final String getDeviceName() {
            return this.deviceName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int getFinishedTests() {
            int n;
            TestSuiteStatus testSuiteStatus = this;
            synchronized (testSuiteStatus) {
                boolean bl = false;
                n = this.testsCompletedCount;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final boolean hasChanged() {
            void var2_2;
            TestSuiteStatus testSuiteStatus = this;
            synchronized (testSuiteStatus) {
                void var3_4;
                boolean bl = false;
                boolean hasChange = this.statusChanged;
                this.statusChanged = false;
                var2_2 = var3_4;
            }
            return (boolean)var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addCompletedTest() {
            TestSuiteStatus testSuiteStatus = this;
            synchronized (testSuiteStatus) {
                boolean bl = false;
                this.statusChanged = true;
                ++this.testsCompletedCount;
                int n = this.testsCompletedCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addFailedTest() {
            TestSuiteStatus testSuiteStatus = this;
            synchronized (testSuiteStatus) {
                boolean bl = false;
                this.statusChanged = true;
                ++this.testsCompletedCount;
                ++this.testsFailedCount;
                int n = this.testsFailedCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addSkippedTest() {
            TestSuiteStatus testSuiteStatus = this;
            synchronized (testSuiteStatus) {
                boolean bl = false;
                this.statusChanged = true;
                ++this.testsCompletedCount;
                ++this.testsSkippedCount;
                int n = this.testsSkippedCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void scheduleTests(int amount) {
            TestSuiteStatus testSuiteStatus = this;
            synchronized (testSuiteStatus) {
                boolean bl = false;
                this.statusChanged = true;
                this.testsScheduledCount = amount;
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String getStatus() {
            String string;
            TestSuiteStatus testSuiteStatus = this;
            synchronized (testSuiteStatus) {
                boolean bl = false;
                string = this.deviceName + " Tests " + this.testsCompletedCount + "/" + this.testsScheduledCount + " completed. (" + this.testsSkippedCount + " skipped) (" + this.testsFailedCount + " failed)";
            }
            return string;
        }
    }
}

