/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.lint.AndroidLintTextOutputTask;
import com.android.build.gradle.internal.lint.AndroidLintWorkAction;
import com.android.build.gradle.internal.lint.LintMode;
import com.android.build.gradle.options.StringOption;
import com.android.utils.JvmWideVariable;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0016\u0010\r\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintWorkAction$LintWorkActionParameters;", "()V", "execute", "", "invokeLintMainRunMethod", "", "classLoader", "Ljava/lang/ClassLoader;", "arguments", "", "", "runLint", "Companion", "LintWorkActionParameters", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nAndroidLintWorkAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidLintWorkAction.kt\ncom/android/build/gradle/internal/lint/AndroidLintWorkAction\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,295:1\n37#2,2:296\n*S KotlinDebug\n*F\n+ 1 AndroidLintWorkAction.kt\ncom/android/build/gradle/internal/lint/AndroidLintWorkAction\n*L\n101#1:296,2\n*E\n"})
public abstract class AndroidLintWorkAction
implements WorkAction<LintWorkActionParameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int ERRNO_SUCCESS = 0;
    public static final int ERRNO_ERRORS = 1;
    private static final int ERRNO_USAGE = 2;
    private static final int ERRNO_EXISTS = 3;
    private static final int ERRNO_HELP = 4;
    private static final int ERRNO_INVALID_ARGS = 5;
    public static final int ERRNO_CREATED_BASELINE = 6;
    private static final int ERRNO_APPLIED_SUGGESTIONS = 7;
    @NotNull
    private static final JvmWideVariable<Map<String, SoftReference<URLClassLoader>>> cachedClassloader = new JvmWideVariable(AndroidLintWorkAction.class, "cachedClassloader", (TypeToken)new TypeToken<Map<String, SoftReference<URLClassLoader>>>(){}, (Supplier)Companion.cachedClassloader.2.INSTANCE);
    @GuardedBy(value="this")
    @NotNull
    private static final Map<String, URLClassLoader> toDispose = new LinkedHashMap();

    public void execute() {
        Logger logger = Logging.getLogger(this.getClass());
        List arguments = (List)((LintWorkActionParameters)this.getParameters()).getArguments().get();
        Intrinsics.checkNotNullExpressionValue((Object)arguments, (String)"arguments");
        logger.debug("Running lint " + CollectionsKt.joinToString$default((Iterable)arguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        if (!((Boolean)((LintWorkActionParameters)this.getParameters()).getRunInProcess().get()).booleanValue()) {
            logger.info("Max memory for Android Lint: {}m\n(can be configured by {}=2G in gradle.properties)", (Object)(Runtime.getRuntime().maxMemory() / (long)1024 / (long)1024), (Object)StringOption.LINT_HEAP_SIZE.getPropertyName());
        }
        int execResult = this.runLint(arguments);
        logger.debug("Lint returned " + execResult);
        Object object = (RegularFile)((LintWorkActionParameters)this.getParameters()).getReturnValueOutputFile().getOrNull();
        if (object != null && (object = object.getAsFile()) != null) {
            Object it = object;
            boolean bl = false;
            FilesKt.writeText$default((File)it, (String)String.valueOf(execResult), null, (int)2, null);
            if (AndroidLintTextOutputTask.Companion.getHANDLED_ERRORS().contains(execResult)) {
                return;
            }
        }
        Object object2 = ((LintWorkActionParameters)this.getParameters()).getAndroid().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.android.get()");
        boolean bl = (Boolean)object2;
        Object object3 = ((LintWorkActionParameters)this.getParameters()).getFatalOnly().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.fatalOnly.get()");
        boolean bl2 = (Boolean)object3;
        Object object4 = ((LintWorkActionParameters)this.getParameters()).getLintMode().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"parameters.lintMode.get()");
        LintMode lintMode = (LintMode)((Object)object4);
        Object object5 = ((LintWorkActionParameters)this.getParameters()).getHasBaseline().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"parameters.hasBaseline.get()");
        Companion.maybeThrowException(execResult, bl, bl2, lintMode, null, (Boolean)object5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int runLint(List<String> arguments) {
        Object object = ((LintWorkActionParameters)this.getParameters()).getVersionKey().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.versionKey.get()");
        ClassLoader classLoader = AndroidLintWorkAction.Companion.getClassloader((String)object, (FileCollection)((LintWorkActionParameters)this.getParameters()).getClasspath());
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(null);
            int n = this.invokeLintMainRunMethod(classLoader, arguments);
            return n;
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"e.targetException");
            throw throwable;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
        }
    }

    private final int invokeLintMainRunMethod(ClassLoader classLoader, List<String> arguments) {
        Class<?> cls = classLoader.loadClass((String)((LintWorkActionParameters)this.getParameters()).getMainClass().get());
        Class[] classArray = new Class[]{String[].class};
        Method method = cls.getMethod("run", classArray);
        Object lintMain = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Object[] objectArray = new Object[1];
        Collection $this$toTypedArray$iv = arguments;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray[0] = thisCollection$iv.toArray(new String[0]);
        Object object = method.invoke(lintMain, objectArray);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        int returnValue = (Integer)object;
        if (!((Boolean)((LintWorkActionParameters)this.getParameters()).getRunInProcess().get()).booleanValue()) {
            Companion.dispose();
        }
        return returnValue;
    }

    @JvmStatic
    public static final void maybeThrowException(int execResult, boolean android, boolean fatalOnly, @NotNull LintMode lintMode, @Nullable String abbreviatedLintOutput, boolean hasBaseline) {
        Companion.maybeThrowException(execResult, android, fatalOnly, lintMode, abbreviatedLintOutput, hasBaseline);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020!H\u0002J*\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\b\u0010&\u001a\u0004\u0018\u00010\u000f2\u0006\u0010'\u001a\u00020$H\u0002J\b\u0010(\u001a\u00020 H\u0002J\"\u0010)\u001a\u00020\u001e2\u0018\u0010*\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000eH\u0002J:\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010-\u001a\u00020.2\b\u0010&\u001a\u0004\u0018\u00010\u000f2\u0006\u0010'\u001a\u00020$H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00110\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintWorkAction$Companion;", "", "()V", "ERRNO_APPLIED_SUGGESTIONS", "", "ERRNO_CREATED_BASELINE", "ERRNO_ERRORS", "ERRNO_EXISTS", "ERRNO_HELP", "ERRNO_INVALID_ARGS", "ERRNO_SUCCESS", "ERRNO_USAGE", "cachedClassloader", "Lcom/android/utils/JvmWideVariable;", "", "", "Ljava/lang/ref/SoftReference;", "Ljava/net/URLClassLoader;", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/gradle/api/logging/Logger;", "toDispose", "createClassLoader", "key", "classpath", "", "Ljava/net/URI;", "dispose", "", "getClassloader", "Ljava/lang/ClassLoader;", "Lorg/gradle/api/file/FileCollection;", "getErrorMessage", "android", "", "fatalOnly", "abbreviatedLintOutput", "hasBaseline", "getPlatformClassLoader", "maintainClassloaders", "map", "maybeThrowException", "execResult", "lintMode", "Lcom/android/build/gradle/internal/lint/LintMode;", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nAndroidLintWorkAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidLintWorkAction.kt\ncom/android/build/gradle/internal/lint/AndroidLintWorkAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,295:1\n1549#2:296\n1620#2,3:297\n1549#2:300\n1620#2,3:301\n1855#2,2:306\n37#3,2:304\n*S KotlinDebug\n*F\n+ 1 AndroidLintWorkAction.kt\ncom/android/build/gradle/internal/lint/AndroidLintWorkAction$Companion\n*L\n153#1:296\n153#1:297,3\n190#1:300\n190#1:301,3\n208#1:306,2\n190#1:304,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLogger() {
            return Logging.getLogger(AndroidLintWorkAction.class);
        }

        /*
         * WARNING - void declaration
         */
        private final synchronized ClassLoader getClassloader(String key, FileCollection classpath) {
            void $this$mapTo$iv$iv;
            Set set = classpath.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"classpath.files");
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toURI());
            }
            List uris = (List)destination$iv$iv;
            Object object = cachedClassloader.executeCallableSynchronously(new Callable(key, uris){
                final /* synthetic */ String $key;
                final /* synthetic */ List<URI> $uris;
                {
                    this.$key = $key;
                    this.$uris = $uris;
                }

                public final URLClassLoader call() {
                    Object object;
                    Map map = (Map)AndroidLintWorkAction.access$getCachedClassloader$cp().get();
                    Object object2 = (SoftReference)map.get(this.$key);
                    if (object2 != null && (object2 = (URLClassLoader)((SoftReference)object2).get()) != null) {
                        Object object3 = object2;
                        String string = this.$key;
                        Object it = object3;
                        boolean bl = false;
                        com.android.build.gradle.internal.lint.AndroidLintWorkAction$Companion.access$getLogger(AndroidLintWorkAction.Companion).info("Android Lint: Reusing lint classloader {}", (Object)string);
                        object = object3;
                    } else {
                        URLClassLoader uRLClassLoader = com.android.build.gradle.internal.lint.AndroidLintWorkAction$Companion.access$createClassLoader(AndroidLintWorkAction.Companion, this.$key, this.$uris);
                        String string = this.$key;
                        URLClassLoader it = uRLClassLoader;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"map");
                        map.put(string, new SoftReference<URLClassLoader>(it));
                        object = uRLClassLoader;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"map[key]?.get()?.also {\n\u2026ey] = SoftReference(it) }");
                    Object classloader = object;
                    AndroidLintWorkAction.access$getToDispose$cp().put(this.$key, classloader);
                    Intrinsics.checkNotNullExpressionValue((Object)map, (String)"map");
                    com.android.build.gradle.internal.lint.AndroidLintWorkAction$Companion.access$maintainClassloaders(AndroidLintWorkAction.Companion, map);
                    return classloader;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"key: String, classpath: \u2026classloader\n            }");
            return (ClassLoader)object;
        }

        private final synchronized void maintainClassloaders(Map<String, SoftReference<URLClassLoader>> map) {
            if (map.size() <= 1) {
                return;
            }
            for (String otherKey : new ArrayList(map.keySet())) {
                SoftReference<URLClassLoader> softReference = map.get(otherKey);
                if ((softReference != null ? softReference.get() : null) != null) continue;
                this.getLogger().info("Android Lint: Classloader was garbage collected {}", (Object)otherKey);
                map.remove(otherKey);
            }
            if (map.size() <= 1) {
                return;
            }
            this.getLogger().info("Android Lint: There are multiple lint class loaders in this gradle daemon, which can lead to jvm metaspace pressure.\nThis be caused when developing lint (usually by using a -dev version) or switching lint versions.\n   Classloaders used in this build: {}\n   Classloaders in this daemon: {}", (Object)CollectionsKt.joinToString$default((Iterable)toDispose.keySet(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), (Object)CollectionsKt.joinToString$default((Iterable)map.keySet(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        }

        /*
         * WARNING - void declaration
         */
        private final URLClassLoader createClassLoader(String key, List<URI> classpath) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            this.getLogger().info("Android Lint: Creating lint class loader {}", (Object)key);
            Iterable $this$map$iv = classpath;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                URI uRI = (URI)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toURL());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            URL[] classpathUrls = thisCollection$iv.toArray(new URL[0]);
            return new URLClassLoader(classpathUrls, this.getPlatformClassLoader());
        }

        private final ClassLoader getPlatformClassLoader() {
            Object object = ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.lang.ClassLoader");
            return (ClassLoader)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final synchronized void dispose() {
            if (!toDispose.isEmpty()) {
                this.getLogger().info("Android Lint: Disposing Uast application environment in lint classloader{} [{}]", (Object)(toDispose.size() == 1 ? "" : "s"), (Object)CollectionsKt.joinToString$default((Iterable)toDispose.keySet(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
                try {
                    Iterable $this$forEach$iv = toDispose.values();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        URLClassLoader classloader = (URLClassLoader)element$iv;
                        boolean bl = false;
                        classloader.loadClass("com.android.tools.lint.UastEnvironment").getDeclaredMethod("disposeApplicationEnvironment", new Class[0]).invoke(null, new Object[0]);
                    }
                }
                finally {
                    toDispose.clear();
                }
            }
        }

        @JvmStatic
        public final void maybeThrowException(int execResult, boolean android, boolean fatalOnly, @NotNull LintMode lintMode, @Nullable String abbreviatedLintOutput, boolean hasBaseline) {
            Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
            switch (execResult) {
                case 0: {
                    break;
                }
                case 1: {
                    throw new RuntimeException(this.getErrorMessage(android, fatalOnly, abbreviatedLintOutput, hasBaseline));
                }
                case 2: {
                    throw new IllegalStateException("Internal Error: Unexpected lint usage");
                }
                case 3: {
                    throw new RuntimeException("Unable to write lint output");
                }
                case 4: {
                    throw new IllegalStateException("Internal error: Unexpected lint help call");
                }
                case 5: {
                    throw new IllegalStateException("Internal error: Unexpected lint invalid arguments");
                }
                case 6: {
                    if (lintMode == LintMode.UPDATE_BASELINE) break;
                    throw new RuntimeException("Aborting build since new baseline file was created");
                }
                case 7: {
                    throw new RuntimeException("Aborting build since sources were modified to apply quickfixes after compilation");
                }
                default: {
                    throw new IllegalStateException("Internal error: unexpected lint return value " + execResult);
                }
            }
        }

        private final String getErrorMessage(boolean android, boolean fatalOnly, String abbreviatedLintOutput, boolean hasBaseline) {
            String prefix = fatalOnly && android ? "Lint found fatal errors while assembling a release target." : "Lint found errors in the project; aborting build.";
            String suggestion = hasBaseline ? "Fix the issues identified by lint, or add the issues to the lint baseline via `gradlew updateLintBaseline`." : (android ? "Fix the issues identified by lint, or create a baseline to see only new errors.\nTo create a baseline, run `gradlew updateLintBaseline` after adding the following to the module's build.gradle file:\n```\nandroid {\n    lint {\n        baseline = file(\"lint-baseline.xml\")\n    }\n}\n```" : "Fix the issues identified by lint, or create a baseline to see only new errors.\nTo create a baseline, run `gradlew updateLintBaseline` after adding the following to the module's build.gradle file:\n```\nlint {\n    baseline = file(\"lint-baseline.xml\")\n}\n```");
            String moreInfo = "For more details, see https://developer.android.com/studio/write/lint#snapshot";
            String string = abbreviatedLintOutput;
            if (string == null) {
                string = "";
            }
            String suffix = string;
            return prefix + "\n\n" + suggestion + "\n" + moreInfo + "\n\n" + suffix;
        }

        public static final /* synthetic */ URLClassLoader access$createClassLoader(Companion $this, String key, List classpath) {
            return $this.createClassLoader(key, classpath);
        }

        public static final /* synthetic */ void access$maintainClassloaders(Companion $this, Map map) {
            $this.maintainClassloaders(map);
        }

        public static final /* synthetic */ Logger access$getLogger(Companion $this) {
            return $this.getLogger();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0007R\u0012\u0010\u001a\u001a\u00020\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0007R\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0007\u00a8\u0006\""}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintWorkAction$LintWorkActionParameters;", "Lorg/gradle/workers/WorkParameters;", "()V", "android", "Lorg/gradle/api/provider/Property;", "", "getAndroid", "()Lorg/gradle/api/provider/Property;", "arguments", "Lorg/gradle/api/provider/ListProperty;", "", "getArguments", "()Lorg/gradle/api/provider/ListProperty;", "classpath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "fatalOnly", "getFatalOnly", "hasBaseline", "getHasBaseline", "lintMode", "Lcom/android/build/gradle/internal/lint/LintMode;", "getLintMode", "mainClass", "getMainClass", "returnValueOutputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getReturnValueOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "runInProcess", "getRunInProcess", "versionKey", "getVersionKey", "gradle-core"})
    public static abstract class LintWorkActionParameters
    implements WorkParameters {
        @NotNull
        public abstract Property<String> getMainClass();

        @NotNull
        public abstract ListProperty<String> getArguments();

        @NotNull
        public abstract ConfigurableFileCollection getClasspath();

        @NotNull
        public abstract Property<String> getVersionKey();

        @NotNull
        public abstract Property<Boolean> getAndroid();

        @NotNull
        public abstract Property<Boolean> getFatalOnly();

        @NotNull
        public abstract Property<Boolean> getRunInProcess();

        @NotNull
        public abstract RegularFileProperty getReturnValueOutputFile();

        @NotNull
        public abstract Property<LintMode> getLintMode();

        @NotNull
        public abstract Property<Boolean> getHasBaseline();
    }
}

