/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.GenerateLibraryProguardRulesTask;
import com.android.builder.files.SerializableChange;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.ide.common.xml.ManifestData;
import com.android.resources.ResourceFolderType;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\f"}, d2={"canResourcesBeProcessedIncrementally", "", "resourceChanges", "Lcom/android/builder/files/SerializableChange;", "isLayoutFile", "file", "Ljava/io/File;", "runFullTask", "", "params", "Lcom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTask$GenerateProguardRulesWorkAction$Params;", "runIncrementalTask", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nGenerateLibraryProguardRulesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateLibraryProguardRulesTask.kt\ncom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTaskKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n766#2:209\n857#2,2:210\n1549#2:212\n1620#2,3:213\n1855#2,2:216\n*S KotlinDebug\n*F\n+ 1 GenerateLibraryProguardRulesTask.kt\ncom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTaskKt\n*L\n185#1:209\n185#1:210,2\n188#1:212\n188#1:213,3\n196#1:216,2\n*E\n"})
public final class GenerateLibraryProguardRulesTaskKt {
    public static final boolean canResourcesBeProcessedIncrementally(@NotNull SerializableChange resourceChanges) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)resourceChanges, (String)"resourceChanges");
        switch (WhenMappings.$EnumSwitchMapping$0[resourceChanges.getFileStatus().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                if (!GenerateLibraryProguardRulesTaskKt.isLayoutFile(resourceChanges.getFile())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                if (!GenerateLibraryProguardRulesTaskKt.isLayoutFile(resourceChanges.getFile())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final void runFullTask(@NotNull GenerateLibraryProguardRulesTask.GenerateProguardRulesWorkAction.Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Path path = ((RegularFile)params.getProguardOutputFile().get()).getAsFile().toPath();
        File file = ((RegularFile)params.getManifestFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"params.manifestFile.get().asFile");
        Files.write(path, (Iterable<? extends CharSequence>)SymbolUtils.generateMinifyKeepRules((ManifestData)SymbolUtils.parseManifest((File)file), (File)((Directory)params.getInputResourcesDir().get()).getAsFile()), new OpenOption[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static final void runIncrementalTask(@NotNull GenerateLibraryProguardRulesTask.GenerateProguardRulesWorkAction.Params params) {
        void $this$mapTo$iv$iv;
        SerializableChange it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (!((RegularFile)params.getProguardOutputFile().get()).getAsFile().exists()) {
            Logging.getLogger(GenerateLibraryProguardRulesTask.class).warn("Cannot find file: " + ((RegularFile)params.getProguardOutputFile().get()).getAsFile().getPath());
            GenerateLibraryProguardRulesTaskKt.runFullTask(params);
            return;
        }
        Object object = params.getChangedResources().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"params.changedResources.get()");
        Iterable $this$filter$iv = (Iterable)object;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SerializableChange)element$iv$iv;
            boolean bl = false;
            if (!(GenerateLibraryProguardRulesTaskKt.isLayoutFile(it.getFile()) && it.getFileStatus() == FileStatus.NEW)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SerializableChange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFile());
        }
        List addedLayoutFiles = (List)destination$iv$iv;
        if (CollectionsKt.none((Iterable)addedLayoutFiles)) {
            return;
        }
        File file = ((RegularFile)params.getProguardOutputFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"params.proguardOutputFile.get().asFile");
        SortedSet currentKeepRules = SymbolUtils.parseMinifiedKeepRules((File)file);
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Iterable $this$forEach$iv = addedLayoutFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File addedLayoutFile = (File)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)documentBuilder, (String)"documentBuilder");
            SymbolUtils.generateKeepRulesFromLayoutXmlFile((File)addedLayoutFile, (DocumentBuilder)documentBuilder, (SortedSet)currentKeepRules);
        }
        String string = "# Generated by the gradle plugin\n" + CollectionsKt.joinToString$default((Iterable)currentKeepRules, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] contentsToWrite = byArray;
        Files.write(((RegularFile)params.getProguardOutputFile().get()).getAsFile().toPath(), contentsToWrite, new OpenOption[0]);
    }

    private static final boolean isLayoutFile(File file) {
        return ResourceFolderType.getFolderType((String)file.getParentFile().getName()) == ResourceFolderType.LAYOUT;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileStatus.values().length];
            try {
                nArray[FileStatus.NEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileStatus.CHANGED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileStatus.REMOVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

