/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.component.ConfigurationVariantDetails;
import org.gradle.api.plugins.JavaBasePlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/dependency/ConfigurationVariantMapping;", "Lorg/gradle/api/Action;", "Lorg/gradle/api/component/ConfigurationVariantDetails;", "scope", "", "optional", "", "(Ljava/lang/String;Z)V", "checkValidArtifact", "element", "Lorg/gradle/api/artifacts/ConfigurationVariant;", "execute", "", "details", "gradle-core"})
public final class ConfigurationVariantMapping
implements Action<ConfigurationVariantDetails> {
    @NotNull
    private final String scope;
    private final boolean optional;

    public ConfigurationVariantMapping(@NotNull String scope, boolean optional) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
        this.optional = optional;
    }

    public void execute(@NotNull ConfigurationVariantDetails details) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        ConfigurationVariant variant = details.getConfigurationVariant();
        Intrinsics.checkNotNull((Object)variant);
        if (this.checkValidArtifact(variant)) {
            details.mapToMavenScope(this.scope);
            if (this.optional) {
                details.mapToOptional();
            }
        } else {
            details.skip();
        }
    }

    private final boolean checkValidArtifact(ConfigurationVariant element) {
        for (PublishArtifact artifact : element.getArtifacts()) {
            if (!JavaBasePlugin.UNPUBLISHABLE_VARIANT_ARTIFACTS.contains(artifact.getType())) continue;
            return false;
        }
        return true;
    }
}

