/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.Info;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.buildanalyzer.common.TaskCategory;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.HELP)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0014J(\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H$R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR6\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n8G@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/tasks/ClasspathComparisonTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "compileVersionMap", "Lorg/gradle/api/provider/MapProperty;", "Lcom/android/build/gradle/internal/tasks/Info;", "", "getCompileVersionMap", "()Lorg/gradle/api/provider/MapProperty;", "<set-?>", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "fakeOutputDirectory", "getFakeOutputDirectory", "()Lorg/gradle/api/provider/Provider;", "setFakeOutputDirectory", "(Lorg/gradle/api/provider/Provider;)V", "runtimeVersionMap", "getRuntimeVersionMap", "doTaskAction", "", "onDifferentVersionsFound", "group", "module", "runtimeVersion", "compileVersion", "gradle-core"})
public abstract class ClasspathComparisonTask
extends NonIncrementalTask {
    @Nullable
    private Provider<Directory> fakeOutputDirectory;

    @Input
    @NotNull
    public abstract MapProperty<Info, String> getRuntimeVersionMap();

    @Input
    @NotNull
    public abstract MapProperty<Info, String> getCompileVersionMap();

    @OutputDirectory
    @Nullable
    public final Provider<Directory> getFakeOutputDirectory() {
        return this.fakeOutputDirectory;
    }

    protected final void setFakeOutputDirectory(@Nullable Provider<Directory> provider2) {
        this.fakeOutputDirectory = provider2;
    }

    protected abstract void onDifferentVersionsFound(@NotNull String var1, @NotNull String var2, @NotNull String var3, @NotNull String var4);

    @Override
    protected void doTaskAction() {
        Map runtimeMap = (Map)this.getRuntimeVersionMap().get();
        for (Map.Entry compileEntry : ((Map)this.getCompileVersionMap().get()).entrySet()) {
            String runtimeVersion;
            if ((String)runtimeMap.get(compileEntry.getKey()) == null || Intrinsics.areEqual((Object)runtimeVersion, compileEntry.getValue())) continue;
            String string = ((Info)compileEntry.getKey()).getGroup();
            String string2 = ((Info)compileEntry.getKey()).getModule();
            Object v = compileEntry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            this.onDifferentVersionsFound(string, string2, runtimeVersion, (String)v);
        }
    }
}

