/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.LibraryJniLibsTaskKt;
import com.android.builder.utils.ZipEntryUtils;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\u001a&\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"pattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "computeFile", "Ljava/io/File;", "rootFolder", "path", "", "copyFromFolder", "", "rootDirectory", "outputDirectory", "from", "pathSegments", "", "copyFromJar", "jarFile", "gradle-core"})
public final class LibraryJniLibsTaskKt {
    private static final Pattern pattern = Pattern.compile("lib/[^/]+/[^/]+\\.so");

    private static final void copyFromFolder(File rootDirectory, File outputDirectory) {
        LibraryJniLibsTaskKt.copyFromFolder(rootDirectory, outputDirectory, new ArrayList());
    }

    private static final void copyFromFolder(File from, File outputDirectory, List<String> pathSegments) {
        File[] children2 = from.listFiles(copyFromFolder.children.1.INSTANCE);
        if (children2 != null) {
            for (File child : children2) {
                String string = child.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                pathSegments.add(string);
                if (child.isDirectory()) {
                    Intrinsics.checkNotNull((Object)child);
                    LibraryJniLibsTaskKt.copyFromFolder(child, outputDirectory, pathSegments);
                } else if (child.isFile() && pattern.matcher(Joiner.on((char)'/').join((Iterable)pathSegments)).matches()) {
                    File to = FileUtils.join((File)outputDirectory, (Iterable)pathSegments.subList(1, 3));
                    FileUtils.mkdirs((File)to.getParentFile());
                    FileUtils.copyFile((File)child, (File)to);
                }
                pathSegments.remove(pathSegments.size() - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void copyFromJar(File jarFile, File outputDirectory) {
        Closeable closeable = new ZipFile(jarFile);
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl = false;
            Enumeration<? extends ZipEntry> entries2 = zipFile.entries();
            while (entries2.hasMoreElements()) {
                ByteBuffer byteBuffer;
                ZipEntry entry2 = entries2.nextElement();
                String entryPath = entry2.getName();
                if (!pattern.matcher(entryPath).matches()) continue;
                Intrinsics.checkNotNull((Object)entry2);
                if (!ZipEntryUtils.isValidZipEntryName((ZipEntry)entry2)) continue;
                Closeable closeable2 = zipFile.getInputStream(entry2);
                Throwable throwable2 = null;
                try {
                    InputStream it = (InputStream)closeable2;
                    boolean bl2 = false;
                    byteBuffer = ByteBuffer.wrap(ByteStreams.toByteArray((InputStream)it));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                ByteBuffer byteBuffer2 = byteBuffer;
                Intrinsics.checkNotNull((Object)entryPath);
                File to = LibraryJniLibsTaskKt.computeFile(outputDirectory, entryPath);
                FileUtils.mkdirs((File)to.getParentFile());
                Files.write((byte[])byteBuffer2.array(), (File)to);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final File computeFile(File rootFolder, String path) {
        String string = path.substring(4);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return new File(rootFolder, FileUtils.toSystemDependentPath((String)string));
    }

    public static final /* synthetic */ void access$copyFromJar(File jarFile, File outputDirectory) {
        LibraryJniLibsTaskKt.copyFromJar(jarFile, outputDirectory);
    }

    public static final /* synthetic */ void access$copyFromFolder(File rootDirectory, File outputDirectory) {
        LibraryJniLibsTaskKt.copyFromFolder(rootDirectory, outputDirectory);
    }
}

