/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Base128OutputStream
extends BufferedOutputStream {
    public Base128OutputStream(@NotNull OutputStream stream) {
        super(stream);
    }

    public Base128OutputStream(@NotNull Path file2) throws IOException {
        super(Files.newOutputStream(file2, new OpenOption[0]));
    }

    public void writeInt(int value) throws IOException {
        do {
            int b = value & 0x7F;
            if ((value >>>= 7) != 0) {
                b |= 0x80;
            }
            super.write(b);
        } while (value != 0);
    }

    public void writeLong(long value) throws IOException {
        do {
            int b = (int)value & 0x7F;
            if ((value >>>= 7) != 0L) {
                b |= 0x80;
            }
            super.write(b);
        } while (value != 0L);
    }

    public void writeString(@Nullable String str) throws IOException {
        if (str == null) {
            this.writeInt(0);
        } else {
            int len = str.length();
            this.writeInt(len + 1);
            for (int i = 0; i < len; ++i) {
                this.writeChar(str.charAt(i));
            }
        }
    }

    public void writeChar(char value) throws IOException {
        this.writeInt(value & 0xFFFF);
    }

    public void writeByte(byte value) throws IOException {
        super.write(value);
    }

    public void writeBytes(@NotNull byte[] bytes) throws IOException {
        this.writeInt(bytes.length);
        for (byte b : bytes) {
            this.writeByte(b);
        }
    }

    public void writeBoolean(boolean value) throws IOException {
        this.writeInt(value ? 1 : 0);
    }

    @Override
    @Deprecated
    public void write(int b) {
        throw new UnsupportedOperationException("This method is disabled to prevent unintended accidental use. Please use writeByte or writeInt instead.");
    }
}

