/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.io.CancellableFileIo;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Base128InputStream
extends BufferedInputStream {
    @Nullable
    private Map<String, String> myStringCache;

    public Base128InputStream(@NotNull InputStream stream) {
        super(stream);
    }

    public Base128InputStream(@NotNull Path file2) throws IOException {
        super(CancellableFileIo.newInputStream(file2, new OpenOption[0]));
    }

    public void setStringCache(@Nullable Map<String, String> stringCache) {
        this.myStringCache = stringCache;
    }

    public char readChar() throws IOException, StreamFormatException {
        int b = this.readByteAsInt();
        int value = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByteAsInt();
            if (shift == 14 && (b & 0xFC) != 0) {
                throw StreamFormatException.invalidFormat();
            }
            value |= (b & 0x7F) << shift;
            shift += 7;
        }
        return (char)value;
    }

    public int readInt() throws IOException {
        int b = this.readByteAsInt();
        int value = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByteAsInt();
            if (shift == 28 && (b & 0xF0) != 0) {
                throw StreamFormatException.invalidFormat();
            }
            value |= (b & 0x7F) << shift;
            shift += 7;
        }
        return value;
    }

    public long readLong() throws IOException, StreamFormatException {
        int b = this.readByteAsInt();
        long value = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByteAsInt();
            if (shift == 63 && (b & 0xFE) != 0) {
                throw StreamFormatException.invalidFormat();
            }
            value |= (long)(b & 0x7F) << shift;
            shift += 7;
        }
        return value;
    }

    @Nullable
    public String readString() throws IOException, StreamFormatException {
        int len = this.readInt();
        if (len < 0) {
            throw StreamFormatException.invalidFormat();
        }
        if (len == 0) {
            return null;
        }
        if (--len == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            buf.append(this.readChar());
        }
        String str = buf.toString();
        return this.myStringCache == null ? str : this.myStringCache.computeIfAbsent(str, Function.identity());
    }

    public byte readByte() throws IOException {
        int b = this.readByteAsInt();
        return (byte)b;
    }

    @NotNull
    public byte[] readBytes() throws IOException, StreamFormatException {
        int len = this.readInt();
        if (len < 0) {
            throw StreamFormatException.invalidFormat();
        }
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = this.readByte();
        }
        return bytes;
    }

    public boolean readBoolean() throws IOException, StreamFormatException {
        int c = this.readInt();
        if ((c & 0xFFFFFFFE) != 0) {
            throw StreamFormatException.invalidFormat();
        }
        return c != 0;
    }

    @Override
    @Deprecated
    public int read() {
        throw new UnsupportedOperationException("This method is disabled to prevent unintended accidental use. Please use readByte or readInt instead.");
    }

    public boolean validateContents(@NotNull byte[] expected) throws IOException {
        boolean result = true;
        for (byte b : expected) {
            if (b == this.readByte()) continue;
            result = false;
        }
        return result;
    }

    private int readByteAsInt() throws IOException {
        int b = super.read();
        if (b < 0) {
            throw StreamFormatException.prematureEndOfFile();
        }
        return b;
    }

    public static class StreamFormatException
    extends IOException {
        public StreamFormatException(@NotNull String message2) {
            super(message2);
        }

        public static StreamFormatException prematureEndOfFile() {
            return new StreamFormatException("Premature end of file");
        }

        public static StreamFormatException invalidFormat() {
            return new StreamFormatException("Invalid file format");
        }
    }
}

