/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\tR \u0010\u0010\u001a\u00020\u0006*\u0004\u0018\u00010\u00018FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\"\u0010\u0015\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u00168FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lcom/android/utils/TraceUtils;", "", "()V", "DATE_FORMAT", "Ljava/text/SimpleDateFormat;", "currentStack", "", "getCurrentStack$annotations", "getCurrentStack", "()Ljava/lang/String;", "currentTime", "getCurrentTime$annotations", "getCurrentTime", "stacksOfAllThreads", "getStacksOfAllThreads$annotations", "getStacksOfAllThreads", "simpleId", "getSimpleId$annotations", "(Ljava/lang/Object;)V", "getSimpleId", "(Ljava/lang/Object;)Ljava/lang/String;", "simpleIds", "", "getSimpleIds$annotations", "(Ljava/lang/Iterable;)V", "getSimpleIds", "(Ljava/lang/Iterable;)Ljava/lang/String;", "numberOfTopFramesToRemove", "", "getStackTrace", "throwable", "", "common"})
public final class TraceUtils {
    @NotNull
    public static final TraceUtils INSTANCE = new TraceUtils();
    @NotNull
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ROOT);

    private TraceUtils() {
    }

    @NotNull
    public static final String getCurrentStack() {
        return TraceUtils.getCurrentStack(1);
    }

    @JvmStatic
    public static /* synthetic */ void getCurrentStack$annotations() {
    }

    @NotNull
    public static final String getStacksOfAllThreads() {
        StringBuilder buf = new StringBuilder();
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getAllStackTraces()");
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            Thread thread = entry.getKey();
            StackTraceElement[] stackTrace = entry.getValue();
            if (((CharSequence)buf).length() > 0) {
                buf.append('\n');
            }
            buf.append(thread.toString());
            buf.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stackTrace, (String)"stackTrace");
            for (StackTraceElement frame : stackTrace) {
                buf.append("  at ");
                buf.append(frame.toString());
                buf.append('\n');
            }
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void getStacksOfAllThreads$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final String getCurrentStack(int numberOfTopFramesToRemove) {
        int pos;
        String fullStack2 = TraceUtils.getStackTrace(new Throwable(){

            @NotNull
            public String toString() {
                return "";
            }
        });
        int start = 0;
        int n = RangesKt.coerceAtLeast((int)numberOfTopFramesToRemove, (int)0) + 2;
        for (int i = 0; i < n && (pos = StringsKt.indexOf$default((CharSequence)fullStack2, (char)'\n', (int)start, (boolean)false, (int)4, null)) >= 0; ++i) {
            start = pos + 1;
        }
        String string = fullStack2.substring(start);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    public static /* synthetic */ String getCurrentStack$default(int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return TraceUtils.getCurrentStack(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final String getStackTrace(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        StringWriter stringWriter = new StringWriter();
        Closeable closeable = new PrintWriter(stringWriter);
        Throwable throwable2 = null;
        try {
            PrintWriter writer = (PrintWriter)closeable;
            boolean bl = false;
            throwable.printStackTrace(writer);
            String string = stringWriter.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringWriter.toString()");
            String string2 = string;
            return string2;
        }
        catch (Throwable throwable3) {
            throwable2 = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
        }
    }

    @NotNull
    public static final String getSimpleId(@Nullable Object $this$simpleId) {
        Object object;
        block3: {
            block2: {
                object = $this$simpleId;
                if (object == null) break block2;
                Object it = object;
                boolean bl = false;
                String string = "%s@%08X";
                Object[] objectArray = new Object[2];
                String string2 = $this$simpleId.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaClass.name");
                objectArray[0] = StringsKt.substringAfterLast$default((String)string2, (char)'.', null, (int)2, null);
                objectArray[1] = System.identityHashCode($this$simpleId);
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                object = string3;
                if (string3 != null) break block3;
            }
            object = "null";
        }
        return object;
    }

    @JvmStatic
    public static /* synthetic */ void getSimpleId$annotations(Object object) {
    }

    @NotNull
    public static final String getSimpleIds(@NotNull Iterable<?> $this$simpleIds) {
        Intrinsics.checkNotNullParameter($this$simpleIds, (String)"<this>");
        StringBuilder result = new StringBuilder();
        for (Object element : $this$simpleIds) {
            if (((CharSequence)result).length() > 0) {
                result.append(", ");
            }
            result.append(TraceUtils.getSimpleId(element));
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void getSimpleIds$annotations(Iterable iterable) {
    }

    @NotNull
    public static final String getCurrentTime() {
        String string = DATE_FORMAT.format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DATE_FORMAT.format(Date())");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void getCurrentTime$annotations() {
    }
}

