/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser.aapt;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.aapt.AbstractAaptOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Error4Parser
extends AbstractAaptOutputParser {
    private static final List<Pattern> MSG_PATTERNS = ImmutableList.of(Pattern.compile("^Error\\s+parsing\\s+XML\\s+file\\s(.+)$"), Pattern.compile("^(.+)\\s+at\\s+line\\s+(\\d+)$"));

    Error4Parser() {
    }

    @Override
    public boolean parse(String line, OutputLineReader reader, List<Message> messages, ILogger logger) throws ParsingFailedException {
        Matcher m4 = MSG_PATTERNS.get(0).matcher(line);
        if (!m4.matches()) {
            return false;
        }
        String sourcePath2 = m4.group(1);
        m4 = Error4Parser.getNextLineMatcher(reader, MSG_PATTERNS.get(1));
        if (m4 == null) {
            throw new ParsingFailedException();
        }
        String msgText = m4.group(1);
        String lineNumber = m4.group(2);
        Message msg = Error4Parser.createMessage(Message.Kind.ERROR, msgText, sourcePath2, lineNumber, "", logger);
        messages.add(msg);
        return true;
    }
}

