/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser.aapt;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.aapt.AbstractAaptOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Error5Parser
extends AbstractAaptOutputParser {
    private static final List<Pattern> MSG_PATTERNS = ImmutableList.of(Pattern.compile("^(.+?):(\\d+): error: Error:\\s+(.+)$"), Pattern.compile("^(.+?):(\\d+): error:\\s+(.+)$"), Pattern.compile("^(.+?):(\\d+):\\s+(.+)$"));

    Error5Parser() {
    }

    @Override
    public boolean parse(String line, OutputLineReader reader, List<Message> messages, ILogger logger) throws ParsingFailedException {
        for (Pattern pattern : MSG_PATTERNS) {
            Matcher m4 = pattern.matcher(line);
            if (!m4.matches()) continue;
            String sourcePath2 = m4.group(1);
            String lineNumber = m4.group(2);
            String msgText = m4.group(3);
            Message.Kind kind = Message.Kind.ERROR;
            if (msgText.startsWith("warning: ")) {
                kind = Message.Kind.WARNING;
            }
            if (sourcePath2.endsWith(".java")) {
                return false;
            }
            Message msg = Error5Parser.createMessage(kind, msgText, sourcePath2, lineNumber, "", logger);
            messages.add(msg);
            return true;
        }
        return false;
    }
}

