/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.PluralsResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.resources.ResourceType;
import java.util.ArrayList;
import java.util.List;

public class PluralsResourceValueImpl
extends ResourceValueImpl
implements PluralsResourceValue {
    private final List<String> quantities = new ArrayList<String>();
    private final List<String> values = new ArrayList<String>();

    public PluralsResourceValueImpl(ResourceNamespace namespace, String name2, String value, String libraryName) {
        super(namespace, ResourceType.PLURALS, name2, value, libraryName);
    }

    public PluralsResourceValueImpl(ResourceReference reference, String value, String libraryName) {
        super(reference, value, libraryName);
        assert (reference.getResourceType() == ResourceType.PLURALS);
    }

    public void addPlural(String quantity, String value) {
        this.quantities.add(quantity);
        this.values.add(value);
    }

    @Override
    public int getPluralsCount() {
        return this.quantities.size();
    }

    @Override
    public String getQuantity(int index2) {
        return this.quantities.get(index2);
    }

    @Override
    public String getValue(int index2) {
        return this.values.get(index2);
    }

    @Override
    public String getValue(String quantity) {
        assert (this.quantities.size() == this.values.size());
        int n2 = this.quantities.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!quantity.equals(this.quantities.get(i2))) continue;
            return this.values.get(i2);
        }
        return null;
    }

    @Override
    public String getValue() {
        if (super.getValue() == null && !this.values.isEmpty()) {
            return this.getValue(0);
        }
        return super.getValue();
    }
}

