/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.google.common.base.MoreObjects;

public class StyleItemResourceValueImpl
extends ResourceValueImpl
implements StyleItemResourceValue {
    private final String attributeName;

    public StyleItemResourceValueImpl(ResourceNamespace namespace, String attributeName, String value, String libraryName) {
        super(namespace, ResourceType.STYLE_ITEM, "<item>", value, libraryName);
        this.attributeName = attributeName;
    }

    @Override
    public String getAttrName() {
        return this.attributeName;
    }

    @Override
    public ResourceReference getAttr() {
        ResourceUrl url = ResourceUrl.parseAttrReference(this.attributeName);
        if (url == null) {
            return null;
        }
        return url.resolve(this.getNamespace(), this.mNamespaceResolver);
    }

    @Override
    @Deprecated
    public String getName() {
        ResourceUrl url = ResourceUrl.parseAttrReference(this.attributeName);
        if (url != null) {
            return url.name;
        }
        return this.attributeName;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("namespace", this.getNamespace()).add("attribute", this.attributeName).add("value", this.getValue()).toString();
    }
}

